/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kendra.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum EntityType {
    USER("USER"),
    GROUP("GROUP"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, EntityType> VALUE_MAP;
    private final String value;

    private EntityType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static EntityType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<EntityType> knownValues() {
        EnumSet<EntityType> knownValues = EnumSet.allOf(EntityType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(EntityType.class, EntityType::toString);
    }
}

