/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kendra;

import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.kendra.KendraClient;
import software.amazon.awssdk.services.kendra.model.AccessDeniedException;
import software.amazon.awssdk.services.kendra.model.AssociateEntitiesToExperienceRequest;
import software.amazon.awssdk.services.kendra.model.AssociateEntitiesToExperienceResponse;
import software.amazon.awssdk.services.kendra.model.AssociatePersonasToEntitiesRequest;
import software.amazon.awssdk.services.kendra.model.AssociatePersonasToEntitiesResponse;
import software.amazon.awssdk.services.kendra.model.BatchDeleteDocumentRequest;
import software.amazon.awssdk.services.kendra.model.BatchDeleteDocumentResponse;
import software.amazon.awssdk.services.kendra.model.BatchGetDocumentStatusRequest;
import software.amazon.awssdk.services.kendra.model.BatchGetDocumentStatusResponse;
import software.amazon.awssdk.services.kendra.model.BatchPutDocumentRequest;
import software.amazon.awssdk.services.kendra.model.BatchPutDocumentResponse;
import software.amazon.awssdk.services.kendra.model.ClearQuerySuggestionsRequest;
import software.amazon.awssdk.services.kendra.model.ClearQuerySuggestionsResponse;
import software.amazon.awssdk.services.kendra.model.ConflictException;
import software.amazon.awssdk.services.kendra.model.CreateAccessControlConfigurationRequest;
import software.amazon.awssdk.services.kendra.model.CreateAccessControlConfigurationResponse;
import software.amazon.awssdk.services.kendra.model.CreateDataSourceRequest;
import software.amazon.awssdk.services.kendra.model.CreateDataSourceResponse;
import software.amazon.awssdk.services.kendra.model.CreateExperienceRequest;
import software.amazon.awssdk.services.kendra.model.CreateExperienceResponse;
import software.amazon.awssdk.services.kendra.model.CreateFaqRequest;
import software.amazon.awssdk.services.kendra.model.CreateFaqResponse;
import software.amazon.awssdk.services.kendra.model.CreateIndexRequest;
import software.amazon.awssdk.services.kendra.model.CreateIndexResponse;
import software.amazon.awssdk.services.kendra.model.CreateQuerySuggestionsBlockListRequest;
import software.amazon.awssdk.services.kendra.model.CreateQuerySuggestionsBlockListResponse;
import software.amazon.awssdk.services.kendra.model.CreateThesaurusRequest;
import software.amazon.awssdk.services.kendra.model.CreateThesaurusResponse;
import software.amazon.awssdk.services.kendra.model.DeleteAccessControlConfigurationRequest;
import software.amazon.awssdk.services.kendra.model.DeleteAccessControlConfigurationResponse;
import software.amazon.awssdk.services.kendra.model.DeleteDataSourceRequest;
import software.amazon.awssdk.services.kendra.model.DeleteDataSourceResponse;
import software.amazon.awssdk.services.kendra.model.DeleteExperienceRequest;
import software.amazon.awssdk.services.kendra.model.DeleteExperienceResponse;
import software.amazon.awssdk.services.kendra.model.DeleteFaqRequest;
import software.amazon.awssdk.services.kendra.model.DeleteFaqResponse;
import software.amazon.awssdk.services.kendra.model.DeleteIndexRequest;
import software.amazon.awssdk.services.kendra.model.DeleteIndexResponse;
import software.amazon.awssdk.services.kendra.model.DeletePrincipalMappingRequest;
import software.amazon.awssdk.services.kendra.model.DeletePrincipalMappingResponse;
import software.amazon.awssdk.services.kendra.model.DeleteQuerySuggestionsBlockListRequest;
import software.amazon.awssdk.services.kendra.model.DeleteQuerySuggestionsBlockListResponse;
import software.amazon.awssdk.services.kendra.model.DeleteThesaurusRequest;
import software.amazon.awssdk.services.kendra.model.DeleteThesaurusResponse;
import software.amazon.awssdk.services.kendra.model.DescribeAccessControlConfigurationRequest;
import software.amazon.awssdk.services.kendra.model.DescribeAccessControlConfigurationResponse;
import software.amazon.awssdk.services.kendra.model.DescribeDataSourceRequest;
import software.amazon.awssdk.services.kendra.model.DescribeDataSourceResponse;
import software.amazon.awssdk.services.kendra.model.DescribeExperienceRequest;
import software.amazon.awssdk.services.kendra.model.DescribeExperienceResponse;
import software.amazon.awssdk.services.kendra.model.DescribeFaqRequest;
import software.amazon.awssdk.services.kendra.model.DescribeFaqResponse;
import software.amazon.awssdk.services.kendra.model.DescribeIndexRequest;
import software.amazon.awssdk.services.kendra.model.DescribeIndexResponse;
import software.amazon.awssdk.services.kendra.model.DescribePrincipalMappingRequest;
import software.amazon.awssdk.services.kendra.model.DescribePrincipalMappingResponse;
import software.amazon.awssdk.services.kendra.model.DescribeQuerySuggestionsBlockListRequest;
import software.amazon.awssdk.services.kendra.model.DescribeQuerySuggestionsBlockListResponse;
import software.amazon.awssdk.services.kendra.model.DescribeQuerySuggestionsConfigRequest;
import software.amazon.awssdk.services.kendra.model.DescribeQuerySuggestionsConfigResponse;
import software.amazon.awssdk.services.kendra.model.DescribeThesaurusRequest;
import software.amazon.awssdk.services.kendra.model.DescribeThesaurusResponse;
import software.amazon.awssdk.services.kendra.model.DisassociateEntitiesFromExperienceRequest;
import software.amazon.awssdk.services.kendra.model.DisassociateEntitiesFromExperienceResponse;
import software.amazon.awssdk.services.kendra.model.DisassociatePersonasFromEntitiesRequest;
import software.amazon.awssdk.services.kendra.model.DisassociatePersonasFromEntitiesResponse;
import software.amazon.awssdk.services.kendra.model.GetQuerySuggestionsRequest;
import software.amazon.awssdk.services.kendra.model.GetQuerySuggestionsResponse;
import software.amazon.awssdk.services.kendra.model.GetSnapshotsRequest;
import software.amazon.awssdk.services.kendra.model.GetSnapshotsResponse;
import software.amazon.awssdk.services.kendra.model.InternalServerException;
import software.amazon.awssdk.services.kendra.model.InvalidRequestException;
import software.amazon.awssdk.services.kendra.model.KendraException;
import software.amazon.awssdk.services.kendra.model.KendraRequest;
import software.amazon.awssdk.services.kendra.model.ListAccessControlConfigurationsRequest;
import software.amazon.awssdk.services.kendra.model.ListAccessControlConfigurationsResponse;
import software.amazon.awssdk.services.kendra.model.ListDataSourceSyncJobsRequest;
import software.amazon.awssdk.services.kendra.model.ListDataSourceSyncJobsResponse;
import software.amazon.awssdk.services.kendra.model.ListDataSourcesRequest;
import software.amazon.awssdk.services.kendra.model.ListDataSourcesResponse;
import software.amazon.awssdk.services.kendra.model.ListEntityPersonasRequest;
import software.amazon.awssdk.services.kendra.model.ListEntityPersonasResponse;
import software.amazon.awssdk.services.kendra.model.ListExperienceEntitiesRequest;
import software.amazon.awssdk.services.kendra.model.ListExperienceEntitiesResponse;
import software.amazon.awssdk.services.kendra.model.ListExperiencesRequest;
import software.amazon.awssdk.services.kendra.model.ListExperiencesResponse;
import software.amazon.awssdk.services.kendra.model.ListFaqsRequest;
import software.amazon.awssdk.services.kendra.model.ListFaqsResponse;
import software.amazon.awssdk.services.kendra.model.ListGroupsOlderThanOrderingIdRequest;
import software.amazon.awssdk.services.kendra.model.ListGroupsOlderThanOrderingIdResponse;
import software.amazon.awssdk.services.kendra.model.ListIndicesRequest;
import software.amazon.awssdk.services.kendra.model.ListIndicesResponse;
import software.amazon.awssdk.services.kendra.model.ListQuerySuggestionsBlockListsRequest;
import software.amazon.awssdk.services.kendra.model.ListQuerySuggestionsBlockListsResponse;
import software.amazon.awssdk.services.kendra.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.kendra.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.kendra.model.ListThesauriRequest;
import software.amazon.awssdk.services.kendra.model.ListThesauriResponse;
import software.amazon.awssdk.services.kendra.model.PutPrincipalMappingRequest;
import software.amazon.awssdk.services.kendra.model.PutPrincipalMappingResponse;
import software.amazon.awssdk.services.kendra.model.QueryRequest;
import software.amazon.awssdk.services.kendra.model.QueryResponse;
import software.amazon.awssdk.services.kendra.model.ResourceAlreadyExistException;
import software.amazon.awssdk.services.kendra.model.ResourceInUseException;
import software.amazon.awssdk.services.kendra.model.ResourceNotFoundException;
import software.amazon.awssdk.services.kendra.model.ResourceUnavailableException;
import software.amazon.awssdk.services.kendra.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.kendra.model.StartDataSourceSyncJobRequest;
import software.amazon.awssdk.services.kendra.model.StartDataSourceSyncJobResponse;
import software.amazon.awssdk.services.kendra.model.StopDataSourceSyncJobRequest;
import software.amazon.awssdk.services.kendra.model.StopDataSourceSyncJobResponse;
import software.amazon.awssdk.services.kendra.model.SubmitFeedbackRequest;
import software.amazon.awssdk.services.kendra.model.SubmitFeedbackResponse;
import software.amazon.awssdk.services.kendra.model.TagResourceRequest;
import software.amazon.awssdk.services.kendra.model.TagResourceResponse;
import software.amazon.awssdk.services.kendra.model.ThrottlingException;
import software.amazon.awssdk.services.kendra.model.UntagResourceRequest;
import software.amazon.awssdk.services.kendra.model.UntagResourceResponse;
import software.amazon.awssdk.services.kendra.model.UpdateAccessControlConfigurationRequest;
import software.amazon.awssdk.services.kendra.model.UpdateAccessControlConfigurationResponse;
import software.amazon.awssdk.services.kendra.model.UpdateDataSourceRequest;
import software.amazon.awssdk.services.kendra.model.UpdateDataSourceResponse;
import software.amazon.awssdk.services.kendra.model.UpdateExperienceRequest;
import software.amazon.awssdk.services.kendra.model.UpdateExperienceResponse;
import software.amazon.awssdk.services.kendra.model.UpdateIndexRequest;
import software.amazon.awssdk.services.kendra.model.UpdateIndexResponse;
import software.amazon.awssdk.services.kendra.model.UpdateQuerySuggestionsBlockListRequest;
import software.amazon.awssdk.services.kendra.model.UpdateQuerySuggestionsBlockListResponse;
import software.amazon.awssdk.services.kendra.model.UpdateQuerySuggestionsConfigRequest;
import software.amazon.awssdk.services.kendra.model.UpdateQuerySuggestionsConfigResponse;
import software.amazon.awssdk.services.kendra.model.UpdateThesaurusRequest;
import software.amazon.awssdk.services.kendra.model.UpdateThesaurusResponse;
import software.amazon.awssdk.services.kendra.model.ValidationException;
import software.amazon.awssdk.services.kendra.paginators.GetSnapshotsIterable;
import software.amazon.awssdk.services.kendra.paginators.ListAccessControlConfigurationsIterable;
import software.amazon.awssdk.services.kendra.paginators.ListDataSourceSyncJobsIterable;
import software.amazon.awssdk.services.kendra.paginators.ListDataSourcesIterable;
import software.amazon.awssdk.services.kendra.paginators.ListEntityPersonasIterable;
import software.amazon.awssdk.services.kendra.paginators.ListExperienceEntitiesIterable;
import software.amazon.awssdk.services.kendra.paginators.ListExperiencesIterable;
import software.amazon.awssdk.services.kendra.paginators.ListFaqsIterable;
import software.amazon.awssdk.services.kendra.paginators.ListGroupsOlderThanOrderingIdIterable;
import software.amazon.awssdk.services.kendra.paginators.ListIndicesIterable;
import software.amazon.awssdk.services.kendra.paginators.ListQuerySuggestionsBlockListsIterable;
import software.amazon.awssdk.services.kendra.paginators.ListThesauriIterable;
import software.amazon.awssdk.services.kendra.transform.AssociateEntitiesToExperienceRequestMarshaller;
import software.amazon.awssdk.services.kendra.transform.AssociatePersonasToEntitiesRequestMarshaller;
import software.amazon.awssdk.services.kendra.transform.BatchDeleteDocumentRequestMarshaller;
import software.amazon.awssdk.services.kendra.transform.BatchGetDocumentStatusRequestMarshaller;
import software.amazon.awssdk.services.kendra.transform.BatchPutDocumentRequestMarshaller;
import software.amazon.awssdk.services.kendra.transform.ClearQuerySuggestionsRequestMarshaller;
import software.amazon.awssdk.services.kendra.transform.CreateAccessControlConfigurationRequestMarshaller;
import software.amazon.awssdk.services.kendra.transform.CreateDataSourceRequestMarshaller;
import software.amazon.awssdk.services.kendra.transform.CreateExperienceRequestMarshaller;
import software.amazon.awssdk.services.kendra.transform.CreateFaqRequestMarshaller;
import software.amazon.awssdk.services.kendra.transform.CreateIndexRequestMarshaller;
import software.amazon.awssdk.services.kendra.transform.CreateQuerySuggestionsBlockListRequestMarshaller;
import software.amazon.awssdk.services.kendra.transform.CreateThesaurusRequestMarshaller;
import software.amazon.awssdk.services.kendra.transform.DeleteAccessControlConfigurationRequestMarshaller;
import software.amazon.awssdk.services.kendra.transform.DeleteDataSourceRequestMarshaller;
import software.amazon.awssdk.services.kendra.transform.DeleteExperienceRequestMarshaller;
import software.amazon.awssdk.services.kendra.transform.DeleteFaqRequestMarshaller;
import software.amazon.awssdk.services.kendra.transform.DeleteIndexRequestMarshaller;
import software.amazon.awssdk.services.kendra.transform.DeletePrincipalMappingRequestMarshaller;
import software.amazon.awssdk.services.kendra.transform.DeleteQuerySuggestionsBlockListRequestMarshaller;
import software.amazon.awssdk.services.kendra.transform.DeleteThesaurusRequestMarshaller;
import software.amazon.awssdk.services.kendra.transform.DescribeAccessControlConfigurationRequestMarshaller;
import software.amazon.awssdk.services.kendra.transform.DescribeDataSourceRequestMarshaller;
import software.amazon.awssdk.services.kendra.transform.DescribeExperienceRequestMarshaller;
import software.amazon.awssdk.services.kendra.transform.DescribeFaqRequestMarshaller;
import software.amazon.awssdk.services.kendra.transform.DescribeIndexRequestMarshaller;
import software.amazon.awssdk.services.kendra.transform.DescribePrincipalMappingRequestMarshaller;
import software.amazon.awssdk.services.kendra.transform.DescribeQuerySuggestionsBlockListRequestMarshaller;
import software.amazon.awssdk.services.kendra.transform.DescribeQuerySuggestionsConfigRequestMarshaller;
import software.amazon.awssdk.services.kendra.transform.DescribeThesaurusRequestMarshaller;
import software.amazon.awssdk.services.kendra.transform.DisassociateEntitiesFromExperienceRequestMarshaller;
import software.amazon.awssdk.services.kendra.transform.DisassociatePersonasFromEntitiesRequestMarshaller;
import software.amazon.awssdk.services.kendra.transform.GetQuerySuggestionsRequestMarshaller;
import software.amazon.awssdk.services.kendra.transform.GetSnapshotsRequestMarshaller;
import software.amazon.awssdk.services.kendra.transform.ListAccessControlConfigurationsRequestMarshaller;
import software.amazon.awssdk.services.kendra.transform.ListDataSourceSyncJobsRequestMarshaller;
import software.amazon.awssdk.services.kendra.transform.ListDataSourcesRequestMarshaller;
import software.amazon.awssdk.services.kendra.transform.ListEntityPersonasRequestMarshaller;
import software.amazon.awssdk.services.kendra.transform.ListExperienceEntitiesRequestMarshaller;
import software.amazon.awssdk.services.kendra.transform.ListExperiencesRequestMarshaller;
import software.amazon.awssdk.services.kendra.transform.ListFaqsRequestMarshaller;
import software.amazon.awssdk.services.kendra.transform.ListGroupsOlderThanOrderingIdRequestMarshaller;
import software.amazon.awssdk.services.kendra.transform.ListIndicesRequestMarshaller;
import software.amazon.awssdk.services.kendra.transform.ListQuerySuggestionsBlockListsRequestMarshaller;
import software.amazon.awssdk.services.kendra.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.kendra.transform.ListThesauriRequestMarshaller;
import software.amazon.awssdk.services.kendra.transform.PutPrincipalMappingRequestMarshaller;
import software.amazon.awssdk.services.kendra.transform.QueryRequestMarshaller;
import software.amazon.awssdk.services.kendra.transform.StartDataSourceSyncJobRequestMarshaller;
import software.amazon.awssdk.services.kendra.transform.StopDataSourceSyncJobRequestMarshaller;
import software.amazon.awssdk.services.kendra.transform.SubmitFeedbackRequestMarshaller;
import software.amazon.awssdk.services.kendra.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.kendra.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.kendra.transform.UpdateAccessControlConfigurationRequestMarshaller;
import software.amazon.awssdk.services.kendra.transform.UpdateDataSourceRequestMarshaller;
import software.amazon.awssdk.services.kendra.transform.UpdateExperienceRequestMarshaller;
import software.amazon.awssdk.services.kendra.transform.UpdateIndexRequestMarshaller;
import software.amazon.awssdk.services.kendra.transform.UpdateQuerySuggestionsBlockListRequestMarshaller;
import software.amazon.awssdk.services.kendra.transform.UpdateQuerySuggestionsConfigRequestMarshaller;
import software.amazon.awssdk.services.kendra.transform.UpdateThesaurusRequestMarshaller;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
final class DefaultKendraClient
implements KendraClient {
    private static final Logger log = Logger.loggerFor(DefaultKendraClient.class);
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultKendraClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    public final String serviceName() {
        return "kendra";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AssociateEntitiesToExperienceResponse associateEntitiesToExperience(AssociateEntitiesToExperienceRequest associateEntitiesToExperienceRequest) throws ValidationException, ResourceNotFoundException, ResourceAlreadyExistException, ThrottlingException, AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException, KendraException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AssociateEntitiesToExperienceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultKendraClient.resolveMetricPublishers(this.clientConfiguration, associateEntitiesToExperienceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"kendra");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AssociateEntitiesToExperience");
            AssociateEntitiesToExperienceResponse associateEntitiesToExperienceResponse = (AssociateEntitiesToExperienceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AssociateEntitiesToExperience").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)associateEntitiesToExperienceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new AssociateEntitiesToExperienceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return associateEntitiesToExperienceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultKendraClient.lambda$associateEntitiesToExperience$0((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AssociatePersonasToEntitiesResponse associatePersonasToEntities(AssociatePersonasToEntitiesRequest associatePersonasToEntitiesRequest) throws ValidationException, ResourceNotFoundException, ResourceAlreadyExistException, ThrottlingException, AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException, KendraException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AssociatePersonasToEntitiesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultKendraClient.resolveMetricPublishers(this.clientConfiguration, associatePersonasToEntitiesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"kendra");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AssociatePersonasToEntities");
            AssociatePersonasToEntitiesResponse associatePersonasToEntitiesResponse = (AssociatePersonasToEntitiesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AssociatePersonasToEntities").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)associatePersonasToEntitiesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new AssociatePersonasToEntitiesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return associatePersonasToEntitiesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultKendraClient.lambda$associatePersonasToEntities$1((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BatchDeleteDocumentResponse batchDeleteDocument(BatchDeleteDocumentRequest batchDeleteDocumentRequest) throws ValidationException, ConflictException, ResourceNotFoundException, ThrottlingException, AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException, KendraException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, BatchDeleteDocumentResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultKendraClient.resolveMetricPublishers(this.clientConfiguration, batchDeleteDocumentRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"kendra");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"BatchDeleteDocument");
            BatchDeleteDocumentResponse batchDeleteDocumentResponse = (BatchDeleteDocumentResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("BatchDeleteDocument").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)batchDeleteDocumentRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new BatchDeleteDocumentRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return batchDeleteDocumentResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultKendraClient.lambda$batchDeleteDocument$2((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BatchGetDocumentStatusResponse batchGetDocumentStatus(BatchGetDocumentStatusRequest batchGetDocumentStatusRequest) throws ValidationException, ConflictException, ResourceNotFoundException, ThrottlingException, AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException, KendraException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, BatchGetDocumentStatusResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultKendraClient.resolveMetricPublishers(this.clientConfiguration, batchGetDocumentStatusRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"kendra");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"BatchGetDocumentStatus");
            BatchGetDocumentStatusResponse batchGetDocumentStatusResponse = (BatchGetDocumentStatusResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("BatchGetDocumentStatus").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)batchGetDocumentStatusRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new BatchGetDocumentStatusRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return batchGetDocumentStatusResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultKendraClient.lambda$batchGetDocumentStatus$3((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BatchPutDocumentResponse batchPutDocument(BatchPutDocumentRequest batchPutDocumentRequest) throws ValidationException, ConflictException, ResourceNotFoundException, ThrottlingException, AccessDeniedException, ServiceQuotaExceededException, InternalServerException, AwsServiceException, SdkClientException, KendraException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, BatchPutDocumentResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultKendraClient.resolveMetricPublishers(this.clientConfiguration, batchPutDocumentRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"kendra");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"BatchPutDocument");
            BatchPutDocumentResponse batchPutDocumentResponse = (BatchPutDocumentResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("BatchPutDocument").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)batchPutDocumentRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new BatchPutDocumentRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return batchPutDocumentResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultKendraClient.lambda$batchPutDocument$4((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ClearQuerySuggestionsResponse clearQuerySuggestions(ClearQuerySuggestionsRequest clearQuerySuggestionsRequest) throws ValidationException, ResourceNotFoundException, ThrottlingException, ConflictException, AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException, KendraException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ClearQuerySuggestionsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultKendraClient.resolveMetricPublishers(this.clientConfiguration, clearQuerySuggestionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"kendra");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ClearQuerySuggestions");
            ClearQuerySuggestionsResponse clearQuerySuggestionsResponse = (ClearQuerySuggestionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ClearQuerySuggestions").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)clearQuerySuggestionsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ClearQuerySuggestionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return clearQuerySuggestionsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultKendraClient.lambda$clearQuerySuggestions$5((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateAccessControlConfigurationResponse createAccessControlConfiguration(CreateAccessControlConfigurationRequest createAccessControlConfigurationRequest) throws ServiceQuotaExceededException, ValidationException, ThrottlingException, ConflictException, AccessDeniedException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, KendraException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateAccessControlConfigurationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultKendraClient.resolveMetricPublishers(this.clientConfiguration, createAccessControlConfigurationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"kendra");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateAccessControlConfiguration");
            CreateAccessControlConfigurationResponse createAccessControlConfigurationResponse = (CreateAccessControlConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateAccessControlConfiguration").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createAccessControlConfigurationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateAccessControlConfigurationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createAccessControlConfigurationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultKendraClient.lambda$createAccessControlConfiguration$6((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateDataSourceResponse createDataSource(CreateDataSourceRequest createDataSourceRequest) throws ValidationException, ConflictException, ResourceNotFoundException, ResourceAlreadyExistException, ServiceQuotaExceededException, ThrottlingException, AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException, KendraException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateDataSourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultKendraClient.resolveMetricPublishers(this.clientConfiguration, createDataSourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"kendra");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateDataSource");
            CreateDataSourceResponse createDataSourceResponse = (CreateDataSourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateDataSource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createDataSourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateDataSourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createDataSourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultKendraClient.lambda$createDataSource$7((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateExperienceResponse createExperience(CreateExperienceRequest createExperienceRequest) throws ValidationException, ConflictException, ResourceNotFoundException, ServiceQuotaExceededException, ThrottlingException, AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException, KendraException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateExperienceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultKendraClient.resolveMetricPublishers(this.clientConfiguration, createExperienceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"kendra");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateExperience");
            CreateExperienceResponse createExperienceResponse = (CreateExperienceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateExperience").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createExperienceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateExperienceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createExperienceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultKendraClient.lambda$createExperience$8((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateFaqResponse createFaq(CreateFaqRequest createFaqRequest) throws ValidationException, ConflictException, ResourceNotFoundException, ThrottlingException, ServiceQuotaExceededException, AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException, KendraException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateFaqResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultKendraClient.resolveMetricPublishers(this.clientConfiguration, createFaqRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"kendra");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateFaq");
            CreateFaqResponse createFaqResponse = (CreateFaqResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateFaq").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createFaqRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateFaqRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createFaqResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultKendraClient.lambda$createFaq$9((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateIndexResponse createIndex(CreateIndexRequest createIndexRequest) throws ValidationException, ResourceAlreadyExistException, ServiceQuotaExceededException, ThrottlingException, AccessDeniedException, ConflictException, InternalServerException, AwsServiceException, SdkClientException, KendraException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateIndexResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultKendraClient.resolveMetricPublishers(this.clientConfiguration, createIndexRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"kendra");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateIndex");
            CreateIndexResponse createIndexResponse = (CreateIndexResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateIndex").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createIndexRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateIndexRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createIndexResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultKendraClient.lambda$createIndex$10((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateQuerySuggestionsBlockListResponse createQuerySuggestionsBlockList(CreateQuerySuggestionsBlockListRequest createQuerySuggestionsBlockListRequest) throws ValidationException, ResourceNotFoundException, ThrottlingException, AccessDeniedException, ServiceQuotaExceededException, ConflictException, InternalServerException, AwsServiceException, SdkClientException, KendraException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateQuerySuggestionsBlockListResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultKendraClient.resolveMetricPublishers(this.clientConfiguration, createQuerySuggestionsBlockListRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"kendra");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateQuerySuggestionsBlockList");
            CreateQuerySuggestionsBlockListResponse createQuerySuggestionsBlockListResponse = (CreateQuerySuggestionsBlockListResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateQuerySuggestionsBlockList").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createQuerySuggestionsBlockListRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateQuerySuggestionsBlockListRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createQuerySuggestionsBlockListResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultKendraClient.lambda$createQuerySuggestionsBlockList$11((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateThesaurusResponse createThesaurus(CreateThesaurusRequest createThesaurusRequest) throws ValidationException, ConflictException, ResourceNotFoundException, ThrottlingException, ServiceQuotaExceededException, AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException, KendraException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateThesaurusResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultKendraClient.resolveMetricPublishers(this.clientConfiguration, createThesaurusRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"kendra");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateThesaurus");
            CreateThesaurusResponse createThesaurusResponse = (CreateThesaurusResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateThesaurus").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createThesaurusRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateThesaurusRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createThesaurusResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultKendraClient.lambda$createThesaurus$12((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteAccessControlConfigurationResponse deleteAccessControlConfiguration(DeleteAccessControlConfigurationRequest deleteAccessControlConfigurationRequest) throws ValidationException, ThrottlingException, ConflictException, ResourceNotFoundException, AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException, KendraException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteAccessControlConfigurationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultKendraClient.resolveMetricPublishers(this.clientConfiguration, deleteAccessControlConfigurationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"kendra");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteAccessControlConfiguration");
            DeleteAccessControlConfigurationResponse deleteAccessControlConfigurationResponse = (DeleteAccessControlConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteAccessControlConfiguration").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteAccessControlConfigurationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteAccessControlConfigurationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteAccessControlConfigurationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultKendraClient.lambda$deleteAccessControlConfiguration$13((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteDataSourceResponse deleteDataSource(DeleteDataSourceRequest deleteDataSourceRequest) throws AccessDeniedException, ValidationException, ConflictException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, KendraException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteDataSourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultKendraClient.resolveMetricPublishers(this.clientConfiguration, deleteDataSourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"kendra");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteDataSource");
            DeleteDataSourceResponse deleteDataSourceResponse = (DeleteDataSourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteDataSource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteDataSourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteDataSourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteDataSourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultKendraClient.lambda$deleteDataSource$14((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteExperienceResponse deleteExperience(DeleteExperienceRequest deleteExperienceRequest) throws AccessDeniedException, ValidationException, ConflictException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, KendraException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteExperienceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultKendraClient.resolveMetricPublishers(this.clientConfiguration, deleteExperienceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"kendra");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteExperience");
            DeleteExperienceResponse deleteExperienceResponse = (DeleteExperienceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteExperience").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteExperienceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteExperienceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteExperienceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultKendraClient.lambda$deleteExperience$15((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteFaqResponse deleteFaq(DeleteFaqRequest deleteFaqRequest) throws ValidationException, ConflictException, ResourceNotFoundException, ThrottlingException, AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException, KendraException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteFaqResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultKendraClient.resolveMetricPublishers(this.clientConfiguration, deleteFaqRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"kendra");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteFaq");
            DeleteFaqResponse deleteFaqResponse = (DeleteFaqResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteFaq").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteFaqRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteFaqRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteFaqResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultKendraClient.lambda$deleteFaq$16((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteIndexResponse deleteIndex(DeleteIndexRequest deleteIndexRequest) throws ValidationException, ConflictException, ResourceNotFoundException, ThrottlingException, AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException, KendraException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteIndexResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultKendraClient.resolveMetricPublishers(this.clientConfiguration, deleteIndexRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"kendra");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteIndex");
            DeleteIndexResponse deleteIndexResponse = (DeleteIndexResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteIndex").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteIndexRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteIndexRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteIndexResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultKendraClient.lambda$deleteIndex$17((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeletePrincipalMappingResponse deletePrincipalMapping(DeletePrincipalMappingRequest deletePrincipalMappingRequest) throws ValidationException, ConflictException, ResourceNotFoundException, ThrottlingException, AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException, KendraException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeletePrincipalMappingResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultKendraClient.resolveMetricPublishers(this.clientConfiguration, deletePrincipalMappingRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"kendra");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeletePrincipalMapping");
            DeletePrincipalMappingResponse deletePrincipalMappingResponse = (DeletePrincipalMappingResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeletePrincipalMapping").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deletePrincipalMappingRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeletePrincipalMappingRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deletePrincipalMappingResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultKendraClient.lambda$deletePrincipalMapping$18((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteQuerySuggestionsBlockListResponse deleteQuerySuggestionsBlockList(DeleteQuerySuggestionsBlockListRequest deleteQuerySuggestionsBlockListRequest) throws ValidationException, ResourceNotFoundException, ThrottlingException, AccessDeniedException, ConflictException, InternalServerException, AwsServiceException, SdkClientException, KendraException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteQuerySuggestionsBlockListResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultKendraClient.resolveMetricPublishers(this.clientConfiguration, deleteQuerySuggestionsBlockListRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"kendra");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteQuerySuggestionsBlockList");
            DeleteQuerySuggestionsBlockListResponse deleteQuerySuggestionsBlockListResponse = (DeleteQuerySuggestionsBlockListResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteQuerySuggestionsBlockList").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteQuerySuggestionsBlockListRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteQuerySuggestionsBlockListRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteQuerySuggestionsBlockListResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultKendraClient.lambda$deleteQuerySuggestionsBlockList$19((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteThesaurusResponse deleteThesaurus(DeleteThesaurusRequest deleteThesaurusRequest) throws ValidationException, ConflictException, ResourceNotFoundException, ThrottlingException, AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException, KendraException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteThesaurusResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultKendraClient.resolveMetricPublishers(this.clientConfiguration, deleteThesaurusRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"kendra");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteThesaurus");
            DeleteThesaurusResponse deleteThesaurusResponse = (DeleteThesaurusResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteThesaurus").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteThesaurusRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteThesaurusRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteThesaurusResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultKendraClient.lambda$deleteThesaurus$20((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeAccessControlConfigurationResponse describeAccessControlConfiguration(DescribeAccessControlConfigurationRequest describeAccessControlConfigurationRequest) throws ValidationException, ThrottlingException, ResourceNotFoundException, AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException, KendraException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeAccessControlConfigurationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultKendraClient.resolveMetricPublishers(this.clientConfiguration, describeAccessControlConfigurationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"kendra");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeAccessControlConfiguration");
            DescribeAccessControlConfigurationResponse describeAccessControlConfigurationResponse = (DescribeAccessControlConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeAccessControlConfiguration").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeAccessControlConfigurationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeAccessControlConfigurationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeAccessControlConfigurationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultKendraClient.lambda$describeAccessControlConfiguration$21((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeDataSourceResponse describeDataSource(DescribeDataSourceRequest describeDataSourceRequest) throws ValidationException, ResourceNotFoundException, ThrottlingException, AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException, KendraException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeDataSourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultKendraClient.resolveMetricPublishers(this.clientConfiguration, describeDataSourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"kendra");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeDataSource");
            DescribeDataSourceResponse describeDataSourceResponse = (DescribeDataSourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeDataSource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeDataSourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeDataSourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeDataSourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultKendraClient.lambda$describeDataSource$22((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeExperienceResponse describeExperience(DescribeExperienceRequest describeExperienceRequest) throws ValidationException, ResourceNotFoundException, ThrottlingException, AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException, KendraException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeExperienceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultKendraClient.resolveMetricPublishers(this.clientConfiguration, describeExperienceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"kendra");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeExperience");
            DescribeExperienceResponse describeExperienceResponse = (DescribeExperienceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeExperience").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeExperienceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeExperienceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeExperienceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultKendraClient.lambda$describeExperience$23((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeFaqResponse describeFaq(DescribeFaqRequest describeFaqRequest) throws ValidationException, ResourceNotFoundException, ThrottlingException, AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException, KendraException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeFaqResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultKendraClient.resolveMetricPublishers(this.clientConfiguration, describeFaqRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"kendra");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeFaq");
            DescribeFaqResponse describeFaqResponse = (DescribeFaqResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeFaq").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeFaqRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeFaqRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeFaqResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultKendraClient.lambda$describeFaq$24((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeIndexResponse describeIndex(DescribeIndexRequest describeIndexRequest) throws ValidationException, ResourceNotFoundException, ThrottlingException, AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException, KendraException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeIndexResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultKendraClient.resolveMetricPublishers(this.clientConfiguration, describeIndexRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"kendra");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeIndex");
            DescribeIndexResponse describeIndexResponse = (DescribeIndexResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeIndex").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeIndexRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeIndexRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeIndexResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultKendraClient.lambda$describeIndex$25((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribePrincipalMappingResponse describePrincipalMapping(DescribePrincipalMappingRequest describePrincipalMappingRequest) throws ValidationException, ResourceNotFoundException, ThrottlingException, AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException, KendraException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribePrincipalMappingResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultKendraClient.resolveMetricPublishers(this.clientConfiguration, describePrincipalMappingRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"kendra");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribePrincipalMapping");
            DescribePrincipalMappingResponse describePrincipalMappingResponse = (DescribePrincipalMappingResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribePrincipalMapping").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describePrincipalMappingRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribePrincipalMappingRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describePrincipalMappingResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultKendraClient.lambda$describePrincipalMapping$26((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeQuerySuggestionsBlockListResponse describeQuerySuggestionsBlockList(DescribeQuerySuggestionsBlockListRequest describeQuerySuggestionsBlockListRequest) throws ValidationException, ResourceNotFoundException, ThrottlingException, AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException, KendraException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeQuerySuggestionsBlockListResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultKendraClient.resolveMetricPublishers(this.clientConfiguration, describeQuerySuggestionsBlockListRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"kendra");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeQuerySuggestionsBlockList");
            DescribeQuerySuggestionsBlockListResponse describeQuerySuggestionsBlockListResponse = (DescribeQuerySuggestionsBlockListResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeQuerySuggestionsBlockList").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeQuerySuggestionsBlockListRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeQuerySuggestionsBlockListRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeQuerySuggestionsBlockListResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultKendraClient.lambda$describeQuerySuggestionsBlockList$27((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeQuerySuggestionsConfigResponse describeQuerySuggestionsConfig(DescribeQuerySuggestionsConfigRequest describeQuerySuggestionsConfigRequest) throws ValidationException, ResourceNotFoundException, ThrottlingException, AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException, KendraException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeQuerySuggestionsConfigResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultKendraClient.resolveMetricPublishers(this.clientConfiguration, describeQuerySuggestionsConfigRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"kendra");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeQuerySuggestionsConfig");
            DescribeQuerySuggestionsConfigResponse describeQuerySuggestionsConfigResponse = (DescribeQuerySuggestionsConfigResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeQuerySuggestionsConfig").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeQuerySuggestionsConfigRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeQuerySuggestionsConfigRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeQuerySuggestionsConfigResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultKendraClient.lambda$describeQuerySuggestionsConfig$28((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeThesaurusResponse describeThesaurus(DescribeThesaurusRequest describeThesaurusRequest) throws ValidationException, ResourceNotFoundException, ThrottlingException, AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException, KendraException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeThesaurusResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultKendraClient.resolveMetricPublishers(this.clientConfiguration, describeThesaurusRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"kendra");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeThesaurus");
            DescribeThesaurusResponse describeThesaurusResponse = (DescribeThesaurusResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeThesaurus").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeThesaurusRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeThesaurusRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeThesaurusResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultKendraClient.lambda$describeThesaurus$29((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DisassociateEntitiesFromExperienceResponse disassociateEntitiesFromExperience(DisassociateEntitiesFromExperienceRequest disassociateEntitiesFromExperienceRequest) throws ValidationException, ResourceNotFoundException, ThrottlingException, AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException, KendraException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DisassociateEntitiesFromExperienceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultKendraClient.resolveMetricPublishers(this.clientConfiguration, disassociateEntitiesFromExperienceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"kendra");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DisassociateEntitiesFromExperience");
            DisassociateEntitiesFromExperienceResponse disassociateEntitiesFromExperienceResponse = (DisassociateEntitiesFromExperienceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DisassociateEntitiesFromExperience").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)disassociateEntitiesFromExperienceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DisassociateEntitiesFromExperienceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return disassociateEntitiesFromExperienceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultKendraClient.lambda$disassociateEntitiesFromExperience$30((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DisassociatePersonasFromEntitiesResponse disassociatePersonasFromEntities(DisassociatePersonasFromEntitiesRequest disassociatePersonasFromEntitiesRequest) throws ValidationException, ResourceNotFoundException, ThrottlingException, AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException, KendraException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DisassociatePersonasFromEntitiesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultKendraClient.resolveMetricPublishers(this.clientConfiguration, disassociatePersonasFromEntitiesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"kendra");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DisassociatePersonasFromEntities");
            DisassociatePersonasFromEntitiesResponse disassociatePersonasFromEntitiesResponse = (DisassociatePersonasFromEntitiesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DisassociatePersonasFromEntities").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)disassociatePersonasFromEntitiesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DisassociatePersonasFromEntitiesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return disassociatePersonasFromEntitiesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultKendraClient.lambda$disassociatePersonasFromEntities$31((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetQuerySuggestionsResponse getQuerySuggestions(GetQuerySuggestionsRequest getQuerySuggestionsRequest) throws ValidationException, ResourceNotFoundException, ThrottlingException, AccessDeniedException, ServiceQuotaExceededException, ConflictException, InternalServerException, AwsServiceException, SdkClientException, KendraException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetQuerySuggestionsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultKendraClient.resolveMetricPublishers(this.clientConfiguration, getQuerySuggestionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"kendra");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetQuerySuggestions");
            GetQuerySuggestionsResponse getQuerySuggestionsResponse = (GetQuerySuggestionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetQuerySuggestions").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getQuerySuggestionsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetQuerySuggestionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getQuerySuggestionsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultKendraClient.lambda$getQuerySuggestions$32((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetSnapshotsResponse getSnapshots(GetSnapshotsRequest getSnapshotsRequest) throws InvalidRequestException, ResourceNotFoundException, AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException, KendraException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetSnapshotsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultKendraClient.resolveMetricPublishers(this.clientConfiguration, getSnapshotsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"kendra");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetSnapshots");
            GetSnapshotsResponse getSnapshotsResponse = (GetSnapshotsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetSnapshots").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getSnapshotsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetSnapshotsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getSnapshotsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultKendraClient.lambda$getSnapshots$33((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public GetSnapshotsIterable getSnapshotsPaginator(GetSnapshotsRequest getSnapshotsRequest) throws InvalidRequestException, ResourceNotFoundException, AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException, KendraException {
        return new GetSnapshotsIterable(this, this.applyPaginatorUserAgent(getSnapshotsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListAccessControlConfigurationsResponse listAccessControlConfigurations(ListAccessControlConfigurationsRequest listAccessControlConfigurationsRequest) throws ValidationException, ThrottlingException, ResourceNotFoundException, AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException, KendraException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListAccessControlConfigurationsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultKendraClient.resolveMetricPublishers(this.clientConfiguration, listAccessControlConfigurationsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"kendra");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListAccessControlConfigurations");
            ListAccessControlConfigurationsResponse listAccessControlConfigurationsResponse = (ListAccessControlConfigurationsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListAccessControlConfigurations").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listAccessControlConfigurationsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListAccessControlConfigurationsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listAccessControlConfigurationsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultKendraClient.lambda$listAccessControlConfigurations$34((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListAccessControlConfigurationsIterable listAccessControlConfigurationsPaginator(ListAccessControlConfigurationsRequest listAccessControlConfigurationsRequest) throws ValidationException, ThrottlingException, ResourceNotFoundException, AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException, KendraException {
        return new ListAccessControlConfigurationsIterable(this, this.applyPaginatorUserAgent(listAccessControlConfigurationsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListDataSourceSyncJobsResponse listDataSourceSyncJobs(ListDataSourceSyncJobsRequest listDataSourceSyncJobsRequest) throws ValidationException, ResourceNotFoundException, ThrottlingException, AccessDeniedException, ConflictException, InternalServerException, AwsServiceException, SdkClientException, KendraException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListDataSourceSyncJobsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultKendraClient.resolveMetricPublishers(this.clientConfiguration, listDataSourceSyncJobsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"kendra");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListDataSourceSyncJobs");
            ListDataSourceSyncJobsResponse listDataSourceSyncJobsResponse = (ListDataSourceSyncJobsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListDataSourceSyncJobs").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listDataSourceSyncJobsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListDataSourceSyncJobsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listDataSourceSyncJobsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultKendraClient.lambda$listDataSourceSyncJobs$35((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListDataSourceSyncJobsIterable listDataSourceSyncJobsPaginator(ListDataSourceSyncJobsRequest listDataSourceSyncJobsRequest) throws ValidationException, ResourceNotFoundException, ThrottlingException, AccessDeniedException, ConflictException, InternalServerException, AwsServiceException, SdkClientException, KendraException {
        return new ListDataSourceSyncJobsIterable(this, this.applyPaginatorUserAgent(listDataSourceSyncJobsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListDataSourcesResponse listDataSources(ListDataSourcesRequest listDataSourcesRequest) throws ValidationException, ResourceNotFoundException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, KendraException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListDataSourcesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultKendraClient.resolveMetricPublishers(this.clientConfiguration, listDataSourcesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"kendra");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListDataSources");
            ListDataSourcesResponse listDataSourcesResponse = (ListDataSourcesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListDataSources").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listDataSourcesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListDataSourcesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listDataSourcesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultKendraClient.lambda$listDataSources$36((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListDataSourcesIterable listDataSourcesPaginator(ListDataSourcesRequest listDataSourcesRequest) throws ValidationException, ResourceNotFoundException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, KendraException {
        return new ListDataSourcesIterable(this, this.applyPaginatorUserAgent(listDataSourcesRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListEntityPersonasResponse listEntityPersonas(ListEntityPersonasRequest listEntityPersonasRequest) throws ValidationException, ResourceNotFoundException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, KendraException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListEntityPersonasResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultKendraClient.resolveMetricPublishers(this.clientConfiguration, listEntityPersonasRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"kendra");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListEntityPersonas");
            ListEntityPersonasResponse listEntityPersonasResponse = (ListEntityPersonasResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListEntityPersonas").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listEntityPersonasRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListEntityPersonasRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listEntityPersonasResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultKendraClient.lambda$listEntityPersonas$37((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListEntityPersonasIterable listEntityPersonasPaginator(ListEntityPersonasRequest listEntityPersonasRequest) throws ValidationException, ResourceNotFoundException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, KendraException {
        return new ListEntityPersonasIterable(this, this.applyPaginatorUserAgent(listEntityPersonasRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListExperienceEntitiesResponse listExperienceEntities(ListExperienceEntitiesRequest listExperienceEntitiesRequest) throws ValidationException, ResourceNotFoundException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, KendraException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListExperienceEntitiesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultKendraClient.resolveMetricPublishers(this.clientConfiguration, listExperienceEntitiesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"kendra");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListExperienceEntities");
            ListExperienceEntitiesResponse listExperienceEntitiesResponse = (ListExperienceEntitiesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListExperienceEntities").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listExperienceEntitiesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListExperienceEntitiesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listExperienceEntitiesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultKendraClient.lambda$listExperienceEntities$38((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListExperienceEntitiesIterable listExperienceEntitiesPaginator(ListExperienceEntitiesRequest listExperienceEntitiesRequest) throws ValidationException, ResourceNotFoundException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, KendraException {
        return new ListExperienceEntitiesIterable(this, this.applyPaginatorUserAgent(listExperienceEntitiesRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListExperiencesResponse listExperiences(ListExperiencesRequest listExperiencesRequest) throws ValidationException, ResourceNotFoundException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, KendraException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListExperiencesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultKendraClient.resolveMetricPublishers(this.clientConfiguration, listExperiencesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"kendra");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListExperiences");
            ListExperiencesResponse listExperiencesResponse = (ListExperiencesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListExperiences").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listExperiencesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListExperiencesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listExperiencesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultKendraClient.lambda$listExperiences$39((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListExperiencesIterable listExperiencesPaginator(ListExperiencesRequest listExperiencesRequest) throws ValidationException, ResourceNotFoundException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, KendraException {
        return new ListExperiencesIterable(this, this.applyPaginatorUserAgent(listExperiencesRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListFaqsResponse listFaqs(ListFaqsRequest listFaqsRequest) throws ValidationException, ResourceNotFoundException, ThrottlingException, AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException, KendraException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListFaqsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultKendraClient.resolveMetricPublishers(this.clientConfiguration, listFaqsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"kendra");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListFaqs");
            ListFaqsResponse listFaqsResponse = (ListFaqsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListFaqs").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listFaqsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListFaqsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listFaqsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultKendraClient.lambda$listFaqs$40((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListFaqsIterable listFaqsPaginator(ListFaqsRequest listFaqsRequest) throws ValidationException, ResourceNotFoundException, ThrottlingException, AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException, KendraException {
        return new ListFaqsIterable(this, this.applyPaginatorUserAgent(listFaqsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListGroupsOlderThanOrderingIdResponse listGroupsOlderThanOrderingId(ListGroupsOlderThanOrderingIdRequest listGroupsOlderThanOrderingIdRequest) throws ValidationException, ResourceNotFoundException, AccessDeniedException, ThrottlingException, ConflictException, InternalServerException, AwsServiceException, SdkClientException, KendraException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListGroupsOlderThanOrderingIdResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultKendraClient.resolveMetricPublishers(this.clientConfiguration, listGroupsOlderThanOrderingIdRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"kendra");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListGroupsOlderThanOrderingId");
            ListGroupsOlderThanOrderingIdResponse listGroupsOlderThanOrderingIdResponse = (ListGroupsOlderThanOrderingIdResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListGroupsOlderThanOrderingId").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listGroupsOlderThanOrderingIdRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListGroupsOlderThanOrderingIdRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listGroupsOlderThanOrderingIdResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultKendraClient.lambda$listGroupsOlderThanOrderingId$41((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListGroupsOlderThanOrderingIdIterable listGroupsOlderThanOrderingIdPaginator(ListGroupsOlderThanOrderingIdRequest listGroupsOlderThanOrderingIdRequest) throws ValidationException, ResourceNotFoundException, AccessDeniedException, ThrottlingException, ConflictException, InternalServerException, AwsServiceException, SdkClientException, KendraException {
        return new ListGroupsOlderThanOrderingIdIterable(this, this.applyPaginatorUserAgent(listGroupsOlderThanOrderingIdRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListIndicesResponse listIndices(ListIndicesRequest listIndicesRequest) throws ValidationException, ThrottlingException, AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException, KendraException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListIndicesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultKendraClient.resolveMetricPublishers(this.clientConfiguration, listIndicesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"kendra");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListIndices");
            ListIndicesResponse listIndicesResponse = (ListIndicesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListIndices").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listIndicesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListIndicesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listIndicesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultKendraClient.lambda$listIndices$42((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListIndicesIterable listIndicesPaginator(ListIndicesRequest listIndicesRequest) throws ValidationException, ThrottlingException, AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException, KendraException {
        return new ListIndicesIterable(this, this.applyPaginatorUserAgent(listIndicesRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListQuerySuggestionsBlockListsResponse listQuerySuggestionsBlockLists(ListQuerySuggestionsBlockListsRequest listQuerySuggestionsBlockListsRequest) throws ValidationException, ResourceNotFoundException, ThrottlingException, AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException, KendraException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListQuerySuggestionsBlockListsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultKendraClient.resolveMetricPublishers(this.clientConfiguration, listQuerySuggestionsBlockListsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"kendra");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListQuerySuggestionsBlockLists");
            ListQuerySuggestionsBlockListsResponse listQuerySuggestionsBlockListsResponse = (ListQuerySuggestionsBlockListsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListQuerySuggestionsBlockLists").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listQuerySuggestionsBlockListsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListQuerySuggestionsBlockListsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listQuerySuggestionsBlockListsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultKendraClient.lambda$listQuerySuggestionsBlockLists$43((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListQuerySuggestionsBlockListsIterable listQuerySuggestionsBlockListsPaginator(ListQuerySuggestionsBlockListsRequest listQuerySuggestionsBlockListsRequest) throws ValidationException, ResourceNotFoundException, ThrottlingException, AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException, KendraException {
        return new ListQuerySuggestionsBlockListsIterable(this, this.applyPaginatorUserAgent(listQuerySuggestionsBlockListsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) throws ValidationException, ResourceUnavailableException, ThrottlingException, AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException, KendraException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTagsForResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultKendraClient.resolveMetricPublishers(this.clientConfiguration, listTagsForResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"kendra");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTagsForResource");
            ListTagsForResourceResponse listTagsForResourceResponse = (ListTagsForResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTagsForResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listTagsForResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListTagsForResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listTagsForResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultKendraClient.lambda$listTagsForResource$44((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListThesauriResponse listThesauri(ListThesauriRequest listThesauriRequest) throws ValidationException, ResourceNotFoundException, ThrottlingException, AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException, KendraException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListThesauriResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultKendraClient.resolveMetricPublishers(this.clientConfiguration, listThesauriRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"kendra");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListThesauri");
            ListThesauriResponse listThesauriResponse = (ListThesauriResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListThesauri").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listThesauriRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListThesauriRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listThesauriResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultKendraClient.lambda$listThesauri$45((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListThesauriIterable listThesauriPaginator(ListThesauriRequest listThesauriRequest) throws ValidationException, ResourceNotFoundException, ThrottlingException, AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException, KendraException {
        return new ListThesauriIterable(this, this.applyPaginatorUserAgent(listThesauriRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutPrincipalMappingResponse putPrincipalMapping(PutPrincipalMappingRequest putPrincipalMappingRequest) throws ValidationException, ConflictException, ResourceNotFoundException, ThrottlingException, AccessDeniedException, ServiceQuotaExceededException, InternalServerException, AwsServiceException, SdkClientException, KendraException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutPrincipalMappingResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultKendraClient.resolveMetricPublishers(this.clientConfiguration, putPrincipalMappingRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"kendra");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutPrincipalMapping");
            PutPrincipalMappingResponse putPrincipalMappingResponse = (PutPrincipalMappingResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutPrincipalMapping").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)putPrincipalMappingRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new PutPrincipalMappingRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return putPrincipalMappingResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultKendraClient.lambda$putPrincipalMapping$46((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public QueryResponse query(QueryRequest queryRequest) throws ValidationException, ConflictException, ResourceNotFoundException, ThrottlingException, AccessDeniedException, ServiceQuotaExceededException, InternalServerException, AwsServiceException, SdkClientException, KendraException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, QueryResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultKendraClient.resolveMetricPublishers(this.clientConfiguration, queryRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"kendra");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"Query");
            QueryResponse queryResponse = (QueryResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("Query").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)queryRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new QueryRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return queryResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultKendraClient.lambda$query$47((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StartDataSourceSyncJobResponse startDataSourceSyncJob(StartDataSourceSyncJobRequest startDataSourceSyncJobRequest) throws ValidationException, ResourceNotFoundException, ResourceInUseException, ThrottlingException, AccessDeniedException, ConflictException, InternalServerException, AwsServiceException, SdkClientException, KendraException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartDataSourceSyncJobResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultKendraClient.resolveMetricPublishers(this.clientConfiguration, startDataSourceSyncJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"kendra");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartDataSourceSyncJob");
            StartDataSourceSyncJobResponse startDataSourceSyncJobResponse = (StartDataSourceSyncJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartDataSourceSyncJob").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)startDataSourceSyncJobRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StartDataSourceSyncJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return startDataSourceSyncJobResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultKendraClient.lambda$startDataSourceSyncJob$48((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StopDataSourceSyncJobResponse stopDataSourceSyncJob(StopDataSourceSyncJobRequest stopDataSourceSyncJobRequest) throws ValidationException, ResourceNotFoundException, ThrottlingException, AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException, KendraException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StopDataSourceSyncJobResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultKendraClient.resolveMetricPublishers(this.clientConfiguration, stopDataSourceSyncJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"kendra");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StopDataSourceSyncJob");
            StopDataSourceSyncJobResponse stopDataSourceSyncJobResponse = (StopDataSourceSyncJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StopDataSourceSyncJob").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)stopDataSourceSyncJobRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StopDataSourceSyncJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return stopDataSourceSyncJobResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultKendraClient.lambda$stopDataSourceSyncJob$49((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SubmitFeedbackResponse submitFeedback(SubmitFeedbackRequest submitFeedbackRequest) throws ValidationException, ResourceUnavailableException, ResourceNotFoundException, ThrottlingException, AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException, KendraException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, SubmitFeedbackResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultKendraClient.resolveMetricPublishers(this.clientConfiguration, submitFeedbackRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"kendra");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"SubmitFeedback");
            SubmitFeedbackResponse submitFeedbackResponse = (SubmitFeedbackResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("SubmitFeedback").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)submitFeedbackRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new SubmitFeedbackRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return submitFeedbackResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultKendraClient.lambda$submitFeedback$50((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws ValidationException, ResourceUnavailableException, ThrottlingException, AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException, KendraException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TagResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultKendraClient.resolveMetricPublishers(this.clientConfiguration, tagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"kendra");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TagResource");
            TagResourceResponse tagResourceResponse = (TagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("TagResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)tagResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new TagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return tagResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultKendraClient.lambda$tagResource$51((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws ValidationException, ResourceUnavailableException, ThrottlingException, AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException, KendraException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UntagResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultKendraClient.resolveMetricPublishers(this.clientConfiguration, untagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"kendra");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UntagResource");
            UntagResourceResponse untagResourceResponse = (UntagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UntagResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)untagResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UntagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return untagResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultKendraClient.lambda$untagResource$52((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateAccessControlConfigurationResponse updateAccessControlConfiguration(UpdateAccessControlConfigurationRequest updateAccessControlConfigurationRequest) throws ValidationException, ThrottlingException, ConflictException, ResourceNotFoundException, AccessDeniedException, ServiceQuotaExceededException, InternalServerException, AwsServiceException, SdkClientException, KendraException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateAccessControlConfigurationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultKendraClient.resolveMetricPublishers(this.clientConfiguration, updateAccessControlConfigurationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"kendra");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateAccessControlConfiguration");
            UpdateAccessControlConfigurationResponse updateAccessControlConfigurationResponse = (UpdateAccessControlConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateAccessControlConfiguration").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateAccessControlConfigurationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateAccessControlConfigurationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateAccessControlConfigurationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultKendraClient.lambda$updateAccessControlConfiguration$53((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateDataSourceResponse updateDataSource(UpdateDataSourceRequest updateDataSourceRequest) throws ValidationException, ConflictException, ResourceNotFoundException, ThrottlingException, AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException, KendraException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateDataSourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultKendraClient.resolveMetricPublishers(this.clientConfiguration, updateDataSourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"kendra");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateDataSource");
            UpdateDataSourceResponse updateDataSourceResponse = (UpdateDataSourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateDataSource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateDataSourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateDataSourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateDataSourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultKendraClient.lambda$updateDataSource$54((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateExperienceResponse updateExperience(UpdateExperienceRequest updateExperienceRequest) throws ValidationException, ConflictException, ResourceNotFoundException, ThrottlingException, AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException, KendraException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateExperienceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultKendraClient.resolveMetricPublishers(this.clientConfiguration, updateExperienceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"kendra");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateExperience");
            UpdateExperienceResponse updateExperienceResponse = (UpdateExperienceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateExperience").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateExperienceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateExperienceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateExperienceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultKendraClient.lambda$updateExperience$55((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateIndexResponse updateIndex(UpdateIndexRequest updateIndexRequest) throws ValidationException, ConflictException, ResourceNotFoundException, ThrottlingException, AccessDeniedException, ServiceQuotaExceededException, InternalServerException, AwsServiceException, SdkClientException, KendraException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateIndexResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultKendraClient.resolveMetricPublishers(this.clientConfiguration, updateIndexRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"kendra");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateIndex");
            UpdateIndexResponse updateIndexResponse = (UpdateIndexResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateIndex").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateIndexRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateIndexRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateIndexResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultKendraClient.lambda$updateIndex$56((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateQuerySuggestionsBlockListResponse updateQuerySuggestionsBlockList(UpdateQuerySuggestionsBlockListRequest updateQuerySuggestionsBlockListRequest) throws ValidationException, ResourceNotFoundException, ThrottlingException, AccessDeniedException, ConflictException, InternalServerException, AwsServiceException, SdkClientException, KendraException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateQuerySuggestionsBlockListResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultKendraClient.resolveMetricPublishers(this.clientConfiguration, updateQuerySuggestionsBlockListRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"kendra");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateQuerySuggestionsBlockList");
            UpdateQuerySuggestionsBlockListResponse updateQuerySuggestionsBlockListResponse = (UpdateQuerySuggestionsBlockListResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateQuerySuggestionsBlockList").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateQuerySuggestionsBlockListRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateQuerySuggestionsBlockListRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateQuerySuggestionsBlockListResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultKendraClient.lambda$updateQuerySuggestionsBlockList$57((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateQuerySuggestionsConfigResponse updateQuerySuggestionsConfig(UpdateQuerySuggestionsConfigRequest updateQuerySuggestionsConfigRequest) throws ValidationException, ConflictException, ResourceNotFoundException, ThrottlingException, AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException, KendraException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateQuerySuggestionsConfigResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultKendraClient.resolveMetricPublishers(this.clientConfiguration, updateQuerySuggestionsConfigRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"kendra");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateQuerySuggestionsConfig");
            UpdateQuerySuggestionsConfigResponse updateQuerySuggestionsConfigResponse = (UpdateQuerySuggestionsConfigResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateQuerySuggestionsConfig").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateQuerySuggestionsConfigRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateQuerySuggestionsConfigRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateQuerySuggestionsConfigResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultKendraClient.lambda$updateQuerySuggestionsConfig$58((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateThesaurusResponse updateThesaurus(UpdateThesaurusRequest updateThesaurusRequest) throws ValidationException, ResourceNotFoundException, ThrottlingException, AccessDeniedException, ConflictException, InternalServerException, AwsServiceException, SdkClientException, KendraException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateThesaurusResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultKendraClient.resolveMetricPublishers(this.clientConfiguration, updateThesaurusRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"kendra");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateThesaurus");
            UpdateThesaurusResponse updateThesaurusResponse = (UpdateThesaurusResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateThesaurus").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateThesaurusRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateThesaurusRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateThesaurusResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultKendraClient.lambda$updateThesaurus$59((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(KendraException::builder).protocol(AwsJsonProtocol.AWS_JSON).protocolVersion("1.1").registerModeledException(ExceptionMetadata.builder().errorCode("InvalidRequestException").exceptionBuilderSupplier(InvalidRequestException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").exceptionBuilderSupplier(ServiceQuotaExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InternalServerException").exceptionBuilderSupplier(InternalServerException::builder).httpStatusCode(Integer.valueOf(500)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").exceptionBuilderSupplier(ResourceNotFoundException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").exceptionBuilderSupplier(ResourceUnavailableException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ValidationException").exceptionBuilderSupplier(ValidationException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceInUseException").exceptionBuilderSupplier(ResourceInUseException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ThrottlingException").exceptionBuilderSupplier(ThrottlingException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("AccessDeniedException").exceptionBuilderSupplier(AccessDeniedException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ConflictException").exceptionBuilderSupplier(ConflictException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistException").exceptionBuilderSupplier(ResourceAlreadyExistException::builder).httpStatusCode(Integer.valueOf(400)).build());
    }

    public void close() {
        this.clientHandler.close();
    }

    private <T extends KendraRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> {
            AwsRequestOverrideConfiguration.Builder cfr_ignored_0 = (AwsRequestOverrideConfiguration.Builder)b.addApiName(ApiName.builder().version("2.18.10").name("PAGINATED").build());
        };
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((KendraRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }

    private static /* synthetic */ void lambda$updateThesaurus$59(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateQuerySuggestionsConfig$58(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateQuerySuggestionsBlockList$57(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateIndex$56(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateExperience$55(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateDataSource$54(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateAccessControlConfiguration$53(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$untagResource$52(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$tagResource$51(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$submitFeedback$50(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$stopDataSourceSyncJob$49(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startDataSourceSyncJob$48(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$query$47(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putPrincipalMapping$46(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listThesauri$45(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTagsForResource$44(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listQuerySuggestionsBlockLists$43(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listIndices$42(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listGroupsOlderThanOrderingId$41(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listFaqs$40(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listExperiences$39(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listExperienceEntities$38(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listEntityPersonas$37(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listDataSources$36(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listDataSourceSyncJobs$35(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listAccessControlConfigurations$34(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getSnapshots$33(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getQuerySuggestions$32(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$disassociatePersonasFromEntities$31(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$disassociateEntitiesFromExperience$30(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeThesaurus$29(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeQuerySuggestionsConfig$28(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeQuerySuggestionsBlockList$27(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describePrincipalMapping$26(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeIndex$25(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeFaq$24(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeExperience$23(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeDataSource$22(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeAccessControlConfiguration$21(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteThesaurus$20(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteQuerySuggestionsBlockList$19(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deletePrincipalMapping$18(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteIndex$17(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteFaq$16(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteExperience$15(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteDataSource$14(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteAccessControlConfiguration$13(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createThesaurus$12(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createQuerySuggestionsBlockList$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createIndex$10(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createFaq$9(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createExperience$8(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createDataSource$7(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createAccessControlConfiguration$6(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$clearQuerySuggestions$5(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$batchPutDocument$4(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$batchGetDocumentStatus$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$batchDeleteDocument$2(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$associatePersonasToEntities$1(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$associateEntitiesToExperience$0(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }
}

