/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kendra.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.kendra.model.DataSourceInclusionsExclusionsStringsCopier;
import software.amazon.awssdk.services.kendra.model.DataSourceToIndexFieldMapping;
import software.amazon.awssdk.services.kendra.model.DataSourceToIndexFieldMappingListCopier;
import software.amazon.awssdk.services.kendra.model.DataSourceVpcConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BoxConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BoxConfiguration> {
    private static final SdkField<String> ENTERPRISE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EnterpriseId").getter(BoxConfiguration.getter(BoxConfiguration::enterpriseId)).setter(BoxConfiguration.setter(Builder::enterpriseId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnterpriseId").build()}).build();
    private static final SdkField<String> SECRET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SecretArn").getter(BoxConfiguration.getter(BoxConfiguration::secretArn)).setter(BoxConfiguration.setter(Builder::secretArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecretArn").build()}).build();
    private static final SdkField<Boolean> USE_CHANGE_LOG_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("UseChangeLog").getter(BoxConfiguration.getter(BoxConfiguration::useChangeLog)).setter(BoxConfiguration.setter(Builder::useChangeLog)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UseChangeLog").build()}).build();
    private static final SdkField<Boolean> CRAWL_COMMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("CrawlComments").getter(BoxConfiguration.getter(BoxConfiguration::crawlComments)).setter(BoxConfiguration.setter(Builder::crawlComments)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CrawlComments").build()}).build();
    private static final SdkField<Boolean> CRAWL_TASKS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("CrawlTasks").getter(BoxConfiguration.getter(BoxConfiguration::crawlTasks)).setter(BoxConfiguration.setter(Builder::crawlTasks)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CrawlTasks").build()}).build();
    private static final SdkField<Boolean> CRAWL_WEB_LINKS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("CrawlWebLinks").getter(BoxConfiguration.getter(BoxConfiguration::crawlWebLinks)).setter(BoxConfiguration.setter(Builder::crawlWebLinks)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CrawlWebLinks").build()}).build();
    private static final SdkField<List<DataSourceToIndexFieldMapping>> FILE_FIELD_MAPPINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("FileFieldMappings").getter(BoxConfiguration.getter(BoxConfiguration::fileFieldMappings)).setter(BoxConfiguration.setter(Builder::fileFieldMappings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileFieldMappings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DataSourceToIndexFieldMapping::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<DataSourceToIndexFieldMapping>> TASK_FIELD_MAPPINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TaskFieldMappings").getter(BoxConfiguration.getter(BoxConfiguration::taskFieldMappings)).setter(BoxConfiguration.setter(Builder::taskFieldMappings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TaskFieldMappings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DataSourceToIndexFieldMapping::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<DataSourceToIndexFieldMapping>> COMMENT_FIELD_MAPPINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CommentFieldMappings").getter(BoxConfiguration.getter(BoxConfiguration::commentFieldMappings)).setter(BoxConfiguration.setter(Builder::commentFieldMappings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CommentFieldMappings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DataSourceToIndexFieldMapping::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<DataSourceToIndexFieldMapping>> WEB_LINK_FIELD_MAPPINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("WebLinkFieldMappings").getter(BoxConfiguration.getter(BoxConfiguration::webLinkFieldMappings)).setter(BoxConfiguration.setter(Builder::webLinkFieldMappings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WebLinkFieldMappings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DataSourceToIndexFieldMapping::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> INCLUSION_PATTERNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("InclusionPatterns").getter(BoxConfiguration.getter(BoxConfiguration::inclusionPatterns)).setter(BoxConfiguration.setter(Builder::inclusionPatterns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InclusionPatterns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> EXCLUSION_PATTERNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ExclusionPatterns").getter(BoxConfiguration.getter(BoxConfiguration::exclusionPatterns)).setter(BoxConfiguration.setter(Builder::exclusionPatterns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExclusionPatterns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<DataSourceVpcConfiguration> VPC_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("VpcConfiguration").getter(BoxConfiguration.getter(BoxConfiguration::vpcConfiguration)).setter(BoxConfiguration.setter(Builder::vpcConfiguration)).constructor(DataSourceVpcConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENTERPRISE_ID_FIELD, SECRET_ARN_FIELD, USE_CHANGE_LOG_FIELD, CRAWL_COMMENTS_FIELD, CRAWL_TASKS_FIELD, CRAWL_WEB_LINKS_FIELD, FILE_FIELD_MAPPINGS_FIELD, TASK_FIELD_MAPPINGS_FIELD, COMMENT_FIELD_MAPPINGS_FIELD, WEB_LINK_FIELD_MAPPINGS_FIELD, INCLUSION_PATTERNS_FIELD, EXCLUSION_PATTERNS_FIELD, VPC_CONFIGURATION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String enterpriseId;
    private final String secretArn;
    private final Boolean useChangeLog;
    private final Boolean crawlComments;
    private final Boolean crawlTasks;
    private final Boolean crawlWebLinks;
    private final List<DataSourceToIndexFieldMapping> fileFieldMappings;
    private final List<DataSourceToIndexFieldMapping> taskFieldMappings;
    private final List<DataSourceToIndexFieldMapping> commentFieldMappings;
    private final List<DataSourceToIndexFieldMapping> webLinkFieldMappings;
    private final List<String> inclusionPatterns;
    private final List<String> exclusionPatterns;
    private final DataSourceVpcConfiguration vpcConfiguration;

    private BoxConfiguration(BuilderImpl builder) {
        this.enterpriseId = builder.enterpriseId;
        this.secretArn = builder.secretArn;
        this.useChangeLog = builder.useChangeLog;
        this.crawlComments = builder.crawlComments;
        this.crawlTasks = builder.crawlTasks;
        this.crawlWebLinks = builder.crawlWebLinks;
        this.fileFieldMappings = builder.fileFieldMappings;
        this.taskFieldMappings = builder.taskFieldMappings;
        this.commentFieldMappings = builder.commentFieldMappings;
        this.webLinkFieldMappings = builder.webLinkFieldMappings;
        this.inclusionPatterns = builder.inclusionPatterns;
        this.exclusionPatterns = builder.exclusionPatterns;
        this.vpcConfiguration = builder.vpcConfiguration;
    }

    public final String enterpriseId() {
        return this.enterpriseId;
    }

    public final String secretArn() {
        return this.secretArn;
    }

    public final Boolean useChangeLog() {
        return this.useChangeLog;
    }

    public final Boolean crawlComments() {
        return this.crawlComments;
    }

    public final Boolean crawlTasks() {
        return this.crawlTasks;
    }

    public final Boolean crawlWebLinks() {
        return this.crawlWebLinks;
    }

    public final boolean hasFileFieldMappings() {
        return this.fileFieldMappings != null && !(this.fileFieldMappings instanceof SdkAutoConstructList);
    }

    public final List<DataSourceToIndexFieldMapping> fileFieldMappings() {
        return this.fileFieldMappings;
    }

    public final boolean hasTaskFieldMappings() {
        return this.taskFieldMappings != null && !(this.taskFieldMappings instanceof SdkAutoConstructList);
    }

    public final List<DataSourceToIndexFieldMapping> taskFieldMappings() {
        return this.taskFieldMappings;
    }

    public final boolean hasCommentFieldMappings() {
        return this.commentFieldMappings != null && !(this.commentFieldMappings instanceof SdkAutoConstructList);
    }

    public final List<DataSourceToIndexFieldMapping> commentFieldMappings() {
        return this.commentFieldMappings;
    }

    public final boolean hasWebLinkFieldMappings() {
        return this.webLinkFieldMappings != null && !(this.webLinkFieldMappings instanceof SdkAutoConstructList);
    }

    public final List<DataSourceToIndexFieldMapping> webLinkFieldMappings() {
        return this.webLinkFieldMappings;
    }

    public final boolean hasInclusionPatterns() {
        return this.inclusionPatterns != null && !(this.inclusionPatterns instanceof SdkAutoConstructList);
    }

    public final List<String> inclusionPatterns() {
        return this.inclusionPatterns;
    }

    public final boolean hasExclusionPatterns() {
        return this.exclusionPatterns != null && !(this.exclusionPatterns instanceof SdkAutoConstructList);
    }

    public final List<String> exclusionPatterns() {
        return this.exclusionPatterns;
    }

    public final DataSourceVpcConfiguration vpcConfiguration() {
        return this.vpcConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.enterpriseId());
        hashCode = 31 * hashCode + Objects.hashCode(this.secretArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.useChangeLog());
        hashCode = 31 * hashCode + Objects.hashCode(this.crawlComments());
        hashCode = 31 * hashCode + Objects.hashCode(this.crawlTasks());
        hashCode = 31 * hashCode + Objects.hashCode(this.crawlWebLinks());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFileFieldMappings() ? this.fileFieldMappings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTaskFieldMappings() ? this.taskFieldMappings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCommentFieldMappings() ? this.commentFieldMappings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasWebLinkFieldMappings() ? this.webLinkFieldMappings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInclusionPatterns() ? this.inclusionPatterns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasExclusionPatterns() ? this.exclusionPatterns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BoxConfiguration)) {
            return false;
        }
        BoxConfiguration other = (BoxConfiguration)obj;
        return Objects.equals(this.enterpriseId(), other.enterpriseId()) && Objects.equals(this.secretArn(), other.secretArn()) && Objects.equals(this.useChangeLog(), other.useChangeLog()) && Objects.equals(this.crawlComments(), other.crawlComments()) && Objects.equals(this.crawlTasks(), other.crawlTasks()) && Objects.equals(this.crawlWebLinks(), other.crawlWebLinks()) && this.hasFileFieldMappings() == other.hasFileFieldMappings() && Objects.equals(this.fileFieldMappings(), other.fileFieldMappings()) && this.hasTaskFieldMappings() == other.hasTaskFieldMappings() && Objects.equals(this.taskFieldMappings(), other.taskFieldMappings()) && this.hasCommentFieldMappings() == other.hasCommentFieldMappings() && Objects.equals(this.commentFieldMappings(), other.commentFieldMappings()) && this.hasWebLinkFieldMappings() == other.hasWebLinkFieldMappings() && Objects.equals(this.webLinkFieldMappings(), other.webLinkFieldMappings()) && this.hasInclusionPatterns() == other.hasInclusionPatterns() && Objects.equals(this.inclusionPatterns(), other.inclusionPatterns()) && this.hasExclusionPatterns() == other.hasExclusionPatterns() && Objects.equals(this.exclusionPatterns(), other.exclusionPatterns()) && Objects.equals(this.vpcConfiguration(), other.vpcConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"BoxConfiguration").add("EnterpriseId", (Object)this.enterpriseId()).add("SecretArn", (Object)this.secretArn()).add("UseChangeLog", (Object)this.useChangeLog()).add("CrawlComments", (Object)this.crawlComments()).add("CrawlTasks", (Object)this.crawlTasks()).add("CrawlWebLinks", (Object)this.crawlWebLinks()).add("FileFieldMappings", this.hasFileFieldMappings() ? this.fileFieldMappings() : null).add("TaskFieldMappings", this.hasTaskFieldMappings() ? this.taskFieldMappings() : null).add("CommentFieldMappings", this.hasCommentFieldMappings() ? this.commentFieldMappings() : null).add("WebLinkFieldMappings", this.hasWebLinkFieldMappings() ? this.webLinkFieldMappings() : null).add("InclusionPatterns", this.hasInclusionPatterns() ? this.inclusionPatterns() : null).add("ExclusionPatterns", this.hasExclusionPatterns() ? this.exclusionPatterns() : null).add("VpcConfiguration", (Object)this.vpcConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EnterpriseId": {
                return Optional.ofNullable(clazz.cast(this.enterpriseId()));
            }
            case "SecretArn": {
                return Optional.ofNullable(clazz.cast(this.secretArn()));
            }
            case "UseChangeLog": {
                return Optional.ofNullable(clazz.cast(this.useChangeLog()));
            }
            case "CrawlComments": {
                return Optional.ofNullable(clazz.cast(this.crawlComments()));
            }
            case "CrawlTasks": {
                return Optional.ofNullable(clazz.cast(this.crawlTasks()));
            }
            case "CrawlWebLinks": {
                return Optional.ofNullable(clazz.cast(this.crawlWebLinks()));
            }
            case "FileFieldMappings": {
                return Optional.ofNullable(clazz.cast(this.fileFieldMappings()));
            }
            case "TaskFieldMappings": {
                return Optional.ofNullable(clazz.cast(this.taskFieldMappings()));
            }
            case "CommentFieldMappings": {
                return Optional.ofNullable(clazz.cast(this.commentFieldMappings()));
            }
            case "WebLinkFieldMappings": {
                return Optional.ofNullable(clazz.cast(this.webLinkFieldMappings()));
            }
            case "InclusionPatterns": {
                return Optional.ofNullable(clazz.cast(this.inclusionPatterns()));
            }
            case "ExclusionPatterns": {
                return Optional.ofNullable(clazz.cast(this.exclusionPatterns()));
            }
            case "VpcConfiguration": {
                return Optional.ofNullable(clazz.cast(this.vpcConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BoxConfiguration, T> g) {
        return obj -> g.apply((BoxConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String enterpriseId;
        private String secretArn;
        private Boolean useChangeLog;
        private Boolean crawlComments;
        private Boolean crawlTasks;
        private Boolean crawlWebLinks;
        private List<DataSourceToIndexFieldMapping> fileFieldMappings = DefaultSdkAutoConstructList.getInstance();
        private List<DataSourceToIndexFieldMapping> taskFieldMappings = DefaultSdkAutoConstructList.getInstance();
        private List<DataSourceToIndexFieldMapping> commentFieldMappings = DefaultSdkAutoConstructList.getInstance();
        private List<DataSourceToIndexFieldMapping> webLinkFieldMappings = DefaultSdkAutoConstructList.getInstance();
        private List<String> inclusionPatterns = DefaultSdkAutoConstructList.getInstance();
        private List<String> exclusionPatterns = DefaultSdkAutoConstructList.getInstance();
        private DataSourceVpcConfiguration vpcConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(BoxConfiguration model) {
            this.enterpriseId(model.enterpriseId);
            this.secretArn(model.secretArn);
            this.useChangeLog(model.useChangeLog);
            this.crawlComments(model.crawlComments);
            this.crawlTasks(model.crawlTasks);
            this.crawlWebLinks(model.crawlWebLinks);
            this.fileFieldMappings(model.fileFieldMappings);
            this.taskFieldMappings(model.taskFieldMappings);
            this.commentFieldMappings(model.commentFieldMappings);
            this.webLinkFieldMappings(model.webLinkFieldMappings);
            this.inclusionPatterns(model.inclusionPatterns);
            this.exclusionPatterns(model.exclusionPatterns);
            this.vpcConfiguration(model.vpcConfiguration);
        }

        public final String getEnterpriseId() {
            return this.enterpriseId;
        }

        public final void setEnterpriseId(String enterpriseId) {
            this.enterpriseId = enterpriseId;
        }

        @Override
        public final Builder enterpriseId(String enterpriseId) {
            this.enterpriseId = enterpriseId;
            return this;
        }

        public final String getSecretArn() {
            return this.secretArn;
        }

        public final void setSecretArn(String secretArn) {
            this.secretArn = secretArn;
        }

        @Override
        public final Builder secretArn(String secretArn) {
            this.secretArn = secretArn;
            return this;
        }

        public final Boolean getUseChangeLog() {
            return this.useChangeLog;
        }

        public final void setUseChangeLog(Boolean useChangeLog) {
            this.useChangeLog = useChangeLog;
        }

        @Override
        public final Builder useChangeLog(Boolean useChangeLog) {
            this.useChangeLog = useChangeLog;
            return this;
        }

        public final Boolean getCrawlComments() {
            return this.crawlComments;
        }

        public final void setCrawlComments(Boolean crawlComments) {
            this.crawlComments = crawlComments;
        }

        @Override
        public final Builder crawlComments(Boolean crawlComments) {
            this.crawlComments = crawlComments;
            return this;
        }

        public final Boolean getCrawlTasks() {
            return this.crawlTasks;
        }

        public final void setCrawlTasks(Boolean crawlTasks) {
            this.crawlTasks = crawlTasks;
        }

        @Override
        public final Builder crawlTasks(Boolean crawlTasks) {
            this.crawlTasks = crawlTasks;
            return this;
        }

        public final Boolean getCrawlWebLinks() {
            return this.crawlWebLinks;
        }

        public final void setCrawlWebLinks(Boolean crawlWebLinks) {
            this.crawlWebLinks = crawlWebLinks;
        }

        @Override
        public final Builder crawlWebLinks(Boolean crawlWebLinks) {
            this.crawlWebLinks = crawlWebLinks;
            return this;
        }

        public final List<DataSourceToIndexFieldMapping.Builder> getFileFieldMappings() {
            List<DataSourceToIndexFieldMapping.Builder> result = DataSourceToIndexFieldMappingListCopier.copyToBuilder(this.fileFieldMappings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFileFieldMappings(Collection<DataSourceToIndexFieldMapping.BuilderImpl> fileFieldMappings) {
            this.fileFieldMappings = DataSourceToIndexFieldMappingListCopier.copyFromBuilder(fileFieldMappings);
        }

        @Override
        public final Builder fileFieldMappings(Collection<DataSourceToIndexFieldMapping> fileFieldMappings) {
            this.fileFieldMappings = DataSourceToIndexFieldMappingListCopier.copy(fileFieldMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fileFieldMappings(DataSourceToIndexFieldMapping ... fileFieldMappings) {
            this.fileFieldMappings(Arrays.asList(fileFieldMappings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fileFieldMappings(Consumer<DataSourceToIndexFieldMapping.Builder> ... fileFieldMappings) {
            this.fileFieldMappings(Stream.of(fileFieldMappings).map(c -> (DataSourceToIndexFieldMapping)((DataSourceToIndexFieldMapping.Builder)DataSourceToIndexFieldMapping.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<DataSourceToIndexFieldMapping.Builder> getTaskFieldMappings() {
            List<DataSourceToIndexFieldMapping.Builder> result = DataSourceToIndexFieldMappingListCopier.copyToBuilder(this.taskFieldMappings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTaskFieldMappings(Collection<DataSourceToIndexFieldMapping.BuilderImpl> taskFieldMappings) {
            this.taskFieldMappings = DataSourceToIndexFieldMappingListCopier.copyFromBuilder(taskFieldMappings);
        }

        @Override
        public final Builder taskFieldMappings(Collection<DataSourceToIndexFieldMapping> taskFieldMappings) {
            this.taskFieldMappings = DataSourceToIndexFieldMappingListCopier.copy(taskFieldMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder taskFieldMappings(DataSourceToIndexFieldMapping ... taskFieldMappings) {
            this.taskFieldMappings(Arrays.asList(taskFieldMappings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder taskFieldMappings(Consumer<DataSourceToIndexFieldMapping.Builder> ... taskFieldMappings) {
            this.taskFieldMappings(Stream.of(taskFieldMappings).map(c -> (DataSourceToIndexFieldMapping)((DataSourceToIndexFieldMapping.Builder)DataSourceToIndexFieldMapping.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<DataSourceToIndexFieldMapping.Builder> getCommentFieldMappings() {
            List<DataSourceToIndexFieldMapping.Builder> result = DataSourceToIndexFieldMappingListCopier.copyToBuilder(this.commentFieldMappings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCommentFieldMappings(Collection<DataSourceToIndexFieldMapping.BuilderImpl> commentFieldMappings) {
            this.commentFieldMappings = DataSourceToIndexFieldMappingListCopier.copyFromBuilder(commentFieldMappings);
        }

        @Override
        public final Builder commentFieldMappings(Collection<DataSourceToIndexFieldMapping> commentFieldMappings) {
            this.commentFieldMappings = DataSourceToIndexFieldMappingListCopier.copy(commentFieldMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder commentFieldMappings(DataSourceToIndexFieldMapping ... commentFieldMappings) {
            this.commentFieldMappings(Arrays.asList(commentFieldMappings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder commentFieldMappings(Consumer<DataSourceToIndexFieldMapping.Builder> ... commentFieldMappings) {
            this.commentFieldMappings(Stream.of(commentFieldMappings).map(c -> (DataSourceToIndexFieldMapping)((DataSourceToIndexFieldMapping.Builder)DataSourceToIndexFieldMapping.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<DataSourceToIndexFieldMapping.Builder> getWebLinkFieldMappings() {
            List<DataSourceToIndexFieldMapping.Builder> result = DataSourceToIndexFieldMappingListCopier.copyToBuilder(this.webLinkFieldMappings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setWebLinkFieldMappings(Collection<DataSourceToIndexFieldMapping.BuilderImpl> webLinkFieldMappings) {
            this.webLinkFieldMappings = DataSourceToIndexFieldMappingListCopier.copyFromBuilder(webLinkFieldMappings);
        }

        @Override
        public final Builder webLinkFieldMappings(Collection<DataSourceToIndexFieldMapping> webLinkFieldMappings) {
            this.webLinkFieldMappings = DataSourceToIndexFieldMappingListCopier.copy(webLinkFieldMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder webLinkFieldMappings(DataSourceToIndexFieldMapping ... webLinkFieldMappings) {
            this.webLinkFieldMappings(Arrays.asList(webLinkFieldMappings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder webLinkFieldMappings(Consumer<DataSourceToIndexFieldMapping.Builder> ... webLinkFieldMappings) {
            this.webLinkFieldMappings(Stream.of(webLinkFieldMappings).map(c -> (DataSourceToIndexFieldMapping)((DataSourceToIndexFieldMapping.Builder)DataSourceToIndexFieldMapping.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getInclusionPatterns() {
            if (this.inclusionPatterns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.inclusionPatterns;
        }

        public final void setInclusionPatterns(Collection<String> inclusionPatterns) {
            this.inclusionPatterns = DataSourceInclusionsExclusionsStringsCopier.copy(inclusionPatterns);
        }

        @Override
        public final Builder inclusionPatterns(Collection<String> inclusionPatterns) {
            this.inclusionPatterns = DataSourceInclusionsExclusionsStringsCopier.copy(inclusionPatterns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inclusionPatterns(String ... inclusionPatterns) {
            this.inclusionPatterns(Arrays.asList(inclusionPatterns));
            return this;
        }

        public final Collection<String> getExclusionPatterns() {
            if (this.exclusionPatterns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.exclusionPatterns;
        }

        public final void setExclusionPatterns(Collection<String> exclusionPatterns) {
            this.exclusionPatterns = DataSourceInclusionsExclusionsStringsCopier.copy(exclusionPatterns);
        }

        @Override
        public final Builder exclusionPatterns(Collection<String> exclusionPatterns) {
            this.exclusionPatterns = DataSourceInclusionsExclusionsStringsCopier.copy(exclusionPatterns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder exclusionPatterns(String ... exclusionPatterns) {
            this.exclusionPatterns(Arrays.asList(exclusionPatterns));
            return this;
        }

        public final DataSourceVpcConfiguration.Builder getVpcConfiguration() {
            return this.vpcConfiguration != null ? this.vpcConfiguration.toBuilder() : null;
        }

        public final void setVpcConfiguration(DataSourceVpcConfiguration.BuilderImpl vpcConfiguration) {
            this.vpcConfiguration = vpcConfiguration != null ? vpcConfiguration.build() : null;
        }

        @Override
        public final Builder vpcConfiguration(DataSourceVpcConfiguration vpcConfiguration) {
            this.vpcConfiguration = vpcConfiguration;
            return this;
        }

        public BoxConfiguration build() {
            return new BoxConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BoxConfiguration> {
        public Builder enterpriseId(String var1);

        public Builder secretArn(String var1);

        public Builder useChangeLog(Boolean var1);

        public Builder crawlComments(Boolean var1);

        public Builder crawlTasks(Boolean var1);

        public Builder crawlWebLinks(Boolean var1);

        public Builder fileFieldMappings(Collection<DataSourceToIndexFieldMapping> var1);

        public Builder fileFieldMappings(DataSourceToIndexFieldMapping ... var1);

        public Builder fileFieldMappings(Consumer<DataSourceToIndexFieldMapping.Builder> ... var1);

        public Builder taskFieldMappings(Collection<DataSourceToIndexFieldMapping> var1);

        public Builder taskFieldMappings(DataSourceToIndexFieldMapping ... var1);

        public Builder taskFieldMappings(Consumer<DataSourceToIndexFieldMapping.Builder> ... var1);

        public Builder commentFieldMappings(Collection<DataSourceToIndexFieldMapping> var1);

        public Builder commentFieldMappings(DataSourceToIndexFieldMapping ... var1);

        public Builder commentFieldMappings(Consumer<DataSourceToIndexFieldMapping.Builder> ... var1);

        public Builder webLinkFieldMappings(Collection<DataSourceToIndexFieldMapping> var1);

        public Builder webLinkFieldMappings(DataSourceToIndexFieldMapping ... var1);

        public Builder webLinkFieldMappings(Consumer<DataSourceToIndexFieldMapping.Builder> ... var1);

        public Builder inclusionPatterns(Collection<String> var1);

        public Builder inclusionPatterns(String ... var1);

        public Builder exclusionPatterns(Collection<String> var1);

        public Builder exclusionPatterns(String ... var1);

        public Builder vpcConfiguration(DataSourceVpcConfiguration var1);

        default public Builder vpcConfiguration(Consumer<DataSourceVpcConfiguration.Builder> vpcConfiguration) {
            return this.vpcConfiguration((DataSourceVpcConfiguration)((DataSourceVpcConfiguration.Builder)DataSourceVpcConfiguration.builder().applyMutation(vpcConfiguration)).build());
        }
    }
}

