/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kendra.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum SalesforceStandardObjectName {
    ACCOUNT("ACCOUNT"),
    CAMPAIGN("CAMPAIGN"),
    CASE("CASE"),
    CONTACT("CONTACT"),
    CONTRACT("CONTRACT"),
    DOCUMENT("DOCUMENT"),
    GROUP("GROUP"),
    IDEA("IDEA"),
    LEAD("LEAD"),
    OPPORTUNITY("OPPORTUNITY"),
    PARTNER("PARTNER"),
    PRICEBOOK("PRICEBOOK"),
    PRODUCT("PRODUCT"),
    PROFILE("PROFILE"),
    SOLUTION("SOLUTION"),
    TASK("TASK"),
    USER("USER"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, SalesforceStandardObjectName> VALUE_MAP;
    private final String value;

    private SalesforceStandardObjectName(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static SalesforceStandardObjectName fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<SalesforceStandardObjectName> knownValues() {
        EnumSet<SalesforceStandardObjectName> knownValues = EnumSet.allOf(SalesforceStandardObjectName.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(SalesforceStandardObjectName.class, SalesforceStandardObjectName::toString);
    }
}

