/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kendra.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides the configuration information to connect to Slack as your data source.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SlackConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<SlackConfiguration.Builder, SlackConfiguration> {
    private static final SdkField<String> TEAM_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("TeamId")
            .getter(getter(SlackConfiguration::teamId)).setter(setter(Builder::teamId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TeamId").build()).build();

    private static final SdkField<String> SECRET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SecretArn").getter(getter(SlackConfiguration::secretArn)).setter(setter(Builder::secretArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecretArn").build()).build();

    private static final SdkField<DataSourceVpcConfiguration> VPC_CONFIGURATION_FIELD = SdkField
            .<DataSourceVpcConfiguration> builder(MarshallingType.SDK_POJO).memberName("VpcConfiguration")
            .getter(getter(SlackConfiguration::vpcConfiguration)).setter(setter(Builder::vpcConfiguration))
            .constructor(DataSourceVpcConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcConfiguration").build()).build();

    private static final SdkField<List<String>> SLACK_ENTITY_LIST_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SlackEntityList")
            .getter(getter(SlackConfiguration::slackEntityListAsStrings))
            .setter(setter(Builder::slackEntityListWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SlackEntityList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> USE_CHANGE_LOG_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("UseChangeLog").getter(getter(SlackConfiguration::useChangeLog)).setter(setter(Builder::useChangeLog))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UseChangeLog").build()).build();

    private static final SdkField<Boolean> CRAWL_BOT_MESSAGE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("CrawlBotMessage").getter(getter(SlackConfiguration::crawlBotMessage))
            .setter(setter(Builder::crawlBotMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CrawlBotMessage").build()).build();

    private static final SdkField<Boolean> EXCLUDE_ARCHIVED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("ExcludeArchived").getter(getter(SlackConfiguration::excludeArchived))
            .setter(setter(Builder::excludeArchived))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExcludeArchived").build()).build();

    private static final SdkField<String> SINCE_CRAWL_DATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SinceCrawlDate").getter(getter(SlackConfiguration::sinceCrawlDate))
            .setter(setter(Builder::sinceCrawlDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SinceCrawlDate").build()).build();

    private static final SdkField<Integer> LOOK_BACK_PERIOD_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("LookBackPeriod").getter(getter(SlackConfiguration::lookBackPeriod))
            .setter(setter(Builder::lookBackPeriod))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LookBackPeriod").build()).build();

    private static final SdkField<List<String>> PRIVATE_CHANNEL_FILTER_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("PrivateChannelFilter")
            .getter(getter(SlackConfiguration::privateChannelFilter))
            .setter(setter(Builder::privateChannelFilter))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrivateChannelFilter").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> PUBLIC_CHANNEL_FILTER_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("PublicChannelFilter")
            .getter(getter(SlackConfiguration::publicChannelFilter))
            .setter(setter(Builder::publicChannelFilter))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PublicChannelFilter").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> INCLUSION_PATTERNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("InclusionPatterns")
            .getter(getter(SlackConfiguration::inclusionPatterns))
            .setter(setter(Builder::inclusionPatterns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InclusionPatterns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> EXCLUSION_PATTERNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ExclusionPatterns")
            .getter(getter(SlackConfiguration::exclusionPatterns))
            .setter(setter(Builder::exclusionPatterns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExclusionPatterns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<DataSourceToIndexFieldMapping>> FIELD_MAPPINGS_FIELD = SdkField
            .<List<DataSourceToIndexFieldMapping>> builder(MarshallingType.LIST)
            .memberName("FieldMappings")
            .getter(getter(SlackConfiguration::fieldMappings))
            .setter(setter(Builder::fieldMappings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FieldMappings").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DataSourceToIndexFieldMapping> builder(MarshallingType.SDK_POJO)
                                            .constructor(DataSourceToIndexFieldMapping::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEAM_ID_FIELD,
            SECRET_ARN_FIELD, VPC_CONFIGURATION_FIELD, SLACK_ENTITY_LIST_FIELD, USE_CHANGE_LOG_FIELD, CRAWL_BOT_MESSAGE_FIELD,
            EXCLUDE_ARCHIVED_FIELD, SINCE_CRAWL_DATE_FIELD, LOOK_BACK_PERIOD_FIELD, PRIVATE_CHANNEL_FILTER_FIELD,
            PUBLIC_CHANNEL_FILTER_FIELD, INCLUSION_PATTERNS_FIELD, EXCLUSION_PATTERNS_FIELD, FIELD_MAPPINGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String teamId;

    private final String secretArn;

    private final DataSourceVpcConfiguration vpcConfiguration;

    private final List<String> slackEntityList;

    private final Boolean useChangeLog;

    private final Boolean crawlBotMessage;

    private final Boolean excludeArchived;

    private final String sinceCrawlDate;

    private final Integer lookBackPeriod;

    private final List<String> privateChannelFilter;

    private final List<String> publicChannelFilter;

    private final List<String> inclusionPatterns;

    private final List<String> exclusionPatterns;

    private final List<DataSourceToIndexFieldMapping> fieldMappings;

    private SlackConfiguration(BuilderImpl builder) {
        this.teamId = builder.teamId;
        this.secretArn = builder.secretArn;
        this.vpcConfiguration = builder.vpcConfiguration;
        this.slackEntityList = builder.slackEntityList;
        this.useChangeLog = builder.useChangeLog;
        this.crawlBotMessage = builder.crawlBotMessage;
        this.excludeArchived = builder.excludeArchived;
        this.sinceCrawlDate = builder.sinceCrawlDate;
        this.lookBackPeriod = builder.lookBackPeriod;
        this.privateChannelFilter = builder.privateChannelFilter;
        this.publicChannelFilter = builder.publicChannelFilter;
        this.inclusionPatterns = builder.inclusionPatterns;
        this.exclusionPatterns = builder.exclusionPatterns;
        this.fieldMappings = builder.fieldMappings;
    }

    /**
     * <p>
     * The identifier of the team in the Slack workspace. For example, <i>T0123456789</i>.
     * </p>
     * <p>
     * You can find your team ID in the URL of the main page of your Slack workspace. When you log in to Slack via a
     * browser, you are directed to the URL of the main page. For example,
     * <i>https://app.slack.com/client/<b>T0123456789</b>/...</i>.
     * </p>
     * 
     * @return The identifier of the team in the Slack workspace. For example, <i>T0123456789</i>.</p>
     *         <p>
     *         You can find your team ID in the URL of the main page of your Slack workspace. When you log in to Slack
     *         via a browser, you are directed to the URL of the main page. For example,
     *         <i>https://app.slack.com/client/<b>T0123456789</b>/...</i>.
     */
    public final String teamId() {
        return teamId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of an Secrets Manager secret that contains the key-value pairs required to connect
     * to your Slack workspace team. The secret must contain a JSON structure with the following keys:
     * </p>
     * <ul>
     * <li>
     * <p>
     * slackToken—The user or bot token created in Slack. For more information on creating a token in Slack, see <a
     * href="https://docs.aws.amazon.com/kendra/latest/dg/data-source-slack.html#slack-authentication">Authentication
     * for a Slack data source</a>.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The Amazon Resource Name (ARN) of an Secrets Manager secret that contains the key-value pairs required to
     *         connect to your Slack workspace team. The secret must contain a JSON structure with the following
     *         keys:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         slackToken—The user or bot token created in Slack. For more information on creating a token in Slack, see
     *         <a href="https://docs.aws.amazon.com/kendra/latest/dg/data-source-slack.html#slack-authentication">
     *         Authentication for a Slack data source</a>.
     *         </p>
     *         </li>
     */
    public final String secretArn() {
        return secretArn;
    }

    /**
     * <p>
     * Configuration information for an Amazon Virtual Private Cloud to connect to your Slack. For more information, see
     * <a href="https://docs.aws.amazon.com/kendra/latest/dg/vpc-configuration.html">Configuring a VPC</a>.
     * </p>
     * 
     * @return Configuration information for an Amazon Virtual Private Cloud to connect to your Slack. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/kendra/latest/dg/vpc-configuration.html">Configuring a VPC</a>.
     */
    public final DataSourceVpcConfiguration vpcConfiguration() {
        return vpcConfiguration;
    }

    /**
     * <p>
     * Specify whether to index public channels, private channels, group messages, and direct messages. You can specify
     * one or more of these options.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSlackEntityList} method.
     * </p>
     * 
     * @return Specify whether to index public channels, private channels, group messages, and direct messages. You can
     *         specify one or more of these options.
     */
    public final List<SlackEntity> slackEntityList() {
        return SlackEntityListCopier.copyStringToEnum(slackEntityList);
    }

    /**
     * For responses, this returns true if the service returned a value for the SlackEntityList property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSlackEntityList() {
        return slackEntityList != null && !(slackEntityList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specify whether to index public channels, private channels, group messages, and direct messages. You can specify
     * one or more of these options.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSlackEntityList} method.
     * </p>
     * 
     * @return Specify whether to index public channels, private channels, group messages, and direct messages. You can
     *         specify one or more of these options.
     */
    public final List<String> slackEntityListAsStrings() {
        return slackEntityList;
    }

    /**
     * <p>
     * <code>TRUE</code> to use the Slack change log to determine which documents require updating in the index.
     * Depending on the Slack change log's size, it may take longer for Amazon Kendra to use the change log than to scan
     * all of your documents in Slack.
     * </p>
     * 
     * @return <code>TRUE</code> to use the Slack change log to determine which documents require updating in the index.
     *         Depending on the Slack change log's size, it may take longer for Amazon Kendra to use the change log than
     *         to scan all of your documents in Slack.
     */
    public final Boolean useChangeLog() {
        return useChangeLog;
    }

    /**
     * <p>
     * <code>TRUE</code> to index bot messages from your Slack workspace team.
     * </p>
     * 
     * @return <code>TRUE</code> to index bot messages from your Slack workspace team.
     */
    public final Boolean crawlBotMessage() {
        return crawlBotMessage;
    }

    /**
     * <p>
     * <code>TRUE</code> to exclude archived messages to index from your Slack workspace team.
     * </p>
     * 
     * @return <code>TRUE</code> to exclude archived messages to index from your Slack workspace team.
     */
    public final Boolean excludeArchived() {
        return excludeArchived;
    }

    /**
     * <p>
     * The date to start crawling your data from your Slack workspace team. The date must follow this format:
     * <code>yyyy-mm-dd</code>.
     * </p>
     * 
     * @return The date to start crawling your data from your Slack workspace team. The date must follow this format:
     *         <code>yyyy-mm-dd</code>.
     */
    public final String sinceCrawlDate() {
        return sinceCrawlDate;
    }

    /**
     * <p>
     * The number of hours for change log to look back from when you last synchronized your data. You can look back up
     * to 7 days or 168 hours.
     * </p>
     * <p>
     * Change log updates your index only if new content was added since you last synced your data. Updated or deleted
     * content from before you last synced does not get updated in your index. To capture updated or deleted content
     * before you last synced, set the <code>LookBackPeriod</code> to the number of hours you want change log to look
     * back.
     * </p>
     * 
     * @return The number of hours for change log to look back from when you last synchronized your data. You can look
     *         back up to 7 days or 168 hours.</p>
     *         <p>
     *         Change log updates your index only if new content was added since you last synced your data. Updated or
     *         deleted content from before you last synced does not get updated in your index. To capture updated or
     *         deleted content before you last synced, set the <code>LookBackPeriod</code> to the number of hours you
     *         want change log to look back.
     */
    public final Integer lookBackPeriod() {
        return lookBackPeriod;
    }

    /**
     * For responses, this returns true if the service returned a value for the PrivateChannelFilter property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPrivateChannelFilter() {
        return privateChannelFilter != null && !(privateChannelFilter instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of private channel names from your Slack workspace team. You use this if you want to index specific
     * private channels, not all private channels. You can also use regular expression patterns to filter private
     * channels.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPrivateChannelFilter} method.
     * </p>
     * 
     * @return The list of private channel names from your Slack workspace team. You use this if you want to index
     *         specific private channels, not all private channels. You can also use regular expression patterns to
     *         filter private channels.
     */
    public final List<String> privateChannelFilter() {
        return privateChannelFilter;
    }

    /**
     * For responses, this returns true if the service returned a value for the PublicChannelFilter property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPublicChannelFilter() {
        return publicChannelFilter != null && !(publicChannelFilter instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of public channel names to index from your Slack workspace team. You use this if you want to index
     * specific public channels, not all public channels. You can also use regular expression patterns to filter public
     * channels.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPublicChannelFilter} method.
     * </p>
     * 
     * @return The list of public channel names to index from your Slack workspace team. You use this if you want to
     *         index specific public channels, not all public channels. You can also use regular expression patterns to
     *         filter public channels.
     */
    public final List<String> publicChannelFilter() {
        return publicChannelFilter;
    }

    /**
     * For responses, this returns true if the service returned a value for the InclusionPatterns property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasInclusionPatterns() {
        return inclusionPatterns != null && !(inclusionPatterns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of regular expression patterns to include certain attached files in your Slack workspace team. Files that
     * match the patterns are included in the index. Files that don't match the patterns are excluded from the index. If
     * a file matches both an inclusion and exclusion pattern, the exclusion pattern takes precedence and the file isn't
     * included in the index.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInclusionPatterns} method.
     * </p>
     * 
     * @return A list of regular expression patterns to include certain attached files in your Slack workspace team.
     *         Files that match the patterns are included in the index. Files that don't match the patterns are excluded
     *         from the index. If a file matches both an inclusion and exclusion pattern, the exclusion pattern takes
     *         precedence and the file isn't included in the index.
     */
    public final List<String> inclusionPatterns() {
        return inclusionPatterns;
    }

    /**
     * For responses, this returns true if the service returned a value for the ExclusionPatterns property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasExclusionPatterns() {
        return exclusionPatterns != null && !(exclusionPatterns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of regular expression patterns to exclude certain attached files in your Slack workspace team. Files that
     * match the patterns are excluded from the index. Files that don’t match the patterns are included in the index. If
     * a file matches both an inclusion and exclusion pattern, the exclusion pattern takes precedence and the file isn't
     * included in the index.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasExclusionPatterns} method.
     * </p>
     * 
     * @return A list of regular expression patterns to exclude certain attached files in your Slack workspace team.
     *         Files that match the patterns are excluded from the index. Files that don’t match the patterns are
     *         included in the index. If a file matches both an inclusion and exclusion pattern, the exclusion pattern
     *         takes precedence and the file isn't included in the index.
     */
    public final List<String> exclusionPatterns() {
        return exclusionPatterns;
    }

    /**
     * For responses, this returns true if the service returned a value for the FieldMappings property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasFieldMappings() {
        return fieldMappings != null && !(fieldMappings instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of <code>DataSourceToIndexFieldMapping</code> objects that map Slack data source attributes or field names
     * to Amazon Kendra index field names. To create custom fields, use the <code>UpdateIndex</code> API before you map
     * to Slack fields. For more information, see <a
     * href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html">Mapping data source fields</a>. The Slack
     * data source field names must exist in your Slack custom metadata.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFieldMappings} method.
     * </p>
     * 
     * @return A list of <code>DataSourceToIndexFieldMapping</code> objects that map Slack data source attributes or
     *         field names to Amazon Kendra index field names. To create custom fields, use the <code>UpdateIndex</code>
     *         API before you map to Slack fields. For more information, see <a
     *         href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html">Mapping data source fields</a>.
     *         The Slack data source field names must exist in your Slack custom metadata.
     */
    public final List<DataSourceToIndexFieldMapping> fieldMappings() {
        return fieldMappings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(teamId());
        hashCode = 31 * hashCode + Objects.hashCode(secretArn());
        hashCode = 31 * hashCode + Objects.hashCode(vpcConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(hasSlackEntityList() ? slackEntityListAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(useChangeLog());
        hashCode = 31 * hashCode + Objects.hashCode(crawlBotMessage());
        hashCode = 31 * hashCode + Objects.hashCode(excludeArchived());
        hashCode = 31 * hashCode + Objects.hashCode(sinceCrawlDate());
        hashCode = 31 * hashCode + Objects.hashCode(lookBackPeriod());
        hashCode = 31 * hashCode + Objects.hashCode(hasPrivateChannelFilter() ? privateChannelFilter() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasPublicChannelFilter() ? publicChannelFilter() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasInclusionPatterns() ? inclusionPatterns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasExclusionPatterns() ? exclusionPatterns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasFieldMappings() ? fieldMappings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SlackConfiguration)) {
            return false;
        }
        SlackConfiguration other = (SlackConfiguration) obj;
        return Objects.equals(teamId(), other.teamId()) && Objects.equals(secretArn(), other.secretArn())
                && Objects.equals(vpcConfiguration(), other.vpcConfiguration())
                && hasSlackEntityList() == other.hasSlackEntityList()
                && Objects.equals(slackEntityListAsStrings(), other.slackEntityListAsStrings())
                && Objects.equals(useChangeLog(), other.useChangeLog())
                && Objects.equals(crawlBotMessage(), other.crawlBotMessage())
                && Objects.equals(excludeArchived(), other.excludeArchived())
                && Objects.equals(sinceCrawlDate(), other.sinceCrawlDate())
                && Objects.equals(lookBackPeriod(), other.lookBackPeriod())
                && hasPrivateChannelFilter() == other.hasPrivateChannelFilter()
                && Objects.equals(privateChannelFilter(), other.privateChannelFilter())
                && hasPublicChannelFilter() == other.hasPublicChannelFilter()
                && Objects.equals(publicChannelFilter(), other.publicChannelFilter())
                && hasInclusionPatterns() == other.hasInclusionPatterns()
                && Objects.equals(inclusionPatterns(), other.inclusionPatterns())
                && hasExclusionPatterns() == other.hasExclusionPatterns()
                && Objects.equals(exclusionPatterns(), other.exclusionPatterns())
                && hasFieldMappings() == other.hasFieldMappings() && Objects.equals(fieldMappings(), other.fieldMappings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SlackConfiguration").add("TeamId", teamId()).add("SecretArn", secretArn())
                .add("VpcConfiguration", vpcConfiguration())
                .add("SlackEntityList", hasSlackEntityList() ? slackEntityListAsStrings() : null)
                .add("UseChangeLog", useChangeLog()).add("CrawlBotMessage", crawlBotMessage())
                .add("ExcludeArchived", excludeArchived()).add("SinceCrawlDate", sinceCrawlDate())
                .add("LookBackPeriod", lookBackPeriod())
                .add("PrivateChannelFilter", hasPrivateChannelFilter() ? privateChannelFilter() : null)
                .add("PublicChannelFilter", hasPublicChannelFilter() ? publicChannelFilter() : null)
                .add("InclusionPatterns", hasInclusionPatterns() ? inclusionPatterns() : null)
                .add("ExclusionPatterns", hasExclusionPatterns() ? exclusionPatterns() : null)
                .add("FieldMappings", hasFieldMappings() ? fieldMappings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TeamId":
            return Optional.ofNullable(clazz.cast(teamId()));
        case "SecretArn":
            return Optional.ofNullable(clazz.cast(secretArn()));
        case "VpcConfiguration":
            return Optional.ofNullable(clazz.cast(vpcConfiguration()));
        case "SlackEntityList":
            return Optional.ofNullable(clazz.cast(slackEntityListAsStrings()));
        case "UseChangeLog":
            return Optional.ofNullable(clazz.cast(useChangeLog()));
        case "CrawlBotMessage":
            return Optional.ofNullable(clazz.cast(crawlBotMessage()));
        case "ExcludeArchived":
            return Optional.ofNullable(clazz.cast(excludeArchived()));
        case "SinceCrawlDate":
            return Optional.ofNullable(clazz.cast(sinceCrawlDate()));
        case "LookBackPeriod":
            return Optional.ofNullable(clazz.cast(lookBackPeriod()));
        case "PrivateChannelFilter":
            return Optional.ofNullable(clazz.cast(privateChannelFilter()));
        case "PublicChannelFilter":
            return Optional.ofNullable(clazz.cast(publicChannelFilter()));
        case "InclusionPatterns":
            return Optional.ofNullable(clazz.cast(inclusionPatterns()));
        case "ExclusionPatterns":
            return Optional.ofNullable(clazz.cast(exclusionPatterns()));
        case "FieldMappings":
            return Optional.ofNullable(clazz.cast(fieldMappings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SlackConfiguration, T> g) {
        return obj -> g.apply((SlackConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SlackConfiguration> {
        /**
         * <p>
         * The identifier of the team in the Slack workspace. For example, <i>T0123456789</i>.
         * </p>
         * <p>
         * You can find your team ID in the URL of the main page of your Slack workspace. When you log in to Slack via a
         * browser, you are directed to the URL of the main page. For example,
         * <i>https://app.slack.com/client/<b>T0123456789</b>/...</i>.
         * </p>
         * 
         * @param teamId
         *        The identifier of the team in the Slack workspace. For example, <i>T0123456789</i>.</p>
         *        <p>
         *        You can find your team ID in the URL of the main page of your Slack workspace. When you log in to
         *        Slack via a browser, you are directed to the URL of the main page. For example,
         *        <i>https://app.slack.com/client/<b>T0123456789</b>/...</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder teamId(String teamId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of an Secrets Manager secret that contains the key-value pairs required to
         * connect to your Slack workspace team. The secret must contain a JSON structure with the following keys:
         * </p>
         * <ul>
         * <li>
         * <p>
         * slackToken—The user or bot token created in Slack. For more information on creating a token in Slack, see <a
         * href
         * ="https://docs.aws.amazon.com/kendra/latest/dg/data-source-slack.html#slack-authentication">Authentication
         * for a Slack data source</a>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param secretArn
         *        The Amazon Resource Name (ARN) of an Secrets Manager secret that contains the key-value pairs required
         *        to connect to your Slack workspace team. The secret must contain a JSON structure with the following
         *        keys:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        slackToken—The user or bot token created in Slack. For more information on creating a token in Slack,
         *        see <a
         *        href="https://docs.aws.amazon.com/kendra/latest/dg/data-source-slack.html#slack-authentication">
         *        Authentication for a Slack data source</a>.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secretArn(String secretArn);

        /**
         * <p>
         * Configuration information for an Amazon Virtual Private Cloud to connect to your Slack. For more information,
         * see <a href="https://docs.aws.amazon.com/kendra/latest/dg/vpc-configuration.html">Configuring a VPC</a>.
         * </p>
         * 
         * @param vpcConfiguration
         *        Configuration information for an Amazon Virtual Private Cloud to connect to your Slack. For more
         *        information, see <a
         *        href="https://docs.aws.amazon.com/kendra/latest/dg/vpc-configuration.html">Configuring a VPC</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcConfiguration(DataSourceVpcConfiguration vpcConfiguration);

        /**
         * <p>
         * Configuration information for an Amazon Virtual Private Cloud to connect to your Slack. For more information,
         * see <a href="https://docs.aws.amazon.com/kendra/latest/dg/vpc-configuration.html">Configuring a VPC</a>.
         * </p>
         * This is a convenience method that creates an instance of the {@link DataSourceVpcConfiguration.Builder}
         * avoiding the need to create one manually via {@link DataSourceVpcConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link DataSourceVpcConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #vpcConfiguration(DataSourceVpcConfiguration)}.
         * 
         * @param vpcConfiguration
         *        a consumer that will call methods on {@link DataSourceVpcConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vpcConfiguration(DataSourceVpcConfiguration)
         */
        default Builder vpcConfiguration(Consumer<DataSourceVpcConfiguration.Builder> vpcConfiguration) {
            return vpcConfiguration(DataSourceVpcConfiguration.builder().applyMutation(vpcConfiguration).build());
        }

        /**
         * <p>
         * Specify whether to index public channels, private channels, group messages, and direct messages. You can
         * specify one or more of these options.
         * </p>
         * 
         * @param slackEntityList
         *        Specify whether to index public channels, private channels, group messages, and direct messages. You
         *        can specify one or more of these options.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder slackEntityListWithStrings(Collection<String> slackEntityList);

        /**
         * <p>
         * Specify whether to index public channels, private channels, group messages, and direct messages. You can
         * specify one or more of these options.
         * </p>
         * 
         * @param slackEntityList
         *        Specify whether to index public channels, private channels, group messages, and direct messages. You
         *        can specify one or more of these options.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder slackEntityListWithStrings(String... slackEntityList);

        /**
         * <p>
         * Specify whether to index public channels, private channels, group messages, and direct messages. You can
         * specify one or more of these options.
         * </p>
         * 
         * @param slackEntityList
         *        Specify whether to index public channels, private channels, group messages, and direct messages. You
         *        can specify one or more of these options.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder slackEntityList(Collection<SlackEntity> slackEntityList);

        /**
         * <p>
         * Specify whether to index public channels, private channels, group messages, and direct messages. You can
         * specify one or more of these options.
         * </p>
         * 
         * @param slackEntityList
         *        Specify whether to index public channels, private channels, group messages, and direct messages. You
         *        can specify one or more of these options.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder slackEntityList(SlackEntity... slackEntityList);

        /**
         * <p>
         * <code>TRUE</code> to use the Slack change log to determine which documents require updating in the index.
         * Depending on the Slack change log's size, it may take longer for Amazon Kendra to use the change log than to
         * scan all of your documents in Slack.
         * </p>
         * 
         * @param useChangeLog
         *        <code>TRUE</code> to use the Slack change log to determine which documents require updating in the
         *        index. Depending on the Slack change log's size, it may take longer for Amazon Kendra to use the
         *        change log than to scan all of your documents in Slack.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder useChangeLog(Boolean useChangeLog);

        /**
         * <p>
         * <code>TRUE</code> to index bot messages from your Slack workspace team.
         * </p>
         * 
         * @param crawlBotMessage
         *        <code>TRUE</code> to index bot messages from your Slack workspace team.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder crawlBotMessage(Boolean crawlBotMessage);

        /**
         * <p>
         * <code>TRUE</code> to exclude archived messages to index from your Slack workspace team.
         * </p>
         * 
         * @param excludeArchived
         *        <code>TRUE</code> to exclude archived messages to index from your Slack workspace team.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder excludeArchived(Boolean excludeArchived);

        /**
         * <p>
         * The date to start crawling your data from your Slack workspace team. The date must follow this format:
         * <code>yyyy-mm-dd</code>.
         * </p>
         * 
         * @param sinceCrawlDate
         *        The date to start crawling your data from your Slack workspace team. The date must follow this format:
         *        <code>yyyy-mm-dd</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sinceCrawlDate(String sinceCrawlDate);

        /**
         * <p>
         * The number of hours for change log to look back from when you last synchronized your data. You can look back
         * up to 7 days or 168 hours.
         * </p>
         * <p>
         * Change log updates your index only if new content was added since you last synced your data. Updated or
         * deleted content from before you last synced does not get updated in your index. To capture updated or deleted
         * content before you last synced, set the <code>LookBackPeriod</code> to the number of hours you want change
         * log to look back.
         * </p>
         * 
         * @param lookBackPeriod
         *        The number of hours for change log to look back from when you last synchronized your data. You can
         *        look back up to 7 days or 168 hours.</p>
         *        <p>
         *        Change log updates your index only if new content was added since you last synced your data. Updated
         *        or deleted content from before you last synced does not get updated in your index. To capture updated
         *        or deleted content before you last synced, set the <code>LookBackPeriod</code> to the number of hours
         *        you want change log to look back.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lookBackPeriod(Integer lookBackPeriod);

        /**
         * <p>
         * The list of private channel names from your Slack workspace team. You use this if you want to index specific
         * private channels, not all private channels. You can also use regular expression patterns to filter private
         * channels.
         * </p>
         * 
         * @param privateChannelFilter
         *        The list of private channel names from your Slack workspace team. You use this if you want to index
         *        specific private channels, not all private channels. You can also use regular expression patterns to
         *        filter private channels.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privateChannelFilter(Collection<String> privateChannelFilter);

        /**
         * <p>
         * The list of private channel names from your Slack workspace team. You use this if you want to index specific
         * private channels, not all private channels. You can also use regular expression patterns to filter private
         * channels.
         * </p>
         * 
         * @param privateChannelFilter
         *        The list of private channel names from your Slack workspace team. You use this if you want to index
         *        specific private channels, not all private channels. You can also use regular expression patterns to
         *        filter private channels.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privateChannelFilter(String... privateChannelFilter);

        /**
         * <p>
         * The list of public channel names to index from your Slack workspace team. You use this if you want to index
         * specific public channels, not all public channels. You can also use regular expression patterns to filter
         * public channels.
         * </p>
         * 
         * @param publicChannelFilter
         *        The list of public channel names to index from your Slack workspace team. You use this if you want to
         *        index specific public channels, not all public channels. You can also use regular expression patterns
         *        to filter public channels.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publicChannelFilter(Collection<String> publicChannelFilter);

        /**
         * <p>
         * The list of public channel names to index from your Slack workspace team. You use this if you want to index
         * specific public channels, not all public channels. You can also use regular expression patterns to filter
         * public channels.
         * </p>
         * 
         * @param publicChannelFilter
         *        The list of public channel names to index from your Slack workspace team. You use this if you want to
         *        index specific public channels, not all public channels. You can also use regular expression patterns
         *        to filter public channels.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publicChannelFilter(String... publicChannelFilter);

        /**
         * <p>
         * A list of regular expression patterns to include certain attached files in your Slack workspace team. Files
         * that match the patterns are included in the index. Files that don't match the patterns are excluded from the
         * index. If a file matches both an inclusion and exclusion pattern, the exclusion pattern takes precedence and
         * the file isn't included in the index.
         * </p>
         * 
         * @param inclusionPatterns
         *        A list of regular expression patterns to include certain attached files in your Slack workspace team.
         *        Files that match the patterns are included in the index. Files that don't match the patterns are
         *        excluded from the index. If a file matches both an inclusion and exclusion pattern, the exclusion
         *        pattern takes precedence and the file isn't included in the index.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inclusionPatterns(Collection<String> inclusionPatterns);

        /**
         * <p>
         * A list of regular expression patterns to include certain attached files in your Slack workspace team. Files
         * that match the patterns are included in the index. Files that don't match the patterns are excluded from the
         * index. If a file matches both an inclusion and exclusion pattern, the exclusion pattern takes precedence and
         * the file isn't included in the index.
         * </p>
         * 
         * @param inclusionPatterns
         *        A list of regular expression patterns to include certain attached files in your Slack workspace team.
         *        Files that match the patterns are included in the index. Files that don't match the patterns are
         *        excluded from the index. If a file matches both an inclusion and exclusion pattern, the exclusion
         *        pattern takes precedence and the file isn't included in the index.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inclusionPatterns(String... inclusionPatterns);

        /**
         * <p>
         * A list of regular expression patterns to exclude certain attached files in your Slack workspace team. Files
         * that match the patterns are excluded from the index. Files that don’t match the patterns are included in the
         * index. If a file matches both an inclusion and exclusion pattern, the exclusion pattern takes precedence and
         * the file isn't included in the index.
         * </p>
         * 
         * @param exclusionPatterns
         *        A list of regular expression patterns to exclude certain attached files in your Slack workspace team.
         *        Files that match the patterns are excluded from the index. Files that don’t match the patterns are
         *        included in the index. If a file matches both an inclusion and exclusion pattern, the exclusion
         *        pattern takes precedence and the file isn't included in the index.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exclusionPatterns(Collection<String> exclusionPatterns);

        /**
         * <p>
         * A list of regular expression patterns to exclude certain attached files in your Slack workspace team. Files
         * that match the patterns are excluded from the index. Files that don’t match the patterns are included in the
         * index. If a file matches both an inclusion and exclusion pattern, the exclusion pattern takes precedence and
         * the file isn't included in the index.
         * </p>
         * 
         * @param exclusionPatterns
         *        A list of regular expression patterns to exclude certain attached files in your Slack workspace team.
         *        Files that match the patterns are excluded from the index. Files that don’t match the patterns are
         *        included in the index. If a file matches both an inclusion and exclusion pattern, the exclusion
         *        pattern takes precedence and the file isn't included in the index.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exclusionPatterns(String... exclusionPatterns);

        /**
         * <p>
         * A list of <code>DataSourceToIndexFieldMapping</code> objects that map Slack data source attributes or field
         * names to Amazon Kendra index field names. To create custom fields, use the <code>UpdateIndex</code> API
         * before you map to Slack fields. For more information, see <a
         * href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html">Mapping data source fields</a>. The
         * Slack data source field names must exist in your Slack custom metadata.
         * </p>
         * 
         * @param fieldMappings
         *        A list of <code>DataSourceToIndexFieldMapping</code> objects that map Slack data source attributes or
         *        field names to Amazon Kendra index field names. To create custom fields, use the
         *        <code>UpdateIndex</code> API before you map to Slack fields. For more information, see <a
         *        href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html">Mapping data source fields</a>.
         *        The Slack data source field names must exist in your Slack custom metadata.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fieldMappings(Collection<DataSourceToIndexFieldMapping> fieldMappings);

        /**
         * <p>
         * A list of <code>DataSourceToIndexFieldMapping</code> objects that map Slack data source attributes or field
         * names to Amazon Kendra index field names. To create custom fields, use the <code>UpdateIndex</code> API
         * before you map to Slack fields. For more information, see <a
         * href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html">Mapping data source fields</a>. The
         * Slack data source field names must exist in your Slack custom metadata.
         * </p>
         * 
         * @param fieldMappings
         *        A list of <code>DataSourceToIndexFieldMapping</code> objects that map Slack data source attributes or
         *        field names to Amazon Kendra index field names. To create custom fields, use the
         *        <code>UpdateIndex</code> API before you map to Slack fields. For more information, see <a
         *        href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html">Mapping data source fields</a>.
         *        The Slack data source field names must exist in your Slack custom metadata.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fieldMappings(DataSourceToIndexFieldMapping... fieldMappings);

        /**
         * <p>
         * A list of <code>DataSourceToIndexFieldMapping</code> objects that map Slack data source attributes or field
         * names to Amazon Kendra index field names. To create custom fields, use the <code>UpdateIndex</code> API
         * before you map to Slack fields. For more information, see <a
         * href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html">Mapping data source fields</a>. The
         * Slack data source field names must exist in your Slack custom metadata.
         * </p>
         * This is a convenience method that creates an instance of the {@link List
         * <DataSourceToIndexFieldMapping>.Builder} avoiding the need to create one manually via {@link List
         * <DataSourceToIndexFieldMapping>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<DataSourceToIndexFieldMapping>.Builder#build()} is called
         * immediately and its result is passed to {@link #fieldMappings(List<DataSourceToIndexFieldMapping>)}.
         * 
         * @param fieldMappings
         *        a consumer that will call methods on {@link List<DataSourceToIndexFieldMapping>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fieldMappings(List<DataSourceToIndexFieldMapping>)
         */
        Builder fieldMappings(Consumer<DataSourceToIndexFieldMapping.Builder>... fieldMappings);
    }

    static final class BuilderImpl implements Builder {
        private String teamId;

        private String secretArn;

        private DataSourceVpcConfiguration vpcConfiguration;

        private List<String> slackEntityList = DefaultSdkAutoConstructList.getInstance();

        private Boolean useChangeLog;

        private Boolean crawlBotMessage;

        private Boolean excludeArchived;

        private String sinceCrawlDate;

        private Integer lookBackPeriod;

        private List<String> privateChannelFilter = DefaultSdkAutoConstructList.getInstance();

        private List<String> publicChannelFilter = DefaultSdkAutoConstructList.getInstance();

        private List<String> inclusionPatterns = DefaultSdkAutoConstructList.getInstance();

        private List<String> exclusionPatterns = DefaultSdkAutoConstructList.getInstance();

        private List<DataSourceToIndexFieldMapping> fieldMappings = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SlackConfiguration model) {
            teamId(model.teamId);
            secretArn(model.secretArn);
            vpcConfiguration(model.vpcConfiguration);
            slackEntityListWithStrings(model.slackEntityList);
            useChangeLog(model.useChangeLog);
            crawlBotMessage(model.crawlBotMessage);
            excludeArchived(model.excludeArchived);
            sinceCrawlDate(model.sinceCrawlDate);
            lookBackPeriod(model.lookBackPeriod);
            privateChannelFilter(model.privateChannelFilter);
            publicChannelFilter(model.publicChannelFilter);
            inclusionPatterns(model.inclusionPatterns);
            exclusionPatterns(model.exclusionPatterns);
            fieldMappings(model.fieldMappings);
        }

        public final String getTeamId() {
            return teamId;
        }

        public final void setTeamId(String teamId) {
            this.teamId = teamId;
        }

        @Override
        public final Builder teamId(String teamId) {
            this.teamId = teamId;
            return this;
        }

        public final String getSecretArn() {
            return secretArn;
        }

        public final void setSecretArn(String secretArn) {
            this.secretArn = secretArn;
        }

        @Override
        public final Builder secretArn(String secretArn) {
            this.secretArn = secretArn;
            return this;
        }

        public final DataSourceVpcConfiguration.Builder getVpcConfiguration() {
            return vpcConfiguration != null ? vpcConfiguration.toBuilder() : null;
        }

        public final void setVpcConfiguration(DataSourceVpcConfiguration.BuilderImpl vpcConfiguration) {
            this.vpcConfiguration = vpcConfiguration != null ? vpcConfiguration.build() : null;
        }

        @Override
        public final Builder vpcConfiguration(DataSourceVpcConfiguration vpcConfiguration) {
            this.vpcConfiguration = vpcConfiguration;
            return this;
        }

        public final Collection<String> getSlackEntityList() {
            if (slackEntityList instanceof SdkAutoConstructList) {
                return null;
            }
            return slackEntityList;
        }

        public final void setSlackEntityList(Collection<String> slackEntityList) {
            this.slackEntityList = SlackEntityListCopier.copy(slackEntityList);
        }

        @Override
        public final Builder slackEntityListWithStrings(Collection<String> slackEntityList) {
            this.slackEntityList = SlackEntityListCopier.copy(slackEntityList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder slackEntityListWithStrings(String... slackEntityList) {
            slackEntityListWithStrings(Arrays.asList(slackEntityList));
            return this;
        }

        @Override
        public final Builder slackEntityList(Collection<SlackEntity> slackEntityList) {
            this.slackEntityList = SlackEntityListCopier.copyEnumToString(slackEntityList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder slackEntityList(SlackEntity... slackEntityList) {
            slackEntityList(Arrays.asList(slackEntityList));
            return this;
        }

        public final Boolean getUseChangeLog() {
            return useChangeLog;
        }

        public final void setUseChangeLog(Boolean useChangeLog) {
            this.useChangeLog = useChangeLog;
        }

        @Override
        public final Builder useChangeLog(Boolean useChangeLog) {
            this.useChangeLog = useChangeLog;
            return this;
        }

        public final Boolean getCrawlBotMessage() {
            return crawlBotMessage;
        }

        public final void setCrawlBotMessage(Boolean crawlBotMessage) {
            this.crawlBotMessage = crawlBotMessage;
        }

        @Override
        public final Builder crawlBotMessage(Boolean crawlBotMessage) {
            this.crawlBotMessage = crawlBotMessage;
            return this;
        }

        public final Boolean getExcludeArchived() {
            return excludeArchived;
        }

        public final void setExcludeArchived(Boolean excludeArchived) {
            this.excludeArchived = excludeArchived;
        }

        @Override
        public final Builder excludeArchived(Boolean excludeArchived) {
            this.excludeArchived = excludeArchived;
            return this;
        }

        public final String getSinceCrawlDate() {
            return sinceCrawlDate;
        }

        public final void setSinceCrawlDate(String sinceCrawlDate) {
            this.sinceCrawlDate = sinceCrawlDate;
        }

        @Override
        public final Builder sinceCrawlDate(String sinceCrawlDate) {
            this.sinceCrawlDate = sinceCrawlDate;
            return this;
        }

        public final Integer getLookBackPeriod() {
            return lookBackPeriod;
        }

        public final void setLookBackPeriod(Integer lookBackPeriod) {
            this.lookBackPeriod = lookBackPeriod;
        }

        @Override
        public final Builder lookBackPeriod(Integer lookBackPeriod) {
            this.lookBackPeriod = lookBackPeriod;
            return this;
        }

        public final Collection<String> getPrivateChannelFilter() {
            if (privateChannelFilter instanceof SdkAutoConstructList) {
                return null;
            }
            return privateChannelFilter;
        }

        public final void setPrivateChannelFilter(Collection<String> privateChannelFilter) {
            this.privateChannelFilter = PrivateChannelFilterCopier.copy(privateChannelFilter);
        }

        @Override
        public final Builder privateChannelFilter(Collection<String> privateChannelFilter) {
            this.privateChannelFilter = PrivateChannelFilterCopier.copy(privateChannelFilter);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder privateChannelFilter(String... privateChannelFilter) {
            privateChannelFilter(Arrays.asList(privateChannelFilter));
            return this;
        }

        public final Collection<String> getPublicChannelFilter() {
            if (publicChannelFilter instanceof SdkAutoConstructList) {
                return null;
            }
            return publicChannelFilter;
        }

        public final void setPublicChannelFilter(Collection<String> publicChannelFilter) {
            this.publicChannelFilter = PublicChannelFilterCopier.copy(publicChannelFilter);
        }

        @Override
        public final Builder publicChannelFilter(Collection<String> publicChannelFilter) {
            this.publicChannelFilter = PublicChannelFilterCopier.copy(publicChannelFilter);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder publicChannelFilter(String... publicChannelFilter) {
            publicChannelFilter(Arrays.asList(publicChannelFilter));
            return this;
        }

        public final Collection<String> getInclusionPatterns() {
            if (inclusionPatterns instanceof SdkAutoConstructList) {
                return null;
            }
            return inclusionPatterns;
        }

        public final void setInclusionPatterns(Collection<String> inclusionPatterns) {
            this.inclusionPatterns = DataSourceInclusionsExclusionsStringsCopier.copy(inclusionPatterns);
        }

        @Override
        public final Builder inclusionPatterns(Collection<String> inclusionPatterns) {
            this.inclusionPatterns = DataSourceInclusionsExclusionsStringsCopier.copy(inclusionPatterns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inclusionPatterns(String... inclusionPatterns) {
            inclusionPatterns(Arrays.asList(inclusionPatterns));
            return this;
        }

        public final Collection<String> getExclusionPatterns() {
            if (exclusionPatterns instanceof SdkAutoConstructList) {
                return null;
            }
            return exclusionPatterns;
        }

        public final void setExclusionPatterns(Collection<String> exclusionPatterns) {
            this.exclusionPatterns = DataSourceInclusionsExclusionsStringsCopier.copy(exclusionPatterns);
        }

        @Override
        public final Builder exclusionPatterns(Collection<String> exclusionPatterns) {
            this.exclusionPatterns = DataSourceInclusionsExclusionsStringsCopier.copy(exclusionPatterns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder exclusionPatterns(String... exclusionPatterns) {
            exclusionPatterns(Arrays.asList(exclusionPatterns));
            return this;
        }

        public final List<DataSourceToIndexFieldMapping.Builder> getFieldMappings() {
            List<DataSourceToIndexFieldMapping.Builder> result = DataSourceToIndexFieldMappingListCopier
                    .copyToBuilder(this.fieldMappings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFieldMappings(Collection<DataSourceToIndexFieldMapping.BuilderImpl> fieldMappings) {
            this.fieldMappings = DataSourceToIndexFieldMappingListCopier.copyFromBuilder(fieldMappings);
        }

        @Override
        public final Builder fieldMappings(Collection<DataSourceToIndexFieldMapping> fieldMappings) {
            this.fieldMappings = DataSourceToIndexFieldMappingListCopier.copy(fieldMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fieldMappings(DataSourceToIndexFieldMapping... fieldMappings) {
            fieldMappings(Arrays.asList(fieldMappings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fieldMappings(Consumer<DataSourceToIndexFieldMapping.Builder>... fieldMappings) {
            fieldMappings(Stream.of(fieldMappings).map(c -> DataSourceToIndexFieldMapping.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public SlackConfiguration build() {
            return new SlackConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
