/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kendra.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeExperienceResponse extends KendraResponse implements
        ToCopyableBuilder<DescribeExperienceResponse.Builder, DescribeExperienceResponse> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(DescribeExperienceResponse::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> INDEX_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IndexId").getter(getter(DescribeExperienceResponse::indexId)).setter(setter(Builder::indexId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IndexId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(DescribeExperienceResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<List<ExperienceEndpoint>> ENDPOINTS_FIELD = SdkField
            .<List<ExperienceEndpoint>> builder(MarshallingType.LIST)
            .memberName("Endpoints")
            .getter(getter(DescribeExperienceResponse::endpoints))
            .setter(setter(Builder::endpoints))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Endpoints").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ExperienceEndpoint> builder(MarshallingType.SDK_POJO)
                                            .constructor(ExperienceEndpoint::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<ExperienceConfiguration> CONFIGURATION_FIELD = SdkField
            .<ExperienceConfiguration> builder(MarshallingType.SDK_POJO).memberName("Configuration")
            .getter(getter(DescribeExperienceResponse::configuration)).setter(setter(Builder::configuration))
            .constructor(ExperienceConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Configuration").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedAt").getter(getter(DescribeExperienceResponse::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()).build();

    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("UpdatedAt").getter(getter(DescribeExperienceResponse::updatedAt)).setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdatedAt").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(DescribeExperienceResponse::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(DescribeExperienceResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoleArn").getter(getter(DescribeExperienceResponse::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()).build();

    private static final SdkField<String> ERROR_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ErrorMessage").getter(getter(DescribeExperienceResponse::errorMessage))
            .setter(setter(Builder::errorMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorMessage").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, INDEX_ID_FIELD,
            NAME_FIELD, ENDPOINTS_FIELD, CONFIGURATION_FIELD, CREATED_AT_FIELD, UPDATED_AT_FIELD, DESCRIPTION_FIELD,
            STATUS_FIELD, ROLE_ARN_FIELD, ERROR_MESSAGE_FIELD));

    private final String id;

    private final String indexId;

    private final String name;

    private final List<ExperienceEndpoint> endpoints;

    private final ExperienceConfiguration configuration;

    private final Instant createdAt;

    private final Instant updatedAt;

    private final String description;

    private final String status;

    private final String roleArn;

    private final String errorMessage;

    private DescribeExperienceResponse(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.indexId = builder.indexId;
        this.name = builder.name;
        this.endpoints = builder.endpoints;
        this.configuration = builder.configuration;
        this.createdAt = builder.createdAt;
        this.updatedAt = builder.updatedAt;
        this.description = builder.description;
        this.status = builder.status;
        this.roleArn = builder.roleArn;
        this.errorMessage = builder.errorMessage;
    }

    /**
     * <p>
     * Shows the identifier of your Amazon Kendra experience.
     * </p>
     * 
     * @return Shows the identifier of your Amazon Kendra experience.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * Shows the identifier of the index for your Amazon Kendra experience.
     * </p>
     * 
     * @return Shows the identifier of the index for your Amazon Kendra experience.
     */
    public final String indexId() {
        return indexId;
    }

    /**
     * <p>
     * Shows the name of your Amazon Kendra experience.
     * </p>
     * 
     * @return Shows the name of your Amazon Kendra experience.
     */
    public final String name() {
        return name;
    }

    /**
     * For responses, this returns true if the service returned a value for the Endpoints property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasEndpoints() {
        return endpoints != null && !(endpoints instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Shows the endpoint URLs for your Amazon Kendra experiences. The URLs are unique and fully hosted by Amazon Web
     * Services.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEndpoints} method.
     * </p>
     * 
     * @return Shows the endpoint URLs for your Amazon Kendra experiences. The URLs are unique and fully hosted by
     *         Amazon Web Services.
     */
    public final List<ExperienceEndpoint> endpoints() {
        return endpoints;
    }

    /**
     * <p>
     * Shows the configuration information for your Amazon Kendra experience. This includes
     * <code>ContentSourceConfiguration</code>, which specifies the data source IDs and/or FAQ IDs, and
     * <code>UserIdentityConfiguration</code>, which specifies the user or group information to grant access to your
     * Amazon Kendra experience.
     * </p>
     * 
     * @return Shows the configuration information for your Amazon Kendra experience. This includes
     *         <code>ContentSourceConfiguration</code>, which specifies the data source IDs and/or FAQ IDs, and
     *         <code>UserIdentityConfiguration</code>, which specifies the user or group information to grant access to
     *         your Amazon Kendra experience.
     */
    public final ExperienceConfiguration configuration() {
        return configuration;
    }

    /**
     * <p>
     * Shows the date-time your Amazon Kendra experience was created.
     * </p>
     * 
     * @return Shows the date-time your Amazon Kendra experience was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * Shows the date-time your Amazon Kendra experience was last updated.
     * </p>
     * 
     * @return Shows the date-time your Amazon Kendra experience was last updated.
     */
    public final Instant updatedAt() {
        return updatedAt;
    }

    /**
     * <p>
     * Shows the description for your Amazon Kendra experience.
     * </p>
     * 
     * @return Shows the description for your Amazon Kendra experience.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The current processing status of your Amazon Kendra experience. When the status is <code>ACTIVE</code>, your
     * Amazon Kendra experience is ready to use. When the status is <code>FAILED</code>, the <code>ErrorMessage</code>
     * field contains the reason that this failed.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ExperienceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current processing status of your Amazon Kendra experience. When the status is <code>ACTIVE</code>,
     *         your Amazon Kendra experience is ready to use. When the status is <code>FAILED</code>, the
     *         <code>ErrorMessage</code> field contains the reason that this failed.
     * @see ExperienceStatus
     */
    public final ExperienceStatus status() {
        return ExperienceStatus.fromValue(status);
    }

    /**
     * <p>
     * The current processing status of your Amazon Kendra experience. When the status is <code>ACTIVE</code>, your
     * Amazon Kendra experience is ready to use. When the status is <code>FAILED</code>, the <code>ErrorMessage</code>
     * field contains the reason that this failed.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ExperienceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current processing status of your Amazon Kendra experience. When the status is <code>ACTIVE</code>,
     *         your Amazon Kendra experience is ready to use. When the status is <code>FAILED</code>, the
     *         <code>ErrorMessage</code> field contains the reason that this failed.
     * @see ExperienceStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * Shows the Amazon Resource Name (ARN) of a role with permission to access <code>Query</code> API,
     * <code>QuerySuggestions</code> API, <code>SubmitFeedback</code> API, and Amazon Web Services SSO that stores your
     * user and group information.
     * </p>
     * 
     * @return Shows the Amazon Resource Name (ARN) of a role with permission to access <code>Query</code> API,
     *         <code>QuerySuggestions</code> API, <code>SubmitFeedback</code> API, and Amazon Web Services SSO that
     *         stores your user and group information.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * The reason your Amazon Kendra experience could not properly process.
     * </p>
     * 
     * @return The reason your Amazon Kendra experience could not properly process.
     */
    public final String errorMessage() {
        return errorMessage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(indexId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(hasEndpoints() ? endpoints() : null);
        hashCode = 31 * hashCode + Objects.hashCode(configuration());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(errorMessage());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeExperienceResponse)) {
            return false;
        }
        DescribeExperienceResponse other = (DescribeExperienceResponse) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(indexId(), other.indexId())
                && Objects.equals(name(), other.name()) && hasEndpoints() == other.hasEndpoints()
                && Objects.equals(endpoints(), other.endpoints()) && Objects.equals(configuration(), other.configuration())
                && Objects.equals(createdAt(), other.createdAt()) && Objects.equals(updatedAt(), other.updatedAt())
                && Objects.equals(description(), other.description()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(roleArn(), other.roleArn()) && Objects.equals(errorMessage(), other.errorMessage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeExperienceResponse").add("Id", id()).add("IndexId", indexId()).add("Name", name())
                .add("Endpoints", hasEndpoints() ? endpoints() : null).add("Configuration", configuration())
                .add("CreatedAt", createdAt()).add("UpdatedAt", updatedAt()).add("Description", description())
                .add("Status", statusAsString()).add("RoleArn", roleArn()).add("ErrorMessage", errorMessage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "IndexId":
            return Optional.ofNullable(clazz.cast(indexId()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Endpoints":
            return Optional.ofNullable(clazz.cast(endpoints()));
        case "Configuration":
            return Optional.ofNullable(clazz.cast(configuration()));
        case "CreatedAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "UpdatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "RoleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "ErrorMessage":
            return Optional.ofNullable(clazz.cast(errorMessage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeExperienceResponse, T> g) {
        return obj -> g.apply((DescribeExperienceResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends KendraResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeExperienceResponse> {
        /**
         * <p>
         * Shows the identifier of your Amazon Kendra experience.
         * </p>
         * 
         * @param id
         *        Shows the identifier of your Amazon Kendra experience.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * Shows the identifier of the index for your Amazon Kendra experience.
         * </p>
         * 
         * @param indexId
         *        Shows the identifier of the index for your Amazon Kendra experience.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder indexId(String indexId);

        /**
         * <p>
         * Shows the name of your Amazon Kendra experience.
         * </p>
         * 
         * @param name
         *        Shows the name of your Amazon Kendra experience.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Shows the endpoint URLs for your Amazon Kendra experiences. The URLs are unique and fully hosted by Amazon
         * Web Services.
         * </p>
         * 
         * @param endpoints
         *        Shows the endpoint URLs for your Amazon Kendra experiences. The URLs are unique and fully hosted by
         *        Amazon Web Services.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpoints(Collection<ExperienceEndpoint> endpoints);

        /**
         * <p>
         * Shows the endpoint URLs for your Amazon Kendra experiences. The URLs are unique and fully hosted by Amazon
         * Web Services.
         * </p>
         * 
         * @param endpoints
         *        Shows the endpoint URLs for your Amazon Kendra experiences. The URLs are unique and fully hosted by
         *        Amazon Web Services.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpoints(ExperienceEndpoint... endpoints);

        /**
         * <p>
         * Shows the endpoint URLs for your Amazon Kendra experiences. The URLs are unique and fully hosted by Amazon
         * Web Services.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<ExperienceEndpoint>.Builder}
         * avoiding the need to create one manually via {@link List<ExperienceEndpoint>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ExperienceEndpoint>.Builder#build()} is called immediately
         * and its result is passed to {@link #endpoints(List<ExperienceEndpoint>)}.
         * 
         * @param endpoints
         *        a consumer that will call methods on {@link List<ExperienceEndpoint>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #endpoints(List<ExperienceEndpoint>)
         */
        Builder endpoints(Consumer<ExperienceEndpoint.Builder>... endpoints);

        /**
         * <p>
         * Shows the configuration information for your Amazon Kendra experience. This includes
         * <code>ContentSourceConfiguration</code>, which specifies the data source IDs and/or FAQ IDs, and
         * <code>UserIdentityConfiguration</code>, which specifies the user or group information to grant access to your
         * Amazon Kendra experience.
         * </p>
         * 
         * @param configuration
         *        Shows the configuration information for your Amazon Kendra experience. This includes
         *        <code>ContentSourceConfiguration</code>, which specifies the data source IDs and/or FAQ IDs, and
         *        <code>UserIdentityConfiguration</code>, which specifies the user or group information to grant access
         *        to your Amazon Kendra experience.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configuration(ExperienceConfiguration configuration);

        /**
         * <p>
         * Shows the configuration information for your Amazon Kendra experience. This includes
         * <code>ContentSourceConfiguration</code>, which specifies the data source IDs and/or FAQ IDs, and
         * <code>UserIdentityConfiguration</code>, which specifies the user or group information to grant access to your
         * Amazon Kendra experience.
         * </p>
         * This is a convenience method that creates an instance of the {@link ExperienceConfiguration.Builder} avoiding
         * the need to create one manually via {@link ExperienceConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link ExperienceConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #configuration(ExperienceConfiguration)}.
         * 
         * @param configuration
         *        a consumer that will call methods on {@link ExperienceConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #configuration(ExperienceConfiguration)
         */
        default Builder configuration(Consumer<ExperienceConfiguration.Builder> configuration) {
            return configuration(ExperienceConfiguration.builder().applyMutation(configuration).build());
        }

        /**
         * <p>
         * Shows the date-time your Amazon Kendra experience was created.
         * </p>
         * 
         * @param createdAt
         *        Shows the date-time your Amazon Kendra experience was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * Shows the date-time your Amazon Kendra experience was last updated.
         * </p>
         * 
         * @param updatedAt
         *        Shows the date-time your Amazon Kendra experience was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(Instant updatedAt);

        /**
         * <p>
         * Shows the description for your Amazon Kendra experience.
         * </p>
         * 
         * @param description
         *        Shows the description for your Amazon Kendra experience.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The current processing status of your Amazon Kendra experience. When the status is <code>ACTIVE</code>, your
         * Amazon Kendra experience is ready to use. When the status is <code>FAILED</code>, the
         * <code>ErrorMessage</code> field contains the reason that this failed.
         * </p>
         * 
         * @param status
         *        The current processing status of your Amazon Kendra experience. When the status is <code>ACTIVE</code>
         *        , your Amazon Kendra experience is ready to use. When the status is <code>FAILED</code>, the
         *        <code>ErrorMessage</code> field contains the reason that this failed.
         * @see ExperienceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExperienceStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current processing status of your Amazon Kendra experience. When the status is <code>ACTIVE</code>, your
         * Amazon Kendra experience is ready to use. When the status is <code>FAILED</code>, the
         * <code>ErrorMessage</code> field contains the reason that this failed.
         * </p>
         * 
         * @param status
         *        The current processing status of your Amazon Kendra experience. When the status is <code>ACTIVE</code>
         *        , your Amazon Kendra experience is ready to use. When the status is <code>FAILED</code>, the
         *        <code>ErrorMessage</code> field contains the reason that this failed.
         * @see ExperienceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExperienceStatus
         */
        Builder status(ExperienceStatus status);

        /**
         * <p>
         * Shows the Amazon Resource Name (ARN) of a role with permission to access <code>Query</code> API,
         * <code>QuerySuggestions</code> API, <code>SubmitFeedback</code> API, and Amazon Web Services SSO that stores
         * your user and group information.
         * </p>
         * 
         * @param roleArn
         *        Shows the Amazon Resource Name (ARN) of a role with permission to access <code>Query</code> API,
         *        <code>QuerySuggestions</code> API, <code>SubmitFeedback</code> API, and Amazon Web Services SSO that
         *        stores your user and group information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * The reason your Amazon Kendra experience could not properly process.
         * </p>
         * 
         * @param errorMessage
         *        The reason your Amazon Kendra experience could not properly process.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorMessage(String errorMessage);
    }

    static final class BuilderImpl extends KendraResponse.BuilderImpl implements Builder {
        private String id;

        private String indexId;

        private String name;

        private List<ExperienceEndpoint> endpoints = DefaultSdkAutoConstructList.getInstance();

        private ExperienceConfiguration configuration;

        private Instant createdAt;

        private Instant updatedAt;

        private String description;

        private String status;

        private String roleArn;

        private String errorMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeExperienceResponse model) {
            super(model);
            id(model.id);
            indexId(model.indexId);
            name(model.name);
            endpoints(model.endpoints);
            configuration(model.configuration);
            createdAt(model.createdAt);
            updatedAt(model.updatedAt);
            description(model.description);
            status(model.status);
            roleArn(model.roleArn);
            errorMessage(model.errorMessage);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getIndexId() {
            return indexId;
        }

        public final void setIndexId(String indexId) {
            this.indexId = indexId;
        }

        @Override
        public final Builder indexId(String indexId) {
            this.indexId = indexId;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final List<ExperienceEndpoint.Builder> getEndpoints() {
            List<ExperienceEndpoint.Builder> result = ExperienceEndpointsCopier.copyToBuilder(this.endpoints);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEndpoints(Collection<ExperienceEndpoint.BuilderImpl> endpoints) {
            this.endpoints = ExperienceEndpointsCopier.copyFromBuilder(endpoints);
        }

        @Override
        public final Builder endpoints(Collection<ExperienceEndpoint> endpoints) {
            this.endpoints = ExperienceEndpointsCopier.copy(endpoints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder endpoints(ExperienceEndpoint... endpoints) {
            endpoints(Arrays.asList(endpoints));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder endpoints(Consumer<ExperienceEndpoint.Builder>... endpoints) {
            endpoints(Stream.of(endpoints).map(c -> ExperienceEndpoint.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final ExperienceConfiguration.Builder getConfiguration() {
            return configuration != null ? configuration.toBuilder() : null;
        }

        public final void setConfiguration(ExperienceConfiguration.BuilderImpl configuration) {
            this.configuration = configuration != null ? configuration.build() : null;
        }

        @Override
        public final Builder configuration(ExperienceConfiguration configuration) {
            this.configuration = configuration;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getUpdatedAt() {
            return updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ExperienceStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getErrorMessage() {
            return errorMessage;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        @Override
        public DescribeExperienceResponse build() {
            return new DescribeExperienceResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
