/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kendra.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides the configuration information to connect to a index.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DatabaseConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<DatabaseConfiguration.Builder, DatabaseConfiguration> {
    private static final SdkField<String> DATABASE_ENGINE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DatabaseEngineType").getter(getter(DatabaseConfiguration::databaseEngineTypeAsString))
            .setter(setter(Builder::databaseEngineType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseEngineType").build())
            .build();

    private static final SdkField<ConnectionConfiguration> CONNECTION_CONFIGURATION_FIELD = SdkField
            .<ConnectionConfiguration> builder(MarshallingType.SDK_POJO).memberName("ConnectionConfiguration")
            .getter(getter(DatabaseConfiguration::connectionConfiguration)).setter(setter(Builder::connectionConfiguration))
            .constructor(ConnectionConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionConfiguration").build())
            .build();

    private static final SdkField<DataSourceVpcConfiguration> VPC_CONFIGURATION_FIELD = SdkField
            .<DataSourceVpcConfiguration> builder(MarshallingType.SDK_POJO).memberName("VpcConfiguration")
            .getter(getter(DatabaseConfiguration::vpcConfiguration)).setter(setter(Builder::vpcConfiguration))
            .constructor(DataSourceVpcConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcConfiguration").build()).build();

    private static final SdkField<ColumnConfiguration> COLUMN_CONFIGURATION_FIELD = SdkField
            .<ColumnConfiguration> builder(MarshallingType.SDK_POJO).memberName("ColumnConfiguration")
            .getter(getter(DatabaseConfiguration::columnConfiguration)).setter(setter(Builder::columnConfiguration))
            .constructor(ColumnConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ColumnConfiguration").build())
            .build();

    private static final SdkField<AclConfiguration> ACL_CONFIGURATION_FIELD = SdkField
            .<AclConfiguration> builder(MarshallingType.SDK_POJO).memberName("AclConfiguration")
            .getter(getter(DatabaseConfiguration::aclConfiguration)).setter(setter(Builder::aclConfiguration))
            .constructor(AclConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AclConfiguration").build()).build();

    private static final SdkField<SqlConfiguration> SQL_CONFIGURATION_FIELD = SdkField
            .<SqlConfiguration> builder(MarshallingType.SDK_POJO).memberName("SqlConfiguration")
            .getter(getter(DatabaseConfiguration::sqlConfiguration)).setter(setter(Builder::sqlConfiguration))
            .constructor(SqlConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SqlConfiguration").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATABASE_ENGINE_TYPE_FIELD,
            CONNECTION_CONFIGURATION_FIELD, VPC_CONFIGURATION_FIELD, COLUMN_CONFIGURATION_FIELD, ACL_CONFIGURATION_FIELD,
            SQL_CONFIGURATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String databaseEngineType;

    private final ConnectionConfiguration connectionConfiguration;

    private final DataSourceVpcConfiguration vpcConfiguration;

    private final ColumnConfiguration columnConfiguration;

    private final AclConfiguration aclConfiguration;

    private final SqlConfiguration sqlConfiguration;

    private DatabaseConfiguration(BuilderImpl builder) {
        this.databaseEngineType = builder.databaseEngineType;
        this.connectionConfiguration = builder.connectionConfiguration;
        this.vpcConfiguration = builder.vpcConfiguration;
        this.columnConfiguration = builder.columnConfiguration;
        this.aclConfiguration = builder.aclConfiguration;
        this.sqlConfiguration = builder.sqlConfiguration;
    }

    /**
     * <p>
     * The type of database engine that runs the database.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #databaseEngineType} will return {@link DatabaseEngineType#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #databaseEngineTypeAsString}.
     * </p>
     * 
     * @return The type of database engine that runs the database.
     * @see DatabaseEngineType
     */
    public final DatabaseEngineType databaseEngineType() {
        return DatabaseEngineType.fromValue(databaseEngineType);
    }

    /**
     * <p>
     * The type of database engine that runs the database.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #databaseEngineType} will return {@link DatabaseEngineType#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #databaseEngineTypeAsString}.
     * </p>
     * 
     * @return The type of database engine that runs the database.
     * @see DatabaseEngineType
     */
    public final String databaseEngineTypeAsString() {
        return databaseEngineType;
    }

    /**
     * <p>
     * Configuration information that's required to connect to a database.
     * </p>
     * 
     * @return Configuration information that's required to connect to a database.
     */
    public final ConnectionConfiguration connectionConfiguration() {
        return connectionConfiguration;
    }

    /**
     * Returns the value of the VpcConfiguration property for this object.
     * 
     * @return The value of the VpcConfiguration property for this object.
     */
    public final DataSourceVpcConfiguration vpcConfiguration() {
        return vpcConfiguration;
    }

    /**
     * <p>
     * Information about where the index should get the document information from the database.
     * </p>
     * 
     * @return Information about where the index should get the document information from the database.
     */
    public final ColumnConfiguration columnConfiguration() {
        return columnConfiguration;
    }

    /**
     * <p>
     * Information about the database column that provides information for user context filtering.
     * </p>
     * 
     * @return Information about the database column that provides information for user context filtering.
     */
    public final AclConfiguration aclConfiguration() {
        return aclConfiguration;
    }

    /**
     * <p>
     * Provides information about how Amazon Kendra uses quote marks around SQL identifiers when querying a database
     * data source.
     * </p>
     * 
     * @return Provides information about how Amazon Kendra uses quote marks around SQL identifiers when querying a
     *         database data source.
     */
    public final SqlConfiguration sqlConfiguration() {
        return sqlConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(databaseEngineTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(connectionConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(vpcConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(columnConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(aclConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(sqlConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DatabaseConfiguration)) {
            return false;
        }
        DatabaseConfiguration other = (DatabaseConfiguration) obj;
        return Objects.equals(databaseEngineTypeAsString(), other.databaseEngineTypeAsString())
                && Objects.equals(connectionConfiguration(), other.connectionConfiguration())
                && Objects.equals(vpcConfiguration(), other.vpcConfiguration())
                && Objects.equals(columnConfiguration(), other.columnConfiguration())
                && Objects.equals(aclConfiguration(), other.aclConfiguration())
                && Objects.equals(sqlConfiguration(), other.sqlConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DatabaseConfiguration").add("DatabaseEngineType", databaseEngineTypeAsString())
                .add("ConnectionConfiguration", connectionConfiguration()).add("VpcConfiguration", vpcConfiguration())
                .add("ColumnConfiguration", columnConfiguration()).add("AclConfiguration", aclConfiguration())
                .add("SqlConfiguration", sqlConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DatabaseEngineType":
            return Optional.ofNullable(clazz.cast(databaseEngineTypeAsString()));
        case "ConnectionConfiguration":
            return Optional.ofNullable(clazz.cast(connectionConfiguration()));
        case "VpcConfiguration":
            return Optional.ofNullable(clazz.cast(vpcConfiguration()));
        case "ColumnConfiguration":
            return Optional.ofNullable(clazz.cast(columnConfiguration()));
        case "AclConfiguration":
            return Optional.ofNullable(clazz.cast(aclConfiguration()));
        case "SqlConfiguration":
            return Optional.ofNullable(clazz.cast(sqlConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DatabaseConfiguration, T> g) {
        return obj -> g.apply((DatabaseConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DatabaseConfiguration> {
        /**
         * <p>
         * The type of database engine that runs the database.
         * </p>
         * 
         * @param databaseEngineType
         *        The type of database engine that runs the database.
         * @see DatabaseEngineType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DatabaseEngineType
         */
        Builder databaseEngineType(String databaseEngineType);

        /**
         * <p>
         * The type of database engine that runs the database.
         * </p>
         * 
         * @param databaseEngineType
         *        The type of database engine that runs the database.
         * @see DatabaseEngineType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DatabaseEngineType
         */
        Builder databaseEngineType(DatabaseEngineType databaseEngineType);

        /**
         * <p>
         * Configuration information that's required to connect to a database.
         * </p>
         * 
         * @param connectionConfiguration
         *        Configuration information that's required to connect to a database.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectionConfiguration(ConnectionConfiguration connectionConfiguration);

        /**
         * <p>
         * Configuration information that's required to connect to a database.
         * </p>
         * This is a convenience method that creates an instance of the {@link ConnectionConfiguration.Builder} avoiding
         * the need to create one manually via {@link ConnectionConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link ConnectionConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #connectionConfiguration(ConnectionConfiguration)}.
         * 
         * @param connectionConfiguration
         *        a consumer that will call methods on {@link ConnectionConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #connectionConfiguration(ConnectionConfiguration)
         */
        default Builder connectionConfiguration(Consumer<ConnectionConfiguration.Builder> connectionConfiguration) {
            return connectionConfiguration(ConnectionConfiguration.builder().applyMutation(connectionConfiguration).build());
        }

        /**
         * Sets the value of the VpcConfiguration property for this object.
         *
         * @param vpcConfiguration
         *        The new value for the VpcConfiguration property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcConfiguration(DataSourceVpcConfiguration vpcConfiguration);

        /**
         * Sets the value of the VpcConfiguration property for this object.
         *
         * This is a convenience method that creates an instance of the {@link DataSourceVpcConfiguration.Builder}
         * avoiding the need to create one manually via {@link DataSourceVpcConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link DataSourceVpcConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #vpcConfiguration(DataSourceVpcConfiguration)}.
         * 
         * @param vpcConfiguration
         *        a consumer that will call methods on {@link DataSourceVpcConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vpcConfiguration(DataSourceVpcConfiguration)
         */
        default Builder vpcConfiguration(Consumer<DataSourceVpcConfiguration.Builder> vpcConfiguration) {
            return vpcConfiguration(DataSourceVpcConfiguration.builder().applyMutation(vpcConfiguration).build());
        }

        /**
         * <p>
         * Information about where the index should get the document information from the database.
         * </p>
         * 
         * @param columnConfiguration
         *        Information about where the index should get the document information from the database.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder columnConfiguration(ColumnConfiguration columnConfiguration);

        /**
         * <p>
         * Information about where the index should get the document information from the database.
         * </p>
         * This is a convenience method that creates an instance of the {@link ColumnConfiguration.Builder} avoiding the
         * need to create one manually via {@link ColumnConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link ColumnConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #columnConfiguration(ColumnConfiguration)}.
         * 
         * @param columnConfiguration
         *        a consumer that will call methods on {@link ColumnConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #columnConfiguration(ColumnConfiguration)
         */
        default Builder columnConfiguration(Consumer<ColumnConfiguration.Builder> columnConfiguration) {
            return columnConfiguration(ColumnConfiguration.builder().applyMutation(columnConfiguration).build());
        }

        /**
         * <p>
         * Information about the database column that provides information for user context filtering.
         * </p>
         * 
         * @param aclConfiguration
         *        Information about the database column that provides information for user context filtering.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aclConfiguration(AclConfiguration aclConfiguration);

        /**
         * <p>
         * Information about the database column that provides information for user context filtering.
         * </p>
         * This is a convenience method that creates an instance of the {@link AclConfiguration.Builder} avoiding the
         * need to create one manually via {@link AclConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link AclConfiguration.Builder#build()} is called immediately and its
         * result is passed to {@link #aclConfiguration(AclConfiguration)}.
         * 
         * @param aclConfiguration
         *        a consumer that will call methods on {@link AclConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #aclConfiguration(AclConfiguration)
         */
        default Builder aclConfiguration(Consumer<AclConfiguration.Builder> aclConfiguration) {
            return aclConfiguration(AclConfiguration.builder().applyMutation(aclConfiguration).build());
        }

        /**
         * <p>
         * Provides information about how Amazon Kendra uses quote marks around SQL identifiers when querying a database
         * data source.
         * </p>
         * 
         * @param sqlConfiguration
         *        Provides information about how Amazon Kendra uses quote marks around SQL identifiers when querying a
         *        database data source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sqlConfiguration(SqlConfiguration sqlConfiguration);

        /**
         * <p>
         * Provides information about how Amazon Kendra uses quote marks around SQL identifiers when querying a database
         * data source.
         * </p>
         * This is a convenience method that creates an instance of the {@link SqlConfiguration.Builder} avoiding the
         * need to create one manually via {@link SqlConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link SqlConfiguration.Builder#build()} is called immediately and its
         * result is passed to {@link #sqlConfiguration(SqlConfiguration)}.
         * 
         * @param sqlConfiguration
         *        a consumer that will call methods on {@link SqlConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sqlConfiguration(SqlConfiguration)
         */
        default Builder sqlConfiguration(Consumer<SqlConfiguration.Builder> sqlConfiguration) {
            return sqlConfiguration(SqlConfiguration.builder().applyMutation(sqlConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String databaseEngineType;

        private ConnectionConfiguration connectionConfiguration;

        private DataSourceVpcConfiguration vpcConfiguration;

        private ColumnConfiguration columnConfiguration;

        private AclConfiguration aclConfiguration;

        private SqlConfiguration sqlConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(DatabaseConfiguration model) {
            databaseEngineType(model.databaseEngineType);
            connectionConfiguration(model.connectionConfiguration);
            vpcConfiguration(model.vpcConfiguration);
            columnConfiguration(model.columnConfiguration);
            aclConfiguration(model.aclConfiguration);
            sqlConfiguration(model.sqlConfiguration);
        }

        public final String getDatabaseEngineType() {
            return databaseEngineType;
        }

        public final void setDatabaseEngineType(String databaseEngineType) {
            this.databaseEngineType = databaseEngineType;
        }

        @Override
        public final Builder databaseEngineType(String databaseEngineType) {
            this.databaseEngineType = databaseEngineType;
            return this;
        }

        @Override
        public final Builder databaseEngineType(DatabaseEngineType databaseEngineType) {
            this.databaseEngineType(databaseEngineType == null ? null : databaseEngineType.toString());
            return this;
        }

        public final ConnectionConfiguration.Builder getConnectionConfiguration() {
            return connectionConfiguration != null ? connectionConfiguration.toBuilder() : null;
        }

        public final void setConnectionConfiguration(ConnectionConfiguration.BuilderImpl connectionConfiguration) {
            this.connectionConfiguration = connectionConfiguration != null ? connectionConfiguration.build() : null;
        }

        @Override
        public final Builder connectionConfiguration(ConnectionConfiguration connectionConfiguration) {
            this.connectionConfiguration = connectionConfiguration;
            return this;
        }

        public final DataSourceVpcConfiguration.Builder getVpcConfiguration() {
            return vpcConfiguration != null ? vpcConfiguration.toBuilder() : null;
        }

        public final void setVpcConfiguration(DataSourceVpcConfiguration.BuilderImpl vpcConfiguration) {
            this.vpcConfiguration = vpcConfiguration != null ? vpcConfiguration.build() : null;
        }

        @Override
        public final Builder vpcConfiguration(DataSourceVpcConfiguration vpcConfiguration) {
            this.vpcConfiguration = vpcConfiguration;
            return this;
        }

        public final ColumnConfiguration.Builder getColumnConfiguration() {
            return columnConfiguration != null ? columnConfiguration.toBuilder() : null;
        }

        public final void setColumnConfiguration(ColumnConfiguration.BuilderImpl columnConfiguration) {
            this.columnConfiguration = columnConfiguration != null ? columnConfiguration.build() : null;
        }

        @Override
        public final Builder columnConfiguration(ColumnConfiguration columnConfiguration) {
            this.columnConfiguration = columnConfiguration;
            return this;
        }

        public final AclConfiguration.Builder getAclConfiguration() {
            return aclConfiguration != null ? aclConfiguration.toBuilder() : null;
        }

        public final void setAclConfiguration(AclConfiguration.BuilderImpl aclConfiguration) {
            this.aclConfiguration = aclConfiguration != null ? aclConfiguration.build() : null;
        }

        @Override
        public final Builder aclConfiguration(AclConfiguration aclConfiguration) {
            this.aclConfiguration = aclConfiguration;
            return this;
        }

        public final SqlConfiguration.Builder getSqlConfiguration() {
            return sqlConfiguration != null ? sqlConfiguration.toBuilder() : null;
        }

        public final void setSqlConfiguration(SqlConfiguration.BuilderImpl sqlConfiguration) {
            this.sqlConfiguration = sqlConfiguration != null ? sqlConfiguration.build() : null;
        }

        @Override
        public final Builder sqlConfiguration(SqlConfiguration sqlConfiguration) {
            this.sqlConfiguration = sqlConfiguration;
            return this;
        }

        @Override
        public DatabaseConfiguration build() {
            return new DatabaseConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
