/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kendra.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides the configuration information for altering document metadata and content during the document ingestion
 * process.
 * </p>
 * <p>
 * For more information, see <a
 * href="https://docs.aws.amazon.com/kendra/latest/dg/custom-document-enrichment.html">Customizing document metadata
 * during the ingestion process</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CustomDocumentEnrichmentConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<CustomDocumentEnrichmentConfiguration.Builder, CustomDocumentEnrichmentConfiguration> {
    private static final SdkField<List<InlineCustomDocumentEnrichmentConfiguration>> INLINE_CONFIGURATIONS_FIELD = SdkField
            .<List<InlineCustomDocumentEnrichmentConfiguration>> builder(MarshallingType.LIST)
            .memberName("InlineConfigurations")
            .getter(getter(CustomDocumentEnrichmentConfiguration::inlineConfigurations))
            .setter(setter(Builder::inlineConfigurations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InlineConfigurations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<InlineCustomDocumentEnrichmentConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(InlineCustomDocumentEnrichmentConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<HookConfiguration> PRE_EXTRACTION_HOOK_CONFIGURATION_FIELD = SdkField
            .<HookConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("PreExtractionHookConfiguration")
            .getter(getter(CustomDocumentEnrichmentConfiguration::preExtractionHookConfiguration))
            .setter(setter(Builder::preExtractionHookConfiguration))
            .constructor(HookConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreExtractionHookConfiguration")
                    .build()).build();

    private static final SdkField<HookConfiguration> POST_EXTRACTION_HOOK_CONFIGURATION_FIELD = SdkField
            .<HookConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("PostExtractionHookConfiguration")
            .getter(getter(CustomDocumentEnrichmentConfiguration::postExtractionHookConfiguration))
            .setter(setter(Builder::postExtractionHookConfiguration))
            .constructor(HookConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PostExtractionHookConfiguration")
                    .build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoleArn").getter(getter(CustomDocumentEnrichmentConfiguration::roleArn))
            .setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INLINE_CONFIGURATIONS_FIELD,
            PRE_EXTRACTION_HOOK_CONFIGURATION_FIELD, POST_EXTRACTION_HOOK_CONFIGURATION_FIELD, ROLE_ARN_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<InlineCustomDocumentEnrichmentConfiguration> inlineConfigurations;

    private final HookConfiguration preExtractionHookConfiguration;

    private final HookConfiguration postExtractionHookConfiguration;

    private final String roleArn;

    private CustomDocumentEnrichmentConfiguration(BuilderImpl builder) {
        this.inlineConfigurations = builder.inlineConfigurations;
        this.preExtractionHookConfiguration = builder.preExtractionHookConfiguration;
        this.postExtractionHookConfiguration = builder.postExtractionHookConfiguration;
        this.roleArn = builder.roleArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the InlineConfigurations property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasInlineConfigurations() {
        return inlineConfigurations != null && !(inlineConfigurations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Configuration information to alter document attributes or metadata fields and content when ingesting documents
     * into Amazon Kendra.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInlineConfigurations} method.
     * </p>
     * 
     * @return Configuration information to alter document attributes or metadata fields and content when ingesting
     *         documents into Amazon Kendra.
     */
    public final List<InlineCustomDocumentEnrichmentConfiguration> inlineConfigurations() {
        return inlineConfigurations;
    }

    /**
     * <p>
     * Configuration information for invoking a Lambda function in Lambda on the original or raw documents before
     * extracting their metadata and text. You can use a Lambda function to apply advanced logic for creating,
     * modifying, or deleting document metadata and content. For more information, see <a
     * href="https://docs.aws.amazon.com/kendra/latest/dg/custom-document-enrichment.html#advanced-data-manipulation"
     * >Advanced data manipulation</a>.
     * </p>
     * 
     * @return Configuration information for invoking a Lambda function in Lambda on the original or raw documents
     *         before extracting their metadata and text. You can use a Lambda function to apply advanced logic for
     *         creating, modifying, or deleting document metadata and content. For more information, see <a href=
     *         "https://docs.aws.amazon.com/kendra/latest/dg/custom-document-enrichment.html#advanced-data-manipulation"
     *         >Advanced data manipulation</a>.
     */
    public final HookConfiguration preExtractionHookConfiguration() {
        return preExtractionHookConfiguration;
    }

    /**
     * <p>
     * Configuration information for invoking a Lambda function in Lambda on the structured documents with their
     * metadata and text extracted. You can use a Lambda function to apply advanced logic for creating, modifying, or
     * deleting document metadata and content. For more information, see <a
     * href="https://docs.aws.amazon.com/kendra/latest/dg/custom-document-enrichment.html#advanced-data-manipulation"
     * >Advanced data manipulation</a>.
     * </p>
     * 
     * @return Configuration information for invoking a Lambda function in Lambda on the structured documents with their
     *         metadata and text extracted. You can use a Lambda function to apply advanced logic for creating,
     *         modifying, or deleting document metadata and content. For more information, see <a href=
     *         "https://docs.aws.amazon.com/kendra/latest/dg/custom-document-enrichment.html#advanced-data-manipulation"
     *         >Advanced data manipulation</a>.
     */
    public final HookConfiguration postExtractionHookConfiguration() {
        return postExtractionHookConfiguration;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of a role with permission to run <code>PreExtractionHookConfiguration</code> and
     * <code>PostExtractionHookConfiguration</code> for altering document metadata and content during the document
     * ingestion process. For more information, see <a
     * href="https://docs.aws.amazon.com/kendra/latest/dg/iam-roles.html">IAM roles for Amazon Kendra</a>.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of a role with permission to run
     *         <code>PreExtractionHookConfiguration</code> and <code>PostExtractionHookConfiguration</code> for altering
     *         document metadata and content during the document ingestion process. For more information, see <a
     *         href="https://docs.aws.amazon.com/kendra/latest/dg/iam-roles.html">IAM roles for Amazon Kendra</a>.
     */
    public final String roleArn() {
        return roleArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasInlineConfigurations() ? inlineConfigurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(preExtractionHookConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(postExtractionHookConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CustomDocumentEnrichmentConfiguration)) {
            return false;
        }
        CustomDocumentEnrichmentConfiguration other = (CustomDocumentEnrichmentConfiguration) obj;
        return hasInlineConfigurations() == other.hasInlineConfigurations()
                && Objects.equals(inlineConfigurations(), other.inlineConfigurations())
                && Objects.equals(preExtractionHookConfiguration(), other.preExtractionHookConfiguration())
                && Objects.equals(postExtractionHookConfiguration(), other.postExtractionHookConfiguration())
                && Objects.equals(roleArn(), other.roleArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CustomDocumentEnrichmentConfiguration")
                .add("InlineConfigurations", hasInlineConfigurations() ? inlineConfigurations() : null)
                .add("PreExtractionHookConfiguration", preExtractionHookConfiguration())
                .add("PostExtractionHookConfiguration", postExtractionHookConfiguration()).add("RoleArn", roleArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InlineConfigurations":
            return Optional.ofNullable(clazz.cast(inlineConfigurations()));
        case "PreExtractionHookConfiguration":
            return Optional.ofNullable(clazz.cast(preExtractionHookConfiguration()));
        case "PostExtractionHookConfiguration":
            return Optional.ofNullable(clazz.cast(postExtractionHookConfiguration()));
        case "RoleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CustomDocumentEnrichmentConfiguration, T> g) {
        return obj -> g.apply((CustomDocumentEnrichmentConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CustomDocumentEnrichmentConfiguration> {
        /**
         * <p>
         * Configuration information to alter document attributes or metadata fields and content when ingesting
         * documents into Amazon Kendra.
         * </p>
         * 
         * @param inlineConfigurations
         *        Configuration information to alter document attributes or metadata fields and content when ingesting
         *        documents into Amazon Kendra.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inlineConfigurations(Collection<InlineCustomDocumentEnrichmentConfiguration> inlineConfigurations);

        /**
         * <p>
         * Configuration information to alter document attributes or metadata fields and content when ingesting
         * documents into Amazon Kendra.
         * </p>
         * 
         * @param inlineConfigurations
         *        Configuration information to alter document attributes or metadata fields and content when ingesting
         *        documents into Amazon Kendra.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inlineConfigurations(InlineCustomDocumentEnrichmentConfiguration... inlineConfigurations);

        /**
         * <p>
         * Configuration information to alter document attributes or metadata fields and content when ingesting
         * documents into Amazon Kendra.
         * </p>
         * This is a convenience method that creates an instance of the {@link List
         * <InlineCustomDocumentEnrichmentConfiguration>.Builder} avoiding the need to create one manually via
         * {@link List<InlineCustomDocumentEnrichmentConfiguration>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List
         * <InlineCustomDocumentEnrichmentConfiguration>.Builder#build()} is called immediately and its result is passed
         * to {@link #inlineConfigurations(List<InlineCustomDocumentEnrichmentConfiguration>)}.
         * 
         * @param inlineConfigurations
         *        a consumer that will call methods on {@link List<InlineCustomDocumentEnrichmentConfiguration>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inlineConfigurations(List<InlineCustomDocumentEnrichmentConfiguration>)
         */
        Builder inlineConfigurations(Consumer<InlineCustomDocumentEnrichmentConfiguration.Builder>... inlineConfigurations);

        /**
         * <p>
         * Configuration information for invoking a Lambda function in Lambda on the original or raw documents before
         * extracting their metadata and text. You can use a Lambda function to apply advanced logic for creating,
         * modifying, or deleting document metadata and content. For more information, see <a href=
         * "https://docs.aws.amazon.com/kendra/latest/dg/custom-document-enrichment.html#advanced-data-manipulation"
         * >Advanced data manipulation</a>.
         * </p>
         * 
         * @param preExtractionHookConfiguration
         *        Configuration information for invoking a Lambda function in Lambda on the original or raw documents
         *        before extracting their metadata and text. You can use a Lambda function to apply advanced logic for
         *        creating, modifying, or deleting document metadata and content. For more information, see <a href=
         *        "https://docs.aws.amazon.com/kendra/latest/dg/custom-document-enrichment.html#advanced-data-manipulation"
         *        >Advanced data manipulation</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder preExtractionHookConfiguration(HookConfiguration preExtractionHookConfiguration);

        /**
         * <p>
         * Configuration information for invoking a Lambda function in Lambda on the original or raw documents before
         * extracting their metadata and text. You can use a Lambda function to apply advanced logic for creating,
         * modifying, or deleting document metadata and content. For more information, see <a href=
         * "https://docs.aws.amazon.com/kendra/latest/dg/custom-document-enrichment.html#advanced-data-manipulation"
         * >Advanced data manipulation</a>.
         * </p>
         * This is a convenience method that creates an instance of the {@link HookConfiguration.Builder} avoiding the
         * need to create one manually via {@link HookConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link HookConfiguration.Builder#build()} is called immediately and its
         * result is passed to {@link #preExtractionHookConfiguration(HookConfiguration)}.
         * 
         * @param preExtractionHookConfiguration
         *        a consumer that will call methods on {@link HookConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #preExtractionHookConfiguration(HookConfiguration)
         */
        default Builder preExtractionHookConfiguration(Consumer<HookConfiguration.Builder> preExtractionHookConfiguration) {
            return preExtractionHookConfiguration(HookConfiguration.builder().applyMutation(preExtractionHookConfiguration)
                    .build());
        }

        /**
         * <p>
         * Configuration information for invoking a Lambda function in Lambda on the structured documents with their
         * metadata and text extracted. You can use a Lambda function to apply advanced logic for creating, modifying,
         * or deleting document metadata and content. For more information, see <a href=
         * "https://docs.aws.amazon.com/kendra/latest/dg/custom-document-enrichment.html#advanced-data-manipulation"
         * >Advanced data manipulation</a>.
         * </p>
         * 
         * @param postExtractionHookConfiguration
         *        Configuration information for invoking a Lambda function in Lambda on the structured documents with
         *        their metadata and text extracted. You can use a Lambda function to apply advanced logic for creating,
         *        modifying, or deleting document metadata and content. For more information, see <a href=
         *        "https://docs.aws.amazon.com/kendra/latest/dg/custom-document-enrichment.html#advanced-data-manipulation"
         *        >Advanced data manipulation</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder postExtractionHookConfiguration(HookConfiguration postExtractionHookConfiguration);

        /**
         * <p>
         * Configuration information for invoking a Lambda function in Lambda on the structured documents with their
         * metadata and text extracted. You can use a Lambda function to apply advanced logic for creating, modifying,
         * or deleting document metadata and content. For more information, see <a href=
         * "https://docs.aws.amazon.com/kendra/latest/dg/custom-document-enrichment.html#advanced-data-manipulation"
         * >Advanced data manipulation</a>.
         * </p>
         * This is a convenience method that creates an instance of the {@link HookConfiguration.Builder} avoiding the
         * need to create one manually via {@link HookConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link HookConfiguration.Builder#build()} is called immediately and its
         * result is passed to {@link #postExtractionHookConfiguration(HookConfiguration)}.
         * 
         * @param postExtractionHookConfiguration
         *        a consumer that will call methods on {@link HookConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #postExtractionHookConfiguration(HookConfiguration)
         */
        default Builder postExtractionHookConfiguration(Consumer<HookConfiguration.Builder> postExtractionHookConfiguration) {
            return postExtractionHookConfiguration(HookConfiguration.builder().applyMutation(postExtractionHookConfiguration)
                    .build());
        }

        /**
         * <p>
         * The Amazon Resource Name (ARN) of a role with permission to run <code>PreExtractionHookConfiguration</code>
         * and <code>PostExtractionHookConfiguration</code> for altering document metadata and content during the
         * document ingestion process. For more information, see <a
         * href="https://docs.aws.amazon.com/kendra/latest/dg/iam-roles.html">IAM roles for Amazon Kendra</a>.
         * </p>
         * 
         * @param roleArn
         *        The Amazon Resource Name (ARN) of a role with permission to run
         *        <code>PreExtractionHookConfiguration</code> and <code>PostExtractionHookConfiguration</code> for
         *        altering document metadata and content during the document ingestion process. For more information,
         *        see <a href="https://docs.aws.amazon.com/kendra/latest/dg/iam-roles.html">IAM roles for Amazon
         *        Kendra</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);
    }

    static final class BuilderImpl implements Builder {
        private List<InlineCustomDocumentEnrichmentConfiguration> inlineConfigurations = DefaultSdkAutoConstructList
                .getInstance();

        private HookConfiguration preExtractionHookConfiguration;

        private HookConfiguration postExtractionHookConfiguration;

        private String roleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(CustomDocumentEnrichmentConfiguration model) {
            inlineConfigurations(model.inlineConfigurations);
            preExtractionHookConfiguration(model.preExtractionHookConfiguration);
            postExtractionHookConfiguration(model.postExtractionHookConfiguration);
            roleArn(model.roleArn);
        }

        public final List<InlineCustomDocumentEnrichmentConfiguration.Builder> getInlineConfigurations() {
            List<InlineCustomDocumentEnrichmentConfiguration.Builder> result = InlineCustomDocumentEnrichmentConfigurationListCopier
                    .copyToBuilder(this.inlineConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInlineConfigurations(
                Collection<InlineCustomDocumentEnrichmentConfiguration.BuilderImpl> inlineConfigurations) {
            this.inlineConfigurations = InlineCustomDocumentEnrichmentConfigurationListCopier
                    .copyFromBuilder(inlineConfigurations);
        }

        @Override
        public final Builder inlineConfigurations(Collection<InlineCustomDocumentEnrichmentConfiguration> inlineConfigurations) {
            this.inlineConfigurations = InlineCustomDocumentEnrichmentConfigurationListCopier.copy(inlineConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inlineConfigurations(InlineCustomDocumentEnrichmentConfiguration... inlineConfigurations) {
            inlineConfigurations(Arrays.asList(inlineConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inlineConfigurations(
                Consumer<InlineCustomDocumentEnrichmentConfiguration.Builder>... inlineConfigurations) {
            inlineConfigurations(Stream.of(inlineConfigurations)
                    .map(c -> InlineCustomDocumentEnrichmentConfiguration.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final HookConfiguration.Builder getPreExtractionHookConfiguration() {
            return preExtractionHookConfiguration != null ? preExtractionHookConfiguration.toBuilder() : null;
        }

        public final void setPreExtractionHookConfiguration(HookConfiguration.BuilderImpl preExtractionHookConfiguration) {
            this.preExtractionHookConfiguration = preExtractionHookConfiguration != null ? preExtractionHookConfiguration.build()
                    : null;
        }

        @Override
        public final Builder preExtractionHookConfiguration(HookConfiguration preExtractionHookConfiguration) {
            this.preExtractionHookConfiguration = preExtractionHookConfiguration;
            return this;
        }

        public final HookConfiguration.Builder getPostExtractionHookConfiguration() {
            return postExtractionHookConfiguration != null ? postExtractionHookConfiguration.toBuilder() : null;
        }

        public final void setPostExtractionHookConfiguration(HookConfiguration.BuilderImpl postExtractionHookConfiguration) {
            this.postExtractionHookConfiguration = postExtractionHookConfiguration != null ? postExtractionHookConfiguration
                    .build() : null;
        }

        @Override
        public final Builder postExtractionHookConfiguration(HookConfiguration postExtractionHookConfiguration) {
            this.postExtractionHookConfiguration = postExtractionHookConfiguration;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        @Override
        public CustomDocumentEnrichmentConfiguration build() {
            return new CustomDocumentEnrichmentConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
