/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kendra.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.kendra.model.DataSourceInclusionsExclusionsStringsCopier;
import software.amazon.awssdk.services.kendra.model.DataSourceToIndexFieldMapping;
import software.amazon.awssdk.services.kendra.model.DataSourceToIndexFieldMappingListCopier;
import software.amazon.awssdk.services.kendra.model.DataSourceVpcConfiguration;
import software.amazon.awssdk.services.kendra.model.PrivateChannelFilterCopier;
import software.amazon.awssdk.services.kendra.model.PublicChannelFilterCopier;
import software.amazon.awssdk.services.kendra.model.SlackEntity;
import software.amazon.awssdk.services.kendra.model.SlackEntityListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SlackConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SlackConfiguration> {
    private static final SdkField<String> TEAM_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TeamId").getter(SlackConfiguration.getter(SlackConfiguration::teamId)).setter(SlackConfiguration.setter(Builder::teamId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TeamId").build()}).build();
    private static final SdkField<String> SECRET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SecretArn").getter(SlackConfiguration.getter(SlackConfiguration::secretArn)).setter(SlackConfiguration.setter(Builder::secretArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecretArn").build()}).build();
    private static final SdkField<DataSourceVpcConfiguration> VPC_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("VpcConfiguration").getter(SlackConfiguration.getter(SlackConfiguration::vpcConfiguration)).setter(SlackConfiguration.setter(Builder::vpcConfiguration)).constructor(DataSourceVpcConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcConfiguration").build()}).build();
    private static final SdkField<List<String>> SLACK_ENTITY_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SlackEntityList").getter(SlackConfiguration.getter(SlackConfiguration::slackEntityListAsStrings)).setter(SlackConfiguration.setter(Builder::slackEntityListWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SlackEntityList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> USE_CHANGE_LOG_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("UseChangeLog").getter(SlackConfiguration.getter(SlackConfiguration::useChangeLog)).setter(SlackConfiguration.setter(Builder::useChangeLog)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UseChangeLog").build()}).build();
    private static final SdkField<Boolean> CRAWL_BOT_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("CrawlBotMessage").getter(SlackConfiguration.getter(SlackConfiguration::crawlBotMessage)).setter(SlackConfiguration.setter(Builder::crawlBotMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CrawlBotMessage").build()}).build();
    private static final SdkField<Boolean> EXCLUDE_ARCHIVED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("ExcludeArchived").getter(SlackConfiguration.getter(SlackConfiguration::excludeArchived)).setter(SlackConfiguration.setter(Builder::excludeArchived)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExcludeArchived").build()}).build();
    private static final SdkField<String> SINCE_CRAWL_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SinceCrawlDate").getter(SlackConfiguration.getter(SlackConfiguration::sinceCrawlDate)).setter(SlackConfiguration.setter(Builder::sinceCrawlDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SinceCrawlDate").build()}).build();
    private static final SdkField<Integer> LOOK_BACK_PERIOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("LookBackPeriod").getter(SlackConfiguration.getter(SlackConfiguration::lookBackPeriod)).setter(SlackConfiguration.setter(Builder::lookBackPeriod)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LookBackPeriod").build()}).build();
    private static final SdkField<List<String>> PRIVATE_CHANNEL_FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PrivateChannelFilter").getter(SlackConfiguration.getter(SlackConfiguration::privateChannelFilter)).setter(SlackConfiguration.setter(Builder::privateChannelFilter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrivateChannelFilter").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> PUBLIC_CHANNEL_FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PublicChannelFilter").getter(SlackConfiguration.getter(SlackConfiguration::publicChannelFilter)).setter(SlackConfiguration.setter(Builder::publicChannelFilter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PublicChannelFilter").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> INCLUSION_PATTERNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("InclusionPatterns").getter(SlackConfiguration.getter(SlackConfiguration::inclusionPatterns)).setter(SlackConfiguration.setter(Builder::inclusionPatterns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InclusionPatterns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> EXCLUSION_PATTERNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ExclusionPatterns").getter(SlackConfiguration.getter(SlackConfiguration::exclusionPatterns)).setter(SlackConfiguration.setter(Builder::exclusionPatterns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExclusionPatterns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<DataSourceToIndexFieldMapping>> FIELD_MAPPINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("FieldMappings").getter(SlackConfiguration.getter(SlackConfiguration::fieldMappings)).setter(SlackConfiguration.setter(Builder::fieldMappings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FieldMappings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DataSourceToIndexFieldMapping::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEAM_ID_FIELD, SECRET_ARN_FIELD, VPC_CONFIGURATION_FIELD, SLACK_ENTITY_LIST_FIELD, USE_CHANGE_LOG_FIELD, CRAWL_BOT_MESSAGE_FIELD, EXCLUDE_ARCHIVED_FIELD, SINCE_CRAWL_DATE_FIELD, LOOK_BACK_PERIOD_FIELD, PRIVATE_CHANNEL_FILTER_FIELD, PUBLIC_CHANNEL_FILTER_FIELD, INCLUSION_PATTERNS_FIELD, EXCLUSION_PATTERNS_FIELD, FIELD_MAPPINGS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String teamId;
    private final String secretArn;
    private final DataSourceVpcConfiguration vpcConfiguration;
    private final List<String> slackEntityList;
    private final Boolean useChangeLog;
    private final Boolean crawlBotMessage;
    private final Boolean excludeArchived;
    private final String sinceCrawlDate;
    private final Integer lookBackPeriod;
    private final List<String> privateChannelFilter;
    private final List<String> publicChannelFilter;
    private final List<String> inclusionPatterns;
    private final List<String> exclusionPatterns;
    private final List<DataSourceToIndexFieldMapping> fieldMappings;

    private SlackConfiguration(BuilderImpl builder) {
        this.teamId = builder.teamId;
        this.secretArn = builder.secretArn;
        this.vpcConfiguration = builder.vpcConfiguration;
        this.slackEntityList = builder.slackEntityList;
        this.useChangeLog = builder.useChangeLog;
        this.crawlBotMessage = builder.crawlBotMessage;
        this.excludeArchived = builder.excludeArchived;
        this.sinceCrawlDate = builder.sinceCrawlDate;
        this.lookBackPeriod = builder.lookBackPeriod;
        this.privateChannelFilter = builder.privateChannelFilter;
        this.publicChannelFilter = builder.publicChannelFilter;
        this.inclusionPatterns = builder.inclusionPatterns;
        this.exclusionPatterns = builder.exclusionPatterns;
        this.fieldMappings = builder.fieldMappings;
    }

    public final String teamId() {
        return this.teamId;
    }

    public final String secretArn() {
        return this.secretArn;
    }

    public final DataSourceVpcConfiguration vpcConfiguration() {
        return this.vpcConfiguration;
    }

    public final List<SlackEntity> slackEntityList() {
        return SlackEntityListCopier.copyStringToEnum(this.slackEntityList);
    }

    public final boolean hasSlackEntityList() {
        return this.slackEntityList != null && !(this.slackEntityList instanceof SdkAutoConstructList);
    }

    public final List<String> slackEntityListAsStrings() {
        return this.slackEntityList;
    }

    public final Boolean useChangeLog() {
        return this.useChangeLog;
    }

    public final Boolean crawlBotMessage() {
        return this.crawlBotMessage;
    }

    public final Boolean excludeArchived() {
        return this.excludeArchived;
    }

    public final String sinceCrawlDate() {
        return this.sinceCrawlDate;
    }

    public final Integer lookBackPeriod() {
        return this.lookBackPeriod;
    }

    public final boolean hasPrivateChannelFilter() {
        return this.privateChannelFilter != null && !(this.privateChannelFilter instanceof SdkAutoConstructList);
    }

    public final List<String> privateChannelFilter() {
        return this.privateChannelFilter;
    }

    public final boolean hasPublicChannelFilter() {
        return this.publicChannelFilter != null && !(this.publicChannelFilter instanceof SdkAutoConstructList);
    }

    public final List<String> publicChannelFilter() {
        return this.publicChannelFilter;
    }

    public final boolean hasInclusionPatterns() {
        return this.inclusionPatterns != null && !(this.inclusionPatterns instanceof SdkAutoConstructList);
    }

    public final List<String> inclusionPatterns() {
        return this.inclusionPatterns;
    }

    public final boolean hasExclusionPatterns() {
        return this.exclusionPatterns != null && !(this.exclusionPatterns instanceof SdkAutoConstructList);
    }

    public final List<String> exclusionPatterns() {
        return this.exclusionPatterns;
    }

    public final boolean hasFieldMappings() {
        return this.fieldMappings != null && !(this.fieldMappings instanceof SdkAutoConstructList);
    }

    public final List<DataSourceToIndexFieldMapping> fieldMappings() {
        return this.fieldMappings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.teamId());
        hashCode = 31 * hashCode + Objects.hashCode(this.secretArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSlackEntityList() ? this.slackEntityListAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.useChangeLog());
        hashCode = 31 * hashCode + Objects.hashCode(this.crawlBotMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.excludeArchived());
        hashCode = 31 * hashCode + Objects.hashCode(this.sinceCrawlDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.lookBackPeriod());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPrivateChannelFilter() ? this.privateChannelFilter() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPublicChannelFilter() ? this.publicChannelFilter() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInclusionPatterns() ? this.inclusionPatterns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasExclusionPatterns() ? this.exclusionPatterns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFieldMappings() ? this.fieldMappings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SlackConfiguration)) {
            return false;
        }
        SlackConfiguration other = (SlackConfiguration)obj;
        return Objects.equals(this.teamId(), other.teamId()) && Objects.equals(this.secretArn(), other.secretArn()) && Objects.equals(this.vpcConfiguration(), other.vpcConfiguration()) && this.hasSlackEntityList() == other.hasSlackEntityList() && Objects.equals(this.slackEntityListAsStrings(), other.slackEntityListAsStrings()) && Objects.equals(this.useChangeLog(), other.useChangeLog()) && Objects.equals(this.crawlBotMessage(), other.crawlBotMessage()) && Objects.equals(this.excludeArchived(), other.excludeArchived()) && Objects.equals(this.sinceCrawlDate(), other.sinceCrawlDate()) && Objects.equals(this.lookBackPeriod(), other.lookBackPeriod()) && this.hasPrivateChannelFilter() == other.hasPrivateChannelFilter() && Objects.equals(this.privateChannelFilter(), other.privateChannelFilter()) && this.hasPublicChannelFilter() == other.hasPublicChannelFilter() && Objects.equals(this.publicChannelFilter(), other.publicChannelFilter()) && this.hasInclusionPatterns() == other.hasInclusionPatterns() && Objects.equals(this.inclusionPatterns(), other.inclusionPatterns()) && this.hasExclusionPatterns() == other.hasExclusionPatterns() && Objects.equals(this.exclusionPatterns(), other.exclusionPatterns()) && this.hasFieldMappings() == other.hasFieldMappings() && Objects.equals(this.fieldMappings(), other.fieldMappings());
    }

    public final String toString() {
        return ToString.builder((String)"SlackConfiguration").add("TeamId", (Object)this.teamId()).add("SecretArn", (Object)this.secretArn()).add("VpcConfiguration", (Object)this.vpcConfiguration()).add("SlackEntityList", this.hasSlackEntityList() ? this.slackEntityListAsStrings() : null).add("UseChangeLog", (Object)this.useChangeLog()).add("CrawlBotMessage", (Object)this.crawlBotMessage()).add("ExcludeArchived", (Object)this.excludeArchived()).add("SinceCrawlDate", (Object)this.sinceCrawlDate()).add("LookBackPeriod", (Object)this.lookBackPeriod()).add("PrivateChannelFilter", this.hasPrivateChannelFilter() ? this.privateChannelFilter() : null).add("PublicChannelFilter", this.hasPublicChannelFilter() ? this.publicChannelFilter() : null).add("InclusionPatterns", this.hasInclusionPatterns() ? this.inclusionPatterns() : null).add("ExclusionPatterns", this.hasExclusionPatterns() ? this.exclusionPatterns() : null).add("FieldMappings", this.hasFieldMappings() ? this.fieldMappings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TeamId": {
                return Optional.ofNullable(clazz.cast(this.teamId()));
            }
            case "SecretArn": {
                return Optional.ofNullable(clazz.cast(this.secretArn()));
            }
            case "VpcConfiguration": {
                return Optional.ofNullable(clazz.cast(this.vpcConfiguration()));
            }
            case "SlackEntityList": {
                return Optional.ofNullable(clazz.cast(this.slackEntityListAsStrings()));
            }
            case "UseChangeLog": {
                return Optional.ofNullable(clazz.cast(this.useChangeLog()));
            }
            case "CrawlBotMessage": {
                return Optional.ofNullable(clazz.cast(this.crawlBotMessage()));
            }
            case "ExcludeArchived": {
                return Optional.ofNullable(clazz.cast(this.excludeArchived()));
            }
            case "SinceCrawlDate": {
                return Optional.ofNullable(clazz.cast(this.sinceCrawlDate()));
            }
            case "LookBackPeriod": {
                return Optional.ofNullable(clazz.cast(this.lookBackPeriod()));
            }
            case "PrivateChannelFilter": {
                return Optional.ofNullable(clazz.cast(this.privateChannelFilter()));
            }
            case "PublicChannelFilter": {
                return Optional.ofNullable(clazz.cast(this.publicChannelFilter()));
            }
            case "InclusionPatterns": {
                return Optional.ofNullable(clazz.cast(this.inclusionPatterns()));
            }
            case "ExclusionPatterns": {
                return Optional.ofNullable(clazz.cast(this.exclusionPatterns()));
            }
            case "FieldMappings": {
                return Optional.ofNullable(clazz.cast(this.fieldMappings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SlackConfiguration, T> g) {
        return obj -> g.apply((SlackConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String teamId;
        private String secretArn;
        private DataSourceVpcConfiguration vpcConfiguration;
        private List<String> slackEntityList = DefaultSdkAutoConstructList.getInstance();
        private Boolean useChangeLog;
        private Boolean crawlBotMessage;
        private Boolean excludeArchived;
        private String sinceCrawlDate;
        private Integer lookBackPeriod;
        private List<String> privateChannelFilter = DefaultSdkAutoConstructList.getInstance();
        private List<String> publicChannelFilter = DefaultSdkAutoConstructList.getInstance();
        private List<String> inclusionPatterns = DefaultSdkAutoConstructList.getInstance();
        private List<String> exclusionPatterns = DefaultSdkAutoConstructList.getInstance();
        private List<DataSourceToIndexFieldMapping> fieldMappings = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SlackConfiguration model) {
            this.teamId(model.teamId);
            this.secretArn(model.secretArn);
            this.vpcConfiguration(model.vpcConfiguration);
            this.slackEntityListWithStrings(model.slackEntityList);
            this.useChangeLog(model.useChangeLog);
            this.crawlBotMessage(model.crawlBotMessage);
            this.excludeArchived(model.excludeArchived);
            this.sinceCrawlDate(model.sinceCrawlDate);
            this.lookBackPeriod(model.lookBackPeriod);
            this.privateChannelFilter(model.privateChannelFilter);
            this.publicChannelFilter(model.publicChannelFilter);
            this.inclusionPatterns(model.inclusionPatterns);
            this.exclusionPatterns(model.exclusionPatterns);
            this.fieldMappings(model.fieldMappings);
        }

        public final String getTeamId() {
            return this.teamId;
        }

        public final void setTeamId(String teamId) {
            this.teamId = teamId;
        }

        @Override
        @Transient
        public final Builder teamId(String teamId) {
            this.teamId = teamId;
            return this;
        }

        public final String getSecretArn() {
            return this.secretArn;
        }

        public final void setSecretArn(String secretArn) {
            this.secretArn = secretArn;
        }

        @Override
        @Transient
        public final Builder secretArn(String secretArn) {
            this.secretArn = secretArn;
            return this;
        }

        public final DataSourceVpcConfiguration.Builder getVpcConfiguration() {
            return this.vpcConfiguration != null ? this.vpcConfiguration.toBuilder() : null;
        }

        public final void setVpcConfiguration(DataSourceVpcConfiguration.BuilderImpl vpcConfiguration) {
            this.vpcConfiguration = vpcConfiguration != null ? vpcConfiguration.build() : null;
        }

        @Override
        @Transient
        public final Builder vpcConfiguration(DataSourceVpcConfiguration vpcConfiguration) {
            this.vpcConfiguration = vpcConfiguration;
            return this;
        }

        public final Collection<String> getSlackEntityList() {
            if (this.slackEntityList instanceof SdkAutoConstructList) {
                return null;
            }
            return this.slackEntityList;
        }

        public final void setSlackEntityList(Collection<String> slackEntityList) {
            this.slackEntityList = SlackEntityListCopier.copy(slackEntityList);
        }

        @Override
        @Transient
        public final Builder slackEntityListWithStrings(Collection<String> slackEntityList) {
            this.slackEntityList = SlackEntityListCopier.copy(slackEntityList);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder slackEntityListWithStrings(String ... slackEntityList) {
            this.slackEntityListWithStrings(Arrays.asList(slackEntityList));
            return this;
        }

        @Override
        @Transient
        public final Builder slackEntityList(Collection<SlackEntity> slackEntityList) {
            this.slackEntityList = SlackEntityListCopier.copyEnumToString(slackEntityList);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder slackEntityList(SlackEntity ... slackEntityList) {
            this.slackEntityList(Arrays.asList(slackEntityList));
            return this;
        }

        public final Boolean getUseChangeLog() {
            return this.useChangeLog;
        }

        public final void setUseChangeLog(Boolean useChangeLog) {
            this.useChangeLog = useChangeLog;
        }

        @Override
        @Transient
        public final Builder useChangeLog(Boolean useChangeLog) {
            this.useChangeLog = useChangeLog;
            return this;
        }

        public final Boolean getCrawlBotMessage() {
            return this.crawlBotMessage;
        }

        public final void setCrawlBotMessage(Boolean crawlBotMessage) {
            this.crawlBotMessage = crawlBotMessage;
        }

        @Override
        @Transient
        public final Builder crawlBotMessage(Boolean crawlBotMessage) {
            this.crawlBotMessage = crawlBotMessage;
            return this;
        }

        public final Boolean getExcludeArchived() {
            return this.excludeArchived;
        }

        public final void setExcludeArchived(Boolean excludeArchived) {
            this.excludeArchived = excludeArchived;
        }

        @Override
        @Transient
        public final Builder excludeArchived(Boolean excludeArchived) {
            this.excludeArchived = excludeArchived;
            return this;
        }

        public final String getSinceCrawlDate() {
            return this.sinceCrawlDate;
        }

        public final void setSinceCrawlDate(String sinceCrawlDate) {
            this.sinceCrawlDate = sinceCrawlDate;
        }

        @Override
        @Transient
        public final Builder sinceCrawlDate(String sinceCrawlDate) {
            this.sinceCrawlDate = sinceCrawlDate;
            return this;
        }

        public final Integer getLookBackPeriod() {
            return this.lookBackPeriod;
        }

        public final void setLookBackPeriod(Integer lookBackPeriod) {
            this.lookBackPeriod = lookBackPeriod;
        }

        @Override
        @Transient
        public final Builder lookBackPeriod(Integer lookBackPeriod) {
            this.lookBackPeriod = lookBackPeriod;
            return this;
        }

        public final Collection<String> getPrivateChannelFilter() {
            if (this.privateChannelFilter instanceof SdkAutoConstructList) {
                return null;
            }
            return this.privateChannelFilter;
        }

        public final void setPrivateChannelFilter(Collection<String> privateChannelFilter) {
            this.privateChannelFilter = PrivateChannelFilterCopier.copy(privateChannelFilter);
        }

        @Override
        @Transient
        public final Builder privateChannelFilter(Collection<String> privateChannelFilter) {
            this.privateChannelFilter = PrivateChannelFilterCopier.copy(privateChannelFilter);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder privateChannelFilter(String ... privateChannelFilter) {
            this.privateChannelFilter(Arrays.asList(privateChannelFilter));
            return this;
        }

        public final Collection<String> getPublicChannelFilter() {
            if (this.publicChannelFilter instanceof SdkAutoConstructList) {
                return null;
            }
            return this.publicChannelFilter;
        }

        public final void setPublicChannelFilter(Collection<String> publicChannelFilter) {
            this.publicChannelFilter = PublicChannelFilterCopier.copy(publicChannelFilter);
        }

        @Override
        @Transient
        public final Builder publicChannelFilter(Collection<String> publicChannelFilter) {
            this.publicChannelFilter = PublicChannelFilterCopier.copy(publicChannelFilter);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder publicChannelFilter(String ... publicChannelFilter) {
            this.publicChannelFilter(Arrays.asList(publicChannelFilter));
            return this;
        }

        public final Collection<String> getInclusionPatterns() {
            if (this.inclusionPatterns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.inclusionPatterns;
        }

        public final void setInclusionPatterns(Collection<String> inclusionPatterns) {
            this.inclusionPatterns = DataSourceInclusionsExclusionsStringsCopier.copy(inclusionPatterns);
        }

        @Override
        @Transient
        public final Builder inclusionPatterns(Collection<String> inclusionPatterns) {
            this.inclusionPatterns = DataSourceInclusionsExclusionsStringsCopier.copy(inclusionPatterns);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder inclusionPatterns(String ... inclusionPatterns) {
            this.inclusionPatterns(Arrays.asList(inclusionPatterns));
            return this;
        }

        public final Collection<String> getExclusionPatterns() {
            if (this.exclusionPatterns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.exclusionPatterns;
        }

        public final void setExclusionPatterns(Collection<String> exclusionPatterns) {
            this.exclusionPatterns = DataSourceInclusionsExclusionsStringsCopier.copy(exclusionPatterns);
        }

        @Override
        @Transient
        public final Builder exclusionPatterns(Collection<String> exclusionPatterns) {
            this.exclusionPatterns = DataSourceInclusionsExclusionsStringsCopier.copy(exclusionPatterns);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder exclusionPatterns(String ... exclusionPatterns) {
            this.exclusionPatterns(Arrays.asList(exclusionPatterns));
            return this;
        }

        public final List<DataSourceToIndexFieldMapping.Builder> getFieldMappings() {
            List<DataSourceToIndexFieldMapping.Builder> result = DataSourceToIndexFieldMappingListCopier.copyToBuilder(this.fieldMappings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFieldMappings(Collection<DataSourceToIndexFieldMapping.BuilderImpl> fieldMappings) {
            this.fieldMappings = DataSourceToIndexFieldMappingListCopier.copyFromBuilder(fieldMappings);
        }

        @Override
        @Transient
        public final Builder fieldMappings(Collection<DataSourceToIndexFieldMapping> fieldMappings) {
            this.fieldMappings = DataSourceToIndexFieldMappingListCopier.copy(fieldMappings);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder fieldMappings(DataSourceToIndexFieldMapping ... fieldMappings) {
            this.fieldMappings(Arrays.asList(fieldMappings));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder fieldMappings(Consumer<DataSourceToIndexFieldMapping.Builder> ... fieldMappings) {
            this.fieldMappings(Stream.of(fieldMappings).map(c -> (DataSourceToIndexFieldMapping)((DataSourceToIndexFieldMapping.Builder)DataSourceToIndexFieldMapping.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public SlackConfiguration build() {
            return new SlackConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SlackConfiguration> {
        public Builder teamId(String var1);

        public Builder secretArn(String var1);

        public Builder vpcConfiguration(DataSourceVpcConfiguration var1);

        default public Builder vpcConfiguration(Consumer<DataSourceVpcConfiguration.Builder> vpcConfiguration) {
            return this.vpcConfiguration((DataSourceVpcConfiguration)((DataSourceVpcConfiguration.Builder)DataSourceVpcConfiguration.builder().applyMutation(vpcConfiguration)).build());
        }

        public Builder slackEntityListWithStrings(Collection<String> var1);

        public Builder slackEntityListWithStrings(String ... var1);

        public Builder slackEntityList(Collection<SlackEntity> var1);

        public Builder slackEntityList(SlackEntity ... var1);

        public Builder useChangeLog(Boolean var1);

        public Builder crawlBotMessage(Boolean var1);

        public Builder excludeArchived(Boolean var1);

        public Builder sinceCrawlDate(String var1);

        public Builder lookBackPeriod(Integer var1);

        public Builder privateChannelFilter(Collection<String> var1);

        public Builder privateChannelFilter(String ... var1);

        public Builder publicChannelFilter(Collection<String> var1);

        public Builder publicChannelFilter(String ... var1);

        public Builder inclusionPatterns(Collection<String> var1);

        public Builder inclusionPatterns(String ... var1);

        public Builder exclusionPatterns(Collection<String> var1);

        public Builder exclusionPatterns(String ... var1);

        public Builder fieldMappings(Collection<DataSourceToIndexFieldMapping> var1);

        public Builder fieldMappings(DataSourceToIndexFieldMapping ... var1);

        public Builder fieldMappings(Consumer<DataSourceToIndexFieldMapping.Builder> ... var1);
    }
}

