/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kendra.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.kendra.model.HookConfiguration;
import software.amazon.awssdk.services.kendra.model.InlineCustomDocumentEnrichmentConfiguration;
import software.amazon.awssdk.services.kendra.model.InlineCustomDocumentEnrichmentConfigurationListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CustomDocumentEnrichmentConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CustomDocumentEnrichmentConfiguration> {
    private static final SdkField<List<InlineCustomDocumentEnrichmentConfiguration>> INLINE_CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("InlineConfigurations").getter(CustomDocumentEnrichmentConfiguration.getter(CustomDocumentEnrichmentConfiguration::inlineConfigurations)).setter(CustomDocumentEnrichmentConfiguration.setter(Builder::inlineConfigurations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InlineConfigurations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(InlineCustomDocumentEnrichmentConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<HookConfiguration> PRE_EXTRACTION_HOOK_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PreExtractionHookConfiguration").getter(CustomDocumentEnrichmentConfiguration.getter(CustomDocumentEnrichmentConfiguration::preExtractionHookConfiguration)).setter(CustomDocumentEnrichmentConfiguration.setter(Builder::preExtractionHookConfiguration)).constructor(HookConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreExtractionHookConfiguration").build()}).build();
    private static final SdkField<HookConfiguration> POST_EXTRACTION_HOOK_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PostExtractionHookConfiguration").getter(CustomDocumentEnrichmentConfiguration.getter(CustomDocumentEnrichmentConfiguration::postExtractionHookConfiguration)).setter(CustomDocumentEnrichmentConfiguration.setter(Builder::postExtractionHookConfiguration)).constructor(HookConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PostExtractionHookConfiguration").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoleArn").getter(CustomDocumentEnrichmentConfiguration.getter(CustomDocumentEnrichmentConfiguration::roleArn)).setter(CustomDocumentEnrichmentConfiguration.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INLINE_CONFIGURATIONS_FIELD, PRE_EXTRACTION_HOOK_CONFIGURATION_FIELD, POST_EXTRACTION_HOOK_CONFIGURATION_FIELD, ROLE_ARN_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<InlineCustomDocumentEnrichmentConfiguration> inlineConfigurations;
    private final HookConfiguration preExtractionHookConfiguration;
    private final HookConfiguration postExtractionHookConfiguration;
    private final String roleArn;

    private CustomDocumentEnrichmentConfiguration(BuilderImpl builder) {
        this.inlineConfigurations = builder.inlineConfigurations;
        this.preExtractionHookConfiguration = builder.preExtractionHookConfiguration;
        this.postExtractionHookConfiguration = builder.postExtractionHookConfiguration;
        this.roleArn = builder.roleArn;
    }

    public final boolean hasInlineConfigurations() {
        return this.inlineConfigurations != null && !(this.inlineConfigurations instanceof SdkAutoConstructList);
    }

    public final List<InlineCustomDocumentEnrichmentConfiguration> inlineConfigurations() {
        return this.inlineConfigurations;
    }

    public final HookConfiguration preExtractionHookConfiguration() {
        return this.preExtractionHookConfiguration;
    }

    public final HookConfiguration postExtractionHookConfiguration() {
        return this.postExtractionHookConfiguration;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInlineConfigurations() ? this.inlineConfigurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.preExtractionHookConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.postExtractionHookConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CustomDocumentEnrichmentConfiguration)) {
            return false;
        }
        CustomDocumentEnrichmentConfiguration other = (CustomDocumentEnrichmentConfiguration)obj;
        return this.hasInlineConfigurations() == other.hasInlineConfigurations() && Objects.equals(this.inlineConfigurations(), other.inlineConfigurations()) && Objects.equals(this.preExtractionHookConfiguration(), other.preExtractionHookConfiguration()) && Objects.equals(this.postExtractionHookConfiguration(), other.postExtractionHookConfiguration()) && Objects.equals(this.roleArn(), other.roleArn());
    }

    public final String toString() {
        return ToString.builder((String)"CustomDocumentEnrichmentConfiguration").add("InlineConfigurations", this.hasInlineConfigurations() ? this.inlineConfigurations() : null).add("PreExtractionHookConfiguration", (Object)this.preExtractionHookConfiguration()).add("PostExtractionHookConfiguration", (Object)this.postExtractionHookConfiguration()).add("RoleArn", (Object)this.roleArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InlineConfigurations": {
                return Optional.ofNullable(clazz.cast(this.inlineConfigurations()));
            }
            case "PreExtractionHookConfiguration": {
                return Optional.ofNullable(clazz.cast(this.preExtractionHookConfiguration()));
            }
            case "PostExtractionHookConfiguration": {
                return Optional.ofNullable(clazz.cast(this.postExtractionHookConfiguration()));
            }
            case "RoleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CustomDocumentEnrichmentConfiguration, T> g) {
        return obj -> g.apply((CustomDocumentEnrichmentConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<InlineCustomDocumentEnrichmentConfiguration> inlineConfigurations = DefaultSdkAutoConstructList.getInstance();
        private HookConfiguration preExtractionHookConfiguration;
        private HookConfiguration postExtractionHookConfiguration;
        private String roleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(CustomDocumentEnrichmentConfiguration model) {
            this.inlineConfigurations(model.inlineConfigurations);
            this.preExtractionHookConfiguration(model.preExtractionHookConfiguration);
            this.postExtractionHookConfiguration(model.postExtractionHookConfiguration);
            this.roleArn(model.roleArn);
        }

        public final List<InlineCustomDocumentEnrichmentConfiguration.Builder> getInlineConfigurations() {
            List<InlineCustomDocumentEnrichmentConfiguration.Builder> result = InlineCustomDocumentEnrichmentConfigurationListCopier.copyToBuilder(this.inlineConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInlineConfigurations(Collection<InlineCustomDocumentEnrichmentConfiguration.BuilderImpl> inlineConfigurations) {
            this.inlineConfigurations = InlineCustomDocumentEnrichmentConfigurationListCopier.copyFromBuilder(inlineConfigurations);
        }

        @Override
        @Transient
        public final Builder inlineConfigurations(Collection<InlineCustomDocumentEnrichmentConfiguration> inlineConfigurations) {
            this.inlineConfigurations = InlineCustomDocumentEnrichmentConfigurationListCopier.copy(inlineConfigurations);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder inlineConfigurations(InlineCustomDocumentEnrichmentConfiguration ... inlineConfigurations) {
            this.inlineConfigurations(Arrays.asList(inlineConfigurations));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder inlineConfigurations(Consumer<InlineCustomDocumentEnrichmentConfiguration.Builder> ... inlineConfigurations) {
            this.inlineConfigurations(Stream.of(inlineConfigurations).map(c -> (InlineCustomDocumentEnrichmentConfiguration)((InlineCustomDocumentEnrichmentConfiguration.Builder)InlineCustomDocumentEnrichmentConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final HookConfiguration.Builder getPreExtractionHookConfiguration() {
            return this.preExtractionHookConfiguration != null ? this.preExtractionHookConfiguration.toBuilder() : null;
        }

        public final void setPreExtractionHookConfiguration(HookConfiguration.BuilderImpl preExtractionHookConfiguration) {
            this.preExtractionHookConfiguration = preExtractionHookConfiguration != null ? preExtractionHookConfiguration.build() : null;
        }

        @Override
        @Transient
        public final Builder preExtractionHookConfiguration(HookConfiguration preExtractionHookConfiguration) {
            this.preExtractionHookConfiguration = preExtractionHookConfiguration;
            return this;
        }

        public final HookConfiguration.Builder getPostExtractionHookConfiguration() {
            return this.postExtractionHookConfiguration != null ? this.postExtractionHookConfiguration.toBuilder() : null;
        }

        public final void setPostExtractionHookConfiguration(HookConfiguration.BuilderImpl postExtractionHookConfiguration) {
            this.postExtractionHookConfiguration = postExtractionHookConfiguration != null ? postExtractionHookConfiguration.build() : null;
        }

        @Override
        @Transient
        public final Builder postExtractionHookConfiguration(HookConfiguration postExtractionHookConfiguration) {
            this.postExtractionHookConfiguration = postExtractionHookConfiguration;
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        @Transient
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public CustomDocumentEnrichmentConfiguration build() {
            return new CustomDocumentEnrichmentConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CustomDocumentEnrichmentConfiguration> {
        public Builder inlineConfigurations(Collection<InlineCustomDocumentEnrichmentConfiguration> var1);

        public Builder inlineConfigurations(InlineCustomDocumentEnrichmentConfiguration ... var1);

        public Builder inlineConfigurations(Consumer<InlineCustomDocumentEnrichmentConfiguration.Builder> ... var1);

        public Builder preExtractionHookConfiguration(HookConfiguration var1);

        default public Builder preExtractionHookConfiguration(Consumer<HookConfiguration.Builder> preExtractionHookConfiguration) {
            return this.preExtractionHookConfiguration((HookConfiguration)((HookConfiguration.Builder)HookConfiguration.builder().applyMutation(preExtractionHookConfiguration)).build());
        }

        public Builder postExtractionHookConfiguration(HookConfiguration var1);

        default public Builder postExtractionHookConfiguration(Consumer<HookConfiguration.Builder> postExtractionHookConfiguration) {
            return this.postExtractionHookConfiguration((HookConfiguration)((HookConfiguration.Builder)HookConfiguration.builder().applyMutation(postExtractionHookConfiguration)).build());
        }

        public Builder roleArn(String var1);
    }
}

