/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kendra.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.kendra.KendraClient;
import software.amazon.awssdk.services.kendra.model.GetSnapshotsRequest;
import software.amazon.awssdk.services.kendra.model.GetSnapshotsResponse;

public class GetSnapshotsIterable
implements SdkIterable<GetSnapshotsResponse> {
    private final KendraClient client;
    private final GetSnapshotsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetSnapshotsIterable(KendraClient client, GetSnapshotsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new GetSnapshotsResponseFetcher();
    }

    public Iterator<GetSnapshotsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class GetSnapshotsResponseFetcher
    implements SyncPageFetcher<GetSnapshotsResponse> {
        private GetSnapshotsResponseFetcher() {
        }

        public boolean hasNextPage(GetSnapshotsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public GetSnapshotsResponse nextPage(GetSnapshotsResponse previousPage) {
            if (previousPage == null) {
                return GetSnapshotsIterable.this.client.getSnapshots(GetSnapshotsIterable.this.firstRequest);
            }
            return GetSnapshotsIterable.this.client.getSnapshots((GetSnapshotsRequest)((Object)GetSnapshotsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

