/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kendra.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.kendra.KendraAsyncClient;
import software.amazon.awssdk.services.kendra.model.ListExperienceEntitiesRequest;
import software.amazon.awssdk.services.kendra.model.ListExperienceEntitiesResponse;

public class ListExperienceEntitiesPublisher
implements SdkPublisher<ListExperienceEntitiesResponse> {
    private final KendraAsyncClient client;
    private final ListExperienceEntitiesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListExperienceEntitiesPublisher(KendraAsyncClient client, ListExperienceEntitiesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListExperienceEntitiesPublisher(KendraAsyncClient client, ListExperienceEntitiesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListExperienceEntitiesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListExperienceEntitiesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListExperienceEntitiesResponseFetcher
    implements AsyncPageFetcher<ListExperienceEntitiesResponse> {
        private ListExperienceEntitiesResponseFetcher() {
        }

        public boolean hasNextPage(ListExperienceEntitiesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListExperienceEntitiesResponse> nextPage(ListExperienceEntitiesResponse previousPage) {
            if (previousPage == null) {
                return ListExperienceEntitiesPublisher.this.client.listExperienceEntities(ListExperienceEntitiesPublisher.this.firstRequest);
            }
            return ListExperienceEntitiesPublisher.this.client.listExperienceEntities((ListExperienceEntitiesRequest)((Object)ListExperienceEntitiesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

