/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kendra.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information that configures Amazon Kendra to use a SQL database.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SqlConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<SqlConfiguration.Builder, SqlConfiguration> {
    private static final SdkField<String> QUERY_IDENTIFIERS_ENCLOSING_OPTION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("QueryIdentifiersEnclosingOption")
            .getter(getter(SqlConfiguration::queryIdentifiersEnclosingOptionAsString))
            .setter(setter(Builder::queryIdentifiersEnclosingOption))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryIdentifiersEnclosingOption")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(QUERY_IDENTIFIERS_ENCLOSING_OPTION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String queryIdentifiersEnclosingOption;

    private SqlConfiguration(BuilderImpl builder) {
        this.queryIdentifiersEnclosingOption = builder.queryIdentifiersEnclosingOption;
    }

    /**
     * <p>
     * Determines whether Amazon Kendra encloses SQL identifiers for tables and column names in double quotes (") when
     * making a database query.
     * </p>
     * <p>
     * By default, Amazon Kendra passes SQL identifiers the way that they are entered into the data source
     * configuration. It does not change the case of identifiers or enclose them in quotes.
     * </p>
     * <p>
     * PostgreSQL internally converts uppercase characters to lower case characters in identifiers unless they are
     * quoted. Choosing this option encloses identifiers in quotes so that PostgreSQL does not convert the character's
     * case.
     * </p>
     * <p>
     * For MySQL databases, you must enable the <code>ansi_quotes</code> option when you set this field to
     * <code>DOUBLE_QUOTES</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #queryIdentifiersEnclosingOption} will return
     * {@link QueryIdentifiersEnclosingOption#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #queryIdentifiersEnclosingOptionAsString}.
     * </p>
     * 
     * @return Determines whether Amazon Kendra encloses SQL identifiers for tables and column names in double quotes
     *         (") when making a database query.</p>
     *         <p>
     *         By default, Amazon Kendra passes SQL identifiers the way that they are entered into the data source
     *         configuration. It does not change the case of identifiers or enclose them in quotes.
     *         </p>
     *         <p>
     *         PostgreSQL internally converts uppercase characters to lower case characters in identifiers unless they
     *         are quoted. Choosing this option encloses identifiers in quotes so that PostgreSQL does not convert the
     *         character's case.
     *         </p>
     *         <p>
     *         For MySQL databases, you must enable the <code>ansi_quotes</code> option when you set this field to
     *         <code>DOUBLE_QUOTES</code>.
     * @see QueryIdentifiersEnclosingOption
     */
    public final QueryIdentifiersEnclosingOption queryIdentifiersEnclosingOption() {
        return QueryIdentifiersEnclosingOption.fromValue(queryIdentifiersEnclosingOption);
    }

    /**
     * <p>
     * Determines whether Amazon Kendra encloses SQL identifiers for tables and column names in double quotes (") when
     * making a database query.
     * </p>
     * <p>
     * By default, Amazon Kendra passes SQL identifiers the way that they are entered into the data source
     * configuration. It does not change the case of identifiers or enclose them in quotes.
     * </p>
     * <p>
     * PostgreSQL internally converts uppercase characters to lower case characters in identifiers unless they are
     * quoted. Choosing this option encloses identifiers in quotes so that PostgreSQL does not convert the character's
     * case.
     * </p>
     * <p>
     * For MySQL databases, you must enable the <code>ansi_quotes</code> option when you set this field to
     * <code>DOUBLE_QUOTES</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #queryIdentifiersEnclosingOption} will return
     * {@link QueryIdentifiersEnclosingOption#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #queryIdentifiersEnclosingOptionAsString}.
     * </p>
     * 
     * @return Determines whether Amazon Kendra encloses SQL identifiers for tables and column names in double quotes
     *         (") when making a database query.</p>
     *         <p>
     *         By default, Amazon Kendra passes SQL identifiers the way that they are entered into the data source
     *         configuration. It does not change the case of identifiers or enclose them in quotes.
     *         </p>
     *         <p>
     *         PostgreSQL internally converts uppercase characters to lower case characters in identifiers unless they
     *         are quoted. Choosing this option encloses identifiers in quotes so that PostgreSQL does not convert the
     *         character's case.
     *         </p>
     *         <p>
     *         For MySQL databases, you must enable the <code>ansi_quotes</code> option when you set this field to
     *         <code>DOUBLE_QUOTES</code>.
     * @see QueryIdentifiersEnclosingOption
     */
    public final String queryIdentifiersEnclosingOptionAsString() {
        return queryIdentifiersEnclosingOption;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(queryIdentifiersEnclosingOptionAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SqlConfiguration)) {
            return false;
        }
        SqlConfiguration other = (SqlConfiguration) obj;
        return Objects.equals(queryIdentifiersEnclosingOptionAsString(), other.queryIdentifiersEnclosingOptionAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SqlConfiguration")
                .add("QueryIdentifiersEnclosingOption", queryIdentifiersEnclosingOptionAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "QueryIdentifiersEnclosingOption":
            return Optional.ofNullable(clazz.cast(queryIdentifiersEnclosingOptionAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SqlConfiguration, T> g) {
        return obj -> g.apply((SqlConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SqlConfiguration> {
        /**
         * <p>
         * Determines whether Amazon Kendra encloses SQL identifiers for tables and column names in double quotes (")
         * when making a database query.
         * </p>
         * <p>
         * By default, Amazon Kendra passes SQL identifiers the way that they are entered into the data source
         * configuration. It does not change the case of identifiers or enclose them in quotes.
         * </p>
         * <p>
         * PostgreSQL internally converts uppercase characters to lower case characters in identifiers unless they are
         * quoted. Choosing this option encloses identifiers in quotes so that PostgreSQL does not convert the
         * character's case.
         * </p>
         * <p>
         * For MySQL databases, you must enable the <code>ansi_quotes</code> option when you set this field to
         * <code>DOUBLE_QUOTES</code>.
         * </p>
         * 
         * @param queryIdentifiersEnclosingOption
         *        Determines whether Amazon Kendra encloses SQL identifiers for tables and column names in double quotes
         *        (") when making a database query.</p>
         *        <p>
         *        By default, Amazon Kendra passes SQL identifiers the way that they are entered into the data source
         *        configuration. It does not change the case of identifiers or enclose them in quotes.
         *        </p>
         *        <p>
         *        PostgreSQL internally converts uppercase characters to lower case characters in identifiers unless
         *        they are quoted. Choosing this option encloses identifiers in quotes so that PostgreSQL does not
         *        convert the character's case.
         *        </p>
         *        <p>
         *        For MySQL databases, you must enable the <code>ansi_quotes</code> option when you set this field to
         *        <code>DOUBLE_QUOTES</code>.
         * @see QueryIdentifiersEnclosingOption
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see QueryIdentifiersEnclosingOption
         */
        Builder queryIdentifiersEnclosingOption(String queryIdentifiersEnclosingOption);

        /**
         * <p>
         * Determines whether Amazon Kendra encloses SQL identifiers for tables and column names in double quotes (")
         * when making a database query.
         * </p>
         * <p>
         * By default, Amazon Kendra passes SQL identifiers the way that they are entered into the data source
         * configuration. It does not change the case of identifiers or enclose them in quotes.
         * </p>
         * <p>
         * PostgreSQL internally converts uppercase characters to lower case characters in identifiers unless they are
         * quoted. Choosing this option encloses identifiers in quotes so that PostgreSQL does not convert the
         * character's case.
         * </p>
         * <p>
         * For MySQL databases, you must enable the <code>ansi_quotes</code> option when you set this field to
         * <code>DOUBLE_QUOTES</code>.
         * </p>
         * 
         * @param queryIdentifiersEnclosingOption
         *        Determines whether Amazon Kendra encloses SQL identifiers for tables and column names in double quotes
         *        (") when making a database query.</p>
         *        <p>
         *        By default, Amazon Kendra passes SQL identifiers the way that they are entered into the data source
         *        configuration. It does not change the case of identifiers or enclose them in quotes.
         *        </p>
         *        <p>
         *        PostgreSQL internally converts uppercase characters to lower case characters in identifiers unless
         *        they are quoted. Choosing this option encloses identifiers in quotes so that PostgreSQL does not
         *        convert the character's case.
         *        </p>
         *        <p>
         *        For MySQL databases, you must enable the <code>ansi_quotes</code> option when you set this field to
         *        <code>DOUBLE_QUOTES</code>.
         * @see QueryIdentifiersEnclosingOption
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see QueryIdentifiersEnclosingOption
         */
        Builder queryIdentifiersEnclosingOption(QueryIdentifiersEnclosingOption queryIdentifiersEnclosingOption);
    }

    static final class BuilderImpl implements Builder {
        private String queryIdentifiersEnclosingOption;

        private BuilderImpl() {
        }

        private BuilderImpl(SqlConfiguration model) {
            queryIdentifiersEnclosingOption(model.queryIdentifiersEnclosingOption);
        }

        public final String getQueryIdentifiersEnclosingOption() {
            return queryIdentifiersEnclosingOption;
        }

        @Override
        public final Builder queryIdentifiersEnclosingOption(String queryIdentifiersEnclosingOption) {
            this.queryIdentifiersEnclosingOption = queryIdentifiersEnclosingOption;
            return this;
        }

        @Override
        public final Builder queryIdentifiersEnclosingOption(QueryIdentifiersEnclosingOption queryIdentifiersEnclosingOption) {
            this.queryIdentifiersEnclosingOption(queryIdentifiersEnclosingOption == null ? null : queryIdentifiersEnclosingOption
                    .toString());
            return this;
        }

        public final void setQueryIdentifiersEnclosingOption(String queryIdentifiersEnclosingOption) {
            this.queryIdentifiersEnclosingOption = queryIdentifiersEnclosingOption;
        }

        @Override
        public SqlConfiguration build() {
            return new SqlConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
