/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kendra.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An attribute returned with a document from a search.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AdditionalResultAttributeValue implements SdkPojo, Serializable,
        ToCopyableBuilder<AdditionalResultAttributeValue.Builder, AdditionalResultAttributeValue> {
    private static final SdkField<TextWithHighlights> TEXT_WITH_HIGHLIGHTS_VALUE_FIELD = SdkField
            .<TextWithHighlights> builder(MarshallingType.SDK_POJO).memberName("TextWithHighlightsValue")
            .getter(getter(AdditionalResultAttributeValue::textWithHighlightsValue))
            .setter(setter(Builder::textWithHighlightsValue)).constructor(TextWithHighlights::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TextWithHighlightsValue").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(TEXT_WITH_HIGHLIGHTS_VALUE_FIELD));

    private static final long serialVersionUID = 1L;

    private final TextWithHighlights textWithHighlightsValue;

    private AdditionalResultAttributeValue(BuilderImpl builder) {
        this.textWithHighlightsValue = builder.textWithHighlightsValue;
    }

    /**
     * <p>
     * The text associated with the attribute and information about the highlight to apply to the text.
     * </p>
     * 
     * @return The text associated with the attribute and information about the highlight to apply to the text.
     */
    public final TextWithHighlights textWithHighlightsValue() {
        return textWithHighlightsValue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(textWithHighlightsValue());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AdditionalResultAttributeValue)) {
            return false;
        }
        AdditionalResultAttributeValue other = (AdditionalResultAttributeValue) obj;
        return Objects.equals(textWithHighlightsValue(), other.textWithHighlightsValue());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AdditionalResultAttributeValue").add("TextWithHighlightsValue", textWithHighlightsValue())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TextWithHighlightsValue":
            return Optional.ofNullable(clazz.cast(textWithHighlightsValue()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AdditionalResultAttributeValue, T> g) {
        return obj -> g.apply((AdditionalResultAttributeValue) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AdditionalResultAttributeValue> {
        /**
         * <p>
         * The text associated with the attribute and information about the highlight to apply to the text.
         * </p>
         * 
         * @param textWithHighlightsValue
         *        The text associated with the attribute and information about the highlight to apply to the text.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder textWithHighlightsValue(TextWithHighlights textWithHighlightsValue);

        /**
         * <p>
         * The text associated with the attribute and information about the highlight to apply to the text.
         * </p>
         * This is a convenience that creates an instance of the {@link TextWithHighlights.Builder} avoiding the need to
         * create one manually via {@link TextWithHighlights#builder()}.
         *
         * When the {@link Consumer} completes, {@link TextWithHighlights.Builder#build()} is called immediately and its
         * result is passed to {@link #textWithHighlightsValue(TextWithHighlights)}.
         * 
         * @param textWithHighlightsValue
         *        a consumer that will call methods on {@link TextWithHighlights.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #textWithHighlightsValue(TextWithHighlights)
         */
        default Builder textWithHighlightsValue(Consumer<TextWithHighlights.Builder> textWithHighlightsValue) {
            return textWithHighlightsValue(TextWithHighlights.builder().applyMutation(textWithHighlightsValue).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private TextWithHighlights textWithHighlightsValue;

        private BuilderImpl() {
        }

        private BuilderImpl(AdditionalResultAttributeValue model) {
            textWithHighlightsValue(model.textWithHighlightsValue);
        }

        public final TextWithHighlights.Builder getTextWithHighlightsValue() {
            return textWithHighlightsValue != null ? textWithHighlightsValue.toBuilder() : null;
        }

        @Override
        public final Builder textWithHighlightsValue(TextWithHighlights textWithHighlightsValue) {
            this.textWithHighlightsValue = textWithHighlightsValue;
            return this;
        }

        public final void setTextWithHighlightsValue(TextWithHighlights.BuilderImpl textWithHighlightsValue) {
            this.textWithHighlightsValue = textWithHighlightsValue != null ? textWithHighlightsValue.build() : null;
        }

        @Override
        public AdditionalResultAttributeValue build() {
            return new AdditionalResultAttributeValue(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
