/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kendra.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DataSourceSyncJobMetrics
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DataSourceSyncJobMetrics> {
    private static final SdkField<String> DOCUMENTS_ADDED_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DocumentsAdded").getter(DataSourceSyncJobMetrics.getter(DataSourceSyncJobMetrics::documentsAdded)).setter(DataSourceSyncJobMetrics.setter(Builder::documentsAdded)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentsAdded").build()}).build();
    private static final SdkField<String> DOCUMENTS_MODIFIED_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DocumentsModified").getter(DataSourceSyncJobMetrics.getter(DataSourceSyncJobMetrics::documentsModified)).setter(DataSourceSyncJobMetrics.setter(Builder::documentsModified)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentsModified").build()}).build();
    private static final SdkField<String> DOCUMENTS_DELETED_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DocumentsDeleted").getter(DataSourceSyncJobMetrics.getter(DataSourceSyncJobMetrics::documentsDeleted)).setter(DataSourceSyncJobMetrics.setter(Builder::documentsDeleted)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentsDeleted").build()}).build();
    private static final SdkField<String> DOCUMENTS_FAILED_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DocumentsFailed").getter(DataSourceSyncJobMetrics.getter(DataSourceSyncJobMetrics::documentsFailed)).setter(DataSourceSyncJobMetrics.setter(Builder::documentsFailed)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentsFailed").build()}).build();
    private static final SdkField<String> DOCUMENTS_SCANNED_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DocumentsScanned").getter(DataSourceSyncJobMetrics.getter(DataSourceSyncJobMetrics::documentsScanned)).setter(DataSourceSyncJobMetrics.setter(Builder::documentsScanned)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentsScanned").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOCUMENTS_ADDED_FIELD, DOCUMENTS_MODIFIED_FIELD, DOCUMENTS_DELETED_FIELD, DOCUMENTS_FAILED_FIELD, DOCUMENTS_SCANNED_FIELD));
    private static final long serialVersionUID = 1L;
    private final String documentsAdded;
    private final String documentsModified;
    private final String documentsDeleted;
    private final String documentsFailed;
    private final String documentsScanned;

    private DataSourceSyncJobMetrics(BuilderImpl builder) {
        this.documentsAdded = builder.documentsAdded;
        this.documentsModified = builder.documentsModified;
        this.documentsDeleted = builder.documentsDeleted;
        this.documentsFailed = builder.documentsFailed;
        this.documentsScanned = builder.documentsScanned;
    }

    public String documentsAdded() {
        return this.documentsAdded;
    }

    public String documentsModified() {
        return this.documentsModified;
    }

    public String documentsDeleted() {
        return this.documentsDeleted;
    }

    public String documentsFailed() {
        return this.documentsFailed;
    }

    public String documentsScanned() {
        return this.documentsScanned;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.documentsAdded());
        hashCode = 31 * hashCode + Objects.hashCode(this.documentsModified());
        hashCode = 31 * hashCode + Objects.hashCode(this.documentsDeleted());
        hashCode = 31 * hashCode + Objects.hashCode(this.documentsFailed());
        hashCode = 31 * hashCode + Objects.hashCode(this.documentsScanned());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataSourceSyncJobMetrics)) {
            return false;
        }
        DataSourceSyncJobMetrics other = (DataSourceSyncJobMetrics)obj;
        return Objects.equals(this.documentsAdded(), other.documentsAdded()) && Objects.equals(this.documentsModified(), other.documentsModified()) && Objects.equals(this.documentsDeleted(), other.documentsDeleted()) && Objects.equals(this.documentsFailed(), other.documentsFailed()) && Objects.equals(this.documentsScanned(), other.documentsScanned());
    }

    public String toString() {
        return ToString.builder((String)"DataSourceSyncJobMetrics").add("DocumentsAdded", (Object)this.documentsAdded()).add("DocumentsModified", (Object)this.documentsModified()).add("DocumentsDeleted", (Object)this.documentsDeleted()).add("DocumentsFailed", (Object)this.documentsFailed()).add("DocumentsScanned", (Object)this.documentsScanned()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DocumentsAdded": {
                return Optional.ofNullable(clazz.cast(this.documentsAdded()));
            }
            case "DocumentsModified": {
                return Optional.ofNullable(clazz.cast(this.documentsModified()));
            }
            case "DocumentsDeleted": {
                return Optional.ofNullable(clazz.cast(this.documentsDeleted()));
            }
            case "DocumentsFailed": {
                return Optional.ofNullable(clazz.cast(this.documentsFailed()));
            }
            case "DocumentsScanned": {
                return Optional.ofNullable(clazz.cast(this.documentsScanned()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DataSourceSyncJobMetrics, T> g) {
        return obj -> g.apply((DataSourceSyncJobMetrics)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String documentsAdded;
        private String documentsModified;
        private String documentsDeleted;
        private String documentsFailed;
        private String documentsScanned;

        private BuilderImpl() {
        }

        private BuilderImpl(DataSourceSyncJobMetrics model) {
            this.documentsAdded(model.documentsAdded);
            this.documentsModified(model.documentsModified);
            this.documentsDeleted(model.documentsDeleted);
            this.documentsFailed(model.documentsFailed);
            this.documentsScanned(model.documentsScanned);
        }

        public final String getDocumentsAdded() {
            return this.documentsAdded;
        }

        @Override
        public final Builder documentsAdded(String documentsAdded) {
            this.documentsAdded = documentsAdded;
            return this;
        }

        public final void setDocumentsAdded(String documentsAdded) {
            this.documentsAdded = documentsAdded;
        }

        public final String getDocumentsModified() {
            return this.documentsModified;
        }

        @Override
        public final Builder documentsModified(String documentsModified) {
            this.documentsModified = documentsModified;
            return this;
        }

        public final void setDocumentsModified(String documentsModified) {
            this.documentsModified = documentsModified;
        }

        public final String getDocumentsDeleted() {
            return this.documentsDeleted;
        }

        @Override
        public final Builder documentsDeleted(String documentsDeleted) {
            this.documentsDeleted = documentsDeleted;
            return this;
        }

        public final void setDocumentsDeleted(String documentsDeleted) {
            this.documentsDeleted = documentsDeleted;
        }

        public final String getDocumentsFailed() {
            return this.documentsFailed;
        }

        @Override
        public final Builder documentsFailed(String documentsFailed) {
            this.documentsFailed = documentsFailed;
            return this;
        }

        public final void setDocumentsFailed(String documentsFailed) {
            this.documentsFailed = documentsFailed;
        }

        public final String getDocumentsScanned() {
            return this.documentsScanned;
        }

        @Override
        public final Builder documentsScanned(String documentsScanned) {
            this.documentsScanned = documentsScanned;
            return this;
        }

        public final void setDocumentsScanned(String documentsScanned) {
            this.documentsScanned = documentsScanned;
        }

        public DataSourceSyncJobMetrics build() {
            return new DataSourceSyncJobMetrics(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DataSourceSyncJobMetrics> {
        public Builder documentsAdded(String var1);

        public Builder documentsModified(String var1);

        public Builder documentsDeleted(String var1);

        public Builder documentsFailed(String var1);

        public Builder documentsScanned(String var1);
    }
}

