/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kendra.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information about how a custom index field is used during a search.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Search implements SdkPojo, Serializable, ToCopyableBuilder<Search.Builder, Search> {
    private static final SdkField<Boolean> FACETABLE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(Search::facetable)).setter(setter(Builder::facetable))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Facetable").build()).build();

    private static final SdkField<Boolean> SEARCHABLE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(Search::searchable)).setter(setter(Builder::searchable))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Searchable").build()).build();

    private static final SdkField<Boolean> DISPLAYABLE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(Search::displayable)).setter(setter(Builder::displayable))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Displayable").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FACETABLE_FIELD,
            SEARCHABLE_FIELD, DISPLAYABLE_FIELD));

    private static final long serialVersionUID = 1L;

    private final Boolean facetable;

    private final Boolean searchable;

    private final Boolean displayable;

    private Search(BuilderImpl builder) {
        this.facetable = builder.facetable;
        this.searchable = builder.searchable;
        this.displayable = builder.displayable;
    }

    /**
     * <p>
     * Indicates that the field can be used to create search facets, a count of results for each value in the field. The
     * default is <code>false</code> .
     * </p>
     * 
     * @return Indicates that the field can be used to create search facets, a count of results for each value in the
     *         field. The default is <code>false</code> .
     */
    public Boolean facetable() {
        return facetable;
    }

    /**
     * <p>
     * Determines whether the field is used in the search. If the <code>Searchable</code> field is <code>true</code>,
     * you can use relevance tuning to manually tune how Amazon Kendra weights the field in the search. The default is
     * <code>true</code> for string fields and <code>false</code> for number and date fields.
     * </p>
     * 
     * @return Determines whether the field is used in the search. If the <code>Searchable</code> field is
     *         <code>true</code>, you can use relevance tuning to manually tune how Amazon Kendra weights the field in
     *         the search. The default is <code>true</code> for string fields and <code>false</code> for number and date
     *         fields.
     */
    public Boolean searchable() {
        return searchable;
    }

    /**
     * <p>
     * Determines whether the field is returned in the query response. The default is <code>true</code>.
     * </p>
     * 
     * @return Determines whether the field is returned in the query response. The default is <code>true</code>.
     */
    public Boolean displayable() {
        return displayable;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(facetable());
        hashCode = 31 * hashCode + Objects.hashCode(searchable());
        hashCode = 31 * hashCode + Objects.hashCode(displayable());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Search)) {
            return false;
        }
        Search other = (Search) obj;
        return Objects.equals(facetable(), other.facetable()) && Objects.equals(searchable(), other.searchable())
                && Objects.equals(displayable(), other.displayable());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("Search").add("Facetable", facetable()).add("Searchable", searchable())
                .add("Displayable", displayable()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Facetable":
            return Optional.ofNullable(clazz.cast(facetable()));
        case "Searchable":
            return Optional.ofNullable(clazz.cast(searchable()));
        case "Displayable":
            return Optional.ofNullable(clazz.cast(displayable()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Search, T> g) {
        return obj -> g.apply((Search) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Search> {
        /**
         * <p>
         * Indicates that the field can be used to create search facets, a count of results for each value in the field.
         * The default is <code>false</code> .
         * </p>
         * 
         * @param facetable
         *        Indicates that the field can be used to create search facets, a count of results for each value in the
         *        field. The default is <code>false</code> .
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder facetable(Boolean facetable);

        /**
         * <p>
         * Determines whether the field is used in the search. If the <code>Searchable</code> field is <code>true</code>
         * , you can use relevance tuning to manually tune how Amazon Kendra weights the field in the search. The
         * default is <code>true</code> for string fields and <code>false</code> for number and date fields.
         * </p>
         * 
         * @param searchable
         *        Determines whether the field is used in the search. If the <code>Searchable</code> field is
         *        <code>true</code>, you can use relevance tuning to manually tune how Amazon Kendra weights the field
         *        in the search. The default is <code>true</code> for string fields and <code>false</code> for number
         *        and date fields.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder searchable(Boolean searchable);

        /**
         * <p>
         * Determines whether the field is returned in the query response. The default is <code>true</code>.
         * </p>
         * 
         * @param displayable
         *        Determines whether the field is returned in the query response. The default is <code>true</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayable(Boolean displayable);
    }

    static final class BuilderImpl implements Builder {
        private Boolean facetable;

        private Boolean searchable;

        private Boolean displayable;

        private BuilderImpl() {
        }

        private BuilderImpl(Search model) {
            facetable(model.facetable);
            searchable(model.searchable);
            displayable(model.displayable);
        }

        public final Boolean getFacetable() {
            return facetable;
        }

        @Override
        public final Builder facetable(Boolean facetable) {
            this.facetable = facetable;
            return this;
        }

        public final void setFacetable(Boolean facetable) {
            this.facetable = facetable;
        }

        public final Boolean getSearchable() {
            return searchable;
        }

        @Override
        public final Builder searchable(Boolean searchable) {
            this.searchable = searchable;
            return this;
        }

        public final void setSearchable(Boolean searchable) {
            this.searchable = searchable;
        }

        public final Boolean getDisplayable() {
            return displayable;
        }

        @Override
        public final Builder displayable(Boolean displayable) {
            this.displayable = displayable;
            return this;
        }

        public final void setDisplayable(Boolean displayable) {
            this.displayable = displayable;
        }

        @Override
        public Search build() {
            return new Search(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
