/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kendra.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.kendra.model.DocumentIdListCopier;
import software.amazon.awssdk.services.kendra.model.KendraRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchDeleteDocumentRequest
extends KendraRequest
implements ToCopyableBuilder<Builder, BatchDeleteDocumentRequest> {
    private static final SdkField<String> INDEX_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(BatchDeleteDocumentRequest.getter(BatchDeleteDocumentRequest::indexId)).setter(BatchDeleteDocumentRequest.setter(Builder::indexId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IndexId").build()}).build();
    private static final SdkField<List<String>> DOCUMENT_ID_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(BatchDeleteDocumentRequest.getter(BatchDeleteDocumentRequest::documentIdList)).setter(BatchDeleteDocumentRequest.setter(Builder::documentIdList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentIdList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INDEX_ID_FIELD, DOCUMENT_ID_LIST_FIELD));
    private final String indexId;
    private final List<String> documentIdList;

    private BatchDeleteDocumentRequest(BuilderImpl builder) {
        super(builder);
        this.indexId = builder.indexId;
        this.documentIdList = builder.documentIdList;
    }

    public String indexId() {
        return this.indexId;
    }

    public boolean hasDocumentIdList() {
        return this.documentIdList != null && !(this.documentIdList instanceof SdkAutoConstructList);
    }

    public List<String> documentIdList() {
        return this.documentIdList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.indexId());
        hashCode = 31 * hashCode + Objects.hashCode(this.documentIdList());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchDeleteDocumentRequest)) {
            return false;
        }
        BatchDeleteDocumentRequest other = (BatchDeleteDocumentRequest)((Object)obj);
        return Objects.equals(this.indexId(), other.indexId()) && Objects.equals(this.documentIdList(), other.documentIdList());
    }

    public String toString() {
        return ToString.builder((String)"BatchDeleteDocumentRequest").add("IndexId", (Object)this.indexId()).add("DocumentIdList", this.documentIdList()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IndexId": {
                return Optional.ofNullable(clazz.cast(this.indexId()));
            }
            case "DocumentIdList": {
                return Optional.ofNullable(clazz.cast(this.documentIdList()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchDeleteDocumentRequest, T> g) {
        return obj -> g.apply((BatchDeleteDocumentRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends KendraRequest.BuilderImpl
    implements Builder {
        private String indexId;
        private List<String> documentIdList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchDeleteDocumentRequest model) {
            super(model);
            this.indexId(model.indexId);
            this.documentIdList(model.documentIdList);
        }

        public final String getIndexId() {
            return this.indexId;
        }

        @Override
        public final Builder indexId(String indexId) {
            this.indexId = indexId;
            return this;
        }

        public final void setIndexId(String indexId) {
            this.indexId = indexId;
        }

        public final Collection<String> getDocumentIdList() {
            return this.documentIdList;
        }

        @Override
        public final Builder documentIdList(Collection<String> documentIdList) {
            this.documentIdList = DocumentIdListCopier.copy(documentIdList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder documentIdList(String ... documentIdList) {
            this.documentIdList(Arrays.asList(documentIdList));
            return this;
        }

        public final void setDocumentIdList(Collection<String> documentIdList) {
            this.documentIdList = DocumentIdListCopier.copy(documentIdList);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchDeleteDocumentRequest build() {
            return new BatchDeleteDocumentRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends KendraRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchDeleteDocumentRequest> {
        public Builder indexId(String var1);

        public Builder documentIdList(Collection<String> var1);

        public Builder documentIdList(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

