/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kendra.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A summary of information about an index.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IndexConfigurationSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<IndexConfigurationSummary.Builder, IndexConfigurationSummary> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(IndexConfigurationSummary::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(IndexConfigurationSummary::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(IndexConfigurationSummary::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()).build();

    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(IndexConfigurationSummary::updatedAt)).setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdatedAt").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(IndexConfigurationSummary::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, ID_FIELD,
            CREATED_AT_FIELD, UPDATED_AT_FIELD, STATUS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String id;

    private final Instant createdAt;

    private final Instant updatedAt;

    private final String status;

    private IndexConfigurationSummary(BuilderImpl builder) {
        this.name = builder.name;
        this.id = builder.id;
        this.createdAt = builder.createdAt;
        this.updatedAt = builder.updatedAt;
        this.status = builder.status;
    }

    /**
     * <p>
     * The name of the index.
     * </p>
     * 
     * @return The name of the index.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * A unique identifier for the index. Use this to identify the index when you are using operations such as
     * <code>Query</code>, <code>DescribeIndex</code>, <code>UpdateIndex</code>, and <code>DeleteIndex</code>.
     * </p>
     * 
     * @return A unique identifier for the index. Use this to identify the index when you are using operations such as
     *         <code>Query</code>, <code>DescribeIndex</code>, <code>UpdateIndex</code>, and <code>DeleteIndex</code>.
     */
    public String id() {
        return id;
    }

    /**
     * <p>
     * The Unix timestamp when the index was created.
     * </p>
     * 
     * @return The Unix timestamp when the index was created.
     */
    public Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The Unix timestamp when the index was last updated by the <code>UpdateIndex</code> operation.
     * </p>
     * 
     * @return The Unix timestamp when the index was last updated by the <code>UpdateIndex</code> operation.
     */
    public Instant updatedAt() {
        return updatedAt;
    }

    /**
     * <p>
     * The current status of the index. When the status is <code>ACTIVE</code>, the index is ready to search.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link IndexStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the index. When the status is <code>ACTIVE</code>, the index is ready to search.
     * @see IndexStatus
     */
    public IndexStatus status() {
        return IndexStatus.fromValue(status);
    }

    /**
     * <p>
     * The current status of the index. When the status is <code>ACTIVE</code>, the index is ready to search.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link IndexStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the index. When the status is <code>ACTIVE</code>, the index is ready to search.
     * @see IndexStatus
     */
    public String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IndexConfigurationSummary)) {
            return false;
        }
        IndexConfigurationSummary other = (IndexConfigurationSummary) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(id(), other.id())
                && Objects.equals(createdAt(), other.createdAt()) && Objects.equals(updatedAt(), other.updatedAt())
                && Objects.equals(statusAsString(), other.statusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("IndexConfigurationSummary").add("Name", name()).add("Id", id()).add("CreatedAt", createdAt())
                .add("UpdatedAt", updatedAt()).add("Status", statusAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "CreatedAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "UpdatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<IndexConfigurationSummary, T> g) {
        return obj -> g.apply((IndexConfigurationSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IndexConfigurationSummary> {
        /**
         * <p>
         * The name of the index.
         * </p>
         * 
         * @param name
         *        The name of the index.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A unique identifier for the index. Use this to identify the index when you are using operations such as
         * <code>Query</code>, <code>DescribeIndex</code>, <code>UpdateIndex</code>, and <code>DeleteIndex</code>.
         * </p>
         * 
         * @param id
         *        A unique identifier for the index. Use this to identify the index when you are using operations such
         *        as <code>Query</code>, <code>DescribeIndex</code>, <code>UpdateIndex</code>, and
         *        <code>DeleteIndex</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The Unix timestamp when the index was created.
         * </p>
         * 
         * @param createdAt
         *        The Unix timestamp when the index was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The Unix timestamp when the index was last updated by the <code>UpdateIndex</code> operation.
         * </p>
         * 
         * @param updatedAt
         *        The Unix timestamp when the index was last updated by the <code>UpdateIndex</code> operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(Instant updatedAt);

        /**
         * <p>
         * The current status of the index. When the status is <code>ACTIVE</code>, the index is ready to search.
         * </p>
         * 
         * @param status
         *        The current status of the index. When the status is <code>ACTIVE</code>, the index is ready to search.
         * @see IndexStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IndexStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current status of the index. When the status is <code>ACTIVE</code>, the index is ready to search.
         * </p>
         * 
         * @param status
         *        The current status of the index. When the status is <code>ACTIVE</code>, the index is ready to search.
         * @see IndexStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IndexStatus
         */
        Builder status(IndexStatus status);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String id;

        private Instant createdAt;

        private Instant updatedAt;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(IndexConfigurationSummary model) {
            name(model.name);
            id(model.id);
            createdAt(model.createdAt);
            updatedAt(model.updatedAt);
            status(model.status);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        public final Instant getUpdatedAt() {
            return updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        public final String getStatusAsString() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(IndexStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public IndexConfigurationSummary build() {
            return new IndexConfigurationSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
