/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kendra.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information about a frequently asked questions and answer contained in an index.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FaqSummary implements SdkPojo, Serializable, ToCopyableBuilder<FaqSummary.Builder, FaqSummary> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(FaqSummary::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(FaqSummary::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(FaqSummary::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(FaqSummary::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()).build();

    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(FaqSummary::updatedAt)).setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdatedAt").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, NAME_FIELD,
            STATUS_FIELD, CREATED_AT_FIELD, UPDATED_AT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String name;

    private final String status;

    private final Instant createdAt;

    private final Instant updatedAt;

    private FaqSummary(BuilderImpl builder) {
        this.id = builder.id;
        this.name = builder.name;
        this.status = builder.status;
        this.createdAt = builder.createdAt;
        this.updatedAt = builder.updatedAt;
    }

    /**
     * <p>
     * The unique identifier of the FAQ.
     * </p>
     * 
     * @return The unique identifier of the FAQ.
     */
    public String id() {
        return id;
    }

    /**
     * <p>
     * The name that you assigned the FAQ when you created or updated the FAQ.
     * </p>
     * 
     * @return The name that you assigned the FAQ when you created or updated the FAQ.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The current status of the FAQ. When the status is <code>ACTIVE</code> the FAQ is ready for use.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link FaqStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the FAQ. When the status is <code>ACTIVE</code> the FAQ is ready for use.
     * @see FaqStatus
     */
    public FaqStatus status() {
        return FaqStatus.fromValue(status);
    }

    /**
     * <p>
     * The current status of the FAQ. When the status is <code>ACTIVE</code> the FAQ is ready for use.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link FaqStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the FAQ. When the status is <code>ACTIVE</code> the FAQ is ready for use.
     * @see FaqStatus
     */
    public String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The UNIX datetime that the FAQ was added to the index.
     * </p>
     * 
     * @return The UNIX datetime that the FAQ was added to the index.
     */
    public Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The UNIX datetime that the FAQ was last updated.
     * </p>
     * 
     * @return The UNIX datetime that the FAQ was last updated.
     */
    public Instant updatedAt() {
        return updatedAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FaqSummary)) {
            return false;
        }
        FaqSummary other = (FaqSummary) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(name(), other.name())
                && Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(updatedAt(), other.updatedAt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("FaqSummary").add("Id", id()).add("Name", name()).add("Status", statusAsString())
                .add("CreatedAt", createdAt()).add("UpdatedAt", updatedAt()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "CreatedAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "UpdatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FaqSummary, T> g) {
        return obj -> g.apply((FaqSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FaqSummary> {
        /**
         * <p>
         * The unique identifier of the FAQ.
         * </p>
         * 
         * @param id
         *        The unique identifier of the FAQ.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The name that you assigned the FAQ when you created or updated the FAQ.
         * </p>
         * 
         * @param name
         *        The name that you assigned the FAQ when you created or updated the FAQ.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The current status of the FAQ. When the status is <code>ACTIVE</code> the FAQ is ready for use.
         * </p>
         * 
         * @param status
         *        The current status of the FAQ. When the status is <code>ACTIVE</code> the FAQ is ready for use.
         * @see FaqStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FaqStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current status of the FAQ. When the status is <code>ACTIVE</code> the FAQ is ready for use.
         * </p>
         * 
         * @param status
         *        The current status of the FAQ. When the status is <code>ACTIVE</code> the FAQ is ready for use.
         * @see FaqStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FaqStatus
         */
        Builder status(FaqStatus status);

        /**
         * <p>
         * The UNIX datetime that the FAQ was added to the index.
         * </p>
         * 
         * @param createdAt
         *        The UNIX datetime that the FAQ was added to the index.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The UNIX datetime that the FAQ was last updated.
         * </p>
         * 
         * @param updatedAt
         *        The UNIX datetime that the FAQ was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(Instant updatedAt);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String name;

        private String status;

        private Instant createdAt;

        private Instant updatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(FaqSummary model) {
            id(model.id);
            name(model.name);
            status(model.status);
            createdAt(model.createdAt);
            updatedAt(model.updatedAt);
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getStatusAsString() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(FaqStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        public final Instant getUpdatedAt() {
            return updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public FaqSummary build() {
            return new FaqSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
