/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kendra.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.kendra.model.IndexConfigurationSummary;
import software.amazon.awssdk.services.kendra.model.IndexConfigurationSummaryListCopier;
import software.amazon.awssdk.services.kendra.model.KendraResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListIndicesResponse
extends KendraResponse
implements ToCopyableBuilder<Builder, ListIndicesResponse> {
    private static final SdkField<List<IndexConfigurationSummary>> INDEX_CONFIGURATION_SUMMARY_ITEMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ListIndicesResponse.getter(ListIndicesResponse::indexConfigurationSummaryItems)).setter(ListIndicesResponse.setter(Builder::indexConfigurationSummaryItems)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IndexConfigurationSummaryItems").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(IndexConfigurationSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListIndicesResponse.getter(ListIndicesResponse::nextToken)).setter(ListIndicesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INDEX_CONFIGURATION_SUMMARY_ITEMS_FIELD, NEXT_TOKEN_FIELD));
    private final List<IndexConfigurationSummary> indexConfigurationSummaryItems;
    private final String nextToken;

    private ListIndicesResponse(BuilderImpl builder) {
        super(builder);
        this.indexConfigurationSummaryItems = builder.indexConfigurationSummaryItems;
        this.nextToken = builder.nextToken;
    }

    public List<IndexConfigurationSummary> indexConfigurationSummaryItems() {
        return this.indexConfigurationSummaryItems;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.indexConfigurationSummaryItems());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListIndicesResponse)) {
            return false;
        }
        ListIndicesResponse other = (ListIndicesResponse)((Object)obj);
        return Objects.equals(this.indexConfigurationSummaryItems(), other.indexConfigurationSummaryItems()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListIndicesResponse").add("IndexConfigurationSummaryItems", this.indexConfigurationSummaryItems()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IndexConfigurationSummaryItems": {
                return Optional.ofNullable(clazz.cast(this.indexConfigurationSummaryItems()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListIndicesResponse, T> g) {
        return obj -> g.apply((ListIndicesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends KendraResponse.BuilderImpl
    implements Builder {
        private List<IndexConfigurationSummary> indexConfigurationSummaryItems = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListIndicesResponse model) {
            super(model);
            this.indexConfigurationSummaryItems(model.indexConfigurationSummaryItems);
            this.nextToken(model.nextToken);
        }

        public final Collection<IndexConfigurationSummary.Builder> getIndexConfigurationSummaryItems() {
            return this.indexConfigurationSummaryItems != null ? (Collection)this.indexConfigurationSummaryItems.stream().map(IndexConfigurationSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder indexConfigurationSummaryItems(Collection<IndexConfigurationSummary> indexConfigurationSummaryItems) {
            this.indexConfigurationSummaryItems = IndexConfigurationSummaryListCopier.copy(indexConfigurationSummaryItems);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder indexConfigurationSummaryItems(IndexConfigurationSummary ... indexConfigurationSummaryItems) {
            this.indexConfigurationSummaryItems(Arrays.asList(indexConfigurationSummaryItems));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder indexConfigurationSummaryItems(Consumer<IndexConfigurationSummary.Builder> ... indexConfigurationSummaryItems) {
            this.indexConfigurationSummaryItems(Stream.of(indexConfigurationSummaryItems).map(c -> (IndexConfigurationSummary)((IndexConfigurationSummary.Builder)IndexConfigurationSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setIndexConfigurationSummaryItems(Collection<IndexConfigurationSummary.BuilderImpl> indexConfigurationSummaryItems) {
            this.indexConfigurationSummaryItems = IndexConfigurationSummaryListCopier.copyFromBuilder(indexConfigurationSummaryItems);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListIndicesResponse build() {
            return new ListIndicesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends KendraResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListIndicesResponse> {
        public Builder indexConfigurationSummaryItems(Collection<IndexConfigurationSummary> var1);

        public Builder indexConfigurationSummaryItems(IndexConfigurationSummary ... var1);

        public Builder indexConfigurationSummaryItems(Consumer<IndexConfigurationSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

