/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kafkaconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FirehoseLogDeliveryDescription
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FirehoseLogDeliveryDescription> {
    private static final SdkField<String> DELIVERY_STREAM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("deliveryStream").getter(FirehoseLogDeliveryDescription.getter(FirehoseLogDeliveryDescription::deliveryStream)).setter(FirehoseLogDeliveryDescription.setter(Builder::deliveryStream)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deliveryStream").build()}).build();
    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("enabled").getter(FirehoseLogDeliveryDescription.getter(FirehoseLogDeliveryDescription::enabled)).setter(FirehoseLogDeliveryDescription.setter(Builder::enabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enabled").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DELIVERY_STREAM_FIELD, ENABLED_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = FirehoseLogDeliveryDescription.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String deliveryStream;
    private final Boolean enabled;

    private FirehoseLogDeliveryDescription(BuilderImpl builder) {
        this.deliveryStream = builder.deliveryStream;
        this.enabled = builder.enabled;
    }

    public final String deliveryStream() {
        return this.deliveryStream;
    }

    public final Boolean enabled() {
        return this.enabled;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.deliveryStream());
        hashCode = 31 * hashCode + Objects.hashCode(this.enabled());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FirehoseLogDeliveryDescription)) {
            return false;
        }
        FirehoseLogDeliveryDescription other = (FirehoseLogDeliveryDescription)obj;
        return Objects.equals(this.deliveryStream(), other.deliveryStream()) && Objects.equals(this.enabled(), other.enabled());
    }

    public final String toString() {
        return ToString.builder((String)"FirehoseLogDeliveryDescription").add("DeliveryStream", (Object)this.deliveryStream()).add("Enabled", (Object)this.enabled()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "deliveryStream": {
                return Optional.ofNullable(clazz.cast(this.deliveryStream()));
            }
            case "enabled": {
                return Optional.ofNullable(clazz.cast(this.enabled()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("deliveryStream", DELIVERY_STREAM_FIELD);
        map.put("enabled", ENABLED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FirehoseLogDeliveryDescription, T> g) {
        return obj -> g.apply((FirehoseLogDeliveryDescription)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String deliveryStream;
        private Boolean enabled;

        private BuilderImpl() {
        }

        private BuilderImpl(FirehoseLogDeliveryDescription model) {
            this.deliveryStream(model.deliveryStream);
            this.enabled(model.enabled);
        }

        public final String getDeliveryStream() {
            return this.deliveryStream;
        }

        public final void setDeliveryStream(String deliveryStream) {
            this.deliveryStream = deliveryStream;
        }

        @Override
        public final Builder deliveryStream(String deliveryStream) {
            this.deliveryStream = deliveryStream;
            return this;
        }

        public final Boolean getEnabled() {
            return this.enabled;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public FirehoseLogDeliveryDescription build() {
            return new FirehoseLogDeliveryDescription(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FirehoseLogDeliveryDescription> {
        public Builder deliveryStream(String var1);

        public Builder enabled(Boolean var1);
    }
}

