/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kafkaconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.kafkaconnect.model.ScaleInPolicy;
import software.amazon.awssdk.services.kafkaconnect.model.ScaleOutPolicy;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AutoScaling
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AutoScaling> {
    private static final SdkField<Integer> MAX_WORKER_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxWorkerCount").getter(AutoScaling.getter(AutoScaling::maxWorkerCount)).setter(AutoScaling.setter(Builder::maxWorkerCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxWorkerCount").build()}).build();
    private static final SdkField<Integer> MCU_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("mcuCount").getter(AutoScaling.getter(AutoScaling::mcuCount)).setter(AutoScaling.setter(Builder::mcuCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mcuCount").build()}).build();
    private static final SdkField<Integer> MIN_WORKER_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("minWorkerCount").getter(AutoScaling.getter(AutoScaling::minWorkerCount)).setter(AutoScaling.setter(Builder::minWorkerCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("minWorkerCount").build()}).build();
    private static final SdkField<ScaleInPolicy> SCALE_IN_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("scaleInPolicy").getter(AutoScaling.getter(AutoScaling::scaleInPolicy)).setter(AutoScaling.setter(Builder::scaleInPolicy)).constructor(ScaleInPolicy::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scaleInPolicy").build()}).build();
    private static final SdkField<ScaleOutPolicy> SCALE_OUT_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("scaleOutPolicy").getter(AutoScaling.getter(AutoScaling::scaleOutPolicy)).setter(AutoScaling.setter(Builder::scaleOutPolicy)).constructor(ScaleOutPolicy::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scaleOutPolicy").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAX_WORKER_COUNT_FIELD, MCU_COUNT_FIELD, MIN_WORKER_COUNT_FIELD, SCALE_IN_POLICY_FIELD, SCALE_OUT_POLICY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AutoScaling.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Integer maxWorkerCount;
    private final Integer mcuCount;
    private final Integer minWorkerCount;
    private final ScaleInPolicy scaleInPolicy;
    private final ScaleOutPolicy scaleOutPolicy;

    private AutoScaling(BuilderImpl builder) {
        this.maxWorkerCount = builder.maxWorkerCount;
        this.mcuCount = builder.mcuCount;
        this.minWorkerCount = builder.minWorkerCount;
        this.scaleInPolicy = builder.scaleInPolicy;
        this.scaleOutPolicy = builder.scaleOutPolicy;
    }

    public final Integer maxWorkerCount() {
        return this.maxWorkerCount;
    }

    public final Integer mcuCount() {
        return this.mcuCount;
    }

    public final Integer minWorkerCount() {
        return this.minWorkerCount;
    }

    public final ScaleInPolicy scaleInPolicy() {
        return this.scaleInPolicy;
    }

    public final ScaleOutPolicy scaleOutPolicy() {
        return this.scaleOutPolicy;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.maxWorkerCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.mcuCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.minWorkerCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.scaleInPolicy());
        hashCode = 31 * hashCode + Objects.hashCode(this.scaleOutPolicy());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutoScaling)) {
            return false;
        }
        AutoScaling other = (AutoScaling)obj;
        return Objects.equals(this.maxWorkerCount(), other.maxWorkerCount()) && Objects.equals(this.mcuCount(), other.mcuCount()) && Objects.equals(this.minWorkerCount(), other.minWorkerCount()) && Objects.equals(this.scaleInPolicy(), other.scaleInPolicy()) && Objects.equals(this.scaleOutPolicy(), other.scaleOutPolicy());
    }

    public final String toString() {
        return ToString.builder((String)"AutoScaling").add("MaxWorkerCount", (Object)this.maxWorkerCount()).add("McuCount", (Object)this.mcuCount()).add("MinWorkerCount", (Object)this.minWorkerCount()).add("ScaleInPolicy", (Object)this.scaleInPolicy()).add("ScaleOutPolicy", (Object)this.scaleOutPolicy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "maxWorkerCount": {
                return Optional.ofNullable(clazz.cast(this.maxWorkerCount()));
            }
            case "mcuCount": {
                return Optional.ofNullable(clazz.cast(this.mcuCount()));
            }
            case "minWorkerCount": {
                return Optional.ofNullable(clazz.cast(this.minWorkerCount()));
            }
            case "scaleInPolicy": {
                return Optional.ofNullable(clazz.cast(this.scaleInPolicy()));
            }
            case "scaleOutPolicy": {
                return Optional.ofNullable(clazz.cast(this.scaleOutPolicy()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("maxWorkerCount", MAX_WORKER_COUNT_FIELD);
        map.put("mcuCount", MCU_COUNT_FIELD);
        map.put("minWorkerCount", MIN_WORKER_COUNT_FIELD);
        map.put("scaleInPolicy", SCALE_IN_POLICY_FIELD);
        map.put("scaleOutPolicy", SCALE_OUT_POLICY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AutoScaling, T> g) {
        return obj -> g.apply((AutoScaling)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer maxWorkerCount;
        private Integer mcuCount;
        private Integer minWorkerCount;
        private ScaleInPolicy scaleInPolicy;
        private ScaleOutPolicy scaleOutPolicy;

        private BuilderImpl() {
        }

        private BuilderImpl(AutoScaling model) {
            this.maxWorkerCount(model.maxWorkerCount);
            this.mcuCount(model.mcuCount);
            this.minWorkerCount(model.minWorkerCount);
            this.scaleInPolicy(model.scaleInPolicy);
            this.scaleOutPolicy(model.scaleOutPolicy);
        }

        public final Integer getMaxWorkerCount() {
            return this.maxWorkerCount;
        }

        public final void setMaxWorkerCount(Integer maxWorkerCount) {
            this.maxWorkerCount = maxWorkerCount;
        }

        @Override
        public final Builder maxWorkerCount(Integer maxWorkerCount) {
            this.maxWorkerCount = maxWorkerCount;
            return this;
        }

        public final Integer getMcuCount() {
            return this.mcuCount;
        }

        public final void setMcuCount(Integer mcuCount) {
            this.mcuCount = mcuCount;
        }

        @Override
        public final Builder mcuCount(Integer mcuCount) {
            this.mcuCount = mcuCount;
            return this;
        }

        public final Integer getMinWorkerCount() {
            return this.minWorkerCount;
        }

        public final void setMinWorkerCount(Integer minWorkerCount) {
            this.minWorkerCount = minWorkerCount;
        }

        @Override
        public final Builder minWorkerCount(Integer minWorkerCount) {
            this.minWorkerCount = minWorkerCount;
            return this;
        }

        public final ScaleInPolicy.Builder getScaleInPolicy() {
            return this.scaleInPolicy != null ? this.scaleInPolicy.toBuilder() : null;
        }

        public final void setScaleInPolicy(ScaleInPolicy.BuilderImpl scaleInPolicy) {
            this.scaleInPolicy = scaleInPolicy != null ? scaleInPolicy.build() : null;
        }

        @Override
        public final Builder scaleInPolicy(ScaleInPolicy scaleInPolicy) {
            this.scaleInPolicy = scaleInPolicy;
            return this;
        }

        public final ScaleOutPolicy.Builder getScaleOutPolicy() {
            return this.scaleOutPolicy != null ? this.scaleOutPolicy.toBuilder() : null;
        }

        public final void setScaleOutPolicy(ScaleOutPolicy.BuilderImpl scaleOutPolicy) {
            this.scaleOutPolicy = scaleOutPolicy != null ? scaleOutPolicy.build() : null;
        }

        @Override
        public final Builder scaleOutPolicy(ScaleOutPolicy scaleOutPolicy) {
            this.scaleOutPolicy = scaleOutPolicy;
            return this;
        }

        public AutoScaling build() {
            return new AutoScaling(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AutoScaling> {
        public Builder maxWorkerCount(Integer var1);

        public Builder mcuCount(Integer var1);

        public Builder minWorkerCount(Integer var1);

        public Builder scaleInPolicy(ScaleInPolicy var1);

        default public Builder scaleInPolicy(Consumer<ScaleInPolicy.Builder> scaleInPolicy) {
            return this.scaleInPolicy((ScaleInPolicy)((ScaleInPolicy.Builder)ScaleInPolicy.builder().applyMutation(scaleInPolicy)).build());
        }

        public Builder scaleOutPolicy(ScaleOutPolicy var1);

        default public Builder scaleOutPolicy(Consumer<ScaleOutPolicy.Builder> scaleOutPolicy) {
            return this.scaleOutPolicy((ScaleOutPolicy)((ScaleOutPolicy.Builder)ScaleOutPolicy.builder().applyMutation(scaleOutPolicy)).build());
        }
    }
}

