/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kafkaconnect.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.kafkaconnect.model.KafkaConnectResponse;
import software.amazon.awssdk.services.kafkaconnect.model.WorkerConfigurationRevisionDescription;
import software.amazon.awssdk.services.kafkaconnect.model.WorkerConfigurationState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeWorkerConfigurationResponse
extends KafkaConnectResponse
implements ToCopyableBuilder<Builder, DescribeWorkerConfigurationResponse> {
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("creationTime").getter(DescribeWorkerConfigurationResponse.getter(DescribeWorkerConfigurationResponse::creationTime)).setter(DescribeWorkerConfigurationResponse.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(DescribeWorkerConfigurationResponse.getter(DescribeWorkerConfigurationResponse::description)).setter(DescribeWorkerConfigurationResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<WorkerConfigurationRevisionDescription> LATEST_REVISION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("latestRevision").getter(DescribeWorkerConfigurationResponse.getter(DescribeWorkerConfigurationResponse::latestRevision)).setter(DescribeWorkerConfigurationResponse.setter(Builder::latestRevision)).constructor(WorkerConfigurationRevisionDescription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("latestRevision").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(DescribeWorkerConfigurationResponse.getter(DescribeWorkerConfigurationResponse::name)).setter(DescribeWorkerConfigurationResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> WORKER_CONFIGURATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("workerConfigurationArn").getter(DescribeWorkerConfigurationResponse.getter(DescribeWorkerConfigurationResponse::workerConfigurationArn)).setter(DescribeWorkerConfigurationResponse.setter(Builder::workerConfigurationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workerConfigurationArn").build()}).build();
    private static final SdkField<String> WORKER_CONFIGURATION_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("workerConfigurationState").getter(DescribeWorkerConfigurationResponse.getter(DescribeWorkerConfigurationResponse::workerConfigurationStateAsString)).setter(DescribeWorkerConfigurationResponse.setter(Builder::workerConfigurationState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workerConfigurationState").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATION_TIME_FIELD, DESCRIPTION_FIELD, LATEST_REVISION_FIELD, NAME_FIELD, WORKER_CONFIGURATION_ARN_FIELD, WORKER_CONFIGURATION_STATE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeWorkerConfigurationResponse.memberNameToFieldInitializer();
    private final Instant creationTime;
    private final String description;
    private final WorkerConfigurationRevisionDescription latestRevision;
    private final String name;
    private final String workerConfigurationArn;
    private final String workerConfigurationState;

    private DescribeWorkerConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.creationTime = builder.creationTime;
        this.description = builder.description;
        this.latestRevision = builder.latestRevision;
        this.name = builder.name;
        this.workerConfigurationArn = builder.workerConfigurationArn;
        this.workerConfigurationState = builder.workerConfigurationState;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final String description() {
        return this.description;
    }

    public final WorkerConfigurationRevisionDescription latestRevision() {
        return this.latestRevision;
    }

    public final String name() {
        return this.name;
    }

    public final String workerConfigurationArn() {
        return this.workerConfigurationArn;
    }

    public final WorkerConfigurationState workerConfigurationState() {
        return WorkerConfigurationState.fromValue(this.workerConfigurationState);
    }

    public final String workerConfigurationStateAsString() {
        return this.workerConfigurationState;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.latestRevision());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.workerConfigurationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.workerConfigurationStateAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeWorkerConfigurationResponse)) {
            return false;
        }
        DescribeWorkerConfigurationResponse other = (DescribeWorkerConfigurationResponse)((Object)obj);
        return Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.latestRevision(), other.latestRevision()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.workerConfigurationArn(), other.workerConfigurationArn()) && Objects.equals(this.workerConfigurationStateAsString(), other.workerConfigurationStateAsString());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeWorkerConfigurationResponse").add("CreationTime", (Object)this.creationTime()).add("Description", (Object)this.description()).add("LatestRevision", (Object)this.latestRevision()).add("Name", (Object)this.name()).add("WorkerConfigurationArn", (Object)this.workerConfigurationArn()).add("WorkerConfigurationState", (Object)this.workerConfigurationStateAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "creationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "latestRevision": {
                return Optional.ofNullable(clazz.cast(this.latestRevision()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "workerConfigurationArn": {
                return Optional.ofNullable(clazz.cast(this.workerConfigurationArn()));
            }
            case "workerConfigurationState": {
                return Optional.ofNullable(clazz.cast(this.workerConfigurationStateAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("creationTime", CREATION_TIME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("latestRevision", LATEST_REVISION_FIELD);
        map.put("name", NAME_FIELD);
        map.put("workerConfigurationArn", WORKER_CONFIGURATION_ARN_FIELD);
        map.put("workerConfigurationState", WORKER_CONFIGURATION_STATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeWorkerConfigurationResponse, T> g) {
        return obj -> g.apply((DescribeWorkerConfigurationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends KafkaConnectResponse.BuilderImpl
    implements Builder {
        private Instant creationTime;
        private String description;
        private WorkerConfigurationRevisionDescription latestRevision;
        private String name;
        private String workerConfigurationArn;
        private String workerConfigurationState;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeWorkerConfigurationResponse model) {
            super(model);
            this.creationTime(model.creationTime);
            this.description(model.description);
            this.latestRevision(model.latestRevision);
            this.name(model.name);
            this.workerConfigurationArn(model.workerConfigurationArn);
            this.workerConfigurationState(model.workerConfigurationState);
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final WorkerConfigurationRevisionDescription.Builder getLatestRevision() {
            return this.latestRevision != null ? this.latestRevision.toBuilder() : null;
        }

        public final void setLatestRevision(WorkerConfigurationRevisionDescription.BuilderImpl latestRevision) {
            this.latestRevision = latestRevision != null ? latestRevision.build() : null;
        }

        @Override
        public final Builder latestRevision(WorkerConfigurationRevisionDescription latestRevision) {
            this.latestRevision = latestRevision;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getWorkerConfigurationArn() {
            return this.workerConfigurationArn;
        }

        public final void setWorkerConfigurationArn(String workerConfigurationArn) {
            this.workerConfigurationArn = workerConfigurationArn;
        }

        @Override
        public final Builder workerConfigurationArn(String workerConfigurationArn) {
            this.workerConfigurationArn = workerConfigurationArn;
            return this;
        }

        public final String getWorkerConfigurationState() {
            return this.workerConfigurationState;
        }

        public final void setWorkerConfigurationState(String workerConfigurationState) {
            this.workerConfigurationState = workerConfigurationState;
        }

        @Override
        public final Builder workerConfigurationState(String workerConfigurationState) {
            this.workerConfigurationState = workerConfigurationState;
            return this;
        }

        @Override
        public final Builder workerConfigurationState(WorkerConfigurationState workerConfigurationState) {
            this.workerConfigurationState(workerConfigurationState == null ? null : workerConfigurationState.toString());
            return this;
        }

        @Override
        public DescribeWorkerConfigurationResponse build() {
            return new DescribeWorkerConfigurationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends KafkaConnectResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeWorkerConfigurationResponse> {
        public Builder creationTime(Instant var1);

        public Builder description(String var1);

        public Builder latestRevision(WorkerConfigurationRevisionDescription var1);

        default public Builder latestRevision(Consumer<WorkerConfigurationRevisionDescription.Builder> latestRevision) {
            return this.latestRevision((WorkerConfigurationRevisionDescription)((WorkerConfigurationRevisionDescription.Builder)WorkerConfigurationRevisionDescription.builder().applyMutation(latestRevision)).build());
        }

        public Builder name(String var1);

        public Builder workerConfigurationArn(String var1);

        public Builder workerConfigurationState(String var1);

        public Builder workerConfigurationState(WorkerConfigurationState var1);
    }
}

