/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kafkaconnect.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.kafkaconnect.model.ConnectorConfigurationCopier;
import software.amazon.awssdk.services.kafkaconnect.model.ConnectorOperationState;
import software.amazon.awssdk.services.kafkaconnect.model.ConnectorOperationStep;
import software.amazon.awssdk.services.kafkaconnect.model.ConnectorOperationType;
import software.amazon.awssdk.services.kafkaconnect.model.KafkaConnectResponse;
import software.amazon.awssdk.services.kafkaconnect.model.StateDescription;
import software.amazon.awssdk.services.kafkaconnect.model.WorkerSetting;
import software.amazon.awssdk.services.kafkaconnect.model.___listOfConnectorOperationStepCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeConnectorOperationResponse
extends KafkaConnectResponse
implements ToCopyableBuilder<Builder, DescribeConnectorOperationResponse> {
    private static final SdkField<String> CONNECTOR_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("connectorArn").getter(DescribeConnectorOperationResponse.getter(DescribeConnectorOperationResponse::connectorArn)).setter(DescribeConnectorOperationResponse.setter(Builder::connectorArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectorArn").build()}).build();
    private static final SdkField<String> CONNECTOR_OPERATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("connectorOperationArn").getter(DescribeConnectorOperationResponse.getter(DescribeConnectorOperationResponse::connectorOperationArn)).setter(DescribeConnectorOperationResponse.setter(Builder::connectorOperationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectorOperationArn").build()}).build();
    private static final SdkField<String> CONNECTOR_OPERATION_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("connectorOperationState").getter(DescribeConnectorOperationResponse.getter(DescribeConnectorOperationResponse::connectorOperationStateAsString)).setter(DescribeConnectorOperationResponse.setter(Builder::connectorOperationState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectorOperationState").build()}).build();
    private static final SdkField<String> CONNECTOR_OPERATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("connectorOperationType").getter(DescribeConnectorOperationResponse.getter(DescribeConnectorOperationResponse::connectorOperationTypeAsString)).setter(DescribeConnectorOperationResponse.setter(Builder::connectorOperationType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectorOperationType").build()}).build();
    private static final SdkField<List<ConnectorOperationStep>> OPERATION_STEPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("operationSteps").getter(DescribeConnectorOperationResponse.getter(DescribeConnectorOperationResponse::operationSteps)).setter(DescribeConnectorOperationResponse.setter(Builder::operationSteps)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("operationSteps").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ConnectorOperationStep::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<WorkerSetting> ORIGIN_WORKER_SETTING_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("originWorkerSetting").getter(DescribeConnectorOperationResponse.getter(DescribeConnectorOperationResponse::originWorkerSetting)).setter(DescribeConnectorOperationResponse.setter(Builder::originWorkerSetting)).constructor(WorkerSetting::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("originWorkerSetting").build()}).build();
    private static final SdkField<Map<String, String>> ORIGIN_CONNECTOR_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("originConnectorConfiguration").getter(DescribeConnectorOperationResponse.getter(DescribeConnectorOperationResponse::originConnectorConfiguration)).setter(DescribeConnectorOperationResponse.setter(Builder::originConnectorConfiguration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("originConnectorConfiguration").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<WorkerSetting> TARGET_WORKER_SETTING_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("targetWorkerSetting").getter(DescribeConnectorOperationResponse.getter(DescribeConnectorOperationResponse::targetWorkerSetting)).setter(DescribeConnectorOperationResponse.setter(Builder::targetWorkerSetting)).constructor(WorkerSetting::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetWorkerSetting").build()}).build();
    private static final SdkField<Map<String, String>> TARGET_CONNECTOR_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("targetConnectorConfiguration").getter(DescribeConnectorOperationResponse.getter(DescribeConnectorOperationResponse::targetConnectorConfiguration)).setter(DescribeConnectorOperationResponse.setter(Builder::targetConnectorConfiguration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetConnectorConfiguration").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<StateDescription> ERROR_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("errorInfo").getter(DescribeConnectorOperationResponse.getter(DescribeConnectorOperationResponse::errorInfo)).setter(DescribeConnectorOperationResponse.setter(Builder::errorInfo)).constructor(StateDescription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorInfo").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("creationTime").getter(DescribeConnectorOperationResponse.getter(DescribeConnectorOperationResponse::creationTime)).setter(DescribeConnectorOperationResponse.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("endTime").getter(DescribeConnectorOperationResponse.getter(DescribeConnectorOperationResponse::endTime)).setter(DescribeConnectorOperationResponse.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONNECTOR_ARN_FIELD, CONNECTOR_OPERATION_ARN_FIELD, CONNECTOR_OPERATION_STATE_FIELD, CONNECTOR_OPERATION_TYPE_FIELD, OPERATION_STEPS_FIELD, ORIGIN_WORKER_SETTING_FIELD, ORIGIN_CONNECTOR_CONFIGURATION_FIELD, TARGET_WORKER_SETTING_FIELD, TARGET_CONNECTOR_CONFIGURATION_FIELD, ERROR_INFO_FIELD, CREATION_TIME_FIELD, END_TIME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeConnectorOperationResponse.memberNameToFieldInitializer();
    private final String connectorArn;
    private final String connectorOperationArn;
    private final String connectorOperationState;
    private final String connectorOperationType;
    private final List<ConnectorOperationStep> operationSteps;
    private final WorkerSetting originWorkerSetting;
    private final Map<String, String> originConnectorConfiguration;
    private final WorkerSetting targetWorkerSetting;
    private final Map<String, String> targetConnectorConfiguration;
    private final StateDescription errorInfo;
    private final Instant creationTime;
    private final Instant endTime;

    private DescribeConnectorOperationResponse(BuilderImpl builder) {
        super(builder);
        this.connectorArn = builder.connectorArn;
        this.connectorOperationArn = builder.connectorOperationArn;
        this.connectorOperationState = builder.connectorOperationState;
        this.connectorOperationType = builder.connectorOperationType;
        this.operationSteps = builder.operationSteps;
        this.originWorkerSetting = builder.originWorkerSetting;
        this.originConnectorConfiguration = builder.originConnectorConfiguration;
        this.targetWorkerSetting = builder.targetWorkerSetting;
        this.targetConnectorConfiguration = builder.targetConnectorConfiguration;
        this.errorInfo = builder.errorInfo;
        this.creationTime = builder.creationTime;
        this.endTime = builder.endTime;
    }

    public final String connectorArn() {
        return this.connectorArn;
    }

    public final String connectorOperationArn() {
        return this.connectorOperationArn;
    }

    public final ConnectorOperationState connectorOperationState() {
        return ConnectorOperationState.fromValue(this.connectorOperationState);
    }

    public final String connectorOperationStateAsString() {
        return this.connectorOperationState;
    }

    public final ConnectorOperationType connectorOperationType() {
        return ConnectorOperationType.fromValue(this.connectorOperationType);
    }

    public final String connectorOperationTypeAsString() {
        return this.connectorOperationType;
    }

    public final boolean hasOperationSteps() {
        return this.operationSteps != null && !(this.operationSteps instanceof SdkAutoConstructList);
    }

    public final List<ConnectorOperationStep> operationSteps() {
        return this.operationSteps;
    }

    public final WorkerSetting originWorkerSetting() {
        return this.originWorkerSetting;
    }

    public final boolean hasOriginConnectorConfiguration() {
        return this.originConnectorConfiguration != null && !(this.originConnectorConfiguration instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> originConnectorConfiguration() {
        return this.originConnectorConfiguration;
    }

    public final WorkerSetting targetWorkerSetting() {
        return this.targetWorkerSetting;
    }

    public final boolean hasTargetConnectorConfiguration() {
        return this.targetConnectorConfiguration != null && !(this.targetConnectorConfiguration instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> targetConnectorConfiguration() {
        return this.targetConnectorConfiguration;
    }

    public final StateDescription errorInfo() {
        return this.errorInfo;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final Instant endTime() {
        return this.endTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.connectorArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectorOperationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectorOperationStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectorOperationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOperationSteps() ? this.operationSteps() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.originWorkerSetting());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOriginConnectorConfiguration() ? this.originConnectorConfiguration() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.targetWorkerSetting());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTargetConnectorConfiguration() ? this.targetConnectorConfiguration() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.errorInfo());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeConnectorOperationResponse)) {
            return false;
        }
        DescribeConnectorOperationResponse other = (DescribeConnectorOperationResponse)((Object)obj);
        return Objects.equals(this.connectorArn(), other.connectorArn()) && Objects.equals(this.connectorOperationArn(), other.connectorOperationArn()) && Objects.equals(this.connectorOperationStateAsString(), other.connectorOperationStateAsString()) && Objects.equals(this.connectorOperationTypeAsString(), other.connectorOperationTypeAsString()) && this.hasOperationSteps() == other.hasOperationSteps() && Objects.equals(this.operationSteps(), other.operationSteps()) && Objects.equals(this.originWorkerSetting(), other.originWorkerSetting()) && this.hasOriginConnectorConfiguration() == other.hasOriginConnectorConfiguration() && Objects.equals(this.originConnectorConfiguration(), other.originConnectorConfiguration()) && Objects.equals(this.targetWorkerSetting(), other.targetWorkerSetting()) && this.hasTargetConnectorConfiguration() == other.hasTargetConnectorConfiguration() && Objects.equals(this.targetConnectorConfiguration(), other.targetConnectorConfiguration()) && Objects.equals(this.errorInfo(), other.errorInfo()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.endTime(), other.endTime());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeConnectorOperationResponse").add("ConnectorArn", (Object)this.connectorArn()).add("ConnectorOperationArn", (Object)this.connectorOperationArn()).add("ConnectorOperationState", (Object)this.connectorOperationStateAsString()).add("ConnectorOperationType", (Object)this.connectorOperationTypeAsString()).add("OperationSteps", this.hasOperationSteps() ? this.operationSteps() : null).add("OriginWorkerSetting", (Object)this.originWorkerSetting()).add("OriginConnectorConfiguration", (Object)(this.originConnectorConfiguration() == null ? null : "*** Sensitive Data Redacted ***")).add("TargetWorkerSetting", (Object)this.targetWorkerSetting()).add("TargetConnectorConfiguration", (Object)(this.targetConnectorConfiguration() == null ? null : "*** Sensitive Data Redacted ***")).add("ErrorInfo", (Object)this.errorInfo()).add("CreationTime", (Object)this.creationTime()).add("EndTime", (Object)this.endTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "connectorArn": {
                return Optional.ofNullable(clazz.cast(this.connectorArn()));
            }
            case "connectorOperationArn": {
                return Optional.ofNullable(clazz.cast(this.connectorOperationArn()));
            }
            case "connectorOperationState": {
                return Optional.ofNullable(clazz.cast(this.connectorOperationStateAsString()));
            }
            case "connectorOperationType": {
                return Optional.ofNullable(clazz.cast(this.connectorOperationTypeAsString()));
            }
            case "operationSteps": {
                return Optional.ofNullable(clazz.cast(this.operationSteps()));
            }
            case "originWorkerSetting": {
                return Optional.ofNullable(clazz.cast(this.originWorkerSetting()));
            }
            case "originConnectorConfiguration": {
                return Optional.ofNullable(clazz.cast(this.originConnectorConfiguration()));
            }
            case "targetWorkerSetting": {
                return Optional.ofNullable(clazz.cast(this.targetWorkerSetting()));
            }
            case "targetConnectorConfiguration": {
                return Optional.ofNullable(clazz.cast(this.targetConnectorConfiguration()));
            }
            case "errorInfo": {
                return Optional.ofNullable(clazz.cast(this.errorInfo()));
            }
            case "creationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "endTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("connectorArn", CONNECTOR_ARN_FIELD);
        map.put("connectorOperationArn", CONNECTOR_OPERATION_ARN_FIELD);
        map.put("connectorOperationState", CONNECTOR_OPERATION_STATE_FIELD);
        map.put("connectorOperationType", CONNECTOR_OPERATION_TYPE_FIELD);
        map.put("operationSteps", OPERATION_STEPS_FIELD);
        map.put("originWorkerSetting", ORIGIN_WORKER_SETTING_FIELD);
        map.put("originConnectorConfiguration", ORIGIN_CONNECTOR_CONFIGURATION_FIELD);
        map.put("targetWorkerSetting", TARGET_WORKER_SETTING_FIELD);
        map.put("targetConnectorConfiguration", TARGET_CONNECTOR_CONFIGURATION_FIELD);
        map.put("errorInfo", ERROR_INFO_FIELD);
        map.put("creationTime", CREATION_TIME_FIELD);
        map.put("endTime", END_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeConnectorOperationResponse, T> g) {
        return obj -> g.apply((DescribeConnectorOperationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends KafkaConnectResponse.BuilderImpl
    implements Builder {
        private String connectorArn;
        private String connectorOperationArn;
        private String connectorOperationState;
        private String connectorOperationType;
        private List<ConnectorOperationStep> operationSteps = DefaultSdkAutoConstructList.getInstance();
        private WorkerSetting originWorkerSetting;
        private Map<String, String> originConnectorConfiguration = DefaultSdkAutoConstructMap.getInstance();
        private WorkerSetting targetWorkerSetting;
        private Map<String, String> targetConnectorConfiguration = DefaultSdkAutoConstructMap.getInstance();
        private StateDescription errorInfo;
        private Instant creationTime;
        private Instant endTime;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeConnectorOperationResponse model) {
            super(model);
            this.connectorArn(model.connectorArn);
            this.connectorOperationArn(model.connectorOperationArn);
            this.connectorOperationState(model.connectorOperationState);
            this.connectorOperationType(model.connectorOperationType);
            this.operationSteps(model.operationSteps);
            this.originWorkerSetting(model.originWorkerSetting);
            this.originConnectorConfiguration(model.originConnectorConfiguration);
            this.targetWorkerSetting(model.targetWorkerSetting);
            this.targetConnectorConfiguration(model.targetConnectorConfiguration);
            this.errorInfo(model.errorInfo);
            this.creationTime(model.creationTime);
            this.endTime(model.endTime);
        }

        public final String getConnectorArn() {
            return this.connectorArn;
        }

        public final void setConnectorArn(String connectorArn) {
            this.connectorArn = connectorArn;
        }

        @Override
        public final Builder connectorArn(String connectorArn) {
            this.connectorArn = connectorArn;
            return this;
        }

        public final String getConnectorOperationArn() {
            return this.connectorOperationArn;
        }

        public final void setConnectorOperationArn(String connectorOperationArn) {
            this.connectorOperationArn = connectorOperationArn;
        }

        @Override
        public final Builder connectorOperationArn(String connectorOperationArn) {
            this.connectorOperationArn = connectorOperationArn;
            return this;
        }

        public final String getConnectorOperationState() {
            return this.connectorOperationState;
        }

        public final void setConnectorOperationState(String connectorOperationState) {
            this.connectorOperationState = connectorOperationState;
        }

        @Override
        public final Builder connectorOperationState(String connectorOperationState) {
            this.connectorOperationState = connectorOperationState;
            return this;
        }

        @Override
        public final Builder connectorOperationState(ConnectorOperationState connectorOperationState) {
            this.connectorOperationState(connectorOperationState == null ? null : connectorOperationState.toString());
            return this;
        }

        public final String getConnectorOperationType() {
            return this.connectorOperationType;
        }

        public final void setConnectorOperationType(String connectorOperationType) {
            this.connectorOperationType = connectorOperationType;
        }

        @Override
        public final Builder connectorOperationType(String connectorOperationType) {
            this.connectorOperationType = connectorOperationType;
            return this;
        }

        @Override
        public final Builder connectorOperationType(ConnectorOperationType connectorOperationType) {
            this.connectorOperationType(connectorOperationType == null ? null : connectorOperationType.toString());
            return this;
        }

        public final List<ConnectorOperationStep.Builder> getOperationSteps() {
            List<ConnectorOperationStep.Builder> result = ___listOfConnectorOperationStepCopier.copyToBuilder(this.operationSteps);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOperationSteps(Collection<ConnectorOperationStep.BuilderImpl> operationSteps) {
            this.operationSteps = ___listOfConnectorOperationStepCopier.copyFromBuilder(operationSteps);
        }

        @Override
        public final Builder operationSteps(Collection<ConnectorOperationStep> operationSteps) {
            this.operationSteps = ___listOfConnectorOperationStepCopier.copy(operationSteps);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder operationSteps(ConnectorOperationStep ... operationSteps) {
            this.operationSteps(Arrays.asList(operationSteps));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder operationSteps(Consumer<ConnectorOperationStep.Builder> ... operationSteps) {
            this.operationSteps(Stream.of(operationSteps).map(c -> (ConnectorOperationStep)((ConnectorOperationStep.Builder)ConnectorOperationStep.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final WorkerSetting.Builder getOriginWorkerSetting() {
            return this.originWorkerSetting != null ? this.originWorkerSetting.toBuilder() : null;
        }

        public final void setOriginWorkerSetting(WorkerSetting.BuilderImpl originWorkerSetting) {
            this.originWorkerSetting = originWorkerSetting != null ? originWorkerSetting.build() : null;
        }

        @Override
        public final Builder originWorkerSetting(WorkerSetting originWorkerSetting) {
            this.originWorkerSetting = originWorkerSetting;
            return this;
        }

        public final Map<String, String> getOriginConnectorConfiguration() {
            if (this.originConnectorConfiguration instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.originConnectorConfiguration;
        }

        public final void setOriginConnectorConfiguration(Map<String, String> originConnectorConfiguration) {
            this.originConnectorConfiguration = ConnectorConfigurationCopier.copy(originConnectorConfiguration);
        }

        @Override
        public final Builder originConnectorConfiguration(Map<String, String> originConnectorConfiguration) {
            this.originConnectorConfiguration = ConnectorConfigurationCopier.copy(originConnectorConfiguration);
            return this;
        }

        public final WorkerSetting.Builder getTargetWorkerSetting() {
            return this.targetWorkerSetting != null ? this.targetWorkerSetting.toBuilder() : null;
        }

        public final void setTargetWorkerSetting(WorkerSetting.BuilderImpl targetWorkerSetting) {
            this.targetWorkerSetting = targetWorkerSetting != null ? targetWorkerSetting.build() : null;
        }

        @Override
        public final Builder targetWorkerSetting(WorkerSetting targetWorkerSetting) {
            this.targetWorkerSetting = targetWorkerSetting;
            return this;
        }

        public final Map<String, String> getTargetConnectorConfiguration() {
            if (this.targetConnectorConfiguration instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.targetConnectorConfiguration;
        }

        public final void setTargetConnectorConfiguration(Map<String, String> targetConnectorConfiguration) {
            this.targetConnectorConfiguration = ConnectorConfigurationCopier.copy(targetConnectorConfiguration);
        }

        @Override
        public final Builder targetConnectorConfiguration(Map<String, String> targetConnectorConfiguration) {
            this.targetConnectorConfiguration = ConnectorConfigurationCopier.copy(targetConnectorConfiguration);
            return this;
        }

        public final StateDescription.Builder getErrorInfo() {
            return this.errorInfo != null ? this.errorInfo.toBuilder() : null;
        }

        public final void setErrorInfo(StateDescription.BuilderImpl errorInfo) {
            this.errorInfo = errorInfo != null ? errorInfo.build() : null;
        }

        @Override
        public final Builder errorInfo(StateDescription errorInfo) {
            this.errorInfo = errorInfo;
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        @Override
        public DescribeConnectorOperationResponse build() {
            return new DescribeConnectorOperationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends KafkaConnectResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeConnectorOperationResponse> {
        public Builder connectorArn(String var1);

        public Builder connectorOperationArn(String var1);

        public Builder connectorOperationState(String var1);

        public Builder connectorOperationState(ConnectorOperationState var1);

        public Builder connectorOperationType(String var1);

        public Builder connectorOperationType(ConnectorOperationType var1);

        public Builder operationSteps(Collection<ConnectorOperationStep> var1);

        public Builder operationSteps(ConnectorOperationStep ... var1);

        public Builder operationSteps(Consumer<ConnectorOperationStep.Builder> ... var1);

        public Builder originWorkerSetting(WorkerSetting var1);

        default public Builder originWorkerSetting(Consumer<WorkerSetting.Builder> originWorkerSetting) {
            return this.originWorkerSetting((WorkerSetting)((WorkerSetting.Builder)WorkerSetting.builder().applyMutation(originWorkerSetting)).build());
        }

        public Builder originConnectorConfiguration(Map<String, String> var1);

        public Builder targetWorkerSetting(WorkerSetting var1);

        default public Builder targetWorkerSetting(Consumer<WorkerSetting.Builder> targetWorkerSetting) {
            return this.targetWorkerSetting((WorkerSetting)((WorkerSetting.Builder)WorkerSetting.builder().applyMutation(targetWorkerSetting)).build());
        }

        public Builder targetConnectorConfiguration(Map<String, String> var1);

        public Builder errorInfo(StateDescription var1);

        default public Builder errorInfo(Consumer<StateDescription.Builder> errorInfo) {
            return this.errorInfo((StateDescription)((StateDescription.Builder)StateDescription.builder().applyMutation(errorInfo)).build());
        }

        public Builder creationTime(Instant var1);

        public Builder endTime(Instant var1);
    }
}

