/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kafkaconnect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateConnectorRequest extends KafkaConnectRequest implements
        ToCopyableBuilder<UpdateConnectorRequest.Builder, UpdateConnectorRequest> {
    private static final SdkField<CapacityUpdate> CAPACITY_FIELD = SdkField.<CapacityUpdate> builder(MarshallingType.SDK_POJO)
            .memberName("capacity").getter(getter(UpdateConnectorRequest::capacity)).setter(setter(Builder::capacity))
            .constructor(CapacityUpdate::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("capacity").build()).build();

    private static final SdkField<String> CONNECTOR_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("connectorArn").getter(getter(UpdateConnectorRequest::connectorArn))
            .setter(setter(Builder::connectorArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("connectorArn").build()).build();

    private static final SdkField<String> CURRENT_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("currentVersion").getter(getter(UpdateConnectorRequest::currentVersion))
            .setter(setter(Builder::currentVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("currentVersion").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CAPACITY_FIELD,
            CONNECTOR_ARN_FIELD, CURRENT_VERSION_FIELD));

    private final CapacityUpdate capacity;

    private final String connectorArn;

    private final String currentVersion;

    private UpdateConnectorRequest(BuilderImpl builder) {
        super(builder);
        this.capacity = builder.capacity;
        this.connectorArn = builder.connectorArn;
        this.currentVersion = builder.currentVersion;
    }

    /**
     * <p>
     * The target capacity.
     * </p>
     * 
     * @return The target capacity.
     */
    public final CapacityUpdate capacity() {
        return capacity;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the connector that you want to update.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the connector that you want to update.
     */
    public final String connectorArn() {
        return connectorArn;
    }

    /**
     * <p>
     * The current version of the connector that you want to update.
     * </p>
     * 
     * @return The current version of the connector that you want to update.
     */
    public final String currentVersion() {
        return currentVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(capacity());
        hashCode = 31 * hashCode + Objects.hashCode(connectorArn());
        hashCode = 31 * hashCode + Objects.hashCode(currentVersion());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateConnectorRequest)) {
            return false;
        }
        UpdateConnectorRequest other = (UpdateConnectorRequest) obj;
        return Objects.equals(capacity(), other.capacity()) && Objects.equals(connectorArn(), other.connectorArn())
                && Objects.equals(currentVersion(), other.currentVersion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateConnectorRequest").add("Capacity", capacity()).add("ConnectorArn", connectorArn())
                .add("CurrentVersion", currentVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "capacity":
            return Optional.ofNullable(clazz.cast(capacity()));
        case "connectorArn":
            return Optional.ofNullable(clazz.cast(connectorArn()));
        case "currentVersion":
            return Optional.ofNullable(clazz.cast(currentVersion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateConnectorRequest, T> g) {
        return obj -> g.apply((UpdateConnectorRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends KafkaConnectRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateConnectorRequest> {
        /**
         * <p>
         * The target capacity.
         * </p>
         * 
         * @param capacity
         *        The target capacity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capacity(CapacityUpdate capacity);

        /**
         * <p>
         * The target capacity.
         * </p>
         * This is a convenience method that creates an instance of the {@link CapacityUpdate.Builder} avoiding the need
         * to create one manually via {@link CapacityUpdate#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CapacityUpdate.Builder#build()} is called immediately and its
         * result is passed to {@link #capacity(CapacityUpdate)}.
         * 
         * @param capacity
         *        a consumer that will call methods on {@link CapacityUpdate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #capacity(CapacityUpdate)
         */
        default Builder capacity(Consumer<CapacityUpdate.Builder> capacity) {
            return capacity(CapacityUpdate.builder().applyMutation(capacity).build());
        }

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the connector that you want to update.
         * </p>
         * 
         * @param connectorArn
         *        The Amazon Resource Name (ARN) of the connector that you want to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectorArn(String connectorArn);

        /**
         * <p>
         * The current version of the connector that you want to update.
         * </p>
         * 
         * @param currentVersion
         *        The current version of the connector that you want to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currentVersion(String currentVersion);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends KafkaConnectRequest.BuilderImpl implements Builder {
        private CapacityUpdate capacity;

        private String connectorArn;

        private String currentVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateConnectorRequest model) {
            super(model);
            capacity(model.capacity);
            connectorArn(model.connectorArn);
            currentVersion(model.currentVersion);
        }

        public final CapacityUpdate.Builder getCapacity() {
            return capacity != null ? capacity.toBuilder() : null;
        }

        public final void setCapacity(CapacityUpdate.BuilderImpl capacity) {
            this.capacity = capacity != null ? capacity.build() : null;
        }

        @Override
        public final Builder capacity(CapacityUpdate capacity) {
            this.capacity = capacity;
            return this;
        }

        public final String getConnectorArn() {
            return connectorArn;
        }

        public final void setConnectorArn(String connectorArn) {
            this.connectorArn = connectorArn;
        }

        @Override
        public final Builder connectorArn(String connectorArn) {
            this.connectorArn = connectorArn;
            return this;
        }

        public final String getCurrentVersion() {
            return currentVersion;
        }

        public final void setCurrentVersion(String currentVersion) {
            this.currentVersion = currentVersion;
        }

        @Override
        public final Builder currentVersion(String currentVersion) {
            this.currentVersion = currentVersion;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateConnectorRequest build() {
            return new UpdateConnectorRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
