/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kafkaconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The settings for delivering connector logs to Amazon CloudWatch Logs.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CloudWatchLogsLogDelivery implements SdkPojo, Serializable,
        ToCopyableBuilder<CloudWatchLogsLogDelivery.Builder, CloudWatchLogsLogDelivery> {
    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("enabled").getter(getter(CloudWatchLogsLogDelivery::enabled)).setter(setter(Builder::enabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enabled").build()).build();

    private static final SdkField<String> LOG_GROUP_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("logGroup").getter(getter(CloudWatchLogsLogDelivery::logGroup)).setter(setter(Builder::logGroup))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logGroup").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(ENABLED_FIELD, LOG_GROUP_FIELD));

    private static final long serialVersionUID = 1L;

    private final Boolean enabled;

    private final String logGroup;

    private CloudWatchLogsLogDelivery(BuilderImpl builder) {
        this.enabled = builder.enabled;
        this.logGroup = builder.logGroup;
    }

    /**
     * <p>
     * Whether log delivery to Amazon CloudWatch Logs is enabled.
     * </p>
     * 
     * @return Whether log delivery to Amazon CloudWatch Logs is enabled.
     */
    public final Boolean enabled() {
        return enabled;
    }

    /**
     * <p>
     * The name of the CloudWatch log group that is the destination for log delivery.
     * </p>
     * 
     * @return The name of the CloudWatch log group that is the destination for log delivery.
     */
    public final String logGroup() {
        return logGroup;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(enabled());
        hashCode = 31 * hashCode + Objects.hashCode(logGroup());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CloudWatchLogsLogDelivery)) {
            return false;
        }
        CloudWatchLogsLogDelivery other = (CloudWatchLogsLogDelivery) obj;
        return Objects.equals(enabled(), other.enabled()) && Objects.equals(logGroup(), other.logGroup());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CloudWatchLogsLogDelivery").add("Enabled", enabled()).add("LogGroup", logGroup()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "enabled":
            return Optional.ofNullable(clazz.cast(enabled()));
        case "logGroup":
            return Optional.ofNullable(clazz.cast(logGroup()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CloudWatchLogsLogDelivery, T> g) {
        return obj -> g.apply((CloudWatchLogsLogDelivery) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CloudWatchLogsLogDelivery> {
        /**
         * <p>
         * Whether log delivery to Amazon CloudWatch Logs is enabled.
         * </p>
         * 
         * @param enabled
         *        Whether log delivery to Amazon CloudWatch Logs is enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabled(Boolean enabled);

        /**
         * <p>
         * The name of the CloudWatch log group that is the destination for log delivery.
         * </p>
         * 
         * @param logGroup
         *        The name of the CloudWatch log group that is the destination for log delivery.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logGroup(String logGroup);
    }

    static final class BuilderImpl implements Builder {
        private Boolean enabled;

        private String logGroup;

        private BuilderImpl() {
        }

        private BuilderImpl(CloudWatchLogsLogDelivery model) {
            enabled(model.enabled);
            logGroup(model.logGroup);
        }

        public final Boolean getEnabled() {
            return enabled;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final String getLogGroup() {
            return logGroup;
        }

        public final void setLogGroup(String logGroup) {
            this.logGroup = logGroup;
        }

        @Override
        public final Builder logGroup(String logGroup) {
            this.logGroup = logGroup;
            return this;
        }

        @Override
        public CloudWatchLogsLogDelivery build() {
            return new CloudWatchLogsLogDelivery(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
