/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kafkaconnect.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.kafkaconnect.KafkaConnectAsyncClient;
import software.amazon.awssdk.services.kafkaconnect.internal.UserAgentUtils;
import software.amazon.awssdk.services.kafkaconnect.model.ConnectorSummary;
import software.amazon.awssdk.services.kafkaconnect.model.ListConnectorsRequest;
import software.amazon.awssdk.services.kafkaconnect.model.ListConnectorsResponse;

public class ListConnectorsPublisher
implements SdkPublisher<ListConnectorsResponse> {
    private final KafkaConnectAsyncClient client;
    private final ListConnectorsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListConnectorsPublisher(KafkaConnectAsyncClient client, ListConnectorsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListConnectorsPublisher(KafkaConnectAsyncClient client, ListConnectorsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListConnectorsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListConnectorsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ConnectorSummary> connectors() {
        Function<ListConnectorsResponse, Iterator> getIterator = response -> {
            if (response != null && response.connectors() != null) {
                return response.connectors().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListConnectorsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListConnectorsResponseFetcher
    implements AsyncPageFetcher<ListConnectorsResponse> {
        private ListConnectorsResponseFetcher() {
        }

        public boolean hasNextPage(ListConnectorsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListConnectorsResponse> nextPage(ListConnectorsResponse previousPage) {
            if (previousPage == null) {
                return ListConnectorsPublisher.this.client.listConnectors(ListConnectorsPublisher.this.firstRequest);
            }
            return ListConnectorsPublisher.this.client.listConnectors((ListConnectorsRequest)((Object)ListConnectorsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

