/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kafkaconnect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.kafkaconnect.model.ConnectorState;
import software.amazon.awssdk.services.kafkaconnect.model.KafkaConnectResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateConnectorResponse
extends KafkaConnectResponse
implements ToCopyableBuilder<Builder, CreateConnectorResponse> {
    private static final SdkField<String> CONNECTOR_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("connectorArn").getter(CreateConnectorResponse.getter(CreateConnectorResponse::connectorArn)).setter(CreateConnectorResponse.setter(Builder::connectorArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectorArn").build()}).build();
    private static final SdkField<String> CONNECTOR_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("connectorName").getter(CreateConnectorResponse.getter(CreateConnectorResponse::connectorName)).setter(CreateConnectorResponse.setter(Builder::connectorName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectorName").build()}).build();
    private static final SdkField<String> CONNECTOR_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("connectorState").getter(CreateConnectorResponse.getter(CreateConnectorResponse::connectorStateAsString)).setter(CreateConnectorResponse.setter(Builder::connectorState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectorState").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONNECTOR_ARN_FIELD, CONNECTOR_NAME_FIELD, CONNECTOR_STATE_FIELD));
    private final String connectorArn;
    private final String connectorName;
    private final String connectorState;

    private CreateConnectorResponse(BuilderImpl builder) {
        super(builder);
        this.connectorArn = builder.connectorArn;
        this.connectorName = builder.connectorName;
        this.connectorState = builder.connectorState;
    }

    public final String connectorArn() {
        return this.connectorArn;
    }

    public final String connectorName() {
        return this.connectorName;
    }

    public final ConnectorState connectorState() {
        return ConnectorState.fromValue(this.connectorState);
    }

    public final String connectorStateAsString() {
        return this.connectorState;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.connectorArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectorName());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectorStateAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateConnectorResponse)) {
            return false;
        }
        CreateConnectorResponse other = (CreateConnectorResponse)((Object)obj);
        return Objects.equals(this.connectorArn(), other.connectorArn()) && Objects.equals(this.connectorName(), other.connectorName()) && Objects.equals(this.connectorStateAsString(), other.connectorStateAsString());
    }

    public final String toString() {
        return ToString.builder((String)"CreateConnectorResponse").add("ConnectorArn", (Object)this.connectorArn()).add("ConnectorName", (Object)this.connectorName()).add("ConnectorState", (Object)this.connectorStateAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "connectorArn": {
                return Optional.ofNullable(clazz.cast(this.connectorArn()));
            }
            case "connectorName": {
                return Optional.ofNullable(clazz.cast(this.connectorName()));
            }
            case "connectorState": {
                return Optional.ofNullable(clazz.cast(this.connectorStateAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateConnectorResponse, T> g) {
        return obj -> g.apply((CreateConnectorResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends KafkaConnectResponse.BuilderImpl
    implements Builder {
        private String connectorArn;
        private String connectorName;
        private String connectorState;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateConnectorResponse model) {
            super(model);
            this.connectorArn(model.connectorArn);
            this.connectorName(model.connectorName);
            this.connectorState(model.connectorState);
        }

        public final String getConnectorArn() {
            return this.connectorArn;
        }

        public final void setConnectorArn(String connectorArn) {
            this.connectorArn = connectorArn;
        }

        @Override
        public final Builder connectorArn(String connectorArn) {
            this.connectorArn = connectorArn;
            return this;
        }

        public final String getConnectorName() {
            return this.connectorName;
        }

        public final void setConnectorName(String connectorName) {
            this.connectorName = connectorName;
        }

        @Override
        public final Builder connectorName(String connectorName) {
            this.connectorName = connectorName;
            return this;
        }

        public final String getConnectorState() {
            return this.connectorState;
        }

        public final void setConnectorState(String connectorState) {
            this.connectorState = connectorState;
        }

        @Override
        public final Builder connectorState(String connectorState) {
            this.connectorState = connectorState;
            return this;
        }

        @Override
        public final Builder connectorState(ConnectorState connectorState) {
            this.connectorState(connectorState == null ? null : connectorState.toString());
            return this;
        }

        @Override
        public CreateConnectorResponse build() {
            return new CreateConnectorResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends KafkaConnectResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateConnectorResponse> {
        public Builder connectorArn(String var1);

        public Builder connectorName(String var1);

        public Builder connectorState(String var1);

        public Builder connectorState(ConnectorState var1);
    }
}

