/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kafkaconnect.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.kafkaconnect.model.WorkerConfigurationRevisionSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class WorkerConfigurationSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, WorkerConfigurationSummary> {
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("creationTime").getter(WorkerConfigurationSummary.getter(WorkerConfigurationSummary::creationTime)).setter(WorkerConfigurationSummary.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(WorkerConfigurationSummary.getter(WorkerConfigurationSummary::description)).setter(WorkerConfigurationSummary.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<WorkerConfigurationRevisionSummary> LATEST_REVISION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("latestRevision").getter(WorkerConfigurationSummary.getter(WorkerConfigurationSummary::latestRevision)).setter(WorkerConfigurationSummary.setter(Builder::latestRevision)).constructor(WorkerConfigurationRevisionSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("latestRevision").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(WorkerConfigurationSummary.getter(WorkerConfigurationSummary::name)).setter(WorkerConfigurationSummary.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> WORKER_CONFIGURATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("workerConfigurationArn").getter(WorkerConfigurationSummary.getter(WorkerConfigurationSummary::workerConfigurationArn)).setter(WorkerConfigurationSummary.setter(Builder::workerConfigurationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workerConfigurationArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATION_TIME_FIELD, DESCRIPTION_FIELD, LATEST_REVISION_FIELD, NAME_FIELD, WORKER_CONFIGURATION_ARN_FIELD));
    private static final long serialVersionUID = 1L;
    private final Instant creationTime;
    private final String description;
    private final WorkerConfigurationRevisionSummary latestRevision;
    private final String name;
    private final String workerConfigurationArn;

    private WorkerConfigurationSummary(BuilderImpl builder) {
        this.creationTime = builder.creationTime;
        this.description = builder.description;
        this.latestRevision = builder.latestRevision;
        this.name = builder.name;
        this.workerConfigurationArn = builder.workerConfigurationArn;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final String description() {
        return this.description;
    }

    public final WorkerConfigurationRevisionSummary latestRevision() {
        return this.latestRevision;
    }

    public final String name() {
        return this.name;
    }

    public final String workerConfigurationArn() {
        return this.workerConfigurationArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.latestRevision());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.workerConfigurationArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WorkerConfigurationSummary)) {
            return false;
        }
        WorkerConfigurationSummary other = (WorkerConfigurationSummary)obj;
        return Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.latestRevision(), other.latestRevision()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.workerConfigurationArn(), other.workerConfigurationArn());
    }

    public final String toString() {
        return ToString.builder((String)"WorkerConfigurationSummary").add("CreationTime", (Object)this.creationTime()).add("Description", (Object)this.description()).add("LatestRevision", (Object)this.latestRevision()).add("Name", (Object)this.name()).add("WorkerConfigurationArn", (Object)this.workerConfigurationArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "creationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "latestRevision": {
                return Optional.ofNullable(clazz.cast(this.latestRevision()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "workerConfigurationArn": {
                return Optional.ofNullable(clazz.cast(this.workerConfigurationArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<WorkerConfigurationSummary, T> g) {
        return obj -> g.apply((WorkerConfigurationSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Instant creationTime;
        private String description;
        private WorkerConfigurationRevisionSummary latestRevision;
        private String name;
        private String workerConfigurationArn;

        private BuilderImpl() {
        }

        private BuilderImpl(WorkerConfigurationSummary model) {
            this.creationTime(model.creationTime);
            this.description(model.description);
            this.latestRevision(model.latestRevision);
            this.name(model.name);
            this.workerConfigurationArn(model.workerConfigurationArn);
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        @Transient
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final WorkerConfigurationRevisionSummary.Builder getLatestRevision() {
            return this.latestRevision != null ? this.latestRevision.toBuilder() : null;
        }

        public final void setLatestRevision(WorkerConfigurationRevisionSummary.BuilderImpl latestRevision) {
            this.latestRevision = latestRevision != null ? latestRevision.build() : null;
        }

        @Override
        @Transient
        public final Builder latestRevision(WorkerConfigurationRevisionSummary latestRevision) {
            this.latestRevision = latestRevision;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getWorkerConfigurationArn() {
            return this.workerConfigurationArn;
        }

        public final void setWorkerConfigurationArn(String workerConfigurationArn) {
            this.workerConfigurationArn = workerConfigurationArn;
        }

        @Override
        @Transient
        public final Builder workerConfigurationArn(String workerConfigurationArn) {
            this.workerConfigurationArn = workerConfigurationArn;
            return this;
        }

        public WorkerConfigurationSummary build() {
            return new WorkerConfigurationSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, WorkerConfigurationSummary> {
        public Builder creationTime(Instant var1);

        public Builder description(String var1);

        public Builder latestRevision(WorkerConfigurationRevisionSummary var1);

        default public Builder latestRevision(Consumer<WorkerConfigurationRevisionSummary.Builder> latestRevision) {
            return this.latestRevision((WorkerConfigurationRevisionSummary)((WorkerConfigurationRevisionSummary.Builder)WorkerConfigurationRevisionSummary.builder().applyMutation(latestRevision)).build());
        }

        public Builder name(String var1);

        public Builder workerConfigurationArn(String var1);
    }
}

