/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kafka.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ZookeeperNodeInfo
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ZookeeperNodeInfo> {
    private static final SdkField<String> ATTACHED_ENI_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ZookeeperNodeInfo.getter(ZookeeperNodeInfo::attachedENIId)).setter(ZookeeperNodeInfo.setter(Builder::attachedENIId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attachedENIId").build()}).build();
    private static final SdkField<String> CLIENT_VPC_IP_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ZookeeperNodeInfo.getter(ZookeeperNodeInfo::clientVpcIpAddress)).setter(ZookeeperNodeInfo.setter(Builder::clientVpcIpAddress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientVpcIpAddress").build()}).build();
    private static final SdkField<Double> ZOOKEEPER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).getter(ZookeeperNodeInfo.getter(ZookeeperNodeInfo::zookeeperId)).setter(ZookeeperNodeInfo.setter(Builder::zookeeperId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("zookeeperId").build()}).build();
    private static final SdkField<String> ZOOKEEPER_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ZookeeperNodeInfo.getter(ZookeeperNodeInfo::zookeeperVersion)).setter(ZookeeperNodeInfo.setter(Builder::zookeeperVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("zookeeperVersion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTACHED_ENI_ID_FIELD, CLIENT_VPC_IP_ADDRESS_FIELD, ZOOKEEPER_ID_FIELD, ZOOKEEPER_VERSION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String attachedENIId;
    private final String clientVpcIpAddress;
    private final Double zookeeperId;
    private final String zookeeperVersion;

    private ZookeeperNodeInfo(BuilderImpl builder) {
        this.attachedENIId = builder.attachedENIId;
        this.clientVpcIpAddress = builder.clientVpcIpAddress;
        this.zookeeperId = builder.zookeeperId;
        this.zookeeperVersion = builder.zookeeperVersion;
    }

    public String attachedENIId() {
        return this.attachedENIId;
    }

    public String clientVpcIpAddress() {
        return this.clientVpcIpAddress;
    }

    public Double zookeeperId() {
        return this.zookeeperId;
    }

    public String zookeeperVersion() {
        return this.zookeeperVersion;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.attachedENIId());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientVpcIpAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.zookeeperId());
        hashCode = 31 * hashCode + Objects.hashCode(this.zookeeperVersion());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ZookeeperNodeInfo)) {
            return false;
        }
        ZookeeperNodeInfo other = (ZookeeperNodeInfo)obj;
        return Objects.equals(this.attachedENIId(), other.attachedENIId()) && Objects.equals(this.clientVpcIpAddress(), other.clientVpcIpAddress()) && Objects.equals(this.zookeeperId(), other.zookeeperId()) && Objects.equals(this.zookeeperVersion(), other.zookeeperVersion());
    }

    public String toString() {
        return ToString.builder((String)"ZookeeperNodeInfo").add("AttachedENIId", (Object)this.attachedENIId()).add("ClientVpcIpAddress", (Object)this.clientVpcIpAddress()).add("ZookeeperId", (Object)this.zookeeperId()).add("ZookeeperVersion", (Object)this.zookeeperVersion()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AttachedENIId": {
                return Optional.ofNullable(clazz.cast(this.attachedENIId()));
            }
            case "ClientVpcIpAddress": {
                return Optional.ofNullable(clazz.cast(this.clientVpcIpAddress()));
            }
            case "ZookeeperId": {
                return Optional.ofNullable(clazz.cast(this.zookeeperId()));
            }
            case "ZookeeperVersion": {
                return Optional.ofNullable(clazz.cast(this.zookeeperVersion()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ZookeeperNodeInfo, T> g) {
        return obj -> g.apply((ZookeeperNodeInfo)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String attachedENIId;
        private String clientVpcIpAddress;
        private Double zookeeperId;
        private String zookeeperVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(ZookeeperNodeInfo model) {
            this.attachedENIId(model.attachedENIId);
            this.clientVpcIpAddress(model.clientVpcIpAddress);
            this.zookeeperId(model.zookeeperId);
            this.zookeeperVersion(model.zookeeperVersion);
        }

        public final String getAttachedENIId() {
            return this.attachedENIId;
        }

        @Override
        public final Builder attachedENIId(String attachedENIId) {
            this.attachedENIId = attachedENIId;
            return this;
        }

        public final void setAttachedENIId(String attachedENIId) {
            this.attachedENIId = attachedENIId;
        }

        public final String getClientVpcIpAddress() {
            return this.clientVpcIpAddress;
        }

        @Override
        public final Builder clientVpcIpAddress(String clientVpcIpAddress) {
            this.clientVpcIpAddress = clientVpcIpAddress;
            return this;
        }

        public final void setClientVpcIpAddress(String clientVpcIpAddress) {
            this.clientVpcIpAddress = clientVpcIpAddress;
        }

        public final Double getZookeeperId() {
            return this.zookeeperId;
        }

        @Override
        public final Builder zookeeperId(Double zookeeperId) {
            this.zookeeperId = zookeeperId;
            return this;
        }

        public final void setZookeeperId(Double zookeeperId) {
            this.zookeeperId = zookeeperId;
        }

        public final String getZookeeperVersion() {
            return this.zookeeperVersion;
        }

        @Override
        public final Builder zookeeperVersion(String zookeeperVersion) {
            this.zookeeperVersion = zookeeperVersion;
            return this;
        }

        public final void setZookeeperVersion(String zookeeperVersion) {
            this.zookeeperVersion = zookeeperVersion;
        }

        public ZookeeperNodeInfo build() {
            return new ZookeeperNodeInfo(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ZookeeperNodeInfo> {
        public Builder attachedENIId(String var1);

        public Builder clientVpcIpAddress(String var1);

        public Builder zookeeperId(Double var1);

        public Builder zookeeperVersion(String var1);
    }
}

