/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kafka.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 *
 * <p>
 * Includes all client authentication information for VPC connectivity.
 * </p>
 * 
 */
@Generated("software.amazon.awssdk:codegen")
public final class VpcConnectivityClientAuthentication implements SdkPojo, Serializable,
        ToCopyableBuilder<VpcConnectivityClientAuthentication.Builder, VpcConnectivityClientAuthentication> {
    private static final SdkField<VpcConnectivitySasl> SASL_FIELD = SdkField
            .<VpcConnectivitySasl> builder(MarshallingType.SDK_POJO).memberName("Sasl")
            .getter(getter(VpcConnectivityClientAuthentication::sasl)).setter(setter(Builder::sasl))
            .constructor(VpcConnectivitySasl::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sasl").build()).build();

    private static final SdkField<VpcConnectivityTls> TLS_FIELD = SdkField.<VpcConnectivityTls> builder(MarshallingType.SDK_POJO)
            .memberName("Tls").getter(getter(VpcConnectivityClientAuthentication::tls)).setter(setter(Builder::tls))
            .constructor(VpcConnectivityTls::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tls").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SASL_FIELD, TLS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final VpcConnectivitySasl sasl;

    private final VpcConnectivityTls tls;

    private VpcConnectivityClientAuthentication(BuilderImpl builder) {
        this.sasl = builder.sasl;
        this.tls = builder.tls;
    }

    /**
     *
     * <p>
     * SASL authentication type details for VPC connectivity.
     * </p>
     * 
     * @return <p>
     *         SASL authentication type details for VPC connectivity.
     *         </p>
     */
    public final VpcConnectivitySasl sasl() {
        return sasl;
    }

    /**
     *
     * <p>
     * TLS authentication type details for VPC connectivity.
     * </p>
     * 
     * @return <p>
     *         TLS authentication type details for VPC connectivity.
     *         </p>
     */
    public final VpcConnectivityTls tls() {
        return tls;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(sasl());
        hashCode = 31 * hashCode + Objects.hashCode(tls());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VpcConnectivityClientAuthentication)) {
            return false;
        }
        VpcConnectivityClientAuthentication other = (VpcConnectivityClientAuthentication) obj;
        return Objects.equals(sasl(), other.sasl()) && Objects.equals(tls(), other.tls());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("VpcConnectivityClientAuthentication").add("Sasl", sasl()).add("Tls", tls()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Sasl":
            return Optional.ofNullable(clazz.cast(sasl()));
        case "Tls":
            return Optional.ofNullable(clazz.cast(tls()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("sasl", SASL_FIELD);
        map.put("tls", TLS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<VpcConnectivityClientAuthentication, T> g) {
        return obj -> g.apply((VpcConnectivityClientAuthentication) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VpcConnectivityClientAuthentication> {
        /**
         *
         * <p>
         * SASL authentication type details for VPC connectivity.
         * </p>
         * 
         * @param sasl
         *        <p>
         *        SASL authentication type details for VPC connectivity.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sasl(VpcConnectivitySasl sasl);

        /**
         *
         * <p>
         * SASL authentication type details for VPC connectivity.
         * </p>
         * 
         * This is a convenience method that creates an instance of the {@link VpcConnectivitySasl.Builder} avoiding the
         * need to create one manually via {@link VpcConnectivitySasl#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VpcConnectivitySasl.Builder#build()} is called immediately and
         * its result is passed to {@link #sasl(VpcConnectivitySasl)}.
         * 
         * @param sasl
         *        a consumer that will call methods on {@link VpcConnectivitySasl.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sasl(VpcConnectivitySasl)
         */
        default Builder sasl(Consumer<VpcConnectivitySasl.Builder> sasl) {
            return sasl(VpcConnectivitySasl.builder().applyMutation(sasl).build());
        }

        /**
         *
         * <p>
         * TLS authentication type details for VPC connectivity.
         * </p>
         * 
         * @param tls
         *        <p>
         *        TLS authentication type details for VPC connectivity.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tls(VpcConnectivityTls tls);

        /**
         *
         * <p>
         * TLS authentication type details for VPC connectivity.
         * </p>
         * 
         * This is a convenience method that creates an instance of the {@link VpcConnectivityTls.Builder} avoiding the
         * need to create one manually via {@link VpcConnectivityTls#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VpcConnectivityTls.Builder#build()} is called immediately and its
         * result is passed to {@link #tls(VpcConnectivityTls)}.
         * 
         * @param tls
         *        a consumer that will call methods on {@link VpcConnectivityTls.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tls(VpcConnectivityTls)
         */
        default Builder tls(Consumer<VpcConnectivityTls.Builder> tls) {
            return tls(VpcConnectivityTls.builder().applyMutation(tls).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private VpcConnectivitySasl sasl;

        private VpcConnectivityTls tls;

        private BuilderImpl() {
        }

        private BuilderImpl(VpcConnectivityClientAuthentication model) {
            sasl(model.sasl);
            tls(model.tls);
        }

        public final VpcConnectivitySasl.Builder getSasl() {
            return sasl != null ? sasl.toBuilder() : null;
        }

        public final void setSasl(VpcConnectivitySasl.BuilderImpl sasl) {
            this.sasl = sasl != null ? sasl.build() : null;
        }

        @Override
        public final Builder sasl(VpcConnectivitySasl sasl) {
            this.sasl = sasl;
            return this;
        }

        public final VpcConnectivityTls.Builder getTls() {
            return tls != null ? tls.toBuilder() : null;
        }

        public final void setTls(VpcConnectivityTls.BuilderImpl tls) {
            this.tls = tls != null ? tls.build() : null;
        }

        @Override
        public final Builder tls(VpcConnectivityTls tls) {
            this.tls = tls;
            return this;
        }

        @Override
        public VpcConnectivityClientAuthentication build() {
            return new VpcConnectivityClientAuthentication(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
