/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kafka.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 *
 * <p>
 * Includes identification info about the topic.
 * </p>
 * 
 */
@Generated("software.amazon.awssdk:codegen")
public final class TopicInfo implements SdkPojo, Serializable, ToCopyableBuilder<TopicInfo.Builder, TopicInfo> {
    private static final SdkField<String> TOPIC_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TopicArn").getter(getter(TopicInfo::topicArn)).setter(setter(Builder::topicArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("topicArn").build()).build();

    private static final SdkField<String> TOPIC_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TopicName").getter(getter(TopicInfo::topicName)).setter(setter(Builder::topicName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("topicName").build()).build();

    private static final SdkField<Integer> REPLICATION_FACTOR_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ReplicationFactor").getter(getter(TopicInfo::replicationFactor))
            .setter(setter(Builder::replicationFactor))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("replicationFactor").build()).build();

    private static final SdkField<Integer> PARTITION_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("PartitionCount").getter(getter(TopicInfo::partitionCount)).setter(setter(Builder::partitionCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("partitionCount").build()).build();

    private static final SdkField<Integer> OUT_OF_SYNC_REPLICA_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("OutOfSyncReplicaCount").getter(getter(TopicInfo::outOfSyncReplicaCount))
            .setter(setter(Builder::outOfSyncReplicaCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outOfSyncReplicaCount").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TOPIC_ARN_FIELD,
            TOPIC_NAME_FIELD, REPLICATION_FACTOR_FIELD, PARTITION_COUNT_FIELD, OUT_OF_SYNC_REPLICA_COUNT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String topicArn;

    private final String topicName;

    private final Integer replicationFactor;

    private final Integer partitionCount;

    private final Integer outOfSyncReplicaCount;

    private TopicInfo(BuilderImpl builder) {
        this.topicArn = builder.topicArn;
        this.topicName = builder.topicName;
        this.replicationFactor = builder.replicationFactor;
        this.partitionCount = builder.partitionCount;
        this.outOfSyncReplicaCount = builder.outOfSyncReplicaCount;
    }

    /**
     *
     * <p>
     * The Amazon Resource Name (ARN) of the topic.
     * </p>
     * 
     * @return <p>
     *         The Amazon Resource Name (ARN) of the topic.
     *         </p>
     */
    public final String topicArn() {
        return topicArn;
    }

    /**
     *
     * <p>
     * Name for a topic.
     * </p>
     * 
     * @return <p>
     *         Name for a topic.
     *         </p>
     */
    public final String topicName() {
        return topicName;
    }

    /**
     *
     * <p>
     * Replication factor for a topic.
     * </p>
     * 
     * @return <p>
     *         Replication factor for a topic.
     *         </p>
     */
    public final Integer replicationFactor() {
        return replicationFactor;
    }

    /**
     *
     * <p>
     * Partition count for a topic.
     * </p>
     * 
     * @return <p>
     *         Partition count for a topic.
     *         </p>
     */
    public final Integer partitionCount() {
        return partitionCount;
    }

    /**
     *
     * <p>
     * Number of out-of-sync replicas for a topic.
     * </p>
     * 
     * @return <p>
     *         Number of out-of-sync replicas for a topic.
     *         </p>
     */
    public final Integer outOfSyncReplicaCount() {
        return outOfSyncReplicaCount;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(topicArn());
        hashCode = 31 * hashCode + Objects.hashCode(topicName());
        hashCode = 31 * hashCode + Objects.hashCode(replicationFactor());
        hashCode = 31 * hashCode + Objects.hashCode(partitionCount());
        hashCode = 31 * hashCode + Objects.hashCode(outOfSyncReplicaCount());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TopicInfo)) {
            return false;
        }
        TopicInfo other = (TopicInfo) obj;
        return Objects.equals(topicArn(), other.topicArn()) && Objects.equals(topicName(), other.topicName())
                && Objects.equals(replicationFactor(), other.replicationFactor())
                && Objects.equals(partitionCount(), other.partitionCount())
                && Objects.equals(outOfSyncReplicaCount(), other.outOfSyncReplicaCount());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TopicInfo").add("TopicArn", topicArn()).add("TopicName", topicName())
                .add("ReplicationFactor", replicationFactor()).add("PartitionCount", partitionCount())
                .add("OutOfSyncReplicaCount", outOfSyncReplicaCount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TopicArn":
            return Optional.ofNullable(clazz.cast(topicArn()));
        case "TopicName":
            return Optional.ofNullable(clazz.cast(topicName()));
        case "ReplicationFactor":
            return Optional.ofNullable(clazz.cast(replicationFactor()));
        case "PartitionCount":
            return Optional.ofNullable(clazz.cast(partitionCount()));
        case "OutOfSyncReplicaCount":
            return Optional.ofNullable(clazz.cast(outOfSyncReplicaCount()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("topicArn", TOPIC_ARN_FIELD);
        map.put("topicName", TOPIC_NAME_FIELD);
        map.put("replicationFactor", REPLICATION_FACTOR_FIELD);
        map.put("partitionCount", PARTITION_COUNT_FIELD);
        map.put("outOfSyncReplicaCount", OUT_OF_SYNC_REPLICA_COUNT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TopicInfo, T> g) {
        return obj -> g.apply((TopicInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TopicInfo> {
        /**
         *
         * <p>
         * The Amazon Resource Name (ARN) of the topic.
         * </p>
         * 
         * @param topicArn
         *        <p>
         *        The Amazon Resource Name (ARN) of the topic.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder topicArn(String topicArn);

        /**
         *
         * <p>
         * Name for a topic.
         * </p>
         * 
         * @param topicName
         *        <p>
         *        Name for a topic.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder topicName(String topicName);

        /**
         *
         * <p>
         * Replication factor for a topic.
         * </p>
         * 
         * @param replicationFactor
         *        <p>
         *        Replication factor for a topic.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicationFactor(Integer replicationFactor);

        /**
         *
         * <p>
         * Partition count for a topic.
         * </p>
         * 
         * @param partitionCount
         *        <p>
         *        Partition count for a topic.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder partitionCount(Integer partitionCount);

        /**
         *
         * <p>
         * Number of out-of-sync replicas for a topic.
         * </p>
         * 
         * @param outOfSyncReplicaCount
         *        <p>
         *        Number of out-of-sync replicas for a topic.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outOfSyncReplicaCount(Integer outOfSyncReplicaCount);
    }

    static final class BuilderImpl implements Builder {
        private String topicArn;

        private String topicName;

        private Integer replicationFactor;

        private Integer partitionCount;

        private Integer outOfSyncReplicaCount;

        private BuilderImpl() {
        }

        private BuilderImpl(TopicInfo model) {
            topicArn(model.topicArn);
            topicName(model.topicName);
            replicationFactor(model.replicationFactor);
            partitionCount(model.partitionCount);
            outOfSyncReplicaCount(model.outOfSyncReplicaCount);
        }

        public final String getTopicArn() {
            return topicArn;
        }

        public final void setTopicArn(String topicArn) {
            this.topicArn = topicArn;
        }

        @Override
        public final Builder topicArn(String topicArn) {
            this.topicArn = topicArn;
            return this;
        }

        public final String getTopicName() {
            return topicName;
        }

        public final void setTopicName(String topicName) {
            this.topicName = topicName;
        }

        @Override
        public final Builder topicName(String topicName) {
            this.topicName = topicName;
            return this;
        }

        public final Integer getReplicationFactor() {
            return replicationFactor;
        }

        public final void setReplicationFactor(Integer replicationFactor) {
            this.replicationFactor = replicationFactor;
        }

        @Override
        public final Builder replicationFactor(Integer replicationFactor) {
            this.replicationFactor = replicationFactor;
            return this;
        }

        public final Integer getPartitionCount() {
            return partitionCount;
        }

        public final void setPartitionCount(Integer partitionCount) {
            this.partitionCount = partitionCount;
        }

        @Override
        public final Builder partitionCount(Integer partitionCount) {
            this.partitionCount = partitionCount;
            return this;
        }

        public final Integer getOutOfSyncReplicaCount() {
            return outOfSyncReplicaCount;
        }

        public final void setOutOfSyncReplicaCount(Integer outOfSyncReplicaCount) {
            this.outOfSyncReplicaCount = outOfSyncReplicaCount;
        }

        @Override
        public final Builder outOfSyncReplicaCount(Integer outOfSyncReplicaCount) {
            this.outOfSyncReplicaCount = outOfSyncReplicaCount;
            return this;
        }

        @Override
        public TopicInfo build() {
            return new TopicInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
