/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kafka.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BrokerLogs implements SdkPojo, Serializable, ToCopyableBuilder<BrokerLogs.Builder, BrokerLogs> {
    private static final SdkField<CloudWatchLogs> CLOUD_WATCH_LOGS_FIELD = SdkField
            .<CloudWatchLogs> builder(MarshallingType.SDK_POJO).memberName("CloudWatchLogs")
            .getter(getter(BrokerLogs::cloudWatchLogs)).setter(setter(Builder::cloudWatchLogs))
            .constructor(CloudWatchLogs::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cloudWatchLogs").build()).build();

    private static final SdkField<Firehose> FIREHOSE_FIELD = SdkField.<Firehose> builder(MarshallingType.SDK_POJO)
            .memberName("Firehose").getter(getter(BrokerLogs::firehose)).setter(setter(Builder::firehose))
            .constructor(Firehose::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("firehose").build()).build();

    private static final SdkField<S3> S3_FIELD = SdkField.<S3> builder(MarshallingType.SDK_POJO).memberName("S3")
            .getter(getter(BrokerLogs::s3)).setter(setter(Builder::s3)).constructor(S3::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLOUD_WATCH_LOGS_FIELD,
            FIREHOSE_FIELD, S3_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final CloudWatchLogs cloudWatchLogs;

    private final Firehose firehose;

    private final S3 s3;

    private BrokerLogs(BuilderImpl builder) {
        this.cloudWatchLogs = builder.cloudWatchLogs;
        this.firehose = builder.firehose;
        this.s3 = builder.s3;
    }

    /**
     * Returns the value of the CloudWatchLogs property for this object.
     * 
     * @return The value of the CloudWatchLogs property for this object.
     */
    public final CloudWatchLogs cloudWatchLogs() {
        return cloudWatchLogs;
    }

    /**
     * Returns the value of the Firehose property for this object.
     * 
     * @return The value of the Firehose property for this object.
     */
    public final Firehose firehose() {
        return firehose;
    }

    /**
     * Returns the value of the S3 property for this object.
     * 
     * @return The value of the S3 property for this object.
     */
    public final S3 s3() {
        return s3;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(cloudWatchLogs());
        hashCode = 31 * hashCode + Objects.hashCode(firehose());
        hashCode = 31 * hashCode + Objects.hashCode(s3());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BrokerLogs)) {
            return false;
        }
        BrokerLogs other = (BrokerLogs) obj;
        return Objects.equals(cloudWatchLogs(), other.cloudWatchLogs()) && Objects.equals(firehose(), other.firehose())
                && Objects.equals(s3(), other.s3());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BrokerLogs").add("CloudWatchLogs", cloudWatchLogs()).add("Firehose", firehose()).add("S3", s3())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CloudWatchLogs":
            return Optional.ofNullable(clazz.cast(cloudWatchLogs()));
        case "Firehose":
            return Optional.ofNullable(clazz.cast(firehose()));
        case "S3":
            return Optional.ofNullable(clazz.cast(s3()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("cloudWatchLogs", CLOUD_WATCH_LOGS_FIELD);
        map.put("firehose", FIREHOSE_FIELD);
        map.put("s3", S3_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BrokerLogs, T> g) {
        return obj -> g.apply((BrokerLogs) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BrokerLogs> {
        /**
         * Sets the value of the CloudWatchLogs property for this object.
         *
         * @param cloudWatchLogs
         *        The new value for the CloudWatchLogs property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudWatchLogs(CloudWatchLogs cloudWatchLogs);

        /**
         * Sets the value of the CloudWatchLogs property for this object.
         *
         * This is a convenience method that creates an instance of the {@link CloudWatchLogs.Builder} avoiding the need
         * to create one manually via {@link CloudWatchLogs#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CloudWatchLogs.Builder#build()} is called immediately and its
         * result is passed to {@link #cloudWatchLogs(CloudWatchLogs)}.
         * 
         * @param cloudWatchLogs
         *        a consumer that will call methods on {@link CloudWatchLogs.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cloudWatchLogs(CloudWatchLogs)
         */
        default Builder cloudWatchLogs(Consumer<CloudWatchLogs.Builder> cloudWatchLogs) {
            return cloudWatchLogs(CloudWatchLogs.builder().applyMutation(cloudWatchLogs).build());
        }

        /**
         * Sets the value of the Firehose property for this object.
         *
         * @param firehose
         *        The new value for the Firehose property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder firehose(Firehose firehose);

        /**
         * Sets the value of the Firehose property for this object.
         *
         * This is a convenience method that creates an instance of the {@link Firehose.Builder} avoiding the need to
         * create one manually via {@link Firehose#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Firehose.Builder#build()} is called immediately and its result is
         * passed to {@link #firehose(Firehose)}.
         * 
         * @param firehose
         *        a consumer that will call methods on {@link Firehose.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #firehose(Firehose)
         */
        default Builder firehose(Consumer<Firehose.Builder> firehose) {
            return firehose(Firehose.builder().applyMutation(firehose).build());
        }

        /**
         * Sets the value of the S3 property for this object.
         *
         * @param s3
         *        The new value for the S3 property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3(S3 s3);

        /**
         * Sets the value of the S3 property for this object.
         *
         * This is a convenience method that creates an instance of the {@link S3.Builder} avoiding the need to create
         * one manually via {@link S3#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link S3.Builder#build()} is called immediately and its result is
         * passed to {@link #s3(S3)}.
         * 
         * @param s3
         *        a consumer that will call methods on {@link S3.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3(S3)
         */
        default Builder s3(Consumer<S3.Builder> s3) {
            return s3(S3.builder().applyMutation(s3).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private CloudWatchLogs cloudWatchLogs;

        private Firehose firehose;

        private S3 s3;

        private BuilderImpl() {
        }

        private BuilderImpl(BrokerLogs model) {
            cloudWatchLogs(model.cloudWatchLogs);
            firehose(model.firehose);
            s3(model.s3);
        }

        public final CloudWatchLogs.Builder getCloudWatchLogs() {
            return cloudWatchLogs != null ? cloudWatchLogs.toBuilder() : null;
        }

        public final void setCloudWatchLogs(CloudWatchLogs.BuilderImpl cloudWatchLogs) {
            this.cloudWatchLogs = cloudWatchLogs != null ? cloudWatchLogs.build() : null;
        }

        @Override
        public final Builder cloudWatchLogs(CloudWatchLogs cloudWatchLogs) {
            this.cloudWatchLogs = cloudWatchLogs;
            return this;
        }

        public final Firehose.Builder getFirehose() {
            return firehose != null ? firehose.toBuilder() : null;
        }

        public final void setFirehose(Firehose.BuilderImpl firehose) {
            this.firehose = firehose != null ? firehose.build() : null;
        }

        @Override
        public final Builder firehose(Firehose firehose) {
            this.firehose = firehose;
            return this;
        }

        public final S3.Builder getS3() {
            return s3 != null ? s3.toBuilder() : null;
        }

        public final void setS3(S3.BuilderImpl s3) {
            this.s3 = s3 != null ? s3.build() : null;
        }

        @Override
        public final Builder s3(S3 s3) {
            this.s3 = s3;
            return this;
        }

        @Override
        public BrokerLogs build() {
            return new BrokerLogs(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
