/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kafka.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.kafka.model.ClientBroker;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EncryptionInTransit
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EncryptionInTransit> {
    private static final SdkField<String> CLIENT_BROKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientBroker").getter(EncryptionInTransit.getter(EncryptionInTransit::clientBrokerAsString)).setter(EncryptionInTransit.setter(Builder::clientBroker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientBroker").build()}).build();
    private static final SdkField<Boolean> IN_CLUSTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("InCluster").getter(EncryptionInTransit.getter(EncryptionInTransit::inCluster)).setter(EncryptionInTransit.setter(Builder::inCluster)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inCluster").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_BROKER_FIELD, IN_CLUSTER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = EncryptionInTransit.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String clientBroker;
    private final Boolean inCluster;

    private EncryptionInTransit(BuilderImpl builder) {
        this.clientBroker = builder.clientBroker;
        this.inCluster = builder.inCluster;
    }

    public final ClientBroker clientBroker() {
        return ClientBroker.fromValue(this.clientBroker);
    }

    public final String clientBrokerAsString() {
        return this.clientBroker;
    }

    public final Boolean inCluster() {
        return this.inCluster;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.clientBrokerAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.inCluster());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EncryptionInTransit)) {
            return false;
        }
        EncryptionInTransit other = (EncryptionInTransit)obj;
        return Objects.equals(this.clientBrokerAsString(), other.clientBrokerAsString()) && Objects.equals(this.inCluster(), other.inCluster());
    }

    public final String toString() {
        return ToString.builder((String)"EncryptionInTransit").add("ClientBroker", (Object)this.clientBrokerAsString()).add("InCluster", (Object)this.inCluster()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClientBroker": {
                return Optional.ofNullable(clazz.cast(this.clientBrokerAsString()));
            }
            case "InCluster": {
                return Optional.ofNullable(clazz.cast(this.inCluster()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("clientBroker", CLIENT_BROKER_FIELD);
        map.put("inCluster", IN_CLUSTER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EncryptionInTransit, T> g) {
        return obj -> g.apply((EncryptionInTransit)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String clientBroker;
        private Boolean inCluster;

        private BuilderImpl() {
        }

        private BuilderImpl(EncryptionInTransit model) {
            this.clientBroker(model.clientBroker);
            this.inCluster(model.inCluster);
        }

        public final String getClientBroker() {
            return this.clientBroker;
        }

        public final void setClientBroker(String clientBroker) {
            this.clientBroker = clientBroker;
        }

        @Override
        public final Builder clientBroker(String clientBroker) {
            this.clientBroker = clientBroker;
            return this;
        }

        @Override
        public final Builder clientBroker(ClientBroker clientBroker) {
            this.clientBroker(clientBroker == null ? null : clientBroker.toString());
            return this;
        }

        public final Boolean getInCluster() {
            return this.inCluster;
        }

        public final void setInCluster(Boolean inCluster) {
            this.inCluster = inCluster;
        }

        @Override
        public final Builder inCluster(Boolean inCluster) {
            this.inCluster = inCluster;
            return this;
        }

        public EncryptionInTransit build() {
            return new EncryptionInTransit(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EncryptionInTransit> {
        public Builder clientBroker(String var1);

        public Builder clientBroker(ClientBroker var1);

        public Builder inCluster(Boolean var1);
    }
}

