/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kafka.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.kafka.model.KafkaRequest;
import software.amazon.awssdk.services.kafka.model.___listOf__stringCopier;
import software.amazon.awssdk.services.kafka.model.___mapOf__stringCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateVpcConnectionRequest
extends KafkaRequest
implements ToCopyableBuilder<Builder, CreateVpcConnectionRequest> {
    private static final SdkField<String> TARGET_CLUSTER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TargetClusterArn").getter(CreateVpcConnectionRequest.getter(CreateVpcConnectionRequest::targetClusterArn)).setter(CreateVpcConnectionRequest.setter(Builder::targetClusterArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetClusterArn").build()}).build();
    private static final SdkField<String> AUTHENTICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Authentication").getter(CreateVpcConnectionRequest.getter(CreateVpcConnectionRequest::authentication)).setter(CreateVpcConnectionRequest.setter(Builder::authentication)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authentication").build()}).build();
    private static final SdkField<String> VPC_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VpcId").getter(CreateVpcConnectionRequest.getter(CreateVpcConnectionRequest::vpcId)).setter(CreateVpcConnectionRequest.setter(Builder::vpcId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpcId").build()}).build();
    private static final SdkField<List<String>> CLIENT_SUBNETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ClientSubnets").getter(CreateVpcConnectionRequest.getter(CreateVpcConnectionRequest::clientSubnets)).setter(CreateVpcConnectionRequest.setter(Builder::clientSubnets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientSubnets").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> SECURITY_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SecurityGroups").getter(CreateVpcConnectionRequest.getter(CreateVpcConnectionRequest::securityGroups)).setter(CreateVpcConnectionRequest.setter(Builder::securityGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("securityGroups").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(CreateVpcConnectionRequest.getter(CreateVpcConnectionRequest::tags)).setter(CreateVpcConnectionRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TARGET_CLUSTER_ARN_FIELD, AUTHENTICATION_FIELD, VPC_ID_FIELD, CLIENT_SUBNETS_FIELD, SECURITY_GROUPS_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateVpcConnectionRequest.memberNameToFieldInitializer();
    private final String targetClusterArn;
    private final String authentication;
    private final String vpcId;
    private final List<String> clientSubnets;
    private final List<String> securityGroups;
    private final Map<String, String> tags;

    private CreateVpcConnectionRequest(BuilderImpl builder) {
        super(builder);
        this.targetClusterArn = builder.targetClusterArn;
        this.authentication = builder.authentication;
        this.vpcId = builder.vpcId;
        this.clientSubnets = builder.clientSubnets;
        this.securityGroups = builder.securityGroups;
        this.tags = builder.tags;
    }

    public final String targetClusterArn() {
        return this.targetClusterArn;
    }

    public final String authentication() {
        return this.authentication;
    }

    public final String vpcId() {
        return this.vpcId;
    }

    public final boolean hasClientSubnets() {
        return this.clientSubnets != null && !(this.clientSubnets instanceof SdkAutoConstructList);
    }

    public final List<String> clientSubnets() {
        return this.clientSubnets;
    }

    public final boolean hasSecurityGroups() {
        return this.securityGroups != null && !(this.securityGroups instanceof SdkAutoConstructList);
    }

    public final List<String> securityGroups() {
        return this.securityGroups;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.targetClusterArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.authentication());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasClientSubnets() ? this.clientSubnets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSecurityGroups() ? this.securityGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateVpcConnectionRequest)) {
            return false;
        }
        CreateVpcConnectionRequest other = (CreateVpcConnectionRequest)((Object)obj);
        return Objects.equals(this.targetClusterArn(), other.targetClusterArn()) && Objects.equals(this.authentication(), other.authentication()) && Objects.equals(this.vpcId(), other.vpcId()) && this.hasClientSubnets() == other.hasClientSubnets() && Objects.equals(this.clientSubnets(), other.clientSubnets()) && this.hasSecurityGroups() == other.hasSecurityGroups() && Objects.equals(this.securityGroups(), other.securityGroups()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateVpcConnectionRequest").add("TargetClusterArn", (Object)this.targetClusterArn()).add("Authentication", (Object)this.authentication()).add("VpcId", (Object)this.vpcId()).add("ClientSubnets", this.hasClientSubnets() ? this.clientSubnets() : null).add("SecurityGroups", this.hasSecurityGroups() ? this.securityGroups() : null).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TargetClusterArn": {
                return Optional.ofNullable(clazz.cast(this.targetClusterArn()));
            }
            case "Authentication": {
                return Optional.ofNullable(clazz.cast(this.authentication()));
            }
            case "VpcId": {
                return Optional.ofNullable(clazz.cast(this.vpcId()));
            }
            case "ClientSubnets": {
                return Optional.ofNullable(clazz.cast(this.clientSubnets()));
            }
            case "SecurityGroups": {
                return Optional.ofNullable(clazz.cast(this.securityGroups()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("targetClusterArn", TARGET_CLUSTER_ARN_FIELD);
        map.put("authentication", AUTHENTICATION_FIELD);
        map.put("vpcId", VPC_ID_FIELD);
        map.put("clientSubnets", CLIENT_SUBNETS_FIELD);
        map.put("securityGroups", SECURITY_GROUPS_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateVpcConnectionRequest, T> g) {
        return obj -> g.apply((CreateVpcConnectionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends KafkaRequest.BuilderImpl
    implements Builder {
        private String targetClusterArn;
        private String authentication;
        private String vpcId;
        private List<String> clientSubnets = DefaultSdkAutoConstructList.getInstance();
        private List<String> securityGroups = DefaultSdkAutoConstructList.getInstance();
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateVpcConnectionRequest model) {
            super(model);
            this.targetClusterArn(model.targetClusterArn);
            this.authentication(model.authentication);
            this.vpcId(model.vpcId);
            this.clientSubnets(model.clientSubnets);
            this.securityGroups(model.securityGroups);
            this.tags(model.tags);
        }

        public final String getTargetClusterArn() {
            return this.targetClusterArn;
        }

        public final void setTargetClusterArn(String targetClusterArn) {
            this.targetClusterArn = targetClusterArn;
        }

        @Override
        public final Builder targetClusterArn(String targetClusterArn) {
            this.targetClusterArn = targetClusterArn;
            return this;
        }

        public final String getAuthentication() {
            return this.authentication;
        }

        public final void setAuthentication(String authentication) {
            this.authentication = authentication;
        }

        @Override
        public final Builder authentication(String authentication) {
            this.authentication = authentication;
            return this;
        }

        public final String getVpcId() {
            return this.vpcId;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final Collection<String> getClientSubnets() {
            if (this.clientSubnets instanceof SdkAutoConstructList) {
                return null;
            }
            return this.clientSubnets;
        }

        public final void setClientSubnets(Collection<String> clientSubnets) {
            this.clientSubnets = ___listOf__stringCopier.copy(clientSubnets);
        }

        @Override
        public final Builder clientSubnets(Collection<String> clientSubnets) {
            this.clientSubnets = ___listOf__stringCopier.copy(clientSubnets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clientSubnets(String ... clientSubnets) {
            this.clientSubnets(Arrays.asList(clientSubnets));
            return this;
        }

        public final Collection<String> getSecurityGroups() {
            if (this.securityGroups instanceof SdkAutoConstructList) {
                return null;
            }
            return this.securityGroups;
        }

        public final void setSecurityGroups(Collection<String> securityGroups) {
            this.securityGroups = ___listOf__stringCopier.copy(securityGroups);
        }

        @Override
        public final Builder securityGroups(Collection<String> securityGroups) {
            this.securityGroups = ___listOf__stringCopier.copy(securityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroups(String ... securityGroups) {
            this.securityGroups(Arrays.asList(securityGroups));
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = ___mapOf__stringCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = ___mapOf__stringCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateVpcConnectionRequest build() {
            return new CreateVpcConnectionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends KafkaRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateVpcConnectionRequest> {
        public Builder targetClusterArn(String var1);

        public Builder authentication(String var1);

        public Builder vpcId(String var1);

        public Builder clientSubnets(Collection<String> var1);

        public Builder clientSubnets(String ... var1);

        public Builder securityGroups(Collection<String> var1);

        public Builder securityGroups(String ... var1);

        public Builder tags(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

