/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kafka.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.kafka.model.KafkaRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateBrokerTypeRequest
extends KafkaRequest
implements ToCopyableBuilder<Builder, UpdateBrokerTypeRequest> {
    private static final SdkField<String> CLUSTER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClusterArn").getter(UpdateBrokerTypeRequest.getter(UpdateBrokerTypeRequest::clusterArn)).setter(UpdateBrokerTypeRequest.setter(Builder::clusterArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("clusterArn").build()}).build();
    private static final SdkField<String> CURRENT_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CurrentVersion").getter(UpdateBrokerTypeRequest.getter(UpdateBrokerTypeRequest::currentVersion)).setter(UpdateBrokerTypeRequest.setter(Builder::currentVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("currentVersion").build()}).build();
    private static final SdkField<String> TARGET_INSTANCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TargetInstanceType").getter(UpdateBrokerTypeRequest.getter(UpdateBrokerTypeRequest::targetInstanceType)).setter(UpdateBrokerTypeRequest.setter(Builder::targetInstanceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetInstanceType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_ARN_FIELD, CURRENT_VERSION_FIELD, TARGET_INSTANCE_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateBrokerTypeRequest.memberNameToFieldInitializer();
    private final String clusterArn;
    private final String currentVersion;
    private final String targetInstanceType;

    private UpdateBrokerTypeRequest(BuilderImpl builder) {
        super(builder);
        this.clusterArn = builder.clusterArn;
        this.currentVersion = builder.currentVersion;
        this.targetInstanceType = builder.targetInstanceType;
    }

    public final String clusterArn() {
        return this.clusterArn;
    }

    public final String currentVersion() {
        return this.currentVersion;
    }

    public final String targetInstanceType() {
        return this.targetInstanceType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.currentVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetInstanceType());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateBrokerTypeRequest)) {
            return false;
        }
        UpdateBrokerTypeRequest other = (UpdateBrokerTypeRequest)((Object)obj);
        return Objects.equals(this.clusterArn(), other.clusterArn()) && Objects.equals(this.currentVersion(), other.currentVersion()) && Objects.equals(this.targetInstanceType(), other.targetInstanceType());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateBrokerTypeRequest").add("ClusterArn", (Object)this.clusterArn()).add("CurrentVersion", (Object)this.currentVersion()).add("TargetInstanceType", (Object)this.targetInstanceType()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClusterArn": {
                return Optional.ofNullable(clazz.cast(this.clusterArn()));
            }
            case "CurrentVersion": {
                return Optional.ofNullable(clazz.cast(this.currentVersion()));
            }
            case "TargetInstanceType": {
                return Optional.ofNullable(clazz.cast(this.targetInstanceType()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("clusterArn", CLUSTER_ARN_FIELD);
        map.put("currentVersion", CURRENT_VERSION_FIELD);
        map.put("targetInstanceType", TARGET_INSTANCE_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateBrokerTypeRequest, T> g) {
        return obj -> g.apply((UpdateBrokerTypeRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends KafkaRequest.BuilderImpl
    implements Builder {
        private String clusterArn;
        private String currentVersion;
        private String targetInstanceType;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateBrokerTypeRequest model) {
            super(model);
            this.clusterArn(model.clusterArn);
            this.currentVersion(model.currentVersion);
            this.targetInstanceType(model.targetInstanceType);
        }

        public final String getClusterArn() {
            return this.clusterArn;
        }

        public final void setClusterArn(String clusterArn) {
            this.clusterArn = clusterArn;
        }

        @Override
        public final Builder clusterArn(String clusterArn) {
            this.clusterArn = clusterArn;
            return this;
        }

        public final String getCurrentVersion() {
            return this.currentVersion;
        }

        public final void setCurrentVersion(String currentVersion) {
            this.currentVersion = currentVersion;
        }

        @Override
        public final Builder currentVersion(String currentVersion) {
            this.currentVersion = currentVersion;
            return this;
        }

        public final String getTargetInstanceType() {
            return this.targetInstanceType;
        }

        public final void setTargetInstanceType(String targetInstanceType) {
            this.targetInstanceType = targetInstanceType;
        }

        @Override
        public final Builder targetInstanceType(String targetInstanceType) {
            this.targetInstanceType = targetInstanceType;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateBrokerTypeRequest build() {
            return new UpdateBrokerTypeRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends KafkaRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateBrokerTypeRequest> {
        public Builder clusterArn(String var1);

        public Builder currentVersion(String var1);

        public Builder targetInstanceType(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

