/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kafka.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.kafka.model.ClusterState;
import software.amazon.awssdk.services.kafka.model.ClusterType;
import software.amazon.awssdk.services.kafka.model.Provisioned;
import software.amazon.awssdk.services.kafka.model.Serverless;
import software.amazon.awssdk.services.kafka.model.StateInfo;
import software.amazon.awssdk.services.kafka.model.___mapOf__stringCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Cluster
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Cluster> {
    private static final SdkField<String> ACTIVE_OPERATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ActiveOperationArn").getter(Cluster.getter(Cluster::activeOperationArn)).setter(Cluster.setter(Builder::activeOperationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("activeOperationArn").build()}).build();
    private static final SdkField<String> CLUSTER_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClusterType").getter(Cluster.getter(Cluster::clusterTypeAsString)).setter(Cluster.setter(Builder::clusterType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clusterType").build()}).build();
    private static final SdkField<String> CLUSTER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClusterArn").getter(Cluster.getter(Cluster::clusterArn)).setter(Cluster.setter(Builder::clusterArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clusterArn").build()}).build();
    private static final SdkField<String> CLUSTER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClusterName").getter(Cluster.getter(Cluster::clusterName)).setter(Cluster.setter(Builder::clusterName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clusterName").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(Cluster.getter(Cluster::creationTime)).setter(Cluster.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> CURRENT_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CurrentVersion").getter(Cluster.getter(Cluster::currentVersion)).setter(Cluster.setter(Builder::currentVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("currentVersion").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(Cluster.getter(Cluster::stateAsString)).setter(Cluster.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()}).build();
    private static final SdkField<StateInfo> STATE_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("StateInfo").getter(Cluster.getter(Cluster::stateInfo)).setter(Cluster.setter(Builder::stateInfo)).constructor(StateInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stateInfo").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(Cluster.getter(Cluster::tags)).setter(Cluster.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Provisioned> PROVISIONED_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Provisioned").getter(Cluster.getter(Cluster::provisioned)).setter(Cluster.setter(Builder::provisioned)).constructor(Provisioned::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("provisioned").build()}).build();
    private static final SdkField<Serverless> SERVERLESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Serverless").getter(Cluster.getter(Cluster::serverless)).setter(Cluster.setter(Builder::serverless)).constructor(Serverless::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serverless").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTIVE_OPERATION_ARN_FIELD, CLUSTER_TYPE_FIELD, CLUSTER_ARN_FIELD, CLUSTER_NAME_FIELD, CREATION_TIME_FIELD, CURRENT_VERSION_FIELD, STATE_FIELD, STATE_INFO_FIELD, TAGS_FIELD, PROVISIONED_FIELD, SERVERLESS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("activeOperationArn", ACTIVE_OPERATION_ARN_FIELD);
            this.put("clusterType", CLUSTER_TYPE_FIELD);
            this.put("clusterArn", CLUSTER_ARN_FIELD);
            this.put("clusterName", CLUSTER_NAME_FIELD);
            this.put("creationTime", CREATION_TIME_FIELD);
            this.put("currentVersion", CURRENT_VERSION_FIELD);
            this.put("state", STATE_FIELD);
            this.put("stateInfo", STATE_INFO_FIELD);
            this.put("tags", TAGS_FIELD);
            this.put("provisioned", PROVISIONED_FIELD);
            this.put("serverless", SERVERLESS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String activeOperationArn;
    private final String clusterType;
    private final String clusterArn;
    private final String clusterName;
    private final Instant creationTime;
    private final String currentVersion;
    private final String state;
    private final StateInfo stateInfo;
    private final Map<String, String> tags;
    private final Provisioned provisioned;
    private final Serverless serverless;

    private Cluster(BuilderImpl builder) {
        this.activeOperationArn = builder.activeOperationArn;
        this.clusterType = builder.clusterType;
        this.clusterArn = builder.clusterArn;
        this.clusterName = builder.clusterName;
        this.creationTime = builder.creationTime;
        this.currentVersion = builder.currentVersion;
        this.state = builder.state;
        this.stateInfo = builder.stateInfo;
        this.tags = builder.tags;
        this.provisioned = builder.provisioned;
        this.serverless = builder.serverless;
    }

    public final String activeOperationArn() {
        return this.activeOperationArn;
    }

    public final ClusterType clusterType() {
        return ClusterType.fromValue(this.clusterType);
    }

    public final String clusterTypeAsString() {
        return this.clusterType;
    }

    public final String clusterArn() {
        return this.clusterArn;
    }

    public final String clusterName() {
        return this.clusterName;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final String currentVersion() {
        return this.currentVersion;
    }

    public final ClusterState state() {
        return ClusterState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final StateInfo stateInfo() {
        return this.stateInfo;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final Provisioned provisioned() {
        return this.provisioned;
    }

    public final Serverless serverless() {
        return this.serverless;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.activeOperationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterName());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.currentVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateInfo());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.provisioned());
        hashCode = 31 * hashCode + Objects.hashCode(this.serverless());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Cluster)) {
            return false;
        }
        Cluster other = (Cluster)obj;
        return Objects.equals(this.activeOperationArn(), other.activeOperationArn()) && Objects.equals(this.clusterTypeAsString(), other.clusterTypeAsString()) && Objects.equals(this.clusterArn(), other.clusterArn()) && Objects.equals(this.clusterName(), other.clusterName()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.currentVersion(), other.currentVersion()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.stateInfo(), other.stateInfo()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.provisioned(), other.provisioned()) && Objects.equals(this.serverless(), other.serverless());
    }

    public final String toString() {
        return ToString.builder((String)"Cluster").add("ActiveOperationArn", (Object)this.activeOperationArn()).add("ClusterType", (Object)this.clusterTypeAsString()).add("ClusterArn", (Object)this.clusterArn()).add("ClusterName", (Object)this.clusterName()).add("CreationTime", (Object)this.creationTime()).add("CurrentVersion", (Object)this.currentVersion()).add("State", (Object)this.stateAsString()).add("StateInfo", (Object)this.stateInfo()).add("Tags", this.hasTags() ? this.tags() : null).add("Provisioned", (Object)this.provisioned()).add("Serverless", (Object)this.serverless()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ActiveOperationArn": {
                return Optional.ofNullable(clazz.cast(this.activeOperationArn()));
            }
            case "ClusterType": {
                return Optional.ofNullable(clazz.cast(this.clusterTypeAsString()));
            }
            case "ClusterArn": {
                return Optional.ofNullable(clazz.cast(this.clusterArn()));
            }
            case "ClusterName": {
                return Optional.ofNullable(clazz.cast(this.clusterName()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "CurrentVersion": {
                return Optional.ofNullable(clazz.cast(this.currentVersion()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "StateInfo": {
                return Optional.ofNullable(clazz.cast(this.stateInfo()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "Provisioned": {
                return Optional.ofNullable(clazz.cast(this.provisioned()));
            }
            case "Serverless": {
                return Optional.ofNullable(clazz.cast(this.serverless()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<Cluster, T> g) {
        return obj -> g.apply((Cluster)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String activeOperationArn;
        private String clusterType;
        private String clusterArn;
        private String clusterName;
        private Instant creationTime;
        private String currentVersion;
        private String state;
        private StateInfo stateInfo;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private Provisioned provisioned;
        private Serverless serverless;

        private BuilderImpl() {
        }

        private BuilderImpl(Cluster model) {
            this.activeOperationArn(model.activeOperationArn);
            this.clusterType(model.clusterType);
            this.clusterArn(model.clusterArn);
            this.clusterName(model.clusterName);
            this.creationTime(model.creationTime);
            this.currentVersion(model.currentVersion);
            this.state(model.state);
            this.stateInfo(model.stateInfo);
            this.tags(model.tags);
            this.provisioned(model.provisioned);
            this.serverless(model.serverless);
        }

        public final String getActiveOperationArn() {
            return this.activeOperationArn;
        }

        public final void setActiveOperationArn(String activeOperationArn) {
            this.activeOperationArn = activeOperationArn;
        }

        @Override
        public final Builder activeOperationArn(String activeOperationArn) {
            this.activeOperationArn = activeOperationArn;
            return this;
        }

        public final String getClusterType() {
            return this.clusterType;
        }

        public final void setClusterType(String clusterType) {
            this.clusterType = clusterType;
        }

        @Override
        public final Builder clusterType(String clusterType) {
            this.clusterType = clusterType;
            return this;
        }

        @Override
        public final Builder clusterType(ClusterType clusterType) {
            this.clusterType(clusterType == null ? null : clusterType.toString());
            return this;
        }

        public final String getClusterArn() {
            return this.clusterArn;
        }

        public final void setClusterArn(String clusterArn) {
            this.clusterArn = clusterArn;
        }

        @Override
        public final Builder clusterArn(String clusterArn) {
            this.clusterArn = clusterArn;
            return this;
        }

        public final String getClusterName() {
            return this.clusterName;
        }

        public final void setClusterName(String clusterName) {
            this.clusterName = clusterName;
        }

        @Override
        public final Builder clusterName(String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final String getCurrentVersion() {
            return this.currentVersion;
        }

        public final void setCurrentVersion(String currentVersion) {
            this.currentVersion = currentVersion;
        }

        @Override
        public final Builder currentVersion(String currentVersion) {
            this.currentVersion = currentVersion;
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(ClusterState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final StateInfo.Builder getStateInfo() {
            return this.stateInfo != null ? this.stateInfo.toBuilder() : null;
        }

        public final void setStateInfo(StateInfo.BuilderImpl stateInfo) {
            this.stateInfo = stateInfo != null ? stateInfo.build() : null;
        }

        @Override
        public final Builder stateInfo(StateInfo stateInfo) {
            this.stateInfo = stateInfo;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = ___mapOf__stringCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = ___mapOf__stringCopier.copy(tags);
            return this;
        }

        public final Provisioned.Builder getProvisioned() {
            return this.provisioned != null ? this.provisioned.toBuilder() : null;
        }

        public final void setProvisioned(Provisioned.BuilderImpl provisioned) {
            this.provisioned = provisioned != null ? provisioned.build() : null;
        }

        @Override
        public final Builder provisioned(Provisioned provisioned) {
            this.provisioned = provisioned;
            return this;
        }

        public final Serverless.Builder getServerless() {
            return this.serverless != null ? this.serverless.toBuilder() : null;
        }

        public final void setServerless(Serverless.BuilderImpl serverless) {
            this.serverless = serverless != null ? serverless.build() : null;
        }

        @Override
        public final Builder serverless(Serverless serverless) {
            this.serverless = serverless;
            return this;
        }

        public Cluster build() {
            return new Cluster(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Cluster> {
        public Builder activeOperationArn(String var1);

        public Builder clusterType(String var1);

        public Builder clusterType(ClusterType var1);

        public Builder clusterArn(String var1);

        public Builder clusterName(String var1);

        public Builder creationTime(Instant var1);

        public Builder currentVersion(String var1);

        public Builder state(String var1);

        public Builder state(ClusterState var1);

        public Builder stateInfo(StateInfo var1);

        default public Builder stateInfo(Consumer<StateInfo.Builder> stateInfo) {
            return this.stateInfo((StateInfo)((StateInfo.Builder)StateInfo.builder().applyMutation(stateInfo)).build());
        }

        public Builder tags(Map<String, String> var1);

        public Builder provisioned(Provisioned var1);

        default public Builder provisioned(Consumer<Provisioned.Builder> provisioned) {
            return this.provisioned((Provisioned)((Provisioned.Builder)Provisioned.builder().applyMutation(provisioned)).build());
        }

        public Builder serverless(Serverless var1);

        default public Builder serverless(Consumer<Serverless.Builder> serverless) {
            return this.serverless((Serverless)((Serverless.Builder)Serverless.builder().applyMutation(serverless)).build());
        }
    }
}

