/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kafka.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.kafka.model.___listOf__stringMax249Copier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TopicReplicationUpdate
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TopicReplicationUpdate> {
    private static final SdkField<Boolean> COPY_ACCESS_CONTROL_LISTS_FOR_TOPICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("CopyAccessControlListsForTopics").getter(TopicReplicationUpdate.getter(TopicReplicationUpdate::copyAccessControlListsForTopics)).setter(TopicReplicationUpdate.setter(Builder::copyAccessControlListsForTopics)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("copyAccessControlListsForTopics").build()}).build();
    private static final SdkField<Boolean> COPY_TOPIC_CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("CopyTopicConfigurations").getter(TopicReplicationUpdate.getter(TopicReplicationUpdate::copyTopicConfigurations)).setter(TopicReplicationUpdate.setter(Builder::copyTopicConfigurations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("copyTopicConfigurations").build()}).build();
    private static final SdkField<Boolean> DETECT_AND_COPY_NEW_TOPICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DetectAndCopyNewTopics").getter(TopicReplicationUpdate.getter(TopicReplicationUpdate::detectAndCopyNewTopics)).setter(TopicReplicationUpdate.setter(Builder::detectAndCopyNewTopics)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("detectAndCopyNewTopics").build()}).build();
    private static final SdkField<List<String>> TOPICS_TO_EXCLUDE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TopicsToExclude").getter(TopicReplicationUpdate.getter(TopicReplicationUpdate::topicsToExclude)).setter(TopicReplicationUpdate.setter(Builder::topicsToExclude)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("topicsToExclude").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> TOPICS_TO_REPLICATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TopicsToReplicate").getter(TopicReplicationUpdate.getter(TopicReplicationUpdate::topicsToReplicate)).setter(TopicReplicationUpdate.setter(Builder::topicsToReplicate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("topicsToReplicate").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COPY_ACCESS_CONTROL_LISTS_FOR_TOPICS_FIELD, COPY_TOPIC_CONFIGURATIONS_FIELD, DETECT_AND_COPY_NEW_TOPICS_FIELD, TOPICS_TO_EXCLUDE_FIELD, TOPICS_TO_REPLICATE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = TopicReplicationUpdate.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Boolean copyAccessControlListsForTopics;
    private final Boolean copyTopicConfigurations;
    private final Boolean detectAndCopyNewTopics;
    private final List<String> topicsToExclude;
    private final List<String> topicsToReplicate;

    private TopicReplicationUpdate(BuilderImpl builder) {
        this.copyAccessControlListsForTopics = builder.copyAccessControlListsForTopics;
        this.copyTopicConfigurations = builder.copyTopicConfigurations;
        this.detectAndCopyNewTopics = builder.detectAndCopyNewTopics;
        this.topicsToExclude = builder.topicsToExclude;
        this.topicsToReplicate = builder.topicsToReplicate;
    }

    public final Boolean copyAccessControlListsForTopics() {
        return this.copyAccessControlListsForTopics;
    }

    public final Boolean copyTopicConfigurations() {
        return this.copyTopicConfigurations;
    }

    public final Boolean detectAndCopyNewTopics() {
        return this.detectAndCopyNewTopics;
    }

    public final boolean hasTopicsToExclude() {
        return this.topicsToExclude != null && !(this.topicsToExclude instanceof SdkAutoConstructList);
    }

    public final List<String> topicsToExclude() {
        return this.topicsToExclude;
    }

    public final boolean hasTopicsToReplicate() {
        return this.topicsToReplicate != null && !(this.topicsToReplicate instanceof SdkAutoConstructList);
    }

    public final List<String> topicsToReplicate() {
        return this.topicsToReplicate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.copyAccessControlListsForTopics());
        hashCode = 31 * hashCode + Objects.hashCode(this.copyTopicConfigurations());
        hashCode = 31 * hashCode + Objects.hashCode(this.detectAndCopyNewTopics());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTopicsToExclude() ? this.topicsToExclude() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTopicsToReplicate() ? this.topicsToReplicate() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TopicReplicationUpdate)) {
            return false;
        }
        TopicReplicationUpdate other = (TopicReplicationUpdate)obj;
        return Objects.equals(this.copyAccessControlListsForTopics(), other.copyAccessControlListsForTopics()) && Objects.equals(this.copyTopicConfigurations(), other.copyTopicConfigurations()) && Objects.equals(this.detectAndCopyNewTopics(), other.detectAndCopyNewTopics()) && this.hasTopicsToExclude() == other.hasTopicsToExclude() && Objects.equals(this.topicsToExclude(), other.topicsToExclude()) && this.hasTopicsToReplicate() == other.hasTopicsToReplicate() && Objects.equals(this.topicsToReplicate(), other.topicsToReplicate());
    }

    public final String toString() {
        return ToString.builder((String)"TopicReplicationUpdate").add("CopyAccessControlListsForTopics", (Object)this.copyAccessControlListsForTopics()).add("CopyTopicConfigurations", (Object)this.copyTopicConfigurations()).add("DetectAndCopyNewTopics", (Object)this.detectAndCopyNewTopics()).add("TopicsToExclude", this.hasTopicsToExclude() ? this.topicsToExclude() : null).add("TopicsToReplicate", this.hasTopicsToReplicate() ? this.topicsToReplicate() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CopyAccessControlListsForTopics": {
                return Optional.ofNullable(clazz.cast(this.copyAccessControlListsForTopics()));
            }
            case "CopyTopicConfigurations": {
                return Optional.ofNullable(clazz.cast(this.copyTopicConfigurations()));
            }
            case "DetectAndCopyNewTopics": {
                return Optional.ofNullable(clazz.cast(this.detectAndCopyNewTopics()));
            }
            case "TopicsToExclude": {
                return Optional.ofNullable(clazz.cast(this.topicsToExclude()));
            }
            case "TopicsToReplicate": {
                return Optional.ofNullable(clazz.cast(this.topicsToReplicate()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("copyAccessControlListsForTopics", COPY_ACCESS_CONTROL_LISTS_FOR_TOPICS_FIELD);
        map.put("copyTopicConfigurations", COPY_TOPIC_CONFIGURATIONS_FIELD);
        map.put("detectAndCopyNewTopics", DETECT_AND_COPY_NEW_TOPICS_FIELD);
        map.put("topicsToExclude", TOPICS_TO_EXCLUDE_FIELD);
        map.put("topicsToReplicate", TOPICS_TO_REPLICATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TopicReplicationUpdate, T> g) {
        return obj -> g.apply((TopicReplicationUpdate)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean copyAccessControlListsForTopics;
        private Boolean copyTopicConfigurations;
        private Boolean detectAndCopyNewTopics;
        private List<String> topicsToExclude = DefaultSdkAutoConstructList.getInstance();
        private List<String> topicsToReplicate = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TopicReplicationUpdate model) {
            this.copyAccessControlListsForTopics(model.copyAccessControlListsForTopics);
            this.copyTopicConfigurations(model.copyTopicConfigurations);
            this.detectAndCopyNewTopics(model.detectAndCopyNewTopics);
            this.topicsToExclude(model.topicsToExclude);
            this.topicsToReplicate(model.topicsToReplicate);
        }

        public final Boolean getCopyAccessControlListsForTopics() {
            return this.copyAccessControlListsForTopics;
        }

        public final void setCopyAccessControlListsForTopics(Boolean copyAccessControlListsForTopics) {
            this.copyAccessControlListsForTopics = copyAccessControlListsForTopics;
        }

        @Override
        public final Builder copyAccessControlListsForTopics(Boolean copyAccessControlListsForTopics) {
            this.copyAccessControlListsForTopics = copyAccessControlListsForTopics;
            return this;
        }

        public final Boolean getCopyTopicConfigurations() {
            return this.copyTopicConfigurations;
        }

        public final void setCopyTopicConfigurations(Boolean copyTopicConfigurations) {
            this.copyTopicConfigurations = copyTopicConfigurations;
        }

        @Override
        public final Builder copyTopicConfigurations(Boolean copyTopicConfigurations) {
            this.copyTopicConfigurations = copyTopicConfigurations;
            return this;
        }

        public final Boolean getDetectAndCopyNewTopics() {
            return this.detectAndCopyNewTopics;
        }

        public final void setDetectAndCopyNewTopics(Boolean detectAndCopyNewTopics) {
            this.detectAndCopyNewTopics = detectAndCopyNewTopics;
        }

        @Override
        public final Builder detectAndCopyNewTopics(Boolean detectAndCopyNewTopics) {
            this.detectAndCopyNewTopics = detectAndCopyNewTopics;
            return this;
        }

        public final Collection<String> getTopicsToExclude() {
            if (this.topicsToExclude instanceof SdkAutoConstructList) {
                return null;
            }
            return this.topicsToExclude;
        }

        public final void setTopicsToExclude(Collection<String> topicsToExclude) {
            this.topicsToExclude = ___listOf__stringMax249Copier.copy(topicsToExclude);
        }

        @Override
        public final Builder topicsToExclude(Collection<String> topicsToExclude) {
            this.topicsToExclude = ___listOf__stringMax249Copier.copy(topicsToExclude);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder topicsToExclude(String ... topicsToExclude) {
            this.topicsToExclude(Arrays.asList(topicsToExclude));
            return this;
        }

        public final Collection<String> getTopicsToReplicate() {
            if (this.topicsToReplicate instanceof SdkAutoConstructList) {
                return null;
            }
            return this.topicsToReplicate;
        }

        public final void setTopicsToReplicate(Collection<String> topicsToReplicate) {
            this.topicsToReplicate = ___listOf__stringMax249Copier.copy(topicsToReplicate);
        }

        @Override
        public final Builder topicsToReplicate(Collection<String> topicsToReplicate) {
            this.topicsToReplicate = ___listOf__stringMax249Copier.copy(topicsToReplicate);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder topicsToReplicate(String ... topicsToReplicate) {
            this.topicsToReplicate(Arrays.asList(topicsToReplicate));
            return this;
        }

        public TopicReplicationUpdate build() {
            return new TopicReplicationUpdate(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TopicReplicationUpdate> {
        public Builder copyAccessControlListsForTopics(Boolean var1);

        public Builder copyTopicConfigurations(Boolean var1);

        public Builder detectAndCopyNewTopics(Boolean var1);

        public Builder topicsToExclude(Collection<String> var1);

        public Builder topicsToExclude(String ... var1);

        public Builder topicsToReplicate(Collection<String> var1);

        public Builder topicsToReplicate(String ... var1);
    }
}

