/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kafka.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.kafka.model.EnhancedMonitoring;
import software.amazon.awssdk.services.kafka.model.KafkaRequest;
import software.amazon.awssdk.services.kafka.model.LoggingInfo;
import software.amazon.awssdk.services.kafka.model.OpenMonitoringInfo;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateMonitoringRequest
extends KafkaRequest
implements ToCopyableBuilder<Builder, UpdateMonitoringRequest> {
    private static final SdkField<String> CLUSTER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClusterArn").getter(UpdateMonitoringRequest.getter(UpdateMonitoringRequest::clusterArn)).setter(UpdateMonitoringRequest.setter(Builder::clusterArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("clusterArn").build()}).build();
    private static final SdkField<String> CURRENT_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CurrentVersion").getter(UpdateMonitoringRequest.getter(UpdateMonitoringRequest::currentVersion)).setter(UpdateMonitoringRequest.setter(Builder::currentVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("currentVersion").build()}).build();
    private static final SdkField<String> ENHANCED_MONITORING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EnhancedMonitoring").getter(UpdateMonitoringRequest.getter(UpdateMonitoringRequest::enhancedMonitoringAsString)).setter(UpdateMonitoringRequest.setter(Builder::enhancedMonitoring)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enhancedMonitoring").build()}).build();
    private static final SdkField<OpenMonitoringInfo> OPEN_MONITORING_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("OpenMonitoring").getter(UpdateMonitoringRequest.getter(UpdateMonitoringRequest::openMonitoring)).setter(UpdateMonitoringRequest.setter(Builder::openMonitoring)).constructor(OpenMonitoringInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("openMonitoring").build()}).build();
    private static final SdkField<LoggingInfo> LOGGING_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LoggingInfo").getter(UpdateMonitoringRequest.getter(UpdateMonitoringRequest::loggingInfo)).setter(UpdateMonitoringRequest.setter(Builder::loggingInfo)).constructor(LoggingInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("loggingInfo").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_ARN_FIELD, CURRENT_VERSION_FIELD, ENHANCED_MONITORING_FIELD, OPEN_MONITORING_FIELD, LOGGING_INFO_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("clusterArn", CLUSTER_ARN_FIELD);
            this.put("currentVersion", CURRENT_VERSION_FIELD);
            this.put("enhancedMonitoring", ENHANCED_MONITORING_FIELD);
            this.put("openMonitoring", OPEN_MONITORING_FIELD);
            this.put("loggingInfo", LOGGING_INFO_FIELD);
        }
    });
    private final String clusterArn;
    private final String currentVersion;
    private final String enhancedMonitoring;
    private final OpenMonitoringInfo openMonitoring;
    private final LoggingInfo loggingInfo;

    private UpdateMonitoringRequest(BuilderImpl builder) {
        super(builder);
        this.clusterArn = builder.clusterArn;
        this.currentVersion = builder.currentVersion;
        this.enhancedMonitoring = builder.enhancedMonitoring;
        this.openMonitoring = builder.openMonitoring;
        this.loggingInfo = builder.loggingInfo;
    }

    public final String clusterArn() {
        return this.clusterArn;
    }

    public final String currentVersion() {
        return this.currentVersion;
    }

    public final EnhancedMonitoring enhancedMonitoring() {
        return EnhancedMonitoring.fromValue(this.enhancedMonitoring);
    }

    public final String enhancedMonitoringAsString() {
        return this.enhancedMonitoring;
    }

    public final OpenMonitoringInfo openMonitoring() {
        return this.openMonitoring;
    }

    public final LoggingInfo loggingInfo() {
        return this.loggingInfo;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.currentVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.enhancedMonitoringAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.openMonitoring());
        hashCode = 31 * hashCode + Objects.hashCode(this.loggingInfo());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateMonitoringRequest)) {
            return false;
        }
        UpdateMonitoringRequest other = (UpdateMonitoringRequest)((Object)obj);
        return Objects.equals(this.clusterArn(), other.clusterArn()) && Objects.equals(this.currentVersion(), other.currentVersion()) && Objects.equals(this.enhancedMonitoringAsString(), other.enhancedMonitoringAsString()) && Objects.equals(this.openMonitoring(), other.openMonitoring()) && Objects.equals(this.loggingInfo(), other.loggingInfo());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateMonitoringRequest").add("ClusterArn", (Object)this.clusterArn()).add("CurrentVersion", (Object)this.currentVersion()).add("EnhancedMonitoring", (Object)this.enhancedMonitoringAsString()).add("OpenMonitoring", (Object)this.openMonitoring()).add("LoggingInfo", (Object)this.loggingInfo()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClusterArn": {
                return Optional.ofNullable(clazz.cast(this.clusterArn()));
            }
            case "CurrentVersion": {
                return Optional.ofNullable(clazz.cast(this.currentVersion()));
            }
            case "EnhancedMonitoring": {
                return Optional.ofNullable(clazz.cast(this.enhancedMonitoringAsString()));
            }
            case "OpenMonitoring": {
                return Optional.ofNullable(clazz.cast(this.openMonitoring()));
            }
            case "LoggingInfo": {
                return Optional.ofNullable(clazz.cast(this.loggingInfo()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<UpdateMonitoringRequest, T> g) {
        return obj -> g.apply((UpdateMonitoringRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends KafkaRequest.BuilderImpl
    implements Builder {
        private String clusterArn;
        private String currentVersion;
        private String enhancedMonitoring;
        private OpenMonitoringInfo openMonitoring;
        private LoggingInfo loggingInfo;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateMonitoringRequest model) {
            super(model);
            this.clusterArn(model.clusterArn);
            this.currentVersion(model.currentVersion);
            this.enhancedMonitoring(model.enhancedMonitoring);
            this.openMonitoring(model.openMonitoring);
            this.loggingInfo(model.loggingInfo);
        }

        public final String getClusterArn() {
            return this.clusterArn;
        }

        public final void setClusterArn(String clusterArn) {
            this.clusterArn = clusterArn;
        }

        @Override
        public final Builder clusterArn(String clusterArn) {
            this.clusterArn = clusterArn;
            return this;
        }

        public final String getCurrentVersion() {
            return this.currentVersion;
        }

        public final void setCurrentVersion(String currentVersion) {
            this.currentVersion = currentVersion;
        }

        @Override
        public final Builder currentVersion(String currentVersion) {
            this.currentVersion = currentVersion;
            return this;
        }

        public final String getEnhancedMonitoring() {
            return this.enhancedMonitoring;
        }

        public final void setEnhancedMonitoring(String enhancedMonitoring) {
            this.enhancedMonitoring = enhancedMonitoring;
        }

        @Override
        public final Builder enhancedMonitoring(String enhancedMonitoring) {
            this.enhancedMonitoring = enhancedMonitoring;
            return this;
        }

        @Override
        public final Builder enhancedMonitoring(EnhancedMonitoring enhancedMonitoring) {
            this.enhancedMonitoring(enhancedMonitoring == null ? null : enhancedMonitoring.toString());
            return this;
        }

        public final OpenMonitoringInfo.Builder getOpenMonitoring() {
            return this.openMonitoring != null ? this.openMonitoring.toBuilder() : null;
        }

        public final void setOpenMonitoring(OpenMonitoringInfo.BuilderImpl openMonitoring) {
            this.openMonitoring = openMonitoring != null ? openMonitoring.build() : null;
        }

        @Override
        public final Builder openMonitoring(OpenMonitoringInfo openMonitoring) {
            this.openMonitoring = openMonitoring;
            return this;
        }

        public final LoggingInfo.Builder getLoggingInfo() {
            return this.loggingInfo != null ? this.loggingInfo.toBuilder() : null;
        }

        public final void setLoggingInfo(LoggingInfo.BuilderImpl loggingInfo) {
            this.loggingInfo = loggingInfo != null ? loggingInfo.build() : null;
        }

        @Override
        public final Builder loggingInfo(LoggingInfo loggingInfo) {
            this.loggingInfo = loggingInfo;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateMonitoringRequest build() {
            return new UpdateMonitoringRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends KafkaRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateMonitoringRequest> {
        public Builder clusterArn(String var1);

        public Builder currentVersion(String var1);

        public Builder enhancedMonitoring(String var1);

        public Builder enhancedMonitoring(EnhancedMonitoring var1);

        public Builder openMonitoring(OpenMonitoringInfo var1);

        default public Builder openMonitoring(Consumer<OpenMonitoringInfo.Builder> openMonitoring) {
            return this.openMonitoring((OpenMonitoringInfo)((OpenMonitoringInfo.Builder)OpenMonitoringInfo.builder().applyMutation(openMonitoring)).build());
        }

        public Builder loggingInfo(LoggingInfo var1);

        default public Builder loggingInfo(Consumer<LoggingInfo.Builder> loggingInfo) {
            return this.loggingInfo((LoggingInfo)((LoggingInfo.Builder)LoggingInfo.builder().applyMutation(loggingInfo)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

