/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kafka.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.kafka.model.KafkaResponse;
import software.amazon.awssdk.services.kafka.model.VpcConnectionState;
import software.amazon.awssdk.services.kafka.model.___listOf__stringCopier;
import software.amazon.awssdk.services.kafka.model.___mapOf__stringCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateVpcConnectionResponse
extends KafkaResponse
implements ToCopyableBuilder<Builder, CreateVpcConnectionResponse> {
    private static final SdkField<String> VPC_CONNECTION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VpcConnectionArn").getter(CreateVpcConnectionResponse.getter(CreateVpcConnectionResponse::vpcConnectionArn)).setter(CreateVpcConnectionResponse.setter(Builder::vpcConnectionArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpcConnectionArn").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(CreateVpcConnectionResponse.getter(CreateVpcConnectionResponse::stateAsString)).setter(CreateVpcConnectionResponse.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()}).build();
    private static final SdkField<String> AUTHENTICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Authentication").getter(CreateVpcConnectionResponse.getter(CreateVpcConnectionResponse::authentication)).setter(CreateVpcConnectionResponse.setter(Builder::authentication)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authentication").build()}).build();
    private static final SdkField<String> VPC_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VpcId").getter(CreateVpcConnectionResponse.getter(CreateVpcConnectionResponse::vpcId)).setter(CreateVpcConnectionResponse.setter(Builder::vpcId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpcId").build()}).build();
    private static final SdkField<List<String>> CLIENT_SUBNETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ClientSubnets").getter(CreateVpcConnectionResponse.getter(CreateVpcConnectionResponse::clientSubnets)).setter(CreateVpcConnectionResponse.setter(Builder::clientSubnets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientSubnets").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> SECURITY_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SecurityGroups").getter(CreateVpcConnectionResponse.getter(CreateVpcConnectionResponse::securityGroups)).setter(CreateVpcConnectionResponse.setter(Builder::securityGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("securityGroups").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(CreateVpcConnectionResponse.getter(CreateVpcConnectionResponse::creationTime)).setter(CreateVpcConnectionResponse.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(CreateVpcConnectionResponse.getter(CreateVpcConnectionResponse::tags)).setter(CreateVpcConnectionResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VPC_CONNECTION_ARN_FIELD, STATE_FIELD, AUTHENTICATION_FIELD, VPC_ID_FIELD, CLIENT_SUBNETS_FIELD, SECURITY_GROUPS_FIELD, CREATION_TIME_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("vpcConnectionArn", VPC_CONNECTION_ARN_FIELD);
            this.put("state", STATE_FIELD);
            this.put("authentication", AUTHENTICATION_FIELD);
            this.put("vpcId", VPC_ID_FIELD);
            this.put("clientSubnets", CLIENT_SUBNETS_FIELD);
            this.put("securityGroups", SECURITY_GROUPS_FIELD);
            this.put("creationTime", CREATION_TIME_FIELD);
            this.put("tags", TAGS_FIELD);
        }
    });
    private final String vpcConnectionArn;
    private final String state;
    private final String authentication;
    private final String vpcId;
    private final List<String> clientSubnets;
    private final List<String> securityGroups;
    private final Instant creationTime;
    private final Map<String, String> tags;

    private CreateVpcConnectionResponse(BuilderImpl builder) {
        super(builder);
        this.vpcConnectionArn = builder.vpcConnectionArn;
        this.state = builder.state;
        this.authentication = builder.authentication;
        this.vpcId = builder.vpcId;
        this.clientSubnets = builder.clientSubnets;
        this.securityGroups = builder.securityGroups;
        this.creationTime = builder.creationTime;
        this.tags = builder.tags;
    }

    public final String vpcConnectionArn() {
        return this.vpcConnectionArn;
    }

    public final VpcConnectionState state() {
        return VpcConnectionState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final String authentication() {
        return this.authentication;
    }

    public final String vpcId() {
        return this.vpcId;
    }

    public final boolean hasClientSubnets() {
        return this.clientSubnets != null && !(this.clientSubnets instanceof SdkAutoConstructList);
    }

    public final List<String> clientSubnets() {
        return this.clientSubnets;
    }

    public final boolean hasSecurityGroups() {
        return this.securityGroups != null && !(this.securityGroups instanceof SdkAutoConstructList);
    }

    public final List<String> securityGroups() {
        return this.securityGroups;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcConnectionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.authentication());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasClientSubnets() ? this.clientSubnets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSecurityGroups() ? this.securityGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateVpcConnectionResponse)) {
            return false;
        }
        CreateVpcConnectionResponse other = (CreateVpcConnectionResponse)((Object)obj);
        return Objects.equals(this.vpcConnectionArn(), other.vpcConnectionArn()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.authentication(), other.authentication()) && Objects.equals(this.vpcId(), other.vpcId()) && this.hasClientSubnets() == other.hasClientSubnets() && Objects.equals(this.clientSubnets(), other.clientSubnets()) && this.hasSecurityGroups() == other.hasSecurityGroups() && Objects.equals(this.securityGroups(), other.securityGroups()) && Objects.equals(this.creationTime(), other.creationTime()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateVpcConnectionResponse").add("VpcConnectionArn", (Object)this.vpcConnectionArn()).add("State", (Object)this.stateAsString()).add("Authentication", (Object)this.authentication()).add("VpcId", (Object)this.vpcId()).add("ClientSubnets", this.hasClientSubnets() ? this.clientSubnets() : null).add("SecurityGroups", this.hasSecurityGroups() ? this.securityGroups() : null).add("CreationTime", (Object)this.creationTime()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "VpcConnectionArn": {
                return Optional.ofNullable(clazz.cast(this.vpcConnectionArn()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "Authentication": {
                return Optional.ofNullable(clazz.cast(this.authentication()));
            }
            case "VpcId": {
                return Optional.ofNullable(clazz.cast(this.vpcId()));
            }
            case "ClientSubnets": {
                return Optional.ofNullable(clazz.cast(this.clientSubnets()));
            }
            case "SecurityGroups": {
                return Optional.ofNullable(clazz.cast(this.securityGroups()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateVpcConnectionResponse, T> g) {
        return obj -> g.apply((CreateVpcConnectionResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends KafkaResponse.BuilderImpl
    implements Builder {
        private String vpcConnectionArn;
        private String state;
        private String authentication;
        private String vpcId;
        private List<String> clientSubnets = DefaultSdkAutoConstructList.getInstance();
        private List<String> securityGroups = DefaultSdkAutoConstructList.getInstance();
        private Instant creationTime;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateVpcConnectionResponse model) {
            super(model);
            this.vpcConnectionArn(model.vpcConnectionArn);
            this.state(model.state);
            this.authentication(model.authentication);
            this.vpcId(model.vpcId);
            this.clientSubnets(model.clientSubnets);
            this.securityGroups(model.securityGroups);
            this.creationTime(model.creationTime);
            this.tags(model.tags);
        }

        public final String getVpcConnectionArn() {
            return this.vpcConnectionArn;
        }

        public final void setVpcConnectionArn(String vpcConnectionArn) {
            this.vpcConnectionArn = vpcConnectionArn;
        }

        @Override
        public final Builder vpcConnectionArn(String vpcConnectionArn) {
            this.vpcConnectionArn = vpcConnectionArn;
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(VpcConnectionState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final String getAuthentication() {
            return this.authentication;
        }

        public final void setAuthentication(String authentication) {
            this.authentication = authentication;
        }

        @Override
        public final Builder authentication(String authentication) {
            this.authentication = authentication;
            return this;
        }

        public final String getVpcId() {
            return this.vpcId;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final Collection<String> getClientSubnets() {
            if (this.clientSubnets instanceof SdkAutoConstructList) {
                return null;
            }
            return this.clientSubnets;
        }

        public final void setClientSubnets(Collection<String> clientSubnets) {
            this.clientSubnets = ___listOf__stringCopier.copy(clientSubnets);
        }

        @Override
        public final Builder clientSubnets(Collection<String> clientSubnets) {
            this.clientSubnets = ___listOf__stringCopier.copy(clientSubnets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clientSubnets(String ... clientSubnets) {
            this.clientSubnets(Arrays.asList(clientSubnets));
            return this;
        }

        public final Collection<String> getSecurityGroups() {
            if (this.securityGroups instanceof SdkAutoConstructList) {
                return null;
            }
            return this.securityGroups;
        }

        public final void setSecurityGroups(Collection<String> securityGroups) {
            this.securityGroups = ___listOf__stringCopier.copy(securityGroups);
        }

        @Override
        public final Builder securityGroups(Collection<String> securityGroups) {
            this.securityGroups = ___listOf__stringCopier.copy(securityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroups(String ... securityGroups) {
            this.securityGroups(Arrays.asList(securityGroups));
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = ___mapOf__stringCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = ___mapOf__stringCopier.copy(tags);
            return this;
        }

        @Override
        public CreateVpcConnectionResponse build() {
            return new CreateVpcConnectionResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends KafkaResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateVpcConnectionResponse> {
        public Builder vpcConnectionArn(String var1);

        public Builder state(String var1);

        public Builder state(VpcConnectionState var1);

        public Builder authentication(String var1);

        public Builder vpcId(String var1);

        public Builder clientSubnets(Collection<String> var1);

        public Builder clientSubnets(String ... var1);

        public Builder securityGroups(Collection<String> var1);

        public Builder securityGroups(String ... var1);

        public Builder creationTime(Instant var1);

        public Builder tags(Map<String, String> var1);
    }
}

