/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kafka.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.kafka.model.ServerlessClientAuthentication;
import software.amazon.awssdk.services.kafka.model.VpcConfig;
import software.amazon.awssdk.services.kafka.model.___listOfVpcConfigCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ServerlessRequest
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ServerlessRequest> {
    private static final SdkField<List<VpcConfig>> VPC_CONFIGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("VpcConfigs").getter(ServerlessRequest.getter(ServerlessRequest::vpcConfigs)).setter(ServerlessRequest.setter(Builder::vpcConfigs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpcConfigs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(VpcConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<ServerlessClientAuthentication> CLIENT_AUTHENTICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ClientAuthentication").getter(ServerlessRequest.getter(ServerlessRequest::clientAuthentication)).setter(ServerlessRequest.setter(Builder::clientAuthentication)).constructor(ServerlessClientAuthentication::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientAuthentication").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VPC_CONFIGS_FIELD, CLIENT_AUTHENTICATION_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<VpcConfig> vpcConfigs;
    private final ServerlessClientAuthentication clientAuthentication;

    private ServerlessRequest(BuilderImpl builder) {
        this.vpcConfigs = builder.vpcConfigs;
        this.clientAuthentication = builder.clientAuthentication;
    }

    public final boolean hasVpcConfigs() {
        return this.vpcConfigs != null && !(this.vpcConfigs instanceof SdkAutoConstructList);
    }

    public final List<VpcConfig> vpcConfigs() {
        return this.vpcConfigs;
    }

    public final ServerlessClientAuthentication clientAuthentication() {
        return this.clientAuthentication;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVpcConfigs() ? this.vpcConfigs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.clientAuthentication());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServerlessRequest)) {
            return false;
        }
        ServerlessRequest other = (ServerlessRequest)obj;
        return this.hasVpcConfigs() == other.hasVpcConfigs() && Objects.equals(this.vpcConfigs(), other.vpcConfigs()) && Objects.equals(this.clientAuthentication(), other.clientAuthentication());
    }

    public final String toString() {
        return ToString.builder((String)"ServerlessRequest").add("VpcConfigs", this.hasVpcConfigs() ? this.vpcConfigs() : null).add("ClientAuthentication", (Object)this.clientAuthentication()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "VpcConfigs": {
                return Optional.ofNullable(clazz.cast(this.vpcConfigs()));
            }
            case "ClientAuthentication": {
                return Optional.ofNullable(clazz.cast(this.clientAuthentication()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ServerlessRequest, T> g) {
        return obj -> g.apply((ServerlessRequest)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<VpcConfig> vpcConfigs = DefaultSdkAutoConstructList.getInstance();
        private ServerlessClientAuthentication clientAuthentication;

        private BuilderImpl() {
        }

        private BuilderImpl(ServerlessRequest model) {
            this.vpcConfigs(model.vpcConfigs);
            this.clientAuthentication(model.clientAuthentication);
        }

        public final List<VpcConfig.Builder> getVpcConfigs() {
            List<VpcConfig.Builder> result = ___listOfVpcConfigCopier.copyToBuilder(this.vpcConfigs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVpcConfigs(Collection<VpcConfig.BuilderImpl> vpcConfigs) {
            this.vpcConfigs = ___listOfVpcConfigCopier.copyFromBuilder(vpcConfigs);
        }

        @Override
        public final Builder vpcConfigs(Collection<VpcConfig> vpcConfigs) {
            this.vpcConfigs = ___listOfVpcConfigCopier.copy(vpcConfigs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcConfigs(VpcConfig ... vpcConfigs) {
            this.vpcConfigs(Arrays.asList(vpcConfigs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcConfigs(Consumer<VpcConfig.Builder> ... vpcConfigs) {
            this.vpcConfigs(Stream.of(vpcConfigs).map(c -> (VpcConfig)((VpcConfig.Builder)VpcConfig.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final ServerlessClientAuthentication.Builder getClientAuthentication() {
            return this.clientAuthentication != null ? this.clientAuthentication.toBuilder() : null;
        }

        public final void setClientAuthentication(ServerlessClientAuthentication.BuilderImpl clientAuthentication) {
            this.clientAuthentication = clientAuthentication != null ? clientAuthentication.build() : null;
        }

        @Override
        public final Builder clientAuthentication(ServerlessClientAuthentication clientAuthentication) {
            this.clientAuthentication = clientAuthentication;
            return this;
        }

        public ServerlessRequest build() {
            return new ServerlessRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ServerlessRequest> {
        public Builder vpcConfigs(Collection<VpcConfig> var1);

        public Builder vpcConfigs(VpcConfig ... var1);

        public Builder vpcConfigs(Consumer<VpcConfig.Builder> ... var1);

        public Builder clientAuthentication(ServerlessClientAuthentication var1);

        default public Builder clientAuthentication(Consumer<ServerlessClientAuthentication.Builder> clientAuthentication) {
            return this.clientAuthentication((ServerlessClientAuthentication)((ServerlessClientAuthentication.Builder)ServerlessClientAuthentication.builder().applyMutation(clientAuthentication)).build());
        }
    }
}

