/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kafka.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.kafka.KafkaClient;
import software.amazon.awssdk.services.kafka.internal.UserAgentUtils;
import software.amazon.awssdk.services.kafka.model.ClusterOperationV2Summary;
import software.amazon.awssdk.services.kafka.model.ListClusterOperationsV2Request;
import software.amazon.awssdk.services.kafka.model.ListClusterOperationsV2Response;

public class ListClusterOperationsV2Iterable
implements SdkIterable<ListClusterOperationsV2Response> {
    private final KafkaClient client;
    private final ListClusterOperationsV2Request firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListClusterOperationsV2Iterable(KafkaClient client, ListClusterOperationsV2Request firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListClusterOperationsV2ResponseFetcher();
    }

    public Iterator<ListClusterOperationsV2Response> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ClusterOperationV2Summary> clusterOperationInfoList() {
        Function<ListClusterOperationsV2Response, Iterator> getIterator = response -> {
            if (response != null && response.clusterOperationInfoList() != null) {
                return response.clusterOperationInfoList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListClusterOperationsV2ResponseFetcher
    implements SyncPageFetcher<ListClusterOperationsV2Response> {
        private ListClusterOperationsV2ResponseFetcher() {
        }

        public boolean hasNextPage(ListClusterOperationsV2Response previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListClusterOperationsV2Response nextPage(ListClusterOperationsV2Response previousPage) {
            if (previousPage == null) {
                return ListClusterOperationsV2Iterable.this.client.listClusterOperationsV2(ListClusterOperationsV2Iterable.this.firstRequest);
            }
            return ListClusterOperationsV2Iterable.this.client.listClusterOperationsV2((ListClusterOperationsV2Request)((Object)ListClusterOperationsV2Iterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

