/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kafka.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.kafka.model.ReplicationStartingPosition;
import software.amazon.awssdk.services.kafka.model.___listOf__stringMax249Copier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TopicReplication
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TopicReplication> {
    private static final SdkField<Boolean> COPY_ACCESS_CONTROL_LISTS_FOR_TOPICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("CopyAccessControlListsForTopics").getter(TopicReplication.getter(TopicReplication::copyAccessControlListsForTopics)).setter(TopicReplication.setter(Builder::copyAccessControlListsForTopics)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("copyAccessControlListsForTopics").build()}).build();
    private static final SdkField<Boolean> COPY_TOPIC_CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("CopyTopicConfigurations").getter(TopicReplication.getter(TopicReplication::copyTopicConfigurations)).setter(TopicReplication.setter(Builder::copyTopicConfigurations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("copyTopicConfigurations").build()}).build();
    private static final SdkField<Boolean> DETECT_AND_COPY_NEW_TOPICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DetectAndCopyNewTopics").getter(TopicReplication.getter(TopicReplication::detectAndCopyNewTopics)).setter(TopicReplication.setter(Builder::detectAndCopyNewTopics)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("detectAndCopyNewTopics").build()}).build();
    private static final SdkField<ReplicationStartingPosition> STARTING_POSITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("StartingPosition").getter(TopicReplication.getter(TopicReplication::startingPosition)).setter(TopicReplication.setter(Builder::startingPosition)).constructor(ReplicationStartingPosition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startingPosition").build()}).build();
    private static final SdkField<List<String>> TOPICS_TO_EXCLUDE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TopicsToExclude").getter(TopicReplication.getter(TopicReplication::topicsToExclude)).setter(TopicReplication.setter(Builder::topicsToExclude)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("topicsToExclude").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> TOPICS_TO_REPLICATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TopicsToReplicate").getter(TopicReplication.getter(TopicReplication::topicsToReplicate)).setter(TopicReplication.setter(Builder::topicsToReplicate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("topicsToReplicate").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COPY_ACCESS_CONTROL_LISTS_FOR_TOPICS_FIELD, COPY_TOPIC_CONFIGURATIONS_FIELD, DETECT_AND_COPY_NEW_TOPICS_FIELD, STARTING_POSITION_FIELD, TOPICS_TO_EXCLUDE_FIELD, TOPICS_TO_REPLICATE_FIELD));
    private static final long serialVersionUID = 1L;
    private final Boolean copyAccessControlListsForTopics;
    private final Boolean copyTopicConfigurations;
    private final Boolean detectAndCopyNewTopics;
    private final ReplicationStartingPosition startingPosition;
    private final List<String> topicsToExclude;
    private final List<String> topicsToReplicate;

    private TopicReplication(BuilderImpl builder) {
        this.copyAccessControlListsForTopics = builder.copyAccessControlListsForTopics;
        this.copyTopicConfigurations = builder.copyTopicConfigurations;
        this.detectAndCopyNewTopics = builder.detectAndCopyNewTopics;
        this.startingPosition = builder.startingPosition;
        this.topicsToExclude = builder.topicsToExclude;
        this.topicsToReplicate = builder.topicsToReplicate;
    }

    public final Boolean copyAccessControlListsForTopics() {
        return this.copyAccessControlListsForTopics;
    }

    public final Boolean copyTopicConfigurations() {
        return this.copyTopicConfigurations;
    }

    public final Boolean detectAndCopyNewTopics() {
        return this.detectAndCopyNewTopics;
    }

    public final ReplicationStartingPosition startingPosition() {
        return this.startingPosition;
    }

    public final boolean hasTopicsToExclude() {
        return this.topicsToExclude != null && !(this.topicsToExclude instanceof SdkAutoConstructList);
    }

    public final List<String> topicsToExclude() {
        return this.topicsToExclude;
    }

    public final boolean hasTopicsToReplicate() {
        return this.topicsToReplicate != null && !(this.topicsToReplicate instanceof SdkAutoConstructList);
    }

    public final List<String> topicsToReplicate() {
        return this.topicsToReplicate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.copyAccessControlListsForTopics());
        hashCode = 31 * hashCode + Objects.hashCode(this.copyTopicConfigurations());
        hashCode = 31 * hashCode + Objects.hashCode(this.detectAndCopyNewTopics());
        hashCode = 31 * hashCode + Objects.hashCode(this.startingPosition());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTopicsToExclude() ? this.topicsToExclude() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTopicsToReplicate() ? this.topicsToReplicate() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TopicReplication)) {
            return false;
        }
        TopicReplication other = (TopicReplication)obj;
        return Objects.equals(this.copyAccessControlListsForTopics(), other.copyAccessControlListsForTopics()) && Objects.equals(this.copyTopicConfigurations(), other.copyTopicConfigurations()) && Objects.equals(this.detectAndCopyNewTopics(), other.detectAndCopyNewTopics()) && Objects.equals(this.startingPosition(), other.startingPosition()) && this.hasTopicsToExclude() == other.hasTopicsToExclude() && Objects.equals(this.topicsToExclude(), other.topicsToExclude()) && this.hasTopicsToReplicate() == other.hasTopicsToReplicate() && Objects.equals(this.topicsToReplicate(), other.topicsToReplicate());
    }

    public final String toString() {
        return ToString.builder((String)"TopicReplication").add("CopyAccessControlListsForTopics", (Object)this.copyAccessControlListsForTopics()).add("CopyTopicConfigurations", (Object)this.copyTopicConfigurations()).add("DetectAndCopyNewTopics", (Object)this.detectAndCopyNewTopics()).add("StartingPosition", (Object)this.startingPosition()).add("TopicsToExclude", this.hasTopicsToExclude() ? this.topicsToExclude() : null).add("TopicsToReplicate", this.hasTopicsToReplicate() ? this.topicsToReplicate() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CopyAccessControlListsForTopics": {
                return Optional.ofNullable(clazz.cast(this.copyAccessControlListsForTopics()));
            }
            case "CopyTopicConfigurations": {
                return Optional.ofNullable(clazz.cast(this.copyTopicConfigurations()));
            }
            case "DetectAndCopyNewTopics": {
                return Optional.ofNullable(clazz.cast(this.detectAndCopyNewTopics()));
            }
            case "StartingPosition": {
                return Optional.ofNullable(clazz.cast(this.startingPosition()));
            }
            case "TopicsToExclude": {
                return Optional.ofNullable(clazz.cast(this.topicsToExclude()));
            }
            case "TopicsToReplicate": {
                return Optional.ofNullable(clazz.cast(this.topicsToReplicate()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TopicReplication, T> g) {
        return obj -> g.apply((TopicReplication)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean copyAccessControlListsForTopics;
        private Boolean copyTopicConfigurations;
        private Boolean detectAndCopyNewTopics;
        private ReplicationStartingPosition startingPosition;
        private List<String> topicsToExclude = DefaultSdkAutoConstructList.getInstance();
        private List<String> topicsToReplicate = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TopicReplication model) {
            this.copyAccessControlListsForTopics(model.copyAccessControlListsForTopics);
            this.copyTopicConfigurations(model.copyTopicConfigurations);
            this.detectAndCopyNewTopics(model.detectAndCopyNewTopics);
            this.startingPosition(model.startingPosition);
            this.topicsToExclude(model.topicsToExclude);
            this.topicsToReplicate(model.topicsToReplicate);
        }

        public final Boolean getCopyAccessControlListsForTopics() {
            return this.copyAccessControlListsForTopics;
        }

        public final void setCopyAccessControlListsForTopics(Boolean copyAccessControlListsForTopics) {
            this.copyAccessControlListsForTopics = copyAccessControlListsForTopics;
        }

        @Override
        public final Builder copyAccessControlListsForTopics(Boolean copyAccessControlListsForTopics) {
            this.copyAccessControlListsForTopics = copyAccessControlListsForTopics;
            return this;
        }

        public final Boolean getCopyTopicConfigurations() {
            return this.copyTopicConfigurations;
        }

        public final void setCopyTopicConfigurations(Boolean copyTopicConfigurations) {
            this.copyTopicConfigurations = copyTopicConfigurations;
        }

        @Override
        public final Builder copyTopicConfigurations(Boolean copyTopicConfigurations) {
            this.copyTopicConfigurations = copyTopicConfigurations;
            return this;
        }

        public final Boolean getDetectAndCopyNewTopics() {
            return this.detectAndCopyNewTopics;
        }

        public final void setDetectAndCopyNewTopics(Boolean detectAndCopyNewTopics) {
            this.detectAndCopyNewTopics = detectAndCopyNewTopics;
        }

        @Override
        public final Builder detectAndCopyNewTopics(Boolean detectAndCopyNewTopics) {
            this.detectAndCopyNewTopics = detectAndCopyNewTopics;
            return this;
        }

        public final ReplicationStartingPosition.Builder getStartingPosition() {
            return this.startingPosition != null ? this.startingPosition.toBuilder() : null;
        }

        public final void setStartingPosition(ReplicationStartingPosition.BuilderImpl startingPosition) {
            this.startingPosition = startingPosition != null ? startingPosition.build() : null;
        }

        @Override
        public final Builder startingPosition(ReplicationStartingPosition startingPosition) {
            this.startingPosition = startingPosition;
            return this;
        }

        public final Collection<String> getTopicsToExclude() {
            if (this.topicsToExclude instanceof SdkAutoConstructList) {
                return null;
            }
            return this.topicsToExclude;
        }

        public final void setTopicsToExclude(Collection<String> topicsToExclude) {
            this.topicsToExclude = ___listOf__stringMax249Copier.copy(topicsToExclude);
        }

        @Override
        public final Builder topicsToExclude(Collection<String> topicsToExclude) {
            this.topicsToExclude = ___listOf__stringMax249Copier.copy(topicsToExclude);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder topicsToExclude(String ... topicsToExclude) {
            this.topicsToExclude(Arrays.asList(topicsToExclude));
            return this;
        }

        public final Collection<String> getTopicsToReplicate() {
            if (this.topicsToReplicate instanceof SdkAutoConstructList) {
                return null;
            }
            return this.topicsToReplicate;
        }

        public final void setTopicsToReplicate(Collection<String> topicsToReplicate) {
            this.topicsToReplicate = ___listOf__stringMax249Copier.copy(topicsToReplicate);
        }

        @Override
        public final Builder topicsToReplicate(Collection<String> topicsToReplicate) {
            this.topicsToReplicate = ___listOf__stringMax249Copier.copy(topicsToReplicate);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder topicsToReplicate(String ... topicsToReplicate) {
            this.topicsToReplicate(Arrays.asList(topicsToReplicate));
            return this;
        }

        public TopicReplication build() {
            return new TopicReplication(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TopicReplication> {
        public Builder copyAccessControlListsForTopics(Boolean var1);

        public Builder copyTopicConfigurations(Boolean var1);

        public Builder detectAndCopyNewTopics(Boolean var1);

        public Builder startingPosition(ReplicationStartingPosition var1);

        default public Builder startingPosition(Consumer<ReplicationStartingPosition.Builder> startingPosition) {
            return this.startingPosition((ReplicationStartingPosition)((ReplicationStartingPosition.Builder)ReplicationStartingPosition.builder().applyMutation(startingPosition)).build());
        }

        public Builder topicsToExclude(Collection<String> var1);

        public Builder topicsToExclude(String ... var1);

        public Builder topicsToReplicate(Collection<String> var1);

        public Builder topicsToReplicate(String ... var1);
    }
}

