/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kafka;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.kafka.DefaultKafkaBaseClientBuilder;
import software.amazon.awssdk.services.kafka.DefaultKafkaClient;
import software.amazon.awssdk.services.kafka.KafkaClient;
import software.amazon.awssdk.services.kafka.KafkaClientBuilder;
import software.amazon.awssdk.services.kafka.KafkaServiceClientConfiguration;
import software.amazon.awssdk.services.kafka.endpoints.KafkaEndpointProvider;

@SdkInternalApi
final class DefaultKafkaClientBuilder
extends DefaultKafkaBaseClientBuilder<KafkaClientBuilder, KafkaClient>
implements KafkaClientBuilder {
    DefaultKafkaClientBuilder() {
    }

    @Override
    public DefaultKafkaClientBuilder endpointProvider(KafkaEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final KafkaClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultKafkaClientBuilder.validateClientOptions(clientConfiguration);
        KafkaServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultKafkaClient client = new DefaultKafkaClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private KafkaServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        if (Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return KafkaServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider((EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER)).build();
    }
}

