/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kafka.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.kafka.model.KafkaRequest;
import software.amazon.awssdk.services.kafka.model.ProvisionedThroughput;
import software.amazon.awssdk.services.kafka.model.StorageMode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateStorageRequest
extends KafkaRequest
implements ToCopyableBuilder<Builder, UpdateStorageRequest> {
    private static final SdkField<String> CLUSTER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClusterArn").getter(UpdateStorageRequest.getter(UpdateStorageRequest::clusterArn)).setter(UpdateStorageRequest.setter(Builder::clusterArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("clusterArn").build()}).build();
    private static final SdkField<String> CURRENT_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CurrentVersion").getter(UpdateStorageRequest.getter(UpdateStorageRequest::currentVersion)).setter(UpdateStorageRequest.setter(Builder::currentVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("currentVersion").build()}).build();
    private static final SdkField<ProvisionedThroughput> PROVISIONED_THROUGHPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ProvisionedThroughput").getter(UpdateStorageRequest.getter(UpdateStorageRequest::provisionedThroughput)).setter(UpdateStorageRequest.setter(Builder::provisionedThroughput)).constructor(ProvisionedThroughput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("provisionedThroughput").build()}).build();
    private static final SdkField<String> STORAGE_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StorageMode").getter(UpdateStorageRequest.getter(UpdateStorageRequest::storageModeAsString)).setter(UpdateStorageRequest.setter(Builder::storageMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("storageMode").build()}).build();
    private static final SdkField<Integer> VOLUME_SIZE_GB_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("VolumeSizeGB").getter(UpdateStorageRequest.getter(UpdateStorageRequest::volumeSizeGB)).setter(UpdateStorageRequest.setter(Builder::volumeSizeGB)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("volumeSizeGB").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_ARN_FIELD, CURRENT_VERSION_FIELD, PROVISIONED_THROUGHPUT_FIELD, STORAGE_MODE_FIELD, VOLUME_SIZE_GB_FIELD));
    private final String clusterArn;
    private final String currentVersion;
    private final ProvisionedThroughput provisionedThroughput;
    private final String storageMode;
    private final Integer volumeSizeGB;

    private UpdateStorageRequest(BuilderImpl builder) {
        super(builder);
        this.clusterArn = builder.clusterArn;
        this.currentVersion = builder.currentVersion;
        this.provisionedThroughput = builder.provisionedThroughput;
        this.storageMode = builder.storageMode;
        this.volumeSizeGB = builder.volumeSizeGB;
    }

    public final String clusterArn() {
        return this.clusterArn;
    }

    public final String currentVersion() {
        return this.currentVersion;
    }

    public final ProvisionedThroughput provisionedThroughput() {
        return this.provisionedThroughput;
    }

    public final StorageMode storageMode() {
        return StorageMode.fromValue(this.storageMode);
    }

    public final String storageModeAsString() {
        return this.storageMode;
    }

    public final Integer volumeSizeGB() {
        return this.volumeSizeGB;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.currentVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.provisionedThroughput());
        hashCode = 31 * hashCode + Objects.hashCode(this.storageModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.volumeSizeGB());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateStorageRequest)) {
            return false;
        }
        UpdateStorageRequest other = (UpdateStorageRequest)((Object)obj);
        return Objects.equals(this.clusterArn(), other.clusterArn()) && Objects.equals(this.currentVersion(), other.currentVersion()) && Objects.equals(this.provisionedThroughput(), other.provisionedThroughput()) && Objects.equals(this.storageModeAsString(), other.storageModeAsString()) && Objects.equals(this.volumeSizeGB(), other.volumeSizeGB());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateStorageRequest").add("ClusterArn", (Object)this.clusterArn()).add("CurrentVersion", (Object)this.currentVersion()).add("ProvisionedThroughput", (Object)this.provisionedThroughput()).add("StorageMode", (Object)this.storageModeAsString()).add("VolumeSizeGB", (Object)this.volumeSizeGB()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClusterArn": {
                return Optional.ofNullable(clazz.cast(this.clusterArn()));
            }
            case "CurrentVersion": {
                return Optional.ofNullable(clazz.cast(this.currentVersion()));
            }
            case "ProvisionedThroughput": {
                return Optional.ofNullable(clazz.cast(this.provisionedThroughput()));
            }
            case "StorageMode": {
                return Optional.ofNullable(clazz.cast(this.storageModeAsString()));
            }
            case "VolumeSizeGB": {
                return Optional.ofNullable(clazz.cast(this.volumeSizeGB()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateStorageRequest, T> g) {
        return obj -> g.apply((UpdateStorageRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends KafkaRequest.BuilderImpl
    implements Builder {
        private String clusterArn;
        private String currentVersion;
        private ProvisionedThroughput provisionedThroughput;
        private String storageMode;
        private Integer volumeSizeGB;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateStorageRequest model) {
            super(model);
            this.clusterArn(model.clusterArn);
            this.currentVersion(model.currentVersion);
            this.provisionedThroughput(model.provisionedThroughput);
            this.storageMode(model.storageMode);
            this.volumeSizeGB(model.volumeSizeGB);
        }

        public final String getClusterArn() {
            return this.clusterArn;
        }

        public final void setClusterArn(String clusterArn) {
            this.clusterArn = clusterArn;
        }

        @Override
        public final Builder clusterArn(String clusterArn) {
            this.clusterArn = clusterArn;
            return this;
        }

        public final String getCurrentVersion() {
            return this.currentVersion;
        }

        public final void setCurrentVersion(String currentVersion) {
            this.currentVersion = currentVersion;
        }

        @Override
        public final Builder currentVersion(String currentVersion) {
            this.currentVersion = currentVersion;
            return this;
        }

        public final ProvisionedThroughput.Builder getProvisionedThroughput() {
            return this.provisionedThroughput != null ? this.provisionedThroughput.toBuilder() : null;
        }

        public final void setProvisionedThroughput(ProvisionedThroughput.BuilderImpl provisionedThroughput) {
            this.provisionedThroughput = provisionedThroughput != null ? provisionedThroughput.build() : null;
        }

        @Override
        public final Builder provisionedThroughput(ProvisionedThroughput provisionedThroughput) {
            this.provisionedThroughput = provisionedThroughput;
            return this;
        }

        public final String getStorageMode() {
            return this.storageMode;
        }

        public final void setStorageMode(String storageMode) {
            this.storageMode = storageMode;
        }

        @Override
        public final Builder storageMode(String storageMode) {
            this.storageMode = storageMode;
            return this;
        }

        @Override
        public final Builder storageMode(StorageMode storageMode) {
            this.storageMode(storageMode == null ? null : storageMode.toString());
            return this;
        }

        public final Integer getVolumeSizeGB() {
            return this.volumeSizeGB;
        }

        public final void setVolumeSizeGB(Integer volumeSizeGB) {
            this.volumeSizeGB = volumeSizeGB;
        }

        @Override
        public final Builder volumeSizeGB(Integer volumeSizeGB) {
            this.volumeSizeGB = volumeSizeGB;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateStorageRequest build() {
            return new UpdateStorageRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends KafkaRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateStorageRequest> {
        public Builder clusterArn(String var1);

        public Builder currentVersion(String var1);

        public Builder provisionedThroughput(ProvisionedThroughput var1);

        default public Builder provisionedThroughput(Consumer<ProvisionedThroughput.Builder> provisionedThroughput) {
            return this.provisionedThroughput((ProvisionedThroughput)((ProvisionedThroughput.Builder)ProvisionedThroughput.builder().applyMutation(provisionedThroughput)).build());
        }

        public Builder storageMode(String var1);

        public Builder storageMode(StorageMode var1);

        public Builder volumeSizeGB(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

