/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kafka.model;

import java.beans.Transient;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.kafka.model.KafkaRequest;
import software.amazon.awssdk.services.kafka.model.___listOf__stringCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateConfigurationRequest
extends KafkaRequest
implements ToCopyableBuilder<Builder, CreateConfigurationRequest> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(CreateConfigurationRequest.getter(CreateConfigurationRequest::description)).setter(CreateConfigurationRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<List<String>> KAFKA_VERSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("KafkaVersions").getter(CreateConfigurationRequest.getter(CreateConfigurationRequest::kafkaVersions)).setter(CreateConfigurationRequest.setter(Builder::kafkaVersions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kafkaVersions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(CreateConfigurationRequest.getter(CreateConfigurationRequest::name)).setter(CreateConfigurationRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<SdkBytes> SERVER_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_BYTES).memberName("ServerProperties").getter(CreateConfigurationRequest.getter(CreateConfigurationRequest::serverProperties)).setter(CreateConfigurationRequest.setter(Builder::serverProperties)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serverProperties").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD, KAFKA_VERSIONS_FIELD, NAME_FIELD, SERVER_PROPERTIES_FIELD));
    private final String description;
    private final List<String> kafkaVersions;
    private final String name;
    private final SdkBytes serverProperties;

    private CreateConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.description = builder.description;
        this.kafkaVersions = builder.kafkaVersions;
        this.name = builder.name;
        this.serverProperties = builder.serverProperties;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasKafkaVersions() {
        return this.kafkaVersions != null && !(this.kafkaVersions instanceof SdkAutoConstructList);
    }

    public final List<String> kafkaVersions() {
        return this.kafkaVersions;
    }

    public final String name() {
        return this.name;
    }

    public final SdkBytes serverProperties() {
        return this.serverProperties;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasKafkaVersions() ? this.kafkaVersions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.serverProperties());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateConfigurationRequest)) {
            return false;
        }
        CreateConfigurationRequest other = (CreateConfigurationRequest)((Object)obj);
        return Objects.equals(this.description(), other.description()) && this.hasKafkaVersions() == other.hasKafkaVersions() && Objects.equals(this.kafkaVersions(), other.kafkaVersions()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.serverProperties(), other.serverProperties());
    }

    public final String toString() {
        return ToString.builder((String)"CreateConfigurationRequest").add("Description", (Object)this.description()).add("KafkaVersions", this.hasKafkaVersions() ? this.kafkaVersions() : null).add("Name", (Object)this.name()).add("ServerProperties", (Object)this.serverProperties()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "KafkaVersions": {
                return Optional.ofNullable(clazz.cast(this.kafkaVersions()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "ServerProperties": {
                return Optional.ofNullable(clazz.cast(this.serverProperties()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateConfigurationRequest, T> g) {
        return obj -> g.apply((CreateConfigurationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends KafkaRequest.BuilderImpl
    implements Builder {
        private String description;
        private List<String> kafkaVersions = DefaultSdkAutoConstructList.getInstance();
        private String name;
        private SdkBytes serverProperties;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateConfigurationRequest model) {
            super(model);
            this.description(model.description);
            this.kafkaVersions(model.kafkaVersions);
            this.name(model.name);
            this.serverProperties(model.serverProperties);
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Collection<String> getKafkaVersions() {
            if (this.kafkaVersions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.kafkaVersions;
        }

        public final void setKafkaVersions(Collection<String> kafkaVersions) {
            this.kafkaVersions = ___listOf__stringCopier.copy(kafkaVersions);
        }

        @Override
        @Transient
        public final Builder kafkaVersions(Collection<String> kafkaVersions) {
            this.kafkaVersions = ___listOf__stringCopier.copy(kafkaVersions);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder kafkaVersions(String ... kafkaVersions) {
            this.kafkaVersions(Arrays.asList(kafkaVersions));
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final ByteBuffer getServerProperties() {
            return this.serverProperties == null ? null : this.serverProperties.asByteBuffer();
        }

        public final void setServerProperties(ByteBuffer serverProperties) {
            this.serverProperties(serverProperties == null ? null : SdkBytes.fromByteBuffer((ByteBuffer)serverProperties));
        }

        @Override
        @Transient
        public final Builder serverProperties(SdkBytes serverProperties) {
            this.serverProperties = serverProperties;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateConfigurationRequest build() {
            return new CreateConfigurationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends KafkaRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateConfigurationRequest> {
        public Builder description(String var1);

        public Builder kafkaVersions(Collection<String> var1);

        public Builder kafkaVersions(String ... var1);

        public Builder name(String var1);

        public Builder serverProperties(SdkBytes var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

