/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kafka.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.kafka.model.BrokerNodeGroupInfo;
import software.amazon.awssdk.services.kafka.model.BrokerSoftwareInfo;
import software.amazon.awssdk.services.kafka.model.ClientAuthentication;
import software.amazon.awssdk.services.kafka.model.EncryptionInfo;
import software.amazon.awssdk.services.kafka.model.EnhancedMonitoring;
import software.amazon.awssdk.services.kafka.model.LoggingInfo;
import software.amazon.awssdk.services.kafka.model.OpenMonitoringInfo;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Provisioned
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Provisioned> {
    private static final SdkField<BrokerNodeGroupInfo> BROKER_NODE_GROUP_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("BrokerNodeGroupInfo").getter(Provisioned.getter(Provisioned::brokerNodeGroupInfo)).setter(Provisioned.setter(Builder::brokerNodeGroupInfo)).constructor(BrokerNodeGroupInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("brokerNodeGroupInfo").build()}).build();
    private static final SdkField<BrokerSoftwareInfo> CURRENT_BROKER_SOFTWARE_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CurrentBrokerSoftwareInfo").getter(Provisioned.getter(Provisioned::currentBrokerSoftwareInfo)).setter(Provisioned.setter(Builder::currentBrokerSoftwareInfo)).constructor(BrokerSoftwareInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("currentBrokerSoftwareInfo").build()}).build();
    private static final SdkField<ClientAuthentication> CLIENT_AUTHENTICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ClientAuthentication").getter(Provisioned.getter(Provisioned::clientAuthentication)).setter(Provisioned.setter(Builder::clientAuthentication)).constructor(ClientAuthentication::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientAuthentication").build()}).build();
    private static final SdkField<EncryptionInfo> ENCRYPTION_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EncryptionInfo").getter(Provisioned.getter(Provisioned::encryptionInfo)).setter(Provisioned.setter(Builder::encryptionInfo)).constructor(EncryptionInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encryptionInfo").build()}).build();
    private static final SdkField<String> ENHANCED_MONITORING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EnhancedMonitoring").getter(Provisioned.getter(Provisioned::enhancedMonitoringAsString)).setter(Provisioned.setter(Builder::enhancedMonitoring)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enhancedMonitoring").build()}).build();
    private static final SdkField<OpenMonitoringInfo> OPEN_MONITORING_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("OpenMonitoring").getter(Provisioned.getter(Provisioned::openMonitoring)).setter(Provisioned.setter(Builder::openMonitoring)).constructor(OpenMonitoringInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("openMonitoring").build()}).build();
    private static final SdkField<LoggingInfo> LOGGING_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LoggingInfo").getter(Provisioned.getter(Provisioned::loggingInfo)).setter(Provisioned.setter(Builder::loggingInfo)).constructor(LoggingInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("loggingInfo").build()}).build();
    private static final SdkField<Integer> NUMBER_OF_BROKER_NODES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("NumberOfBrokerNodes").getter(Provisioned.getter(Provisioned::numberOfBrokerNodes)).setter(Provisioned.setter(Builder::numberOfBrokerNodes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("numberOfBrokerNodes").build()}).build();
    private static final SdkField<String> ZOOKEEPER_CONNECT_STRING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ZookeeperConnectString").getter(Provisioned.getter(Provisioned::zookeeperConnectString)).setter(Provisioned.setter(Builder::zookeeperConnectString)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("zookeeperConnectString").build()}).build();
    private static final SdkField<String> ZOOKEEPER_CONNECT_STRING_TLS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ZookeeperConnectStringTls").getter(Provisioned.getter(Provisioned::zookeeperConnectStringTls)).setter(Provisioned.setter(Builder::zookeeperConnectStringTls)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("zookeeperConnectStringTls").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BROKER_NODE_GROUP_INFO_FIELD, CURRENT_BROKER_SOFTWARE_INFO_FIELD, CLIENT_AUTHENTICATION_FIELD, ENCRYPTION_INFO_FIELD, ENHANCED_MONITORING_FIELD, OPEN_MONITORING_FIELD, LOGGING_INFO_FIELD, NUMBER_OF_BROKER_NODES_FIELD, ZOOKEEPER_CONNECT_STRING_FIELD, ZOOKEEPER_CONNECT_STRING_TLS_FIELD));
    private static final long serialVersionUID = 1L;
    private final BrokerNodeGroupInfo brokerNodeGroupInfo;
    private final BrokerSoftwareInfo currentBrokerSoftwareInfo;
    private final ClientAuthentication clientAuthentication;
    private final EncryptionInfo encryptionInfo;
    private final String enhancedMonitoring;
    private final OpenMonitoringInfo openMonitoring;
    private final LoggingInfo loggingInfo;
    private final Integer numberOfBrokerNodes;
    private final String zookeeperConnectString;
    private final String zookeeperConnectStringTls;

    private Provisioned(BuilderImpl builder) {
        this.brokerNodeGroupInfo = builder.brokerNodeGroupInfo;
        this.currentBrokerSoftwareInfo = builder.currentBrokerSoftwareInfo;
        this.clientAuthentication = builder.clientAuthentication;
        this.encryptionInfo = builder.encryptionInfo;
        this.enhancedMonitoring = builder.enhancedMonitoring;
        this.openMonitoring = builder.openMonitoring;
        this.loggingInfo = builder.loggingInfo;
        this.numberOfBrokerNodes = builder.numberOfBrokerNodes;
        this.zookeeperConnectString = builder.zookeeperConnectString;
        this.zookeeperConnectStringTls = builder.zookeeperConnectStringTls;
    }

    public final BrokerNodeGroupInfo brokerNodeGroupInfo() {
        return this.brokerNodeGroupInfo;
    }

    public final BrokerSoftwareInfo currentBrokerSoftwareInfo() {
        return this.currentBrokerSoftwareInfo;
    }

    public final ClientAuthentication clientAuthentication() {
        return this.clientAuthentication;
    }

    public final EncryptionInfo encryptionInfo() {
        return this.encryptionInfo;
    }

    public final EnhancedMonitoring enhancedMonitoring() {
        return EnhancedMonitoring.fromValue(this.enhancedMonitoring);
    }

    public final String enhancedMonitoringAsString() {
        return this.enhancedMonitoring;
    }

    public final OpenMonitoringInfo openMonitoring() {
        return this.openMonitoring;
    }

    public final LoggingInfo loggingInfo() {
        return this.loggingInfo;
    }

    public final Integer numberOfBrokerNodes() {
        return this.numberOfBrokerNodes;
    }

    public final String zookeeperConnectString() {
        return this.zookeeperConnectString;
    }

    public final String zookeeperConnectStringTls() {
        return this.zookeeperConnectStringTls;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.brokerNodeGroupInfo());
        hashCode = 31 * hashCode + Objects.hashCode(this.currentBrokerSoftwareInfo());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientAuthentication());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptionInfo());
        hashCode = 31 * hashCode + Objects.hashCode(this.enhancedMonitoringAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.openMonitoring());
        hashCode = 31 * hashCode + Objects.hashCode(this.loggingInfo());
        hashCode = 31 * hashCode + Objects.hashCode(this.numberOfBrokerNodes());
        hashCode = 31 * hashCode + Objects.hashCode(this.zookeeperConnectString());
        hashCode = 31 * hashCode + Objects.hashCode(this.zookeeperConnectStringTls());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Provisioned)) {
            return false;
        }
        Provisioned other = (Provisioned)obj;
        return Objects.equals(this.brokerNodeGroupInfo(), other.brokerNodeGroupInfo()) && Objects.equals(this.currentBrokerSoftwareInfo(), other.currentBrokerSoftwareInfo()) && Objects.equals(this.clientAuthentication(), other.clientAuthentication()) && Objects.equals(this.encryptionInfo(), other.encryptionInfo()) && Objects.equals(this.enhancedMonitoringAsString(), other.enhancedMonitoringAsString()) && Objects.equals(this.openMonitoring(), other.openMonitoring()) && Objects.equals(this.loggingInfo(), other.loggingInfo()) && Objects.equals(this.numberOfBrokerNodes(), other.numberOfBrokerNodes()) && Objects.equals(this.zookeeperConnectString(), other.zookeeperConnectString()) && Objects.equals(this.zookeeperConnectStringTls(), other.zookeeperConnectStringTls());
    }

    public final String toString() {
        return ToString.builder((String)"Provisioned").add("BrokerNodeGroupInfo", (Object)this.brokerNodeGroupInfo()).add("CurrentBrokerSoftwareInfo", (Object)this.currentBrokerSoftwareInfo()).add("ClientAuthentication", (Object)this.clientAuthentication()).add("EncryptionInfo", (Object)this.encryptionInfo()).add("EnhancedMonitoring", (Object)this.enhancedMonitoringAsString()).add("OpenMonitoring", (Object)this.openMonitoring()).add("LoggingInfo", (Object)this.loggingInfo()).add("NumberOfBrokerNodes", (Object)this.numberOfBrokerNodes()).add("ZookeeperConnectString", (Object)this.zookeeperConnectString()).add("ZookeeperConnectStringTls", (Object)this.zookeeperConnectStringTls()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BrokerNodeGroupInfo": {
                return Optional.ofNullable(clazz.cast(this.brokerNodeGroupInfo()));
            }
            case "CurrentBrokerSoftwareInfo": {
                return Optional.ofNullable(clazz.cast(this.currentBrokerSoftwareInfo()));
            }
            case "ClientAuthentication": {
                return Optional.ofNullable(clazz.cast(this.clientAuthentication()));
            }
            case "EncryptionInfo": {
                return Optional.ofNullable(clazz.cast(this.encryptionInfo()));
            }
            case "EnhancedMonitoring": {
                return Optional.ofNullable(clazz.cast(this.enhancedMonitoringAsString()));
            }
            case "OpenMonitoring": {
                return Optional.ofNullable(clazz.cast(this.openMonitoring()));
            }
            case "LoggingInfo": {
                return Optional.ofNullable(clazz.cast(this.loggingInfo()));
            }
            case "NumberOfBrokerNodes": {
                return Optional.ofNullable(clazz.cast(this.numberOfBrokerNodes()));
            }
            case "ZookeeperConnectString": {
                return Optional.ofNullable(clazz.cast(this.zookeeperConnectString()));
            }
            case "ZookeeperConnectStringTls": {
                return Optional.ofNullable(clazz.cast(this.zookeeperConnectStringTls()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Provisioned, T> g) {
        return obj -> g.apply((Provisioned)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private BrokerNodeGroupInfo brokerNodeGroupInfo;
        private BrokerSoftwareInfo currentBrokerSoftwareInfo;
        private ClientAuthentication clientAuthentication;
        private EncryptionInfo encryptionInfo;
        private String enhancedMonitoring;
        private OpenMonitoringInfo openMonitoring;
        private LoggingInfo loggingInfo;
        private Integer numberOfBrokerNodes;
        private String zookeeperConnectString;
        private String zookeeperConnectStringTls;

        private BuilderImpl() {
        }

        private BuilderImpl(Provisioned model) {
            this.brokerNodeGroupInfo(model.brokerNodeGroupInfo);
            this.currentBrokerSoftwareInfo(model.currentBrokerSoftwareInfo);
            this.clientAuthentication(model.clientAuthentication);
            this.encryptionInfo(model.encryptionInfo);
            this.enhancedMonitoring(model.enhancedMonitoring);
            this.openMonitoring(model.openMonitoring);
            this.loggingInfo(model.loggingInfo);
            this.numberOfBrokerNodes(model.numberOfBrokerNodes);
            this.zookeeperConnectString(model.zookeeperConnectString);
            this.zookeeperConnectStringTls(model.zookeeperConnectStringTls);
        }

        public final BrokerNodeGroupInfo.Builder getBrokerNodeGroupInfo() {
            return this.brokerNodeGroupInfo != null ? this.brokerNodeGroupInfo.toBuilder() : null;
        }

        public final void setBrokerNodeGroupInfo(BrokerNodeGroupInfo.BuilderImpl brokerNodeGroupInfo) {
            this.brokerNodeGroupInfo = brokerNodeGroupInfo != null ? brokerNodeGroupInfo.build() : null;
        }

        @Override
        @Transient
        public final Builder brokerNodeGroupInfo(BrokerNodeGroupInfo brokerNodeGroupInfo) {
            this.brokerNodeGroupInfo = brokerNodeGroupInfo;
            return this;
        }

        public final BrokerSoftwareInfo.Builder getCurrentBrokerSoftwareInfo() {
            return this.currentBrokerSoftwareInfo != null ? this.currentBrokerSoftwareInfo.toBuilder() : null;
        }

        public final void setCurrentBrokerSoftwareInfo(BrokerSoftwareInfo.BuilderImpl currentBrokerSoftwareInfo) {
            this.currentBrokerSoftwareInfo = currentBrokerSoftwareInfo != null ? currentBrokerSoftwareInfo.build() : null;
        }

        @Override
        @Transient
        public final Builder currentBrokerSoftwareInfo(BrokerSoftwareInfo currentBrokerSoftwareInfo) {
            this.currentBrokerSoftwareInfo = currentBrokerSoftwareInfo;
            return this;
        }

        public final ClientAuthentication.Builder getClientAuthentication() {
            return this.clientAuthentication != null ? this.clientAuthentication.toBuilder() : null;
        }

        public final void setClientAuthentication(ClientAuthentication.BuilderImpl clientAuthentication) {
            this.clientAuthentication = clientAuthentication != null ? clientAuthentication.build() : null;
        }

        @Override
        @Transient
        public final Builder clientAuthentication(ClientAuthentication clientAuthentication) {
            this.clientAuthentication = clientAuthentication;
            return this;
        }

        public final EncryptionInfo.Builder getEncryptionInfo() {
            return this.encryptionInfo != null ? this.encryptionInfo.toBuilder() : null;
        }

        public final void setEncryptionInfo(EncryptionInfo.BuilderImpl encryptionInfo) {
            this.encryptionInfo = encryptionInfo != null ? encryptionInfo.build() : null;
        }

        @Override
        @Transient
        public final Builder encryptionInfo(EncryptionInfo encryptionInfo) {
            this.encryptionInfo = encryptionInfo;
            return this;
        }

        public final String getEnhancedMonitoring() {
            return this.enhancedMonitoring;
        }

        public final void setEnhancedMonitoring(String enhancedMonitoring) {
            this.enhancedMonitoring = enhancedMonitoring;
        }

        @Override
        @Transient
        public final Builder enhancedMonitoring(String enhancedMonitoring) {
            this.enhancedMonitoring = enhancedMonitoring;
            return this;
        }

        @Override
        @Transient
        public final Builder enhancedMonitoring(EnhancedMonitoring enhancedMonitoring) {
            this.enhancedMonitoring(enhancedMonitoring == null ? null : enhancedMonitoring.toString());
            return this;
        }

        public final OpenMonitoringInfo.Builder getOpenMonitoring() {
            return this.openMonitoring != null ? this.openMonitoring.toBuilder() : null;
        }

        public final void setOpenMonitoring(OpenMonitoringInfo.BuilderImpl openMonitoring) {
            this.openMonitoring = openMonitoring != null ? openMonitoring.build() : null;
        }

        @Override
        @Transient
        public final Builder openMonitoring(OpenMonitoringInfo openMonitoring) {
            this.openMonitoring = openMonitoring;
            return this;
        }

        public final LoggingInfo.Builder getLoggingInfo() {
            return this.loggingInfo != null ? this.loggingInfo.toBuilder() : null;
        }

        public final void setLoggingInfo(LoggingInfo.BuilderImpl loggingInfo) {
            this.loggingInfo = loggingInfo != null ? loggingInfo.build() : null;
        }

        @Override
        @Transient
        public final Builder loggingInfo(LoggingInfo loggingInfo) {
            this.loggingInfo = loggingInfo;
            return this;
        }

        public final Integer getNumberOfBrokerNodes() {
            return this.numberOfBrokerNodes;
        }

        public final void setNumberOfBrokerNodes(Integer numberOfBrokerNodes) {
            this.numberOfBrokerNodes = numberOfBrokerNodes;
        }

        @Override
        @Transient
        public final Builder numberOfBrokerNodes(Integer numberOfBrokerNodes) {
            this.numberOfBrokerNodes = numberOfBrokerNodes;
            return this;
        }

        public final String getZookeeperConnectString() {
            return this.zookeeperConnectString;
        }

        public final void setZookeeperConnectString(String zookeeperConnectString) {
            this.zookeeperConnectString = zookeeperConnectString;
        }

        @Override
        @Transient
        public final Builder zookeeperConnectString(String zookeeperConnectString) {
            this.zookeeperConnectString = zookeeperConnectString;
            return this;
        }

        public final String getZookeeperConnectStringTls() {
            return this.zookeeperConnectStringTls;
        }

        public final void setZookeeperConnectStringTls(String zookeeperConnectStringTls) {
            this.zookeeperConnectStringTls = zookeeperConnectStringTls;
        }

        @Override
        @Transient
        public final Builder zookeeperConnectStringTls(String zookeeperConnectStringTls) {
            this.zookeeperConnectStringTls = zookeeperConnectStringTls;
            return this;
        }

        public Provisioned build() {
            return new Provisioned(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Provisioned> {
        public Builder brokerNodeGroupInfo(BrokerNodeGroupInfo var1);

        default public Builder brokerNodeGroupInfo(Consumer<BrokerNodeGroupInfo.Builder> brokerNodeGroupInfo) {
            return this.brokerNodeGroupInfo((BrokerNodeGroupInfo)((BrokerNodeGroupInfo.Builder)BrokerNodeGroupInfo.builder().applyMutation(brokerNodeGroupInfo)).build());
        }

        public Builder currentBrokerSoftwareInfo(BrokerSoftwareInfo var1);

        default public Builder currentBrokerSoftwareInfo(Consumer<BrokerSoftwareInfo.Builder> currentBrokerSoftwareInfo) {
            return this.currentBrokerSoftwareInfo((BrokerSoftwareInfo)((BrokerSoftwareInfo.Builder)BrokerSoftwareInfo.builder().applyMutation(currentBrokerSoftwareInfo)).build());
        }

        public Builder clientAuthentication(ClientAuthentication var1);

        default public Builder clientAuthentication(Consumer<ClientAuthentication.Builder> clientAuthentication) {
            return this.clientAuthentication((ClientAuthentication)((ClientAuthentication.Builder)ClientAuthentication.builder().applyMutation(clientAuthentication)).build());
        }

        public Builder encryptionInfo(EncryptionInfo var1);

        default public Builder encryptionInfo(Consumer<EncryptionInfo.Builder> encryptionInfo) {
            return this.encryptionInfo((EncryptionInfo)((EncryptionInfo.Builder)EncryptionInfo.builder().applyMutation(encryptionInfo)).build());
        }

        public Builder enhancedMonitoring(String var1);

        public Builder enhancedMonitoring(EnhancedMonitoring var1);

        public Builder openMonitoring(OpenMonitoringInfo var1);

        default public Builder openMonitoring(Consumer<OpenMonitoringInfo.Builder> openMonitoring) {
            return this.openMonitoring((OpenMonitoringInfo)((OpenMonitoringInfo.Builder)OpenMonitoringInfo.builder().applyMutation(openMonitoring)).build());
        }

        public Builder loggingInfo(LoggingInfo var1);

        default public Builder loggingInfo(Consumer<LoggingInfo.Builder> loggingInfo) {
            return this.loggingInfo((LoggingInfo)((LoggingInfo.Builder)LoggingInfo.builder().applyMutation(loggingInfo)).build());
        }

        public Builder numberOfBrokerNodes(Integer var1);

        public Builder zookeeperConnectString(String var1);

        public Builder zookeeperConnectStringTls(String var1);
    }
}

