/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kafka.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CloudWatchLogs
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CloudWatchLogs> {
    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Enabled").getter(CloudWatchLogs.getter(CloudWatchLogs::enabled)).setter(CloudWatchLogs.setter(Builder::enabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enabled").build()}).build();
    private static final SdkField<String> LOG_GROUP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LogGroup").getter(CloudWatchLogs.getter(CloudWatchLogs::logGroup)).setter(CloudWatchLogs.setter(Builder::logGroup)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logGroup").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENABLED_FIELD, LOG_GROUP_FIELD));
    private static final long serialVersionUID = 1L;
    private final Boolean enabled;
    private final String logGroup;

    private CloudWatchLogs(BuilderImpl builder) {
        this.enabled = builder.enabled;
        this.logGroup = builder.logGroup;
    }

    public Boolean enabled() {
        return this.enabled;
    }

    public String logGroup() {
        return this.logGroup;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.enabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.logGroup());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CloudWatchLogs)) {
            return false;
        }
        CloudWatchLogs other = (CloudWatchLogs)obj;
        return Objects.equals(this.enabled(), other.enabled()) && Objects.equals(this.logGroup(), other.logGroup());
    }

    public String toString() {
        return ToString.builder((String)"CloudWatchLogs").add("Enabled", (Object)this.enabled()).add("LogGroup", (Object)this.logGroup()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Enabled": {
                return Optional.ofNullable(clazz.cast(this.enabled()));
            }
            case "LogGroup": {
                return Optional.ofNullable(clazz.cast(this.logGroup()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CloudWatchLogs, T> g) {
        return obj -> g.apply((CloudWatchLogs)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean enabled;
        private String logGroup;

        private BuilderImpl() {
        }

        private BuilderImpl(CloudWatchLogs model) {
            this.enabled(model.enabled);
            this.logGroup(model.logGroup);
        }

        public final Boolean getEnabled() {
            return this.enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        public final String getLogGroup() {
            return this.logGroup;
        }

        @Override
        public final Builder logGroup(String logGroup) {
            this.logGroup = logGroup;
            return this;
        }

        public final void setLogGroup(String logGroup) {
            this.logGroup = logGroup;
        }

        public CloudWatchLogs build() {
            return new CloudWatchLogs(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CloudWatchLogs> {
        public Builder enabled(Boolean var1);

        public Builder logGroup(String var1);
    }
}

