/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kafka.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.kafka.model.BrokerEBSVolumeInfo;
import software.amazon.awssdk.services.kafka.model.KafkaRequest;
import software.amazon.awssdk.services.kafka.model.___listOfBrokerEBSVolumeInfoCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateBrokerStorageRequest
extends KafkaRequest
implements ToCopyableBuilder<Builder, UpdateBrokerStorageRequest> {
    private static final SdkField<String> CLUSTER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClusterArn").getter(UpdateBrokerStorageRequest.getter(UpdateBrokerStorageRequest::clusterArn)).setter(UpdateBrokerStorageRequest.setter(Builder::clusterArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("clusterArn").build()}).build();
    private static final SdkField<String> CURRENT_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CurrentVersion").getter(UpdateBrokerStorageRequest.getter(UpdateBrokerStorageRequest::currentVersion)).setter(UpdateBrokerStorageRequest.setter(Builder::currentVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("currentVersion").build()}).build();
    private static final SdkField<List<BrokerEBSVolumeInfo>> TARGET_BROKER_EBS_VOLUME_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TargetBrokerEBSVolumeInfo").getter(UpdateBrokerStorageRequest.getter(UpdateBrokerStorageRequest::targetBrokerEBSVolumeInfo)).setter(UpdateBrokerStorageRequest.setter(Builder::targetBrokerEBSVolumeInfo)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetBrokerEBSVolumeInfo").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BrokerEBSVolumeInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_ARN_FIELD, CURRENT_VERSION_FIELD, TARGET_BROKER_EBS_VOLUME_INFO_FIELD));
    private final String clusterArn;
    private final String currentVersion;
    private final List<BrokerEBSVolumeInfo> targetBrokerEBSVolumeInfo;

    private UpdateBrokerStorageRequest(BuilderImpl builder) {
        super(builder);
        this.clusterArn = builder.clusterArn;
        this.currentVersion = builder.currentVersion;
        this.targetBrokerEBSVolumeInfo = builder.targetBrokerEBSVolumeInfo;
    }

    public String clusterArn() {
        return this.clusterArn;
    }

    public String currentVersion() {
        return this.currentVersion;
    }

    public boolean hasTargetBrokerEBSVolumeInfo() {
        return this.targetBrokerEBSVolumeInfo != null && !(this.targetBrokerEBSVolumeInfo instanceof SdkAutoConstructList);
    }

    public List<BrokerEBSVolumeInfo> targetBrokerEBSVolumeInfo() {
        return this.targetBrokerEBSVolumeInfo;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.currentVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTargetBrokerEBSVolumeInfo() ? this.targetBrokerEBSVolumeInfo() : null);
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateBrokerStorageRequest)) {
            return false;
        }
        UpdateBrokerStorageRequest other = (UpdateBrokerStorageRequest)((Object)obj);
        return Objects.equals(this.clusterArn(), other.clusterArn()) && Objects.equals(this.currentVersion(), other.currentVersion()) && this.hasTargetBrokerEBSVolumeInfo() == other.hasTargetBrokerEBSVolumeInfo() && Objects.equals(this.targetBrokerEBSVolumeInfo(), other.targetBrokerEBSVolumeInfo());
    }

    public String toString() {
        return ToString.builder((String)"UpdateBrokerStorageRequest").add("ClusterArn", (Object)this.clusterArn()).add("CurrentVersion", (Object)this.currentVersion()).add("TargetBrokerEBSVolumeInfo", this.hasTargetBrokerEBSVolumeInfo() ? this.targetBrokerEBSVolumeInfo() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClusterArn": {
                return Optional.ofNullable(clazz.cast(this.clusterArn()));
            }
            case "CurrentVersion": {
                return Optional.ofNullable(clazz.cast(this.currentVersion()));
            }
            case "TargetBrokerEBSVolumeInfo": {
                return Optional.ofNullable(clazz.cast(this.targetBrokerEBSVolumeInfo()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateBrokerStorageRequest, T> g) {
        return obj -> g.apply((UpdateBrokerStorageRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends KafkaRequest.BuilderImpl
    implements Builder {
        private String clusterArn;
        private String currentVersion;
        private List<BrokerEBSVolumeInfo> targetBrokerEBSVolumeInfo = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateBrokerStorageRequest model) {
            super(model);
            this.clusterArn(model.clusterArn);
            this.currentVersion(model.currentVersion);
            this.targetBrokerEBSVolumeInfo(model.targetBrokerEBSVolumeInfo);
        }

        public final String getClusterArn() {
            return this.clusterArn;
        }

        @Override
        public final Builder clusterArn(String clusterArn) {
            this.clusterArn = clusterArn;
            return this;
        }

        public final void setClusterArn(String clusterArn) {
            this.clusterArn = clusterArn;
        }

        public final String getCurrentVersion() {
            return this.currentVersion;
        }

        @Override
        public final Builder currentVersion(String currentVersion) {
            this.currentVersion = currentVersion;
            return this;
        }

        public final void setCurrentVersion(String currentVersion) {
            this.currentVersion = currentVersion;
        }

        public final Collection<BrokerEBSVolumeInfo.Builder> getTargetBrokerEBSVolumeInfo() {
            if (this.targetBrokerEBSVolumeInfo instanceof SdkAutoConstructList) {
                return null;
            }
            return this.targetBrokerEBSVolumeInfo != null ? (Collection)this.targetBrokerEBSVolumeInfo.stream().map(BrokerEBSVolumeInfo::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder targetBrokerEBSVolumeInfo(Collection<BrokerEBSVolumeInfo> targetBrokerEBSVolumeInfo) {
            this.targetBrokerEBSVolumeInfo = ___listOfBrokerEBSVolumeInfoCopier.copy(targetBrokerEBSVolumeInfo);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetBrokerEBSVolumeInfo(BrokerEBSVolumeInfo ... targetBrokerEBSVolumeInfo) {
            this.targetBrokerEBSVolumeInfo(Arrays.asList(targetBrokerEBSVolumeInfo));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetBrokerEBSVolumeInfo(Consumer<BrokerEBSVolumeInfo.Builder> ... targetBrokerEBSVolumeInfo) {
            this.targetBrokerEBSVolumeInfo(Stream.of(targetBrokerEBSVolumeInfo).map(c -> (BrokerEBSVolumeInfo)((BrokerEBSVolumeInfo.Builder)BrokerEBSVolumeInfo.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTargetBrokerEBSVolumeInfo(Collection<BrokerEBSVolumeInfo.BuilderImpl> targetBrokerEBSVolumeInfo) {
            this.targetBrokerEBSVolumeInfo = ___listOfBrokerEBSVolumeInfoCopier.copyFromBuilder(targetBrokerEBSVolumeInfo);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateBrokerStorageRequest build() {
            return new UpdateBrokerStorageRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends KafkaRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateBrokerStorageRequest> {
        public Builder clusterArn(String var1);

        public Builder currentVersion(String var1);

        public Builder targetBrokerEBSVolumeInfo(Collection<BrokerEBSVolumeInfo> var1);

        public Builder targetBrokerEBSVolumeInfo(BrokerEBSVolumeInfo ... var1);

        public Builder targetBrokerEBSVolumeInfo(Consumer<BrokerEBSVolumeInfo.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

