/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kafka.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.kafka.model.ClusterOperationStepInfo;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ClusterOperationStep
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ClusterOperationStep> {
    private static final SdkField<ClusterOperationStepInfo> STEP_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("StepInfo").getter(ClusterOperationStep.getter(ClusterOperationStep::stepInfo)).setter(ClusterOperationStep.setter(Builder::stepInfo)).constructor(ClusterOperationStepInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stepInfo").build()}).build();
    private static final SdkField<String> STEP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StepName").getter(ClusterOperationStep.getter(ClusterOperationStep::stepName)).setter(ClusterOperationStep.setter(Builder::stepName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stepName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STEP_INFO_FIELD, STEP_NAME_FIELD));
    private static final long serialVersionUID = 1L;
    private final ClusterOperationStepInfo stepInfo;
    private final String stepName;

    private ClusterOperationStep(BuilderImpl builder) {
        this.stepInfo = builder.stepInfo;
        this.stepName = builder.stepName;
    }

    public ClusterOperationStepInfo stepInfo() {
        return this.stepInfo;
    }

    public String stepName() {
        return this.stepName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.stepInfo());
        hashCode = 31 * hashCode + Objects.hashCode(this.stepName());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClusterOperationStep)) {
            return false;
        }
        ClusterOperationStep other = (ClusterOperationStep)obj;
        return Objects.equals(this.stepInfo(), other.stepInfo()) && Objects.equals(this.stepName(), other.stepName());
    }

    public String toString() {
        return ToString.builder((String)"ClusterOperationStep").add("StepInfo", (Object)this.stepInfo()).add("StepName", (Object)this.stepName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StepInfo": {
                return Optional.ofNullable(clazz.cast(this.stepInfo()));
            }
            case "StepName": {
                return Optional.ofNullable(clazz.cast(this.stepName()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ClusterOperationStep, T> g) {
        return obj -> g.apply((ClusterOperationStep)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private ClusterOperationStepInfo stepInfo;
        private String stepName;

        private BuilderImpl() {
        }

        private BuilderImpl(ClusterOperationStep model) {
            this.stepInfo(model.stepInfo);
            this.stepName(model.stepName);
        }

        public final ClusterOperationStepInfo.Builder getStepInfo() {
            return this.stepInfo != null ? this.stepInfo.toBuilder() : null;
        }

        @Override
        public final Builder stepInfo(ClusterOperationStepInfo stepInfo) {
            this.stepInfo = stepInfo;
            return this;
        }

        public final void setStepInfo(ClusterOperationStepInfo.BuilderImpl stepInfo) {
            this.stepInfo = stepInfo != null ? stepInfo.build() : null;
        }

        public final String getStepName() {
            return this.stepName;
        }

        @Override
        public final Builder stepName(String stepName) {
            this.stepName = stepName;
            return this;
        }

        public final void setStepName(String stepName) {
            this.stepName = stepName;
        }

        public ClusterOperationStep build() {
            return new ClusterOperationStep(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ClusterOperationStep> {
        public Builder stepInfo(ClusterOperationStepInfo var1);

        default public Builder stepInfo(Consumer<ClusterOperationStepInfo.Builder> stepInfo) {
            return this.stepInfo((ClusterOperationStepInfo)((ClusterOperationStepInfo.Builder)ClusterOperationStepInfo.builder().applyMutation(stepInfo)).build());
        }

        public Builder stepName(String var1);
    }
}

